/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_MAC;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import java.io.Serializable;
import java.util.Arrays;

public class POPOSigningKeyInput
implements Cloneable,
Serializable {
    private ASN1Template asn1Template;
    private byte[] salt;
    private int count;
    private GeneralName sender;
    private byte[] subjectPublicKeyInfo;
    private byte[] macValue;
    private char[] secret;
    byte[] passwordBasedMAC = new byte[]{42, -122, 72, -122, -10, 125, 7, 66, 13};
    byte[] hmacSHA1 = new byte[]{43, 6, 1, 5, 5, 8, 1, 2};

    public POPOSigningKeyInput() {
    }

    public POPOSigningKeyInput(byte[] dataBER, int offset) throws CRMFException {
        if (dataBER == null) {
            throw new CRMFException("POPOSigningKeyInput Encoding is null.");
        }
        SequenceContainer aSeq = new SequenceContainer(0x810000);
        ChoiceContainer popContainer = new ChoiceContainer(0);
        EncodedContainer nameContainer = new EncodedContainer(0xA0FF00);
        EncodedContainer macContainer = new EncodedContainer(12288);
        EncodedContainer keyContainer = new EncodedContainer(12288);
        EndContainer anEnd = new EndContainer();
        ASN1Container[] asn1Def = new ASN1Container[]{aSeq, popContainer, nameContainer, macContainer, anEnd, keyContainer, anEnd};
        try {
            ASN1.berDecode((byte[])dataBER, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("FIRST", (Exception)((Object)asnException));
        }
        try {
            if (nameContainer.dataPresent) {
                this.sender = new GeneralName(nameContainer.data, nameContainer.dataOffset, 0xA00000);
            }
        }
        catch (NameException nameExc) {
            throw new CRMFException("NAME ", nameExc);
        }
        if (macContainer.dataPresent) {
            this.setPKMACValue(macContainer.data, macContainer.dataOffset);
        }
        this.setSubjectPublicKey(keyContainer.data, keyContainer.dataOffset);
    }

    private void setPKMACValue(byte[] data, int offset) throws CRMFException {
        if (data == null) {
            throw new CRMFException("PKMACValue Encoding is null.");
        }
        SequenceContainer aSeq = new SequenceContainer(0);
        EncodedContainer algID = new EncodedContainer(12288);
        BitStringContainer value = new BitStringContainer(0);
        EndContainer anEnd = new EndContainer();
        ASN1Container[] asn1Def = new ASN1Container[]{aSeq, algID, value, anEnd};
        try {
            ASN1.berDecode((byte[])data, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Could not BER decode the PKMACValue.", (Exception)((Object)asnException));
        }
        this.setAlgorithmID(algID.data, algID.dataOffset);
        this.macValue = new byte[value.dataLen];
        System.arraycopy(value.data, value.dataOffset, this.macValue, 0, value.dataLen);
    }

    public boolean verifyPKMACValue() throws CRMFException {
        if (this.secret == null) {
            throw new CRMFException("Secret value is not set in POPOSigningKeyInput.");
        }
        if (this.subjectPublicKeyInfo == null) {
            throw new CRMFException("Public Key is not set in POPOSigningKeyInput.");
        }
        try {
            String hmacString = "PBE/HMAC/SHA1/PKIXPBE-" + this.count;
            JSAFE_MAC macObject = JSAFEFactory.getMAC(hmacString, "Java", (CertJ)null);
            macObject.setSalt(this.salt, 0, this.salt.length);
            JSAFE_SecretKey macKey = macObject.getBlankKey();
            macKey.setPassword(this.secret, 0, this.secret.length);
            macObject.verifyInit(macKey, null);
            macObject.verifyUpdate(this.subjectPublicKeyInfo, 0, this.subjectPublicKeyInfo.length);
            return macObject.verifyFinal(this.macValue, 0, this.macValue.length);
        }
        catch (JSAFE_Exception jsafeExc) {
            throw new CRMFException((Exception)((Object)jsafeExc));
        }
    }

    private void setAlgorithmID(byte[] data, int offset) throws CRMFException {
        if (data == null) {
            throw new CRMFException("Password-Based MAC algorithm ID Encoding is null.");
        }
        SequenceContainer aSeq = new SequenceContainer(0);
        EndContainer anEnd = new EndContainer();
        EncodedContainer param = new EncodedContainer(12288);
        OIDContainer oid = new OIDContainer(0);
        ASN1Container[] asn1Def = new ASN1Container[]{aSeq, oid, param, anEnd};
        try {
            ASN1.berDecode((byte[])data, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Could not BER decode the PKMAC algID.", (Exception)((Object)asnException));
        }
        if (this.passwordBasedMAC.length != oid.dataLen) {
            throw new CRMFException("Wrong OID for Password-Based MAC.");
        }
        for (int index = 0; index < oid.dataLen; ++index) {
            if (this.passwordBasedMAC[index] == oid.data[index + oid.dataOffset]) continue;
            throw new CRMFException("Wrong OID for Password-Based MAC.");
        }
        SequenceContainer seq = new SequenceContainer(0);
        OctetStringContainer saltContainer = new OctetStringContainer(0);
        EncodedContainer digestContainer = new EncodedContainer(12288);
        IntegerContainer countContainer = new IntegerContainer(0);
        EncodedContainer macContainer = new EncodedContainer(12288);
        ASN1Container[] asnDef = new ASN1Container[]{seq, saltContainer, digestContainer, countContainer, macContainer, anEnd};
        try {
            ASN1.berDecode((byte[])param.data, (int)param.dataOffset, (ASN1Container[])asnDef);
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException((Exception)((Object)asnException));
        }
        this.salt = new byte[saltContainer.dataLen];
        System.arraycopy(saltContainer.data, saltContainer.dataOffset, this.salt, 0, saltContainer.dataLen);
        try {
            this.count = countContainer.getValueAsInt();
            String digestAlg = AlgorithmID.berDecodeAlgID((byte[])digestContainer.data, (int)digestContainer.dataOffset, (int)11, null);
            if (digestAlg == null) {
                throw new CRMFException("Cannot recognize the digest algorithm.");
            }
            if (!digestAlg.equals("SHA1")) {
                throw new CRMFException("Digest algorithm SHA1 was expected.");
            }
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException((Exception)((Object)asnException));
        }
        try {
            SequenceContainer macSeq = new SequenceContainer(0);
            EncodedContainer macParam = new EncodedContainer(65280);
            OIDContainer macOid = new OIDContainer(0);
            ASN1Container[] asn2Def = new ASN1Container[]{macSeq, macOid, macParam, anEnd};
            ASN1.berDecode((byte[])macContainer.data, (int)macContainer.dataOffset, (ASN1Container[])asn2Def);
            if (macOid.dataLen != this.hmacSHA1.length) {
                throw new CRMFException("Wrong HMAC OID.");
            }
            for (int index = 0; index < this.hmacSHA1.length; ++index) {
                if (macOid.data[index + macOid.dataOffset] == this.hmacSHA1[index]) continue;
                throw new CRMFException("Wrong HMAC OID.");
            }
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Could not BER decode the HMAC algID.", (Exception)((Object)asnException));
        }
    }

    public void setSharedSecret(char[] secret, int offset, int len) throws CRMFException {
        if (secret == null || len == 0) {
            throw new CRMFException("Shared secret is null in PBMParameter.");
        }
        this.secret = new char[secret.length];
        System.arraycopy(secret, offset, this.secret, 0, len);
    }

    public void setSalt(byte[] salt, int offset, int len) throws CRMFException {
        if (salt == null || len == 0) {
            throw new CRMFException("The Salt value is null in PBMParameter.");
        }
        this.salt = new byte[len];
        System.arraycopy(salt, offset, this.salt, 0, len);
    }

    public byte[] getSalt() {
        if (this.salt == null) {
            return null;
        }
        byte[] returnValue = new byte[this.salt.length];
        System.arraycopy(this.salt, 0, returnValue, 0, this.salt.length);
        return returnValue;
    }

    public int getIterationCount() {
        return this.count;
    }

    public void setIterationCount(int count) {
        this.count = count;
    }

    public GeneralName getSenderName() throws CRMFException {
        if (this.sender == null) {
            return null;
        }
        try {
            return (GeneralName)this.sender.clone();
        }
        catch (CloneNotSupportedException cloneExc) {
            throw new CRMFException(cloneExc);
        }
    }

    public void setSenderName(GeneralName sender) throws CRMFException {
        if (sender == null) {
            throw new CRMFException("Passed in SenderName is null.");
        }
        try {
            this.sender = (GeneralName)sender.clone();
        }
        catch (CloneNotSupportedException cloneExc) {
            throw new CRMFException(cloneExc);
        }
    }

    public void setSubjectPublicKey(JSAFE_PublicKey publicKey) throws CRMFException {
        if (publicKey == null) {
            throw new CRMFException("Public key is null in POPOSigningKeyInput.");
        }
        try {
            String format = publicKey.getAlgorithm().compareTo("DSA") == 0 ? "DSAPublicKeyX957BER" : publicKey.getAlgorithm() + "PublicKeyBER";
            byte[][] keyData = publicKey.getKeyData(format);
            this.subjectPublicKeyInfo = keyData[0];
        }
        catch (JSAFE_Exception jsafeException) {
            throw new CRMFException("Could not read the public key in POPOSigningKeyInput. ", (Exception)((Object)jsafeException));
        }
    }

    public void setSubjectPublicKey(byte[] publicKeyBER, int offset) throws CRMFException {
        if (publicKeyBER == null) {
            throw new CRMFException("Public key encoding is null in POPOSigningKeyInput.");
        }
        JSAFE_PublicKey publicKey = null;
        try {
            publicKeyBER[offset] = 48;
            publicKey = JSAFEFactory.getPublicKey(publicKeyBER, offset, "Java", (CertJ)null);
            this.setSubjectPublicKey(publicKey);
        }
        catch (JSAFE_Exception jsafeException) {
            throw new CRMFException("Could not read the public key in POPOSigningKeyInput. ", (Exception)((Object)jsafeException));
        }
        finally {
            if (publicKey != null) {
                publicKey.clearSensitiveData();
            }
        }
    }

    public JSAFE_PublicKey getSubjectPublicKey() throws CRMFException {
        if (this.subjectPublicKeyInfo == null) {
            return null;
        }
        try {
            return JSAFEFactory.getPublicKey(this.subjectPublicKeyInfo, 0, "Java", (CertJ)null);
        }
        catch (JSAFE_Exception jsafeException) {
            throw new CRMFException("Cannot retrieve the public key in POPOSigningKeyInput: ", (Exception)((Object)jsafeException));
        }
    }

    public byte[] getSubjectPublicKeyBER() {
        if (this.subjectPublicKeyInfo == null) {
            return null;
        }
        return (byte[])this.subjectPublicKeyInfo.clone();
    }

    public byte[] getPKMACValue() {
        if (this.macValue == null) {
            return null;
        }
        byte[] returnValue = new byte[this.macValue.length];
        System.arraycopy(this.macValue, 0, returnValue, 0, this.macValue.length);
        return returnValue;
    }

    private void computeMacValue() throws CRMFException {
        if (this.secret == null) {
            throw new CRMFException("Shared Secret is not set in PKMAC value.");
        }
        if (this.salt == null) {
            throw new CRMFException("Salt value is not set in PKMAC value.");
        }
        if (this.subjectPublicKeyInfo == null) {
            throw new CRMFException("Public Key is not set in PKMAC value.");
        }
        if (this.count == 0) {
            throw new CRMFException("Iteration count is not set in PKMAC value.");
        }
        try {
            String hmacString = "PBE/HMAC/SHA1/PKIXPBE-" + this.count;
            JSAFE_MAC macObject = JSAFEFactory.getMAC(hmacString, "Java", (CertJ)null);
            macObject.setSalt(this.salt, 0, this.salt.length);
            JSAFE_SecretKey macKey = macObject.getBlankKey();
            macKey.setPassword(this.secret, 0, this.secret.length);
            macObject.macInit(macKey, null);
            macObject.macUpdate(this.subjectPublicKeyInfo, 0, this.subjectPublicKeyInfo.length);
            this.macValue = macObject.macFinal();
            macObject.clearSensitiveData();
        }
        catch (JSAFE_Exception jsafeExc) {
            throw new CRMFException((Exception)((Object)jsafeExc));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        POPOSigningKeyInput otherSelf = new POPOSigningKeyInput();
        otherSelf.count = this.count;
        if (this.salt != null) {
            otherSelf.salt = new byte[this.salt.length];
            System.arraycopy(this.salt, 0, otherSelf.salt, 0, this.salt.length);
        }
        if (this.sender != null) {
            otherSelf.sender = (GeneralName)this.sender.clone();
        }
        if (this.subjectPublicKeyInfo != null) {
            otherSelf.subjectPublicKeyInfo = new byte[this.subjectPublicKeyInfo.length];
            System.arraycopy(this.subjectPublicKeyInfo, 0, otherSelf.subjectPublicKeyInfo, 0, this.subjectPublicKeyInfo.length);
        }
        if (this.macValue != null) {
            otherSelf.macValue = new byte[this.macValue.length];
            System.arraycopy(this.macValue, 0, otherSelf.macValue, 0, this.macValue.length);
        }
        if (this.secret != null) {
            otherSelf.secret = new char[this.secret.length];
            System.arraycopy(this.secret, 0, otherSelf.secret, 0, this.secret.length);
        }
        try {
            if (this.asn1Template != null) {
                otherSelf.encodeInit();
            }
        }
        catch (CRMFException crmfException) {
            throw new CloneNotSupportedException(crmfException.getMessage());
        }
        return otherSelf;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof POPOSigningKeyInput)) {
            return false;
        }
        POPOSigningKeyInput other = (POPOSigningKeyInput)obj;
        try {
            int thisLen = this.getDERLen();
            int otherLen = other.getDERLen();
            if (thisLen != otherLen) {
                return false;
            }
            if (thisLen == 0 || otherLen == 0) {
                return false;
            }
            byte[] thisEncoding = new byte[thisLen];
            byte[] otherEncoding = new byte[otherLen];
            thisLen = this.getDEREncoding(thisEncoding, 0);
            if (thisLen != (otherLen = other.getDEREncoding(otherEncoding, 0))) {
                return false;
            }
            for (int index = 0; index < thisLen; ++index) {
                if (thisEncoding[index] == otherEncoding[index]) continue;
                return false;
            }
        }
        catch (CRMFException certException) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        try {
            int len = this.getDERLen();
            byte[] encoding = new byte[len];
            len = this.getDEREncoding(encoding, 0);
            result = prime * result + Arrays.hashCode(encoding);
        }
        catch (CRMFException certException) {
            return 0;
        }
        return result;
    }

    public static int getNextBEROffset(byte[] popBER, int offset) throws CRMFException {
        if (popBER == null) {
            throw new CRMFException("POPOSigningKeyInput Encoding is null.");
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])popBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])popBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Could not read the BER encoding.", (Exception)((Object)asnException));
        }
    }

    public int getDERLen() throws CRMFException {
        return this.encodeInit();
    }

    public int getDEREncoding(byte[] encoding, int offset) throws CRMFException {
        int returnValue;
        if (encoding == null) {
            throw new CRMFException("Specified POPOSigningKeyInput array is null.");
        }
        try {
            if (this.asn1Template == null) {
                this.getDERLen();
            }
            returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new CRMFException("Unable to encode POPOSigningKeyInput.", (Exception)((Object)asnException));
        }
        return returnValue;
    }

    private int encodeInit() throws CRMFException {
        try {
            boolean senderPresent = true;
            boolean macPresent = true;
            byte[] senderEncoding = null;
            int senderLen = 0;
            byte[] pkMacEncoding = null;
            int pkMacLen = 0;
            if (this.subjectPublicKeyInfo == null) {
                throw new CRMFException("Public key is not set.");
            }
            if (this.sender != null) {
                macPresent = false;
                senderLen = this.sender.getDERLen(0xA00000);
                senderEncoding = new byte[senderLen];
                senderLen = this.sender.getDEREncoding(senderEncoding, 0, 0xA00000);
            } else {
                senderPresent = false;
                if (this.macValue == null) {
                    this.computeMacValue();
                }
                byte[] macEncoding = new byte[this.hmacSHA1.length + 6];
                macEncoding[0] = 48;
                macEncoding[1] = (byte)(this.hmacSHA1.length + 4);
                macEncoding[2] = 6;
                macEncoding[3] = (byte)this.hmacSHA1.length;
                System.arraycopy(this.hmacSHA1, 0, macEncoding, 4, this.hmacSHA1.length);
                macEncoding[this.hmacSHA1.length + 4] = 5;
                macEncoding[this.hmacSHA1.length + 5] = 0;
                byte[] digestEncoding = AlgorithmID.derEncodeAlgID((String)"SHA1", (int)11, null, (int)0, (int)0);
                SequenceContainer seq = new SequenceContainer(0, true, 0);
                OctetStringContainer saltContainer = new OctetStringContainer(0, true, 0, this.salt, 0, this.salt.length);
                EncodedContainer digestContainer = new EncodedContainer(12288, true, 0, digestEncoding, 0, digestEncoding.length);
                IntegerContainer countContainer = new IntegerContainer(0, true, 0, this.count);
                EncodedContainer macContainer = new EncodedContainer(12288, true, 0, macEncoding, 0, macEncoding.length);
                EndContainer anEnd = new EndContainer();
                ASN1Container[] asnDef = new ASN1Container[]{seq, saltContainer, digestContainer, countContainer, macContainer, anEnd};
                ASN1Template paramTemplate = new ASN1Template(asnDef);
                int paramLen = paramTemplate.derEncodeInit();
                byte[] paramEncoding = new byte[paramLen];
                paramLen = paramTemplate.derEncode(paramEncoding, 0);
                byte[] pbEncoding = new byte[this.passwordBasedMAC.length + paramLen + 4];
                pbEncoding[0] = 48;
                pbEncoding[1] = (byte)(this.passwordBasedMAC.length + paramLen + 2);
                pbEncoding[2] = 6;
                pbEncoding[3] = (byte)this.passwordBasedMAC.length;
                System.arraycopy(this.passwordBasedMAC, 0, pbEncoding, 4, this.passwordBasedMAC.length);
                System.arraycopy(paramEncoding, 0, pbEncoding, this.passwordBasedMAC.length + 4, paramEncoding.length);
                SequenceContainer aSeq = new SequenceContainer(0, true, 0);
                EncodedContainer algID = new EncodedContainer(12288, true, 0, pbEncoding, 0, pbEncoding.length);
                BitStringContainer value = new BitStringContainer(0, true, 0, this.macValue, 0, this.macValue.length);
                ASN1Container[] asn1Def = new ASN1Container[]{aSeq, algID, value, anEnd};
                ASN1Template pkMacTemplate = new ASN1Template(asn1Def);
                pkMacLen = pkMacTemplate.derEncodeInit();
                pkMacEncoding = new byte[pkMacLen];
                pkMacLen = pkMacTemplate.derEncode(pkMacEncoding, 0);
            }
            SequenceContainer popSeq = new SequenceContainer(0x810000, true, 0);
            EndContainer anEnd = new EndContainer();
            ChoiceContainer popContainer = new ChoiceContainer(0, 0);
            EncodedContainer nameContainer = new EncodedContainer(0xA00000, senderPresent, 0, senderEncoding, 0, senderLen);
            EncodedContainer pbmacContainer = new EncodedContainer(12288, macPresent, 0, pkMacEncoding, 0, pkMacLen);
            EncodedContainer keyContainer = new EncodedContainer(12288, true, 0, this.subjectPublicKeyInfo, 0, this.subjectPublicKeyInfo.length);
            ASN1Container[] asn2Def = new ASN1Container[]{popSeq, popContainer, nameContainer, pbmacContainer, anEnd, keyContainer, anEnd};
            this.asn1Template = new ASN1Template(asn2Def);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Unable to encode POPOSigningKeyInput.", (Exception)((Object)asnException));
        }
        catch (NameException nameExc) {
            throw new CRMFException("Unable to encode POPOSigningKeyInput.", nameExc);
        }
    }
}

