/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.UTF8StringContainer;
import com.rsa.certj.CertJInternalHelper;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.crmf.CRMFException;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Vector;

public class RegInfo
implements Cloneable,
Serializable {
    public static final byte[] REG_INFO_OID = new byte[]{43, 6, 1, 5, 5, 7, 5, 2, 1};
    private String valueString;
    private Vector<String> regInfoSeq = new Vector();
    protected int special;
    protected ASN1Template asn1Template;

    public RegInfo() {
    }

    public RegInfo(String name, String value) throws CRMFException {
        this.addNameValuePair(name, value, false);
    }

    public RegInfo(byte[] regInfoBER, int offset, int special) throws CRMFException {
        if (regInfoBER == null) {
            throw new CRMFException("RegInfo Encoding is null.");
        }
        this.special = special;
        try {
            OfContainer seqOf = new OfContainer(special, 12288, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] regInfoDef = new ASN1Container[]{seqOf};
            ASN1.berDecode((byte[])regInfoBER, (int)offset, (ASN1Container[])regInfoDef);
            int count = seqOf.getContainerCount();
            for (int index = 0; index < count; ++index) {
                ASN1Container encodedInfoContainer = seqOf.containerAt(index);
                SequenceContainer seq = new SequenceContainer(0);
                EndContainer anEnd = new EndContainer();
                OIDContainer oid = new OIDContainer(0x1000000);
                UTF8StringContainer value = new UTF8StringContainer(0);
                ASN1Container[] asn1Def = new ASN1Container[]{seq, oid, value, anEnd};
                ASN1.berDecode((byte[])encodedInfoContainer.data, (int)encodedInfoContainer.dataOffset, (ASN1Container[])asn1Def);
                byte[] infoOID = new byte[oid.dataLen];
                System.arraycopy(oid.data, oid.dataOffset, infoOID, 0, oid.dataLen);
                if (!CertJUtils.byteArraysEqual(infoOID, REG_INFO_OID)) {
                    throw new CRMFException("Wrong OID");
                }
                if (value.data == null) continue;
                this.valueString = new String(value.data, value.dataOffset, value.dataLen);
                this.regInfoSeq.addElement(this.valueString);
            }
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Cannot read the BER of the regInfo.", (Exception)((Object)asnException));
        }
    }

    public void addNameValuePair(String name, String value, boolean newRegInfo) throws CRMFException {
        if (name == null || value == null) {
            throw new CRMFException("Passed in RegInfo values are null.");
        }
        this.valueString = this.urlEncode(name);
        this.valueString = this.valueString.concat("?");
        this.valueString = this.valueString.concat(this.urlEncode(value));
        this.valueString = this.valueString.concat("%");
        if (!newRegInfo && !this.regInfoSeq.isEmpty()) {
            String info = this.regInfoSeq.lastElement();
            this.regInfoSeq.removeElement(info);
            this.valueString = info = info.concat(this.valueString);
        }
        this.regInfoSeq.addElement(this.valueString);
        this.valueString = null;
    }

    public String getAttribute(int index) throws CRMFException {
        if (this.getRegInfoCount() > index) {
            return this.regInfoSeq.elementAt(index);
        }
        throw new CRMFException("The specified RegInfo index is invalid.");
    }

    public int getRegInfoCount() {
        return this.regInfoSeq.size();
    }

    public static int getNextBEROffset(byte[] infoBER, int offset) throws CRMFException {
        if (infoBER == null) {
            throw new CRMFException("RegInfo Encoding is null.");
        }
        if (infoBER[offset] == 0 && infoBER[offset + 1] == 0) {
            return offset + 2;
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])infoBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])infoBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Unable to determine length of the RegInfo BER", (Exception)((Object)asnException));
        }
    }

    public int getDERLen(int special) throws CRMFException {
        return this.encodeInit(special);
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws CRMFException {
        int returnValue;
        if (encoding == null) {
            throw new CRMFException("Specified RegInfo array is null.");
        }
        try {
            if (this.asn1Template == null || this.special != special) {
                this.getDERLen(special);
            }
            returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new CRMFException("Unable to encode RegInfo.", (Exception)((Object)asnException));
        }
        return returnValue;
    }

    private int encodeInit(int special) throws CRMFException {
        this.special = special;
        Vector<OfContainer> asn1Def = new Vector<OfContainer>();
        try {
            OfContainer seqOf = new OfContainer(special, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
            asn1Def.addElement(seqOf);
            int infoCount = 0;
            if (this.regInfoSeq != null) {
                infoCount = this.regInfoSeq.size();
            }
            for (int index = 0; index < infoCount; ++index) {
                this.valueString = this.regInfoSeq.elementAt(index);
                byte[] octets = this.valueString.getBytes();
                SequenceContainer seq1 = new SequenceContainer(special, true, 0);
                EndContainer anEnd = new EndContainer();
                OIDContainer oid = new OIDContainer(0x1000000, true, 0, REG_INFO_OID, 0, REG_INFO_OID.length);
                UTF8StringContainer value = new UTF8StringContainer(0, true, 0, octets, 0, octets.length);
                ASN1Container[] asnDef = new ASN1Container[]{seq1, oid, value, anEnd};
                this.asn1Template = new ASN1Template(asnDef);
                int encodingLen = this.asn1Template.derEncodeInit();
                byte[] encoding = new byte[encodingLen];
                encodingLen = this.asn1Template.derEncode(encoding, 0);
                EncodedContainer info = new EncodedContainer(0, true, 0, encoding, 0, encodingLen);
                seqOf.addContainer((ASN1Container)info);
            }
            Object[] asn1DefArray = new ASN1Container[asn1Def.size()];
            asn1Def.copyInto(asn1DefArray);
            this.asn1Template = new ASN1Template((ASN1Container[])asn1DefArray);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException((Exception)((Object)asnException));
        }
    }

    public boolean equals(Object obj) {
        int otherVectorLen;
        if (obj == null || !(obj instanceof RegInfo)) {
            return false;
        }
        RegInfo other = (RegInfo)obj;
        int thisVectorLen = this.regInfoSeq.size();
        if (thisVectorLen != (otherVectorLen = other.regInfoSeq.size())) {
            return false;
        }
        for (int vectorIndex = 0; vectorIndex < thisVectorLen; ++vectorIndex) {
            if (this.regInfoSeq.elementAt(vectorIndex).equals(other.regInfoSeq.elementAt(vectorIndex))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return 31 + CertJInternalHelper.hashCodeValue(this.regInfoSeq);
    }

    public Object clone() throws CloneNotSupportedException {
        RegInfo otherSelf = new RegInfo();
        otherSelf.regInfoSeq = new Vector<String>(this.regInfoSeq);
        try {
            if (this.asn1Template != null) {
                otherSelf.encodeInit(this.special);
            }
        }
        catch (CRMFException crmf) {
            throw new CloneNotSupportedException(crmf.getMessage());
        }
        return otherSelf;
    }

    private String urlEncode(String string) {
        return URLEncoder.encode(string);
    }
}

