/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.UTF8StringContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.Control;
import java.util.Arrays;

public class RegistrationToken
extends Control {
    private byte[] value;
    ASN1Template asn1TemplateValue;
    private int special = 0;

    public RegistrationToken() {
        this.controlTypeFlag = 0;
        this.theOID = new byte[OID_LIST[0].length];
        System.arraycopy(OID_LIST[0], 0, this.theOID, 0, this.theOID.length);
        this.controlTypeString = "RegistrationToken";
    }

    protected void decodeValue(byte[] valueBER, int offset) throws CRMFException {
        if (valueBER == null) {
            throw new CRMFException("RegistrationToken encoding is null.");
        }
        try {
            UTF8StringContainer utfContainer = new UTF8StringContainer(this.special);
            ASN1Container[] asn1Def = new ASN1Container[]{utfContainer};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            this.value = new byte[utfContainer.dataLen];
            System.arraycopy(utfContainer.data, utfContainer.dataOffset, this.value, 0, utfContainer.dataLen);
        }
        catch (Exception anyExc) {
            throw new CRMFException("Cannot decode RegistrationToken control.", anyExc);
        }
    }

    public void setValue(byte[] value, int offset, int len) throws CRMFException {
        if (value == null || len <= 0 || offset < 0) {
            throw new CRMFException("The RegistrationToken value cannot be null.");
        }
        this.value = new byte[len];
        System.arraycopy(value, offset, this.value, 0, len);
    }

    public byte[] getValue() {
        if (this.value == null) {
            return null;
        }
        byte[] returnValue = new byte[this.value.length];
        System.arraycopy(this.value, 0, returnValue, 0, this.value.length);
        return returnValue;
    }

    protected int derEncodeValue(byte[] encoding, int offset) throws CRMFException {
        if (encoding == null) {
            throw new CRMFException("Passed in array is null in RegistrationToken control.");
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            throw new CRMFException("Cannot encode RegistrationToken control.");
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Cannot encode RegistrationToken control.", (Exception)((Object)asnException));
        }
    }

    protected int derEncodeValueInit() throws CRMFException {
        this.asn1TemplateValue = null;
        try {
            UTF8StringContainer utfContainer = new UTF8StringContainer(this.special, true, 0, this.value, 0, this.value.length);
            ASN1Container[] asn1Def = new ASN1Container[]{utfContainer};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException((Exception)((Object)asnException));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        RegistrationToken otherSelf = new RegistrationToken();
        if (this.value != null) {
            otherSelf.value = (byte[])this.value.clone();
        }
        otherSelf.special = this.special;
        super.copyValues(otherSelf);
        return otherSelf;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RegistrationToken)) {
            return false;
        }
        RegistrationToken other = (RegistrationToken)obj;
        return CertJUtils.byteArraysEqual(this.value, other.value);
    }

    public int hashCode() {
        return 31 + Arrays.hashCode(this.value);
    }
}

