/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.internal;

import com.rsa.certj.FIPS140Mode;
import com.rsa.certj.FIPS140Role;
import com.rsa.jsafe.CryptoJ;
import com.rsa.jsafe.FIPS140Context;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import java.io.File;

public class CertJContext {
    public final com.rsa.jsafe.crypto.FIPS140Context fips140;
    public final FIPS140Context jsafe;

    CertJContext(com.rsa.jsafe.crypto.FIPS140Context fips140, FIPS140Context jsafeFIPS140) {
        this.fips140 = fips140;
        this.jsafe = jsafeFIPS140;
    }

    public static CertJContext getCertJContext() {
        FIPS140Context jsafeCtx;
        com.rsa.jsafe.crypto.FIPS140Context ctx = com.rsa.jsafe.crypto.CryptoJ.isFIPS140Compliant() ? com.rsa.jsafe.crypto.CryptoJ.getFIPS140Context() : null;
        try {
            jsafeCtx = CryptoJ.isFIPS140Compliant() ? CryptoJ.getFIPS140Context() : null;
        }
        catch (JSAFE_InvalidUseException e) {
            jsafeCtx = null;
        }
        return new CertJContext(ctx, jsafeCtx);
    }

    public static CertJContext getCertJContext(FIPS140Mode mode) {
        return CertJContext.getCertJContext(mode, CertJContext.defaultCertJRole(), null, null);
    }

    public static CertJContext getCertJContext(FIPS140Mode mode, FIPS140Role role) {
        return CertJContext.getCertJContext(mode, role, null, null);
    }

    public static CertJContext getCertJContext(FIPS140Mode mode, FIPS140Role role, byte[] pin, File moduleConfigFile) {
        com.rsa.jsafe.crypto.FIPS140Context jceContext = CertJContext.buildJSAFEJCEContext(mode, role, pin, moduleConfigFile);
        FIPS140Context jsafeContext = CertJContext.buildJSAFEContext(mode, role, pin, moduleConfigFile);
        return new CertJContext(jceContext, jsafeContext);
    }

    public int getMode() {
        return this.fips140 != null ? this.fips140.getModeValue() : -1;
    }

    public int getRole() {
        return this.fips140 != null ? this.fips140.getRoleValue() : -1;
    }

    static com.rsa.jsafe.crypto.FIPS140Context buildJSAFEJCEContext(FIPS140Mode mode, FIPS140Role role, byte[] pin, File moduleConfigFile) {
        com.rsa.jsafe.crypto.FIPS140Context jceContext = null;
        if (com.rsa.jsafe.crypto.CryptoJ.isFIPS140Compliant()) {
            if (mode == null || role == null) {
                throw new IllegalArgumentException("Parameters mode or role cannot be null.");
            }
            jceContext = pin == null ? new com.rsa.jsafe.crypto.FIPS140Context(mode.getValue(), role.getValue()) : (moduleConfigFile == null ? new com.rsa.jsafe.crypto.FIPS140Context(mode.getValue(), role.getValue(), pin) : new com.rsa.jsafe.crypto.FIPS140Context(mode.getValue(), role.getValue(), pin, moduleConfigFile));
        }
        return jceContext;
    }

    static FIPS140Context buildJSAFEContext(FIPS140Mode mode, FIPS140Role role, byte[] pin, File moduleConfigFile) {
        FIPS140Context jsafeContext = null;
        if (com.rsa.jsafe.crypto.CryptoJ.isFIPS140Compliant()) {
            if (mode == null || role == null) {
                throw new IllegalArgumentException("Parameters mode or role cannot be null.");
            }
            try {
                jsafeContext = pin == null ? new FIPS140Context(mode.getValue(), role.getValue()) : (moduleConfigFile == null ? new FIPS140Context(mode.getValue(), role.getValue(), pin) : new FIPS140Context(mode.getValue(), role.getValue(), pin, moduleConfigFile));
            }
            catch (JSAFE_InvalidUseException exc) {
                throw new AssertionError((Object)"Implementation Error: Mode/Role types must ensure only valid modes and roles are used.");
            }
        }
        return jsafeContext;
    }

    static FIPS140Role defaultCertJRole() {
        if (!com.rsa.jsafe.crypto.CryptoJ.isFIPS140Compliant()) {
            return null;
        }
        return FIPS140Role.lookup(com.rsa.jsafe.crypto.CryptoJ.getFIPS140Context().getRoleValue());
    }
}

