/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.internal;

import com.rsa.certj.cert.AttributeValueAssertion;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.RDN;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.internal.CertJContext;
import com.rsa.jsafe.crypto.FIPS140Context;
import com.rsa.jsafe.provider.JsafeJCE;
import java.io.ByteArrayInputStream;
import java.security.Provider;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;

public class CertificateUtil {
    public static final String DEFAULT_ENCODING = "Cp1252";

    public static X509Certificate convertToJCPCert(byte[] encodedData, CertJContext context) throws CertificateException {
        if (context == null) {
            context = CertJContext.getCertJContext();
        }
        JsafeJCE prov = context.getMode() != -1 && context.getRole() != -1 ? new JsafeJCE(new FIPS140Context(context.getMode(), context.getRole())) : new JsafeJCE();
        CertificateFactory factory = CertificateFactory.getInstance("X.509", (Provider)prov);
        ByteArrayInputStream is = new ByteArrayInputStream(encodedData);
        return (X509Certificate)factory.generateCertificate(is);
    }

    public static X509CRL convertToJCPCrl(byte[] encodedData, CertJContext context) throws CRLException {
        CertificateFactory cf;
        if (context == null) {
            context = CertJContext.getCertJContext();
        }
        JsafeJCE prov = context.getMode() != -1 && context.getRole() != -1 ? new JsafeJCE(new FIPS140Context(context.getMode(), context.getRole())) : new JsafeJCE();
        try {
            cf = CertificateFactory.getInstance("X509", (Provider)prov);
        }
        catch (CertificateException e) {
            throw new CRLException(e.getMessage());
        }
        ByteArrayInputStream is = new ByteArrayInputStream(encodedData);
        return (X509CRL)cf.generateCRL(is);
    }

    public static void checkSerialNumber(X500Name name) {
        try {
            boolean found = false;
            for (int i = 0; i < name.getRDNCount(); ++i) {
                RDN rdn = name.getRDN(i);
                AttributeValueAssertion ava = rdn.getAttribute(14);
                if (ava == null) continue;
                found = true;
                break;
            }
            if (!found) {
                RDN rdn = new RDN();
                AttributeValueAssertion ava = new AttributeValueAssertion(14, AttributeValueAssertion.SERIAL_NUMBER_OID, 1280, null);
                rdn.addNameAVA(ava);
                name.addRDN(rdn);
            }
        }
        catch (NameException nameException) {
            // empty catch block
        }
    }
}

