/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.internal;

import com.rsa.certj.internal.CertJContext;
import com.rsa.certj.internal.CertificateUtil;
import com.rsa.certj.spi.path.CertPathException;
import com.rsa.jcp.EVChecker;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EVDelegator {
    public static boolean checkEVCompliance(com.rsa.certj.cert.X509Certificate[] certs, List<String> trustedEVPolicyOIDs, int compatibilityMask, CertJContext context) throws CertPathException {
        boolean result;
        X509Certificate[] jcpCerts = new X509Certificate[certs.length];
        try {
            try {
                for (int i = 0; i < certs.length; ++i) {
                    byte[] data = new byte[certs[i].getDERLen(0)];
                    certs[i].getDEREncoding(data, 0, 0);
                    jcpCerts[i] = CertificateUtil.convertToJCPCert(data, context);
                }
            }
            catch (Exception e) {
                throw new CertPathException("Unable to parse certificates", e);
            }
            result = EVChecker.isEVCompliant((X509Certificate[])jcpCerts, trustedEVPolicyOIDs, (int)compatibilityMask);
        }
        catch (CertificateException e) {
            throw new CertPathException("Unable to check for EV Compliance", e);
        }
        return result;
    }

    public static int getDefaultCompatibilityMask() {
        return EVChecker.getDefaultCompatibilityMask();
    }
}

