/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.internal;

import com.rsa.certj.CertJ;
import com.rsa.certj.CertJInternalHelper;
import com.rsa.certj.internal.CertJContext;
import com.rsa.jsafe.CryptoJ;
import com.rsa.jsafe.FIPS140Context;
import com.rsa.jsafe.JSAFE_AsymmetricCipher;
import com.rsa.jsafe.JSAFE_IVException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_MAC;
import com.rsa.jsafe.JSAFE_MessageDigest;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_Recode;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_Signature;
import com.rsa.jsafe.JSAFE_SymmetricCipher;
import com.rsa.jsafe.JSAFE_UnimplementedException;

public class JSAFEFactory {
    private static final boolean IS_FIPS140_COMPLIANT = CryptoJ.isFIPS140Compliant();

    public static JSAFE_PublicKey getPublicKey(byte[] ber, int offset, String device, CertJ certj) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        return JSAFEFactory.getPublicKey(ber, offset, device, JSAFEFactory.fips140(certj));
    }

    public static JSAFE_PublicKey getPublicKey(byte[] ber, int offset, String device, FIPS140Context ctx) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        if (IS_FIPS140_COMPLIANT && ctx != null) {
            return JSAFE_PublicKey.getInstance((byte[])ber, (int)offset, (String)device, (FIPS140Context)ctx);
        }
        return JSAFE_PublicKey.getInstance((byte[])ber, (int)offset, (String)device);
    }

    public static JSAFE_MessageDigest getDigest(String transform, String device, CertJ certj) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        return JSAFEFactory.getDigest(transform, device, JSAFEFactory.fips140(certj));
    }

    public static JSAFE_MessageDigest getDigest(String transform, String device, FIPS140Context ctx) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        if (IS_FIPS140_COMPLIANT && ctx != null) {
            return JSAFE_MessageDigest.getInstance((String)transform, (String)device, (FIPS140Context)ctx);
        }
        return JSAFE_MessageDigest.getInstance((String)transform, (String)device);
    }

    public static JSAFE_Signature getSignature(String transform, String device, CertJ certj) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        return JSAFEFactory.getSignature(transform, device, JSAFEFactory.fips140(certj));
    }

    public static JSAFE_Signature getSignature(byte[] ber, int offset, String device, CertJ certj) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        return JSAFEFactory.getSignature(ber, offset, device, JSAFEFactory.fips140(certj));
    }

    public static JSAFE_Signature getSignature(String transform, String device, FIPS140Context ctx) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        if (IS_FIPS140_COMPLIANT && ctx != null) {
            return JSAFE_Signature.getInstance((String)transform, (String)device, (FIPS140Context)ctx);
        }
        return JSAFE_Signature.getInstance((String)transform, (String)device);
    }

    public static JSAFE_Signature getSignature(byte[] ber, int offset, String device, FIPS140Context ctx) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        if (IS_FIPS140_COMPLIANT && ctx != null) {
            return JSAFE_Signature.getInstance((byte[])ber, (int)offset, (String)device, (FIPS140Context)ctx);
        }
        return JSAFE_Signature.getInstance((byte[])ber, (int)offset, (String)device);
    }

    public static JSAFE_SecureRandom getRandom(CertJContext context) {
        if (context.jsafe == null) {
            return (JSAFE_SecureRandom)CryptoJ.getDefaultRandom();
        }
        return (JSAFE_SecureRandom)CryptoJ.getDefaultRandom((FIPS140Context)context.jsafe);
    }

    public static JSAFE_MAC getMAC(String transform, String device, FIPS140Context ctx) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        if (IS_FIPS140_COMPLIANT && ctx != null) {
            return JSAFE_MAC.getInstance((String)transform, (String)device, (FIPS140Context)ctx);
        }
        return JSAFE_MAC.getInstance((String)transform, (String)device);
    }

    private static FIPS140Context fips140(CertJ certj) {
        if (certj == null) {
            return null;
        }
        return CertJInternalHelper.context((CertJ)certj).jsafe;
    }

    public static JSAFE_SymmetricCipher getSymmetricCipher(byte[] ber, int offset, String device, FIPS140Context ctx) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException, JSAFE_IVException {
        if (IS_FIPS140_COMPLIANT && ctx != null) {
            return JSAFE_SymmetricCipher.getInstance((byte[])ber, (int)offset, (String)device, (FIPS140Context)ctx);
        }
        return JSAFE_SymmetricCipher.getInstance((byte[])ber, (int)offset, (String)device);
    }

    public static JSAFE_SymmetricCipher getSymmetricCipher(String transform, String device, FIPS140Context ctx) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        if (IS_FIPS140_COMPLIANT && ctx != null) {
            return JSAFE_SymmetricCipher.getInstance((String)transform, (String)device, (FIPS140Context)ctx);
        }
        return JSAFE_SymmetricCipher.getInstance((String)transform, (String)device);
    }

    public static JSAFE_SymmetricCipher getSymmetricCipher(byte[] ber, int offset, String device, CertJ certj) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException, JSAFE_IVException {
        return JSAFEFactory.getSymmetricCipher(ber, offset, device, JSAFEFactory.fips140(certj));
    }

    public static JSAFE_PrivateKey getPrivateKey(byte[] ber, int offset, String device, CertJ certj) throws JSAFE_UnimplementedException {
        return JSAFEFactory.getPrivateKey(ber, offset, device, JSAFEFactory.fips140(certj));
    }

    public static JSAFE_PrivateKey getPrivateKey(byte[] ber, int offset, String device, FIPS140Context ctx) throws JSAFE_UnimplementedException {
        if (IS_FIPS140_COMPLIANT && ctx != null) {
            return JSAFE_PrivateKey.getInstance((byte[])ber, (int)offset, (String)device, (FIPS140Context)ctx);
        }
        return JSAFE_PrivateKey.getInstance((byte[])ber, (int)offset, (String)device);
    }

    public static JSAFE_SymmetricCipher getSymmetricCipher(String transform, String device, CertJ certj) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        return JSAFEFactory.getSymmetricCipher(transform, device, JSAFEFactory.fips140(certj));
    }

    public static JSAFE_MessageDigest getDigest(byte[] ber, int offset, String device, FIPS140Context ctx) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        if (IS_FIPS140_COMPLIANT && ctx != null) {
            return JSAFE_MessageDigest.getInstance((byte[])ber, (int)offset, (String)device, (FIPS140Context)ctx);
        }
        return JSAFE_MessageDigest.getInstance((byte[])ber, (int)offset, (String)device);
    }

    public static JSAFE_SecretKey getSecretKey(String transform, String device, FIPS140Context ctx) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        if (IS_FIPS140_COMPLIANT && ctx != null) {
            return JSAFE_SecretKey.getInstance((String)transform, (String)device, (FIPS140Context)ctx);
        }
        return JSAFE_SecretKey.getInstance((String)transform, (String)device);
    }

    public static JSAFE_AsymmetricCipher getAsymmetricCipher(byte[] ber, int offset, String device, FIPS140Context ctx) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        if (IS_FIPS140_COMPLIANT && ctx != null) {
            return JSAFE_AsymmetricCipher.getInstance((byte[])ber, (int)offset, (String)device, (FIPS140Context)ctx);
        }
        return JSAFE_AsymmetricCipher.getInstance((byte[])ber, (int)offset, (String)device);
    }

    public static JSAFE_AsymmetricCipher getAsymmetricCipher(String transform, String device, FIPS140Context ctx) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        if (IS_FIPS140_COMPLIANT && ctx != null) {
            return JSAFE_AsymmetricCipher.getInstance((String)transform, (String)device, (FIPS140Context)ctx);
        }
        return JSAFE_AsymmetricCipher.getInstance((String)transform, (String)device);
    }

    public static JSAFE_Recode getRecode(String transform, String device, FIPS140Context ctx) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        if (IS_FIPS140_COMPLIANT && ctx != null) {
            return JSAFE_Recode.getInstance((String)transform, (String)device, (FIPS140Context)ctx);
        }
        return JSAFE_Recode.getInstance((String)transform, (String)device);
    }

    public static JSAFE_PublicKey getPublicKey(String transform, String device, FIPS140Context ctx) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        if (IS_FIPS140_COMPLIANT && ctx != null) {
            return JSAFE_PublicKey.getInstance((String)transform, (String)device, (FIPS140Context)ctx);
        }
        return JSAFE_PublicKey.getInstance((String)transform, (String)device);
    }

    public static JSAFE_PrivateKey getPrivateKey(String transform, String device, FIPS140Context ctx) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        if (IS_FIPS140_COMPLIANT && ctx != null) {
            return JSAFE_PrivateKey.getInstance((String)transform, (String)device, (FIPS140Context)ctx);
        }
        return JSAFE_PrivateKey.getInstance((String)transform, (String)device);
    }

    public static JSAFE_MAC getMAC(String transform, String device, CertJ certj) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        return JSAFEFactory.getMAC(transform, device, JSAFEFactory.fips140(certj));
    }

    public static JSAFE_AsymmetricCipher getAsymmetricCipher(byte[] ber, int offset, String device, CertJ certj) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        return JSAFEFactory.getAsymmetricCipher(ber, offset, device, JSAFEFactory.fips140(certj));
    }

    public static JSAFE_PrivateKey getPrivateKey(String transform, String device, CertJ certj) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        return JSAFEFactory.getPrivateKey(transform, device, JSAFEFactory.fips140(certj));
    }

    public static JSAFE_MessageDigest getDigest(byte[] ber, int offset, String device, CertJ certj) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        return JSAFEFactory.getDigest(ber, offset, device, JSAFEFactory.fips140(certj));
    }

    public static JSAFE_SecretKey getSecretKey(String transform, String device, CertJ certj) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        return JSAFEFactory.getSecretKey(transform, device, JSAFEFactory.fips140(certj));
    }
}

