/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.internal;

import com.rsa.certj.internal.CertJContext;
import com.rsa.certj.internal.CertificateUtil;
import com.rsa.certj.spi.path.CertPathException;
import com.rsa.certj.spi.revocation.CertStatusException;
import com.rsa.jcp.SuiteBChecker;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.provider.JsafeJCE;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;

public class SuiteBDelegator {
    public static boolean checkSuiteBCompliance(com.rsa.certj.cert.X509Certificate cert, JSAFE_PublicKey signingPubKey, CertJContext context) throws CertPathException {
        try {
            X509Certificate jcpCert;
            byte[] data = new byte[cert.getDERLen(0)];
            try {
                cert.getDEREncoding(data, 0, 0);
                jcpCert = CertificateUtil.convertToJCPCert(data, context);
            }
            catch (Exception e) {
                throw new CertPathException("Unable to parse certificate", e);
            }
            if (signingPubKey == null) {
                return SuiteBChecker.isSuiteBCompliant((X509Certificate)jcpCert);
            }
            return SuiteBChecker.isSuiteBCompliant((X509Certificate)jcpCert, (PublicKey)SuiteBDelegator.convertKey(signingPubKey));
        }
        catch (CertPathValidatorException e) {
            throw new CertPathException("Unable to check for SuiteB Compliance", e);
        }
    }

    public static boolean checkSuiteBCompliance(com.rsa.certj.cert.X509CRL crl) throws CertStatusException {
        X509CRL jcpCrl;
        CertJContext context = CertJContext.getCertJContext();
        byte[] data = new byte[crl.getDERLen(0)];
        try {
            crl.getDEREncoding(data, 0, 0);
            jcpCrl = CertificateUtil.convertToJCPCrl(data, context);
        }
        catch (Exception e) {
            throw new CertStatusException("Unable to parse CRL", e);
        }
        boolean result = SuiteBChecker.isSuiteBCompliant((X509CRL)jcpCrl, null);
        return result;
    }

    private static PublicKey convertKey(JSAFE_PublicKey publicKey) throws CertPathException {
        PublicKey jcePubKey;
        String[] formats = publicKey.getSupportedGetFormats();
        String berFormat = null;
        for (int j = 0; j < formats.length; ++j) {
            if (!"RSAPublicKeyBER".equals(formats[j]) && !"DSAPublicKeyBER".equals(formats[j]) && !"ECPublicKeyBER".equals(formats[j])) continue;
            berFormat = formats[j];
            break;
        }
        try {
            byte[][] keyData1 = publicKey.getKeyData(berFormat);
            KeyFactory keyFactory = KeyFactory.getInstance(publicKey.getAlgorithm(), (Provider)new JsafeJCE());
            jcePubKey = keyFactory.generatePublic(new X509EncodedKeySpec(keyData1[0]));
        }
        catch (Exception e) {
            throw new CertPathException("Unable to parse JSAFE_PublicKey for SuiteB compliance checks.", e);
        }
        return jcePubKey;
    }
}

