/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.pkcs12;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJException;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.certj.pkcs12.PKCS12Exception;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_MAC;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_UnimplementedException;

final class MacData {
    private static final int SALT_LEN = 8;
    private static final int ITERATIONS_DEFAULT = 1;

    private MacData() {
    }

    static byte[] encodeMac(CertJ certJ, byte[] data, int offset, int len, String digestAlg, int iterations, char[] password) throws PKCS12Exception {
        byte[] digestInfoEncoding;
        int derLen;
        JSAFE_MAC macObject = null;
        byte[] hmac = null;
        byte[] salt = new byte[8];
        String device = certJ.getDevice();
        try {
            macObject = JSAFEFactory.getMAC(MacData.createMacTransformation(digestAlg, iterations), device, certJ);
            JSAFE_SecureRandom random = certJ.getRandomObject();
            random.generateRandomBytes(salt, 0, 8);
            macObject.setSalt(salt, 0, salt.length);
            JSAFE_SecretKey macKey = macObject.getBlankKey();
            macKey.setPassword(password, 0, password.length);
            macObject.macInit(macKey, null);
            hmac = new byte[macObject.getMACSize()];
            macObject.macUpdate(data, offset, len);
            macObject.macFinal(hmac, 0);
        }
        catch (JSAFE_Exception e) {
            throw new PKCS12Exception("MacData.computeMac: JSAFE operation failed.", (Exception)((Object)e));
        }
        catch (CertJException e) {
            throw new PKCS12Exception("MacData.computeMac: ", e);
        }
        finally {
            if (macObject != null) {
                macObject.clearSensitiveData();
            }
        }
        try {
            SequenceContainer seq1 = new SequenceContainer(0, true, 0);
            SequenceContainer seq2 = new SequenceContainer(0, true, 0);
            EndContainer end = new EndContainer();
            OIDContainer oid = new OIDContainer(0, true, 0, digestAlg, 11);
            EncodedContainer params = new EncodedContainer(77824, false, 0, null, 0, 0);
            OctetStringContainer digest = new OctetStringContainer(0, true, 0, hmac, 0, hmac.length);
            ASN1Container[] digestInfoDef = new ASN1Container[]{seq1, seq2, oid, params, end, digest, end};
            ASN1Template template = new ASN1Template(digestInfoDef);
            derLen = template.derEncodeInit();
            digestInfoEncoding = new byte[derLen];
            template.derEncode(digestInfoEncoding, 0);
        }
        catch (ASN_Exception e) {
            throw new PKCS12Exception("MacData.encodeMac: Encoding DigestInfo failed.", (Exception)((Object)e));
        }
        try {
            SequenceContainer aSeq = new SequenceContainer(0, true, 0);
            EncodedContainer digestinfo = new EncodedContainer(12288, true, 0, digestInfoEncoding, 0, digestInfoEncoding.length);
            OctetStringContainer macsalt = new OctetStringContainer(0, true, 0, salt, 0, 8);
            IntegerContainer iters = new IntegerContainer(131072, iterations != 1, 0, iterations);
            EndContainer end = new EndContainer();
            ASN1Container[] macDataDef = new ASN1Container[]{aSeq, digestinfo, macsalt, iters, end};
            ASN1Template template = new ASN1Template(macDataDef);
            derLen = template.derEncodeInit();
            byte[] der = new byte[derLen];
            template.derEncode(der, 0);
            return der;
        }
        catch (ASN_Exception e) {
            throw new PKCS12Exception("MacData.encodeMac: Encoding MacData failed.", (Exception)((Object)e));
        }
    }

    static void verifyMacData(CertJ certJ, char[] password, byte[] authSafeBer, byte[] macDataBer, int macDataOffset, int special) throws PKCS12Exception {
        if (certJ == null) {
            throw new PKCS12Exception("MacData.MacData: certJ can not be null.");
        }
        try {
            SequenceContainer aSeq = new SequenceContainer(special);
            EndContainer anEnd = new EndContainer();
            EncodedContainer digestinfo = new EncodedContainer(12288);
            OctetStringContainer macsalt = new OctetStringContainer(0);
            IntegerContainer iters = new IntegerContainer(131072);
            ASN1Container[] macDataDef = new ASN1Container[]{aSeq, digestinfo, macsalt, iters, anEnd};
            ASN1.berDecode((byte[])macDataBer, (int)macDataOffset, (ASN1Container[])macDataDef);
            int iterations = 1;
            if (iters.dataPresent) {
                iterations = iters.getValueAsInt();
            }
            SequenceContainer seq1 = new SequenceContainer(0);
            SequenceContainer seq2 = new SequenceContainer(0);
            OIDContainer oid = new OIDContainer(0, 11);
            EncodedContainer params = new EncodedContainer(77824);
            OctetStringContainer digest = new OctetStringContainer(0);
            ASN1Container[] asn1Def = new ASN1Container[]{seq1, seq2, oid, params, anEnd, digest, anEnd};
            ASN1.berDecode((byte[])digestinfo.data, (int)digestinfo.dataOffset, (ASN1Container[])asn1Def);
            JSAFE_MAC macObject = JSAFEFactory.getMAC(MacData.createMacTransformation(oid.transformation, iterations), certJ.getDevice(), certJ);
            macObject.setSalt(macsalt.data, macsalt.dataOffset, macsalt.dataLen);
            JSAFE_SecretKey macKey = macObject.getBlankKey();
            macKey.setPassword(password, 0, password.length);
            macObject.verifyInit(macKey, null);
            macObject.verifyUpdate(authSafeBer, 0, authSafeBer.length);
            if (!macObject.verifyFinal(digest.data, digest.dataOffset, digest.dataLen)) {
                throw new PKCS12Exception("MacData.MacData: MAC Verification failed");
            }
        }
        catch (ASN_Exception asnException) {
            throw new PKCS12Exception("Cannot decode the BER of the MacData.");
        }
        catch (JSAFE_InvalidUseException jsafeException) {
            throw new PKCS12Exception((Exception)((Object)jsafeException));
        }
        catch (JSAFE_UnimplementedException jsafeException) {
            throw new PKCS12Exception((Exception)((Object)jsafeException));
        }
        catch (JSAFE_InvalidKeyException jsafeException) {
            throw new PKCS12Exception((Exception)((Object)jsafeException));
        }
        catch (JSAFE_InvalidParameterException jsafeException) {
            throw new PKCS12Exception((Exception)((Object)jsafeException));
        }
    }

    private static String createMacTransformation(String digestAlg, int iterations) {
        return "PBE/HMAC/" + digestAlg + "/PKCS12V1PBE-" + iterations + "-160";
    }
}

