/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.pkcs12;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJException;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.certj.pkcs12.MacData;
import com.rsa.certj.pkcs12.PKCS12Exception;
import com.rsa.certj.pkcs12.SafeContents;
import com.rsa.certj.pkcs12.SafeObjects;
import com.rsa.certj.pkcs7.ContentInfo;
import com.rsa.certj.pkcs7.Data;
import com.rsa.certj.pkcs7.EncryptedData;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_IVException;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_PaddingException;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_SymmetricCipher;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.Serializable;
import java.util.Vector;

final class PFX
implements Cloneable,
Serializable {
    private int version = 3;
    private SafeObjects safeObjects;
    private static final int SALT_LEN = 8;

    PFX(CertJ certJ, DatabaseService database, char[] password, char[] encPassword, byte[] pfxBer, int offset, int special) throws PKCS12Exception {
        try {
            SequenceContainer aSeq = new SequenceContainer(special);
            EndContainer anEnd = new EndContainer();
            IntegerContainer vers = new IntegerContainer(0);
            EncodedContainer auth = new EncodedContainer(12288);
            EncodedContainer mac = new EncodedContainer(77824);
            ASN1Container[] pfxDef = new ASN1Container[]{aSeq, vers, auth, mac, anEnd};
            ASN1.berDecode((byte[])pfxBer, (int)offset, (ASN1Container[])pfxDef);
            this.version = vers.getValueAsInt();
            if (encPassword == null) {
                encPassword = new char[password.length];
                System.arraycopy(password, 0, encPassword, 0, password.length);
            }
            byte[] content = this.decodeContentInfo(encPassword, certJ, auth.data, auth.dataOffset, auth.dataLen);
            if (mac.dataPresent) {
                MacData.verifyMacData(certJ, password, content, mac.data, mac.dataOffset, 0);
            }
            OfContainer ofContainer = new OfContainer(0, 12288, (ASN1Container)new EncodedContainer(65280));
            ASN1Container[] ofDef = new ASN1Container[]{ofContainer};
            ASN1.berDecode((byte[])content, (int)0, (ASN1Container[])ofDef);
            this.safeObjects = new SafeObjects();
            block9: for (int indx = 0; indx < ofContainer.getContainerCount(); ++indx) {
                ASN1Container contentinfo = ofContainer.containerAt(indx);
                byte[] dataBer = this.decodeContentInfo(encPassword, certJ, contentinfo.data, contentinfo.dataOffset, contentinfo.dataLen);
                int contentType = ContentInfo.getMessageType(contentinfo.data, contentinfo.dataOffset, contentinfo.dataLen);
                switch (contentType) {
                    case 1: 
                    case 6: {
                        new SafeContents(certJ, database, this.safeObjects, encPassword, dataBer, 0, 0);
                        continue block9;
                    }
                    case 3: {
                        throw new PKCS12Exception("enveloped data is not implemented yet");
                    }
                    default: {
                        throw new PKCS12Exception("Illegal contentType found");
                    }
                }
            }
            if (database != null) {
                Vector<JSAFE_PrivateKey> keyVector = this.safeObjects.getKeys();
                Vector<X501Attributes> attrsVector = this.safeObjects.keyAttributes;
                for (int i = 0; i < keyVector.size(); ++i) {
                    X509Certificate x509;
                    JSAFE_PrivateKey key = keyVector.elementAt(i);
                    X501Attributes attrs = attrsVector.elementAt(i);
                    if (attrs == null || (x509 = this.safeObjects.findCertificateForKey(attrs)) == null) continue;
                    database.insertPrivateKeyByCertificate(x509, key);
                }
            }
        }
        catch (NoServiceException certjException) {
            throw new PKCS12Exception(certjException);
        }
        catch (DatabaseException dbException) {
            throw new PKCS12Exception(dbException);
        }
        catch (ASN_Exception asnException) {
            throw new PKCS12Exception("Cannot decode the BER of the PFX.");
        }
        catch (PKCS7Exception e) {
            throw new PKCS12Exception("PFX.PFX: Illegal contentType found.", e);
        }
    }

    PFX(Certificate[] certs, CRL[] crls, JSAFE_PrivateKey[] keys, X501Attributes[] certAttrs, X501Attributes[] crlAttrs, X501Attributes[] keyAttrs, String[] keyFormats) throws InvalidParameterException {
        this.safeObjects = new SafeObjects(certs, crls, keys, certAttrs, crlAttrs, keyAttrs, keyFormats);
    }

    private byte[] decodeContentInfo(char[] password, CertJ certJ, byte[] contentBER, int offset, int dataLen) throws PKCS12Exception {
        try {
            int contentType = ContentInfo.getMessageType(contentBER, offset, dataLen);
            switch (contentType) {
                case 1: {
                    Data pkcs12data = new Data();
                    pkcs12data.readInit(contentBER, offset, dataLen);
                    return pkcs12data.getData();
                }
                case 3: {
                    throw new PKCS12Exception("Enveloped Data is not implemented yet");
                }
                case 6: {
                    return this.decryptEncryptedData(certJ, password, contentBER, offset);
                }
            }
            throw new PKCS12Exception("Illegal contentType found");
        }
        catch (PKCS7Exception pkcs7Exception) {
            throw new PKCS12Exception(pkcs7Exception);
        }
    }

    private byte[] decryptEncryptedData(CertJ certJ, char[] password, byte[] contentBER, int offset) throws PKCS12Exception {
        try {
            SequenceContainer aseq = new SequenceContainer(0);
            EndContainer aend = new EndContainer();
            OIDContainer contentOID = new OIDContainer(0x1000000);
            EncodedContainer encryptedData = new EncodedContainer(10616576);
            ASN1Container[] contentInfoDef = new ASN1Container[]{aseq, contentOID, encryptedData, aend};
            ASN1.berDecode((byte[])contentBER, (int)offset, (ASN1Container[])contentInfoDef);
            SequenceContainer bseq = new SequenceContainer(0xA10000);
            EndContainer bend = new EndContainer();
            IntegerContainer localVersion = new IntegerContainer(0);
            EncodedContainer encContentInfo = new EncodedContainer(12288);
            ASN1Container[] encryptedDef = new ASN1Container[]{bseq, localVersion, encContentInfo, bend};
            ASN1.berDecode((byte[])encryptedData.data, (int)encryptedData.dataOffset, (ASN1Container[])encryptedDef);
            SequenceContainer cSeq = new SequenceContainer(0);
            EndContainer cEnd = new EndContainer();
            OIDContainer pbeoid = new OIDContainer(0x1000000);
            EncodedContainer algoID = new EncodedContainer(12288);
            OctetStringContainer encryptContent = new OctetStringContainer(0x810000);
            ASN1Container[] infoStringDef = new ASN1Container[]{cSeq, pbeoid, algoID, encryptContent, cEnd};
            ASN1.berDecode((byte[])encContentInfo.data, (int)encContentInfo.dataOffset, (ASN1Container[])infoStringDef);
            SequenceContainer dSeq = new SequenceContainer(0);
            EndContainer dEnd = new EndContainer();
            OIDContainer algoOID = new OIDContainer(0);
            EncodedContainer theParams = new EncodedContainer(130816);
            ASN1Container[] algoDef = new ASN1Container[]{dSeq, algoOID, theParams, dEnd};
            ASN1.berDecode((byte[])algoID.data, (int)algoID.dataOffset, (ASN1Container[])algoDef);
            SequenceContainer eSeq = new SequenceContainer(0);
            EndContainer eEnd = new EndContainer();
            OctetStringContainer salt = new OctetStringContainer(0);
            IntegerContainer itCount = new IntegerContainer(0);
            ASN1Container[] paramsDef = new ASN1Container[]{eSeq, salt, itCount, eEnd};
            ASN1.berDecode((byte[])theParams.data, (int)theParams.dataOffset, (ASN1Container[])paramsDef);
            JSAFE_SymmetricCipher decryptor = JSAFEFactory.getSymmetricCipher(algoID.data, algoID.dataOffset, certJ.getDevice(), certJ);
            decryptor.setSalt(salt.data, salt.dataOffset, salt.dataLen);
            JSAFE_SecretKey secretKey = decryptor.getBlankKey();
            secretKey.setPassword(password, 0, password.length);
            decryptor.decryptInit(secretKey);
            byte[] newDataBer = new byte[encryptContent.dataLen];
            int partOut = decryptor.decryptUpdate(encryptContent.data, encryptContent.dataOffset, encryptContent.dataLen, newDataBer, 0);
            decryptor.decryptFinal(newDataBer, partOut);
            return newDataBer;
        }
        catch (JSAFE_InputException jsafeException) {
            throw new PKCS12Exception((Exception)((Object)jsafeException));
        }
        catch (JSAFE_PaddingException jsafeException) {
            throw new PKCS12Exception((Exception)((Object)jsafeException));
        }
        catch (JSAFE_InvalidParameterException jsafeException) {
            throw new PKCS12Exception((Exception)((Object)jsafeException));
        }
        catch (JSAFE_UnimplementedException jsafeException) {
            throw new PKCS12Exception((Exception)((Object)jsafeException));
        }
        catch (JSAFE_InvalidUseException jsafeException) {
            throw new PKCS12Exception((Exception)((Object)jsafeException));
        }
        catch (JSAFE_InvalidKeyException jsafeException) {
            throw new PKCS12Exception((Exception)((Object)jsafeException));
        }
        catch (JSAFE_IVException jsafeException) {
            throw new PKCS12Exception((Exception)((Object)jsafeException));
        }
        catch (ASN_Exception asnException) {
            throw new PKCS12Exception((Exception)((Object)asnException));
        }
    }

    void setVersion(int version) {
        this.version = version;
    }

    int getVersion() {
        return this.version;
    }

    SafeObjects getSafeObjects() {
        return this.safeObjects;
    }

    byte[] derEncode(CertJ certJ, char[] password, char[] encPassword, String encAlg, String digestAlg, int iterations, int option) throws PKCS12Exception {
        byte[] authDER;
        byte[] authenticatedSafe;
        if (encPassword == null) {
            encPassword = new char[password.length];
            System.arraycopy(password, 0, encPassword, 0, password.length);
        }
        SafeContents safeContents = new SafeContents(this.safeObjects);
        byte[] safeContentsDER = safeContents.derEncode(certJ, encAlg, encPassword, option);
        Data data = new Data();
        try {
            data.setContent(safeContentsDER, 0, safeContentsDER.length);
            ContentInfo contentInfo = data;
            if (option == 1) {
                try {
                    JSAFE_SecureRandom random = certJ.getRandomObject();
                    byte[] salt = new byte[8];
                    random.generateRandomBytes(salt, 0, 8);
                    EncryptedData encryptedData = new EncryptedData(certJ, null);
                    encryptedData.setVersionNumber(0);
                    encryptedData.setSalt(salt, 0, salt.length);
                    encryptedData.setEncryptionAlgorithm(encAlg);
                    encryptedData.setPassword(encPassword, 0, encPassword.length);
                    encryptedData.setContentInfo(data);
                    contentInfo = encryptedData;
                    JSAFEFactory.getSymmetricCipher(encAlg, certJ.getDevice(), certJ);
                }
                catch (JSAFE_Exception e) {
                    throw new PKCS12Exception("PFX.derEncode: ", (Exception)((Object)e));
                }
                catch (CertJException e) {
                    throw new PKCS12Exception("PFX.derEncode: No random provider error.", e);
                }
            }
            int innerLen = contentInfo.getContentInfoDERLen();
            try {
                SequenceContainer seq = new SequenceContainer(0, true, 0);
                EndContainer end = new EndContainer();
                EncodedContainer inner = new EncodedContainer(12288, true, 0, null, 0, innerLen);
                ASN1Container[] safe = new ASN1Container[]{seq, inner, end};
                ASN1Template template = new ASN1Template(safe);
                authenticatedSafe = new byte[template.derEncodeInit()];
                int innerStart = template.derEncode(authenticatedSafe, 0);
                contentInfo.writeMessage(authenticatedSafe, innerStart);
            }
            catch (ASN_Exception e) {
                throw new PKCS12Exception("PFX.derEncode: Encoding of authenticated failed.", (Exception)((Object)e));
            }
            Data authSafe = new Data();
            authSafe.setContent(authenticatedSafe, 0, authenticatedSafe.length);
            int authLen = authSafe.getContentInfoDERLen();
            authDER = new byte[authLen];
            authSafe.writeMessage(authDER, 0);
        }
        catch (PKCS7Exception e) {
            throw new PKCS12Exception("PFX.derEncode: ContentInfo encoding failed.", e);
        }
        byte[] macDER = MacData.encodeMac(certJ, authenticatedSafe, 0, authenticatedSafe.length, digestAlg, iterations, password);
        try {
            SequenceContainer aSeq = new SequenceContainer(0, true, 0);
            EndContainer anEnd = new EndContainer();
            IntegerContainer vers = new IntegerContainer(0, true, 0, this.version);
            EncodedContainer auth = new EncodedContainer(12288, true, 0, authDER, 0, authDER.length);
            EncodedContainer mac = new EncodedContainer(77824, true, 0, macDER, 0, macDER.length);
            ASN1Container[] pfxDef = new ASN1Container[]{aSeq, vers, auth, mac, anEnd};
            ASN1Template template = new ASN1Template(pfxDef);
            int len = template.derEncodeInit();
            byte[] der = new byte[len];
            template.derEncode(der, 0);
            return der;
        }
        catch (ASN_Exception e) {
            throw new PKCS12Exception("PFX.derEncode: Encoding PFX failed.", (Exception)((Object)e));
        }
    }
}

