/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.pkcs7;

import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.OIDContainer;
import com.rsa.certj.pkcs7.Data;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.certj.pkcs7.Pkcs7Util;
import java.util.Arrays;

public class CMSData
extends Data {
    public CMSData(String dottedOID) throws PKCS7Exception {
        this.oid = Pkcs7Util.oidStrToArray(dottedOID);
    }

    public CMSData(byte[] oid) throws PKCS7Exception {
        this.oid = oid;
    }

    public byte[] getOID() {
        return this.oid;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        CMSData other = (CMSData)obj;
        if (this.oid.length != other.oid.length) {
            return false;
        }
        for (int i = 0; i < this.oid.length; ++i) {
            if (this.oid[i] == other.oid[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(this.oid);
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        CMSData otherSelf = (CMSData)super.clone();
        otherSelf.oid = this.oid;
        return otherSelf;
    }

    protected OIDContainer buildOIDContainer() throws ASN_Exception {
        return new OIDContainer(0x1000000, true, 0, this.oid, 0, this.oid.length);
    }
}

