/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.pkcs7;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.pkcs7.ContentInfo;
import com.rsa.certj.pkcs7.PKCS7Exception;
import java.util.Arrays;

public class Data
extends ContentInfo {
    protected byte[] data;
    protected int dataLen;

    public Data() {
        this.contentType = 1;
        OctetStringContainer octetStringContainer = null;
        try {
            octetStringContainer = new OctetStringContainer(0xA10000, true, 0, null, 0, 0);
        }
        catch (ASN_Exception aSN_Exception) {
            // empty catch block
        }
        this.contentASN1Def = new ASN1Container[1];
        this.contentASN1Def[0] = octetStringContainer;
    }

    public void setContent(byte[] octetString, int offset, int len) throws PKCS7Exception {
        if (octetString == null || len <= 0) {
            throw new PKCS7Exception("content is null");
        }
        if (offset < 0 || offset + len > octetString.length) {
            throw new PKCS7Exception("Invalid Content data");
        }
        this.data = new byte[len];
        System.arraycopy(octetString, offset, this.data, 0, len);
        this.dataLen = len;
    }

    public byte[] getData() {
        if (this.data != null) {
            byte[] retContent = new byte[this.dataLen];
            System.arraycopy(this.data, 0, retContent, 0, this.dataLen);
            return retContent;
        }
        return null;
    }

    protected int getContentDERLen() throws PKCS7Exception {
        this.contentASN1Def[0].data = null;
        this.contentASN1Def[0].dataLen = this.dataLen;
        this.contentASN1Def[0].dataPresent = this.data != null;
        this.contentASN1Template = new ASN1Template(this.contentASN1Def);
        try {
            return this.contentASN1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception((Exception)((Object)asnException));
        }
    }

    protected int writeContent(byte[] output, int outOffset) throws PKCS7Exception {
        if (output == null) {
            throw new PKCS7Exception("Cannot write Data: output array is null.");
        }
        try {
            this.contentASN1Def[0].data = this.data;
            this.contentASN1Def[0].dataOffset = 0;
            this.contentASN1Def[0].dataLen = this.dataLen;
            return this.contentASN1Template.derEncode(output, outOffset);
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Could not DER encode Data: ", (Exception)((Object)asnException));
        }
    }

    protected boolean contentReadInit(byte[] input, int inOffset, int maxInputLen) throws PKCS7Exception {
        try {
            if (this.maxBufferSize != 0) {
                OctetStringContainer octetStringContainer = new OctetStringContainer(0xA10000, true, 0, this.maxBufferSize, null, 0, 0);
                this.contentASN1Def = new ASN1Container[1];
                this.contentASN1Def[0] = octetStringContainer;
            }
            this.contentASN1Template = new ASN1Template(this.contentASN1Def);
            this.contentASN1Template.berDecodeInit();
            this.numberOfBytesRead = this.contentASN1Template.berDecodeUpdate(input, inOffset, maxInputLen);
            this.copyNewDataToOutput();
            return true;
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Could not decode message: ", (Exception)((Object)asnException));
        }
    }

    protected int contentReadUpdate(byte[] input, int inOffset, int maxInputLen) throws PKCS7Exception {
        this.numberOfBytesRead = 0;
        int bytesToOutput = 0;
        if (input == null) {
            return bytesToOutput;
        }
        if (this.contentASN1Template == null) {
            this.contentASN1Template = new ASN1Template(this.contentASN1Def);
            this.contentASN1Template.berDecodeInit();
        }
        try {
            if (this.contentASN1Template.isComplete()) {
                return bytesToOutput;
            }
            this.numberOfBytesRead = this.contentASN1Template.berDecodeUpdate(input, inOffset, maxInputLen);
            return bytesToOutput += this.copyNewDataToOutput();
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Could not decode message: ", (Exception)((Object)asnException));
        }
    }

    private int copyNewDataToOutput() {
        int copyLen;
        int maxOutput;
        if (this.contentASN1Def[0].data == null || this.contentASN1Def[0].dataLen == 0) {
            return 0;
        }
        if (this.data == null) {
            this.data = this.maxBufferSize != 0 ? new byte[this.maxBufferSize] : new byte[this.contentASN1Def[0].dataLen];
        }
        if ((maxOutput = this.data.length - this.dataLen) < this.contentASN1Def[0].dataLen) {
            byte[] temp = new byte[this.dataLen];
            System.arraycopy(this.data, 0, temp, 0, this.dataLen);
            this.clearInternalBuffer(this.data);
            this.data = new byte[this.contentASN1Def[0].dataLen + this.dataLen];
            System.arraycopy(temp, 0, this.data, 0, this.dataLen);
            this.clearInternalBuffer(temp);
        }
        if ((copyLen = this.contentASN1Def[0].dataLen) != 0) {
            System.arraycopy(this.contentASN1Def[0].data, this.contentASN1Def[0].dataOffset, this.data, this.dataLen, copyLen);
        }
        this.dataLen += copyLen;
        return copyLen;
    }

    public int getUnprocessedDataLen() {
        return this.dataLen;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Data)) {
            return false;
        }
        Data other = (Data)obj;
        return this.dataLen == other.dataLen && CertJUtils.byteArraysEqual(this.data, 0, this.dataLen, other.data, 0, other.dataLen);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(this.data);
        result = prime * result + this.dataLen;
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        Data otherSelf = (Data)super.clone();
        if (this.data != null) {
            otherSelf.data = new byte[this.data.length];
            System.arraycopy(this.data, 0, otherSelf.data, 0, this.dataLen);
            otherSelf.dataLen = this.dataLen;
        }
        return otherSelf;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.clearInternalBuffer(this.data);
    }
}

