/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.pkcs7;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.pkcs7.ContentInfo;
import com.rsa.certj.pkcs7.PKCS7Exception;
import java.io.Serializable;
import java.util.Arrays;

class EncryptedContentInfo
implements Cloneable,
Serializable {
    private byte[] contentType;
    private byte[] encryptionAlgorithm;
    private byte[] encryptedContent;
    private static final int CONTENT_SPECIAL = 0x810000;
    protected static int special;
    private ASN1Template asn1Template;

    protected EncryptedContentInfo() {
    }

    protected EncryptedContentInfo(byte[] infoBER, int offset, int special, int maxBufferSize) throws PKCS7Exception {
        block6: {
            try {
                OctetStringContainer encryptContent;
                SequenceContainer aSeq = new SequenceContainer(special);
                EndContainer anEnd = new EndContainer();
                OIDContainer oid = new OIDContainer(0x1000000);
                EncodedContainer encryptionID = new EncodedContainer(12288);
                EncodedContainer content = new EncodedContainer(130816);
                ASN1Container[] infoStringDef = new ASN1Container[]{aSeq, oid, encryptionID, content, anEnd};
                ASN1.berDecode((byte[])infoBER, (int)offset, (ASN1Container[])infoStringDef);
                this.contentType = new byte[oid.dataLen];
                System.arraycopy(oid.data, oid.dataOffset, this.contentType, 0, oid.dataLen);
                this.encryptionAlgorithm = new byte[encryptionID.dataLen];
                System.arraycopy(encryptionID.data, encryptionID.dataOffset, this.encryptionAlgorithm, 0, encryptionID.dataLen);
                if (!content.dataPresent) break block6;
                int curMaxBufferSize = maxBufferSize - content.dataOffset + offset;
                if (maxBufferSize == 0) {
                    curMaxBufferSize = 0;
                }
                try {
                    encryptContent = new OctetStringContainer(0x810000, true, 0, curMaxBufferSize, null, 0, 0);
                    ASN1Container[] encryptedContentDef = new ASN1Container[]{encryptContent};
                    ASN1.berDecode((byte[])content.data, (int)content.dataOffset, (ASN1Container[])encryptedContentDef);
                }
                catch (ASN_Exception e) {
                    encryptContent = new OctetStringContainer(0xA10000, true, 0, curMaxBufferSize, null, 0, 0);
                    ASN1Container[] encryptedContentDef = new ASN1Container[]{encryptContent};
                    ASN1.berDecode((byte[])content.data, (int)content.dataOffset, (ASN1Container[])encryptedContentDef);
                }
                if (encryptContent.dataPresent) {
                    this.encryptedContent = new byte[encryptContent.dataLen];
                    System.arraycopy(encryptContent.data, encryptContent.dataOffset, this.encryptedContent, 0, encryptContent.dataLen);
                }
            }
            catch (ASN_Exception asnException) {
                throw new PKCS7Exception("Cannot decode the BER of the EncryptedContentInfo.", (Exception)((Object)asnException));
            }
        }
    }

    protected void setContentType(byte[] type, int offset, int len) throws PKCS7Exception {
        if (type == null) {
            throw new PKCS7Exception("Cannot set content type: null OID.");
        }
        if (len != 9) {
            throw new PKCS7Exception("Cannot set content type: unknown OID.");
        }
        for (int index = 0; index < 7; ++index) {
            if (type[index + offset] == ContentInfo.P7OID[index]) continue;
            throw new PKCS7Exception("Cannot set content type: unknown OID.");
        }
        this.contentType = new byte[len];
        System.arraycopy(type, offset, this.contentType, 0, len);
    }

    protected byte[] getContentType() {
        return this.contentType;
    }

    protected void setEncryptionAlgorithm(byte[] oid, int offset, int len) throws PKCS7Exception {
        if (oid == null || len == 0) {
            throw new PKCS7Exception("Specified OID is NULL.");
        }
        this.encryptionAlgorithm = new byte[len];
        System.arraycopy(oid, offset, this.encryptionAlgorithm, 0, len);
    }

    protected byte[] getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    protected void setEncryptedContent(byte[] content, int offset, int len) throws PKCS7Exception {
        if (content == null) {
            throw new PKCS7Exception("encrypted content is null.");
        }
        this.encryptedContent = new byte[len];
        System.arraycopy(content, offset, this.encryptedContent, 0, len);
    }

    protected byte[] getEncryptedContent() {
        return this.encryptedContent;
    }

    protected int getDERLen(int special) throws PKCS7Exception {
        EncryptedContentInfo.special = special;
        return this.derEncodeInit();
    }

    protected int getDEREncoding(byte[] encoding, int offset, int special) throws PKCS7Exception {
        try {
            if (this.asn1Template == null || special != EncryptedContentInfo.special) {
                this.getDERLen(special);
            }
            int returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
            return returnValue;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new PKCS7Exception("Unable to encode EncryptedContentInfo: ", (Exception)((Object)asnException));
        }
    }

    private int derEncodeInit() throws PKCS7Exception {
        try {
            SequenceContainer aSeq = new SequenceContainer(special, true, 0);
            EndContainer anEnd = new EndContainer();
            OIDContainer oid = new OIDContainer(0x1000000, true, 0, this.contentType, 0, this.contentType.length);
            EncodedContainer encryptionID = new EncodedContainer(12288, true, 0, this.encryptionAlgorithm, 0, this.encryptionAlgorithm.length);
            if (this.encryptedContent != null) {
                OctetStringContainer encryptContent = new OctetStringContainer(0x810000, true, 0, this.encryptedContent, 0, this.encryptedContent.length);
                ASN1Container[] infoStringDef = new ASN1Container[]{aSeq, oid, encryptionID, encryptContent, anEnd};
                this.asn1Template = new ASN1Template(infoStringDef);
            } else {
                ASN1Container[] infoStringDef1 = new ASN1Container[]{aSeq, oid, encryptionID, anEnd};
                this.asn1Template = new ASN1Template(infoStringDef1);
            }
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception((Exception)((Object)asnException));
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof EncryptedContentInfo)) {
            return false;
        }
        EncryptedContentInfo other = (EncryptedContentInfo)obj;
        return CertJUtils.byteArraysEqual(this.contentType, other.contentType) && CertJUtils.byteArraysEqual(this.encryptionAlgorithm, other.encryptionAlgorithm) && CertJUtils.byteArraysEqual(this.encryptedContent, other.encryptedContent);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(this.contentType);
        result = prime * result + Arrays.hashCode(this.encryptedContent);
        result = prime * result + Arrays.hashCode(this.encryptionAlgorithm);
        return result;
    }

    protected Object clone() throws CloneNotSupportedException {
        EncryptedContentInfo otherSelf = new EncryptedContentInfo();
        if (this.contentType != null) {
            otherSelf.contentType = new byte[this.contentType.length];
            System.arraycopy(this.contentType, 0, otherSelf.contentType, 0, this.contentType.length);
        }
        if (this.encryptionAlgorithm != null) {
            otherSelf.encryptionAlgorithm = new byte[this.encryptionAlgorithm.length];
            System.arraycopy(this.encryptionAlgorithm, 0, otherSelf.encryptionAlgorithm, 0, this.encryptionAlgorithm.length);
        }
        if (this.encryptedContent != null) {
            otherSelf.encryptedContent = new byte[this.encryptedContent.length];
            System.arraycopy(this.encryptedContent, 0, otherSelf.encryptedContent, 0, this.encryptedContent.length);
        }
        try {
            if (this.asn1Template != null) {
                otherSelf.derEncodeInit();
            }
        }
        catch (PKCS7Exception pkcsException) {
            throw new CloneNotSupportedException(pkcsException.getMessage());
        }
        return otherSelf;
    }

    protected void clearSensitiveData() {
        this.contentType = null;
        this.encryptionAlgorithm = null;
        this.encryptedContent = null;
        special = 0;
    }
}

