/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.pkcs7;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDList;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJInternalHelper;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.FIPS140Mode;
import com.rsa.certj.FIPS140Role;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.internal.CertJContext;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.certj.pkcs7.DigestedData;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.jsafe.JSAFE_AsymmetricCipher;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_Signature;
import java.io.Serializable;
import java.util.Arrays;

public class SignerInfo
implements Cloneable,
Serializable {
    private static final int AUTHENT_ATTR_SPECIAL = 0x810000;
    private static final int UNAUTHENT_ATTR_SPECIAL = 0x810001;
    private int version = 1;
    private X500Name issuer;
    private byte[] serialNumber;
    private byte[] digestOID;
    private X501Attributes authentAttrs;
    private byte[] digestEncryptionOID;
    private X501Attributes unauthentAttrs;
    private byte[] digest;
    private String digestAlgName;
    private String encryptionAlgName;
    private byte[] authenAttrsOrgBer;
    protected static int special;
    private ASN1Template asn1Template;
    private final CertJContext context;

    public SignerInfo() {
        this(CertJContext.getCertJContext());
    }

    public SignerInfo(FIPS140Mode mode) {
        this(CertJContext.getCertJContext(mode));
    }

    public SignerInfo(FIPS140Mode mode, FIPS140Role role) {
        this(CertJContext.getCertJContext(mode, role));
    }

    protected SignerInfo(byte[] infoBER, int offset, int special) throws PKCS7Exception {
        this(CertJContext.getCertJContext(), infoBER, offset, special);
    }

    protected SignerInfo(byte[] infoBER, int offset, int special, FIPS140Mode mode) throws PKCS7Exception {
        this(CertJContext.getCertJContext(mode), infoBER, offset, special);
    }

    protected SignerInfo(byte[] infoBER, int offset, int special, FIPS140Mode mode, FIPS140Role role) throws PKCS7Exception {
        this(CertJContext.getCertJContext(mode, role), infoBER, offset, special);
    }

    SignerInfo(CertJContext context) {
        this.context = context;
    }

    SignerInfo(CertJContext context, byte[] infoBER, int offset, int special) throws PKCS7Exception {
        this.context = context;
        try {
            if (infoBER == null) {
                throw new PKCS7Exception("Encoding is null.");
            }
            SequenceContainer aSeq = new SequenceContainer(special);
            EndContainer anEnd = new EndContainer();
            IntegerContainer vers = new IntegerContainer(0);
            EncodedContainer issuerAndserial = new EncodedContainer(12288);
            EncodedContainer digestID = new EncodedContainer(12288);
            EncodedContainer authAttrs = new EncodedContainer(8466688);
            EncodedContainer digestEncryptID = new EncodedContainer(12288);
            OctetStringContainer encryptDigest = new OctetStringContainer(0);
            EncodedContainer unauthAttrs = new EncodedContainer(8466689);
            ASN1Container[] infoStringDef = new ASN1Container[]{aSeq, vers, issuerAndserial, digestID, authAttrs, digestEncryptID, encryptDigest, unauthAttrs, anEnd};
            ASN1.berDecode((byte[])infoBER, (int)offset, (ASN1Container[])infoStringDef);
            this.version = vers.getValueAsInt();
            SequenceContainer bSeq = new SequenceContainer(special);
            EncodedContainer iss = new EncodedContainer(12288);
            IntegerContainer serial = new IntegerContainer(0);
            ASN1Container[] issAndSerialDef = new ASN1Container[]{bSeq, iss, serial, anEnd};
            ASN1.berDecode((byte[])issuerAndserial.data, (int)issuerAndserial.dataOffset, (ASN1Container[])issAndSerialDef);
            this.issuer = new X500Name(iss.data, iss.dataOffset, 0);
            if (serial.dataLen == 0) {
                throw new PKCS7Exception("Cannot decode the BER of the SignerInfo: Serial Number is null.");
            }
            this.serialNumber = new byte[serial.dataLen];
            System.arraycopy(serial.data, serial.dataOffset, this.serialNumber, 0, serial.dataLen);
            if (digestID.dataLen == 0) {
                throw new PKCS7Exception("Cannot decode the BER of the SignerInfo: Digest algorithm is missing.");
            }
            this.digestOID = new byte[digestID.dataLen];
            System.arraycopy(digestID.data, digestID.dataOffset, this.digestOID, 0, digestID.dataLen);
            if (authAttrs.dataPresent) {
                this.authenAttrsOrgBer = new byte[authAttrs.dataLen];
                System.arraycopy(authAttrs.data, authAttrs.dataOffset, this.authenAttrsOrgBer, 0, authAttrs.dataLen);
                this.authenAttrsOrgBer[0] = 49;
                this.authentAttrs = new X501Attributes(authAttrs.data, authAttrs.dataOffset, 0x810000);
            }
            if (digestEncryptID.dataLen == 0) {
                throw new PKCS7Exception("Cannot decode the BER of the SignerInfo: Encryption algorithm is missing.");
            }
            this.digestEncryptionOID = new byte[digestEncryptID.dataLen];
            System.arraycopy(digestEncryptID.data, digestEncryptID.dataOffset, this.digestEncryptionOID, 0, digestEncryptID.dataLen);
            this.checkForDSAWithParamsOID();
            if (encryptDigest.dataLen == 0) {
                throw new PKCS7Exception("Cannot decode the BER of the SignerInfo: Encrypted digest is missing.");
            }
            this.digest = new byte[encryptDigest.dataLen];
            System.arraycopy(encryptDigest.data, encryptDigest.dataOffset, this.digest, 0, encryptDigest.dataLen);
            if (unauthAttrs.dataPresent) {
                this.unauthentAttrs = new X501Attributes(unauthAttrs.data, unauthAttrs.dataOffset, 0x810001);
            }
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Cannot decode the BER of the SignerInfo: ", (Exception)((Object)asnException));
        }
        catch (AttributeException attrException) {
            throw new PKCS7Exception("Cannot decode the BER of the SignerInfo: ", attrException);
        }
        catch (NameException nameException) {
            throw new PKCS7Exception("Cannot decode the BER of the SignerInfo: ", nameException);
        }
    }

    public void setVersionNumber(int version) {
        this.version = version;
    }

    public int getVersionNumber() {
        return this.version;
    }

    public void setIssuerAndSerialNumber(X500Name name, byte[] number, int offset, int length) throws PKCS7Exception {
        if (name == null) {
            throw new PKCS7Exception("Issuer name is null.");
        }
        try {
            this.issuer = (X500Name)name.clone();
        }
        catch (CloneNotSupportedException cloneExc) {
            throw new PKCS7Exception("Invalid name.");
        }
        if (number == null || length <= 0) {
            throw new PKCS7Exception("SerialNumber is null.");
        }
        if (offset < 0 || offset + length > number.length) {
            throw new PKCS7Exception("Invalid SerialNumber");
        }
        this.serialNumber = new byte[length];
        System.arraycopy(number, offset, this.serialNumber, 0, length);
    }

    public X500Name getIssuerName() throws PKCS7Exception {
        if (this.issuer == null) {
            return null;
        }
        try {
            return (X500Name)this.issuer.clone();
        }
        catch (CloneNotSupportedException cloneExc) {
            throw new PKCS7Exception("Invalid attributes.");
        }
    }

    public byte[] getSerialNumber() {
        if (this.serialNumber == null) {
            return null;
        }
        return (byte[])this.serialNumber.clone();
    }

    public byte[] getIssuerAndSerialNumber() throws PKCS7Exception {
        if (this.issuer == null || this.serialNumber == null) {
            throw new PKCS7Exception("Cannot get issuerSerial, not all values set.");
        }
        try {
            int nameLen = this.issuer.getDERLen(0);
            byte[] nameBER = new byte[nameLen];
            nameLen = this.issuer.getDEREncoding(nameBER, 0, 0);
            SequenceContainer aSeq = new SequenceContainer(0, true, 0);
            EndContainer anEnd = new EndContainer();
            IntegerContainer serial = (this.serialNumber[0] & 0x80) >> 7 == 0 ? new IntegerContainer(0, true, 0, this.serialNumber, 0, this.serialNumber.length, true) : new IntegerContainer(0, true, 0, this.serialNumber, 0, this.serialNumber.length, false);
            EncodedContainer issue = new EncodedContainer(12288, true, 0, nameBER, 0, nameLen);
            ASN1Container[] asn1Def = new ASN1Container[]{aSeq, issue, serial, anEnd};
            return ASN1.derEncode((ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Cannot encode issuerSerial: ", (Exception)((Object)asnException));
        }
        catch (NameException nameException) {
            throw new PKCS7Exception("Cannot encode issuerSerial: ", nameException);
        }
    }

    public void setDigestAlgorithm(String algName) throws PKCS7Exception {
        this.digestOID = DigestedData.setDigestAlgorithmInternal(this.context, algName);
        this.digestAlgName = algName;
    }

    public void setDigestAlgorithm(byte[] digestOID, int offset, int len) throws PKCS7Exception {
        this.digestOID = DigestedData.setDigestAlgorithmInternal(digestOID, offset, len);
    }

    public byte[] getDigestAlgorithmOID() {
        return this.digestOID;
    }

    public String getDigestAlgorithmName() throws PKCS7Exception {
        return DigestedData.getDigestAlgorithmNameInternal(this.context, this.digestOID, this.digestAlgName);
    }

    public void setAuthenticatedAttrs(X501Attributes attrs) throws PKCS7Exception {
        if (attrs == null) {
            throw new PKCS7Exception("Attributes are null");
        }
        try {
            this.authentAttrs = (X501Attributes)attrs.clone();
        }
        catch (CloneNotSupportedException cloneExc) {
            throw new PKCS7Exception("Invalid attributes: ", cloneExc);
        }
    }

    protected byte[] getAuthenticatedAttrsBer() {
        if (this.authenAttrsOrgBer != null) {
            return this.authenAttrsOrgBer;
        }
        return null;
    }

    public X501Attributes getAuthenticatedAttrs() throws PKCS7Exception {
        if (this.authentAttrs == null) {
            return null;
        }
        try {
            return (X501Attributes)this.authentAttrs.clone();
        }
        catch (CloneNotSupportedException cloneExc) {
            throw new PKCS7Exception("Invalid attributes.");
        }
    }

    public void setEncryptionAlgorithm(String algName) throws PKCS7Exception {
        if (algName == null) {
            throw new PKCS7Exception("Could not set algorithm OID: name is null.");
        }
        this.encryptionAlgName = algName;
        if (algName.indexOf("RSA") != -1) {
            try {
                JSAFE_AsymmetricCipher asymmetricCipher = JSAFEFactory.getAsymmetricCipher(algName, "Java", this.context.jsafe);
                this.digestEncryptionOID = asymmetricCipher.getDERAlgorithmID();
            }
            catch (JSAFE_Exception jsafeException) {
                throw new PKCS7Exception("Could not set algorithm OID: ", (Exception)((Object)jsafeException));
            }
        } else if (algName.indexOf("DSA") != -1) {
            try {
                JSAFE_Signature signature = JSAFEFactory.getSignature(this.buildSignatureInfo(algName), "Java", this.context.jsafe);
                this.digestEncryptionOID = signature.getDERAlgorithmID();
            }
            catch (JSAFE_Exception jsafeException) {
                throw new PKCS7Exception("Could not set algorithm OID: ", (Exception)((Object)jsafeException));
            }
        } else {
            throw new PKCS7Exception("Could not set Encryption Algorithm, " + algName + " is invalid algorithm.");
        }
    }

    private String buildSignatureInfo(String algName) throws PKCS7Exception {
        if (this.getDigestAlgorithmName() == null) {
            this.setDigestAlgorithm("SHA1");
        }
        return this.getDigestAlgorithmName() + "/" + algName + "/NoPad";
    }

    public void setEncryptionAlgorithm(byte[] encryptOID, int offset, int len) throws PKCS7Exception {
        if (encryptOID == null || len <= 0) {
            throw new PKCS7Exception("Could not set algorithm OID: OID is null");
        }
        if (offset < 0 || offset + len > encryptOID.length) {
            throw new PKCS7Exception("Invalid Encryption Algorithm Identifier.");
        }
        this.digestEncryptionOID = new byte[len];
        System.arraycopy(encryptOID, offset, this.digestEncryptionOID, 0, len);
    }

    public byte[] getEncryptionAlgorithmOID() {
        if (this.digestEncryptionOID == null) {
            return null;
        }
        return (byte[])this.digestEncryptionOID.clone();
    }

    public String getEncryptionAlgorithmName() throws PKCS7Exception {
        if (this.digestEncryptionOID == null) {
            return null;
        }
        if (this.encryptionAlgName != null) {
            return this.encryptionAlgName;
        }
        try {
            JSAFE_AsymmetricCipher asymmetricCipher = JSAFEFactory.getAsymmetricCipher(this.digestEncryptionOID, 0, "Java", this.context.jsafe);
            return asymmetricCipher.getEncryptionAlgorithm();
        }
        catch (JSAFE_Exception jsafeException) {
            try {
                JSAFE_Signature signature = JSAFEFactory.getSignature(this.digestEncryptionOID, 0, "Java", this.context.jsafe);
                return signature.getSignatureAlgorithm();
            }
            catch (JSAFE_Exception jsafeException2) {
                throw new PKCS7Exception("Could not get encryption algorithm name: ", (Exception)((Object)jsafeException2));
            }
        }
    }

    private void checkForDSAWithParamsOID() throws PKCS7Exception {
        int offset = -1;
        offset = this.digestEncryptionOID[3] == 6 ? 3 : 2;
        if (this.digestEncryptionOID[offset] == 6) {
            byte[] tempOID = new byte[this.digestEncryptionOID[offset + 1]];
            System.arraycopy(this.digestEncryptionOID, offset + 2, tempOID, 0, this.digestEncryptionOID[offset + 1]);
            if (Arrays.equals(tempOID, OIDList.getOID((String)"DSAX957", (int)4))) {
                this.setEncryptionAlgorithm("DSA");
            }
        }
    }

    protected void setEncryptedDigest(byte[] encryptDigest, int offset, int len) {
        if (encryptDigest != null && len != 0) {
            this.digest = new byte[len];
            System.arraycopy(encryptDigest, offset, this.digest, 0, len);
        }
    }

    public byte[] getEncryptedDigest() {
        if (this.digest == null) {
            return null;
        }
        return (byte[])this.digest.clone();
    }

    public void setUnauthenticatedAttrs(X501Attributes attrs) throws PKCS7Exception {
        if (attrs == null) {
            throw new PKCS7Exception("Null attributes.");
        }
        try {
            this.unauthentAttrs = (X501Attributes)attrs.clone();
        }
        catch (CloneNotSupportedException cloneExc) {
            throw new PKCS7Exception("Invalid attributes: ", cloneExc);
        }
    }

    public X501Attributes getUnauthenticatedAttrs() throws PKCS7Exception {
        if (this.unauthentAttrs == null) {
            return null;
        }
        try {
            return (X501Attributes)this.unauthentAttrs.clone();
        }
        catch (CloneNotSupportedException cloneExc) {
            throw new PKCS7Exception("Invalid attributes: ", cloneExc);
        }
    }

    protected static int getNextBEROffset(byte[] infoBER, int offset) throws PKCS7Exception {
        if (infoBER == null) {
            throw new PKCS7Exception("Encoding is null.");
        }
        if (infoBER[offset] == 0 && infoBER[offset + 1] == 0) {
            return offset + 2;
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])infoBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])infoBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Unable to determine length of the BER: ", (Exception)((Object)asnException));
        }
    }

    protected int getDERLen(int special) throws PKCS7Exception {
        SignerInfo.special = special;
        return this.derEncodeInit();
    }

    protected int getDEREncoding(byte[] encoding, int offset, int special) throws PKCS7Exception {
        if (encoding == null) {
            throw new PKCS7Exception("Passed array is null.");
        }
        try {
            if (this.asn1Template == null || special != SignerInfo.special) {
                this.getDERLen(special);
            }
            int returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
            return returnValue;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new PKCS7Exception("Unable to encode SignerInfo: ", (Exception)((Object)asnException));
        }
    }

    private int derEncodeInit() throws PKCS7Exception {
        if (this.issuer == null || this.serialNumber == null) {
            throw new PKCS7Exception("Cannot encode SignerInfo: issuerName or SerialNumber is not set.");
        }
        try {
            int len = this.issuer.getDERLen(0);
            byte[] encoding0 = new byte[len];
            len = this.issuer.getDEREncoding(encoding0, 0, 0);
            EncodedContainer authAttrs = null;
            if (this.authentAttrs != null) {
                len = this.authentAttrs.getDERLen(0x810000);
                byte[] encoding1 = new byte[len];
                len = this.authentAttrs.getDEREncoding(encoding1, 0, 0x810000);
                authAttrs = new EncodedContainer(8466688, true, 0, encoding1, 0, len);
            }
            EncodedContainer unauthAttrs = null;
            if (this.unauthentAttrs != null) {
                len = this.unauthentAttrs.getDERLen(0x810001);
                byte[] encoding2 = new byte[len];
                len = this.unauthentAttrs.getDEREncoding(encoding2, 0, 0x810001);
                unauthAttrs = new EncodedContainer(8466689, true, 0, encoding2, 0, len);
            }
            SequenceContainer bSeq = new SequenceContainer(0, true, 0);
            EndContainer anEnd = new EndContainer();
            EncodedContainer iss = new EncodedContainer(12288, true, 0, encoding0, 0, encoding0.length);
            IntegerContainer serial = (this.serialNumber[0] & 0x80) >> 7 == 0 ? new IntegerContainer(0, true, 0, this.serialNumber, 0, this.serialNumber.length, true) : new IntegerContainer(0, true, 0, this.serialNumber, 0, this.serialNumber.length, false);
            ASN1Container[] issAndSerialDef = new ASN1Container[]{bSeq, iss, serial, anEnd};
            ASN1Template issTemplate = new ASN1Template(issAndSerialDef);
            len = issTemplate.derEncodeInit();
            byte[] encoding = new byte[len];
            issTemplate.derEncode(encoding, 0);
            SequenceContainer aSeq = new SequenceContainer(special, true, 0);
            IntegerContainer vers = new IntegerContainer(0, true, 0, this.version);
            EncodedContainer issuerAndserial = new EncodedContainer(12288, true, 0, encoding, 0, encoding.length);
            if (this.digestOID == null) {
                throw new PKCS7Exception("DigestAlgorithmIdentifier is not set.");
            }
            EncodedContainer digestID = new EncodedContainer(12288, true, 0, this.digestOID, 0, this.digestOID.length);
            if (this.digestEncryptionOID == null) {
                throw new PKCS7Exception("EncryptionAlgorithmIdentifier is not set.");
            }
            EncodedContainer digestEncryptID = new EncodedContainer(12288, true, 0, this.digestEncryptionOID, 0, this.digestEncryptionOID.length);
            int digestLen = 0;
            if (this.digest != null) {
                digestLen = this.digest.length;
            }
            OctetStringContainer encryptDigest = new OctetStringContainer(0, true, 0, this.digest, 0, digestLen);
            if (authAttrs != null) {
                if (unauthAttrs != null) {
                    ASN1Container[] infoStringDef1 = new ASN1Container[]{aSeq, vers, issuerAndserial, digestID, authAttrs, digestEncryptID, encryptDigest, unauthAttrs, anEnd};
                    this.asn1Template = new ASN1Template(infoStringDef1);
                } else {
                    ASN1Container[] infoStringDef2 = new ASN1Container[]{aSeq, vers, issuerAndserial, digestID, authAttrs, digestEncryptID, encryptDigest, anEnd};
                    this.asn1Template = new ASN1Template(infoStringDef2);
                }
            } else if (unauthAttrs != null) {
                ASN1Container[] infoStringDef3 = new ASN1Container[]{aSeq, vers, issuerAndserial, digestID, digestEncryptID, encryptDigest, unauthAttrs, anEnd};
                this.asn1Template = new ASN1Template(infoStringDef3);
            } else {
                ASN1Container[] infoStringDef4 = new ASN1Container[]{aSeq, vers, issuerAndserial, digestID, digestEncryptID, encryptDigest, anEnd};
                this.asn1Template = new ASN1Template(infoStringDef4);
            }
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Cannot encode SignerInfo: ", (Exception)((Object)asnException));
        }
        catch (NameException nameException) {
            throw new PKCS7Exception("Cannot encode X500Name: ", nameException);
        }
        catch (AttributeException attrException) {
            throw new PKCS7Exception("Cannot encode X501Attributes: ", attrException);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SignerInfo)) {
            return false;
        }
        SignerInfo other = (SignerInfo)obj;
        if (this.version != other.version) {
            return false;
        }
        if (this.issuer != null ? !this.issuer.equals(other.issuer) : other.issuer != null) {
            return false;
        }
        if (!CertJUtils.byteArraysEqual(this.serialNumber, other.serialNumber)) {
            return false;
        }
        if (!CertJUtils.byteArraysEqual(this.digestOID, other.digestOID)) {
            return false;
        }
        if (this.authentAttrs != null ? !this.authentAttrs.equals(other.authentAttrs) : other.authentAttrs != null) {
            return false;
        }
        if (!CertJUtils.byteArraysEqual(this.digestEncryptionOID, other.digestEncryptionOID)) {
            return false;
        }
        if (this.unauthentAttrs != null ? !this.unauthentAttrs.equals(other.unauthentAttrs) : other.unauthentAttrs != null) {
            return false;
        }
        return CertJUtils.byteArraysEqual(this.digest, other.digest);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + CertJInternalHelper.hashCodeValue(this.authentAttrs);
        result = prime * result + Arrays.hashCode(this.digest);
        result = prime * result + Arrays.hashCode(this.digestEncryptionOID);
        result = prime * result + Arrays.hashCode(this.digestOID);
        result = prime * result + CertJInternalHelper.hashCodeValue(this.issuer);
        result = prime * result + Arrays.hashCode(this.serialNumber);
        result = prime * result + CertJInternalHelper.hashCodeValue(this.unauthentAttrs);
        result = prime * result + this.version;
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        SignerInfo otherSelf = new SignerInfo(this.context);
        otherSelf.version = this.version;
        if (this.issuer != null) {
            otherSelf.issuer = (X500Name)this.issuer.clone();
        }
        if (this.serialNumber != null) {
            otherSelf.serialNumber = new byte[this.serialNumber.length];
            System.arraycopy(this.serialNumber, 0, otherSelf.serialNumber, 0, this.serialNumber.length);
        }
        if (this.digestOID != null) {
            otherSelf.digestOID = new byte[this.digestOID.length];
            System.arraycopy(this.digestOID, 0, otherSelf.digestOID, 0, this.digestOID.length);
        }
        if (this.authentAttrs != null) {
            otherSelf.authentAttrs = (X501Attributes)this.authentAttrs.clone();
        }
        if (this.digestEncryptionOID != null) {
            otherSelf.digestEncryptionOID = new byte[this.digestEncryptionOID.length];
            System.arraycopy(this.digestEncryptionOID, 0, otherSelf.digestEncryptionOID, 0, this.digestEncryptionOID.length);
        }
        if (this.unauthentAttrs != null) {
            otherSelf.unauthentAttrs = (X501Attributes)this.unauthentAttrs.clone();
        }
        if (this.digest != null) {
            otherSelf.digest = new byte[this.digest.length];
            System.arraycopy(this.digest, 0, otherSelf.digest, 0, this.digest.length);
        }
        if (this.authenAttrsOrgBer != null) {
            otherSelf.authenAttrsOrgBer = new byte[this.authenAttrsOrgBer.length];
            System.arraycopy(this.authenAttrsOrgBer, 0, otherSelf.authenAttrsOrgBer, 0, this.authenAttrsOrgBer.length);
        }
        try {
            if (this.asn1Template != null) {
                otherSelf.derEncodeInit();
            }
        }
        catch (PKCS7Exception pkcsException) {
            throw new CloneNotSupportedException("Cannot set ASN1 template:" + pkcsException.getMessage());
        }
        return otherSelf;
    }
}

