/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider;

import com.rsa.certj.CertJ;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.core.util.Version;
import com.rsa.certj.provider.pki.HTTPResult;
import com.rsa.certj.spi.pki.PKIException;
import com.rsa.certj.spi.pki.PKIResult;
import com.rsa.certj.spi.pki.PKIStatusInfo;
import com.rsa.certj.spi.pki.PKITransportException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class TransportImplementation
extends ProviderImplementation {
    public static final String MIME_CONTENT_TYPE_PREFIX = "Content-type: ";
    public static final String MIME_CONTENT_LENGTH_PREFIX = "Content-length: ";
    protected static final String MIME_USER_AGENT_STRING = "User-Agent: Cert-J/" + Version.getVersionString();
    protected static final String HTTP_HEADER_CACHE_CONTROL_NO_CACHE = "Cache-Control: no-cache";
    protected static final String HTTP_HEADER_PRAGMA_NO_CACHE = "Pragma: no-cache";
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final int READ_BUFFER_SIZE = 30000;
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final String CRLF = "\r\n";
    protected String[] destList;
    protected String[] proxyList;
    protected String profile;
    protected int timeoutSecs;
    protected String host;
    protected int port;
    protected Socket socket;
    private String urlFile;
    protected boolean closeConnection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket socketWithTimeout(String host, int port, int mstimeout) throws IOException {
        MakeSocketThr thr = new MakeSocketThr(host, port);
        Object object = thr.lock;
        synchronized (object) {
            thr.start();
            try {
                thr.lock.wait(mstimeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (thr.socket != null) {
            return thr.socket;
        }
        if (thr.exception != null) {
            throw thr.exception;
        }
        thr.interrupt();
        throw new InterruptedIOException("connect timed out");
    }

    public TransportImplementation(CertJ certJ, String name) throws InvalidParameterException {
        super(certJ, name);
    }

    public synchronized void unregister() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PKIResult sendAndReceiveHttp(URL url, String[] headers, String[] proxyList, byte[] request, String[] responseTypes) throws PKIException {
        HTTPResult httpResult = this.http("POST", url, proxyList, headers, request);
        String[] statusStrings = httpResult.getHeaders();
        int failInfoAux = httpResult.getStatus();
        int status = this.mapHTTPStatus(failInfoAux);
        int failInfo = this.mapHTTPFailInfo(failInfoAux);
        if (status == 0) {
            String contentString = null;
            for (int i = 0; i < statusStrings.length; ++i) {
                String string = statusStrings[i];
                int prefixLen = MIME_CONTENT_TYPE_PREFIX.length();
                if (string.length() <= prefixLen || !MIME_CONTENT_TYPE_PREFIX.equalsIgnoreCase(string.substring(0, prefixLen))) continue;
                contentString = string;
                break;
            }
            if (contentString == null) {
                throw new PKIException("TransportImplementation.sendAndReceiveHttp: no Content-type found.");
            }
            boolean found = false;
            for (int i = 0; i < responseTypes.length; ++i) {
                String responseType = responseTypes[i];
                if (contentString.length() < responseType.length() || !responseType.equalsIgnoreCase(contentString.substring(0, responseType.length()))) continue;
                found = true;
                break;
            }
            if (!found) {
                status = 2;
                failInfo = 0x200000;
            }
        }
        if (status != 0 && httpResult.getMessage().length > 0) {
            String[] originalStatusStrings = statusStrings;
            int originalLen = originalStatusStrings.length;
            statusStrings = new String[originalLen + 2];
            System.arraycopy(originalStatusStrings, 0, statusStrings, 0, originalLen);
            statusStrings[originalLen] = null;
            statusStrings[originalLen + 1] = new String(httpResult.getMessage());
        }
        return new PKIResult(new PKIStatusInfo(status, failInfo, statusStrings, failInfoAux), httpResult.getMessage());
    }

    public synchronized HTTPResult http(String method, URL url, String[] proxyList, String[] headers, byte[] message) throws PKIException {
        if (this.socket != null) {
            return this.httpSend(method, headers, message);
        }
        int proxyCount = 0;
        if (proxyList != null) {
            proxyCount = proxyList.length;
        }
        if (message == null) {
            message = new byte[]{};
        }
        if (proxyList == null || proxyCount == 0) {
            this.host = url.getHost();
            this.port = this.getPort(url);
            this.urlFile = this.getFile(url);
            return this.httpSend(method, headers, message);
        }
        String remoteHost = url.getHost();
        int remotePort = url.getPort();
        for (int i = 0; i < proxyCount; ++i) {
            URL proxyURL;
            String urlstr = null;
            try {
                urlstr = proxyList[i];
                proxyURL = new URL(urlstr);
            }
            catch (MalformedURLException e) {
                throw new PKIException("TransportImplementation.http: unable to parse proxy specification" + urlstr + ".", e);
            }
            try {
                this.host = proxyURL.getHost();
                this.port = proxyURL.getPort();
                String portString = ":" + (remotePort <= 0 ? 80 : remotePort);
                this.urlFile = "http://" + remoteHost + portString + this.getFile(url);
                return this.httpSend(method, headers, message);
            }
            catch (Exception e) {
                continue;
            }
        }
        throw new PKIException("TransportImplementation.http: no proxy succeeds.");
    }

    public int mapHTTPStatus(int code) {
        if (code >= 200 && code < 300) {
            return 0;
        }
        return 2;
    }

    public int mapHTTPFailInfo(int code) {
        if (code < 200) {
            return 0x200000;
        }
        if (code >= 200 && code < 300) {
            return 0;
        }
        if (code >= 300 && code < 400) {
            return 0x200000;
        }
        if (code >= 400 && code < 500) {
            return 0x20000000;
        }
        if (code >= 500 && code < 600) {
            return 0x100000;
        }
        return 0x200000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPResult httpSend(String method, String[] headers, byte[] message) throws PKIException {
        Object header;
        if (method == null || !method.equalsIgnoreCase("POST")) {
            throw new PKIException("TransportImplementation.httpSend: only POST is supported.");
        }
        StringBuffer buffer = new StringBuffer(method + " " + this.urlFile + " HTTP/1.0" + CRLF);
        if (headers == null) {
            throw new PKIException("TransportImplementation.httpSend: Content-Type not found.");
        }
        int headerCount = headers.length;
        boolean foundContentType = false;
        for (int i = 0; i < headerCount; ++i) {
            header = headers[i];
            if (((String)header).length() >= MIME_CONTENT_TYPE_PREFIX.length() && MIME_CONTENT_TYPE_PREFIX.equalsIgnoreCase(((String)header).substring(0, MIME_CONTENT_TYPE_PREFIX.length()))) {
                foundContentType = true;
            }
            if (((String)header).length() >= MIME_CONTENT_LENGTH_PREFIX.length() && MIME_CONTENT_LENGTH_PREFIX.equalsIgnoreCase(((String)header).substring(0, MIME_CONTENT_LENGTH_PREFIX.length()))) {
                throw new PKIException("TransportImplementation.httpSend: found Content-Length.");
            }
            buffer.append((String)header).append(CRLF);
        }
        if (!foundContentType) {
            throw new PKIException("TransportImplementation.httpSend: Content-Type not found.");
        }
        buffer.append(MIME_CONTENT_LENGTH_PREFIX);
        buffer.append(message.length);
        buffer.append("\r\n\r\n");
        byte[] dataRead = null;
        try {
            this.openSocketIfNecessary();
            header = new String(buffer).getBytes();
            dataRead = this.httpTransport((byte[])header, message, true);
        }
        finally {
            if (this.socket != null && this.closeConnection) {
                try {
                    this.socket.close();
                    this.socket = null;
                }
                catch (IOException e) {
                    throw new PKITransportException("TransportImplementation.httpSend: unable to close a socket.", e);
                }
            }
        }
        int headerLen = this.getHTTPHeaderLen(dataRead);
        String headerString = new String(dataRead, 0, headerLen);
        byte[] body = new byte[dataRead.length - headerLen];
        System.arraycopy(dataRead, headerLen, body, 0, dataRead.length - headerLen);
        Vector<String> items = new Vector<String>();
        int start = 0;
        boolean foundCR = false;
        block12: for (int i = 0; i < headerString.length(); ++i) {
            char ch = headerString.charAt(i);
            switch (ch) {
                case '\r': {
                    foundCR = true;
                    continue block12;
                }
                case '\n': {
                    if (foundCR) {
                        items.addElement(headerString.substring(start, i - 1));
                        start = i + 1;
                    }
                    foundCR = false;
                    continue block12;
                }
                default: {
                    foundCR = false;
                }
            }
        }
        int itemCount = items.size();
        if (itemCount == 0) {
            throw new PKIException("TransportImplementation.httpSend: no headers received.");
        }
        int status = this.findStatusNumber((String)items.elementAt(0));
        String[] returnHeaders = new String[itemCount - 1];
        for (int i = 1; i < itemCount; ++i) {
            returnHeaders[i - 1] = (String)items.elementAt(i);
        }
        return new HTTPResult(status, returnHeaders, body);
    }

    private byte[] httpTransport(byte[] header, byte[] body, boolean retry) throws PKITransportException {
        try {
            this.writeToSocket(header);
            this.writeToSocket(body, 0, body.length);
            byte[] dataRead = this.readFromSocket();
            if (retry && dataRead.length == 0) {
                this.openSocket();
                return this.httpTransport(header, body, false);
            }
            return dataRead;
        }
        catch (IOException e) {
            if (retry) {
                this.openSocket();
                return this.httpTransport(header, body, false);
            }
            throw new PKITransportException("TransportImplementation.httpTransfer: socket I/O failed.", e);
        }
    }

    protected void openSocket() throws PKITransportException {
        try {
            this.socket = this.timeoutSecs >= 0 ? this.socketWithTimeout(this.host, this.port, this.timeoutSecs * 1000) : new Socket(this.host, this.port);
            if (this.timeoutSecs >= 0) {
                this.socket.setSoTimeout(this.timeoutSecs * 1000);
            }
        }
        catch (UnknownHostException e) {
            throw new PKITransportException("TransportImplementation.openSocket: unknown host(" + this.host + ")", e);
        }
        catch (SocketException e) {
            throw new PKITransportException("TransportImplementation.openSocket: socket operation failed.", e);
        }
        catch (IOException e) {
            throw new PKITransportException("TransportImplementation.openSocket: IO operation failed.", e);
        }
    }

    protected void writeToSocket(byte[] data) throws PKITransportException, IOException {
        this.writeToSocket(data, 0, data.length);
    }

    protected void writeToSocket(byte[] data, int offset, int size) throws PKITransportException, IOException {
        OutputStream output = this.socket.getOutputStream();
        output.write(data, offset, size);
        output.flush();
    }

    private byte[] readFromSocket() throws IOException {
        int readCount;
        byte[] dataReadSoFar;
        byte[] buffer = new byte[30000];
        byte[] data = dataReadSoFar = new byte[0];
        InputStream input = this.socket.getInputStream();
        while ((readCount = input.read(buffer)) >= 0) {
            data = new byte[dataReadSoFar.length + readCount];
            System.arraycopy(dataReadSoFar, 0, data, 0, dataReadSoFar.length);
            System.arraycopy(buffer, 0, data, dataReadSoFar.length, readCount);
            dataReadSoFar = data;
        }
        return data;
    }

    private int getHTTPHeaderLen(byte[] data) throws PKIException {
        int state = 0;
        for (int i = 0; i < data.length; ++i) {
            switch (data[i]) {
                case 13: {
                    if (state != 0 && state != 2) break;
                    ++state;
                    break;
                }
                case 10: {
                    if (state != 1 && state != 3) break;
                    ++state;
                    break;
                }
                default: {
                    state = 0;
                }
            }
            if (state != 4) continue;
            return i + 1;
        }
        throw new PKIException("TransportImplementation.getHTTPHeaderLen: HTTP header not found.");
    }

    private int getPort(URL url) throws PKIException {
        int localPort = url.getPort();
        if (localPort != -1) {
            return localPort;
        }
        if (url.getProtocol().equalsIgnoreCase("http")) {
            return 80;
        }
        if (url.getProtocol().equalsIgnoreCase("https")) {
            return 443;
        }
        throw new PKIException("TransportImplementation.getPort: make sure to specify the port number for URLs.");
    }

    private String getFile(URL url) {
        String file = url.getFile();
        if (file == null || file.equals("")) {
            return "/";
        }
        return file;
    }

    private int findStatusNumber(String statusLine) throws PKIException {
        StringTokenizer tokens = new StringTokenizer(statusLine, " ");
        int count = tokens.countTokens();
        if (count < 2) {
            throw new PKIException("PKICommonImplementation.findStatusNumber: invalid status line.");
        }
        tokens.nextToken();
        String token = tokens.nextToken();
        int result = 0;
        for (int i = 0; i < token.length(); ++i) {
            char ch = token.charAt(i);
            if (ch < '0' || ch > '9') {
                throw new PKIException("PKICommonImplementation.findStatusNumber: non-decimal digit found in status code.");
            }
            result = result * 10 + ch - 48;
        }
        return result;
    }

    protected void openSocketIfNecessary() throws PKITransportException {
        if (this.socket == null) {
            this.openSocket();
        }
    }

    public String getName() {
        return super.getName();
    }

    static class MakeSocketThr
    extends Thread {
        Object lock;
        Socket socket;
        IOException exception;
        private final String mHost;
        private final int mPort;

        MakeSocketThr(String host, int port) {
            this.mHost = host;
            this.mPort = port;
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Socket s;
            try {
                s = new Socket(this.mHost, this.mPort);
            }
            catch (IOException e) {
                if (MakeSocketThr.interrupted()) {
                    return;
                }
                this.exception = e;
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notify();
                }
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                this.socket = s;
                this.lock.notify();
            }
        }
    }
}

