/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.db;

import com.rsa.certj.CertJ;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.provider.db.EnhancedFlatFileDB;
import com.rsa.certj.provider.db.EnhancedFlatFileDBAccess;
import com.rsa.certj.provider.db.FlatFileDB;
import com.rsa.certj.provider.db.FlatFileDBAccess;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.db.DatabaseInterface;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EnhancedFlatFileDBImpl
extends ProviderImplementation
implements DatabaseInterface {
    private List<File> certIterator;
    private List<File> crlIterator;
    private List<File> keyIterator;
    private int certPointer;
    private int crlPointer;
    private int keyPointer;
    private final Lock certIteratorLock = new ReentrantLock();
    private final Lock crlIteratorLock = new ReentrantLock();
    private final Lock keyIteratorLock = new ReentrantLock();
    private EnhancedFlatFileDBAccess access;

    EnhancedFlatFileDBImpl(EnhancedFlatFileDB enhancedFlatFileDB, CertJ certJ, String name) throws InvalidParameterException {
        super(certJ, name);
        this.access = (EnhancedFlatFileDBAccess)EnhancedFlatFileDB.accessHash.get(enhancedFlatFileDB.path);
        if (this.access == null) {
            try {
                this.access = new EnhancedFlatFileDBAccess(enhancedFlatFileDB.path, enhancedFlatFileDB.passphrase, enhancedFlatFileDB.salt);
            }
            catch (DatabaseException e) {
                throw new InvalidParameterException("Could not create database using the specified path");
            }
            EnhancedFlatFileDB.accessHash.put(enhancedFlatFileDB.path, this.access);
        }
        ++this.access.references;
    }

    EnhancedFlatFileDBImpl(FlatFileDB flatFileDB, CertJ certJ, String name) throws InvalidParameterException {
        super(certJ, name);
        this.access = (FlatFileDBAccess)FlatFileDB.accessHash.get(flatFileDB.path);
        if (this.access == null) {
            try {
                this.access = new FlatFileDBAccess(flatFileDB.path, flatFileDB.passphrase, flatFileDB.baseNameLen, flatFileDB.prefixLen);
            }
            catch (DatabaseException e) {
                throw new InvalidParameterException("Could not create database using the specified path");
            }
            FlatFileDB.accessHash.put(flatFileDB.path, this.access);
        }
        ++this.access.references;
    }

    @Override
    public void unregister() {
        --this.access.references;
        if (this.access.references == 0) {
            if (this.access instanceof FlatFileDBAccess) {
                FlatFileDB.accessHash.remove(this.access.path);
            } else if (this.access instanceof EnhancedFlatFileDBAccess) {
                EnhancedFlatFileDB.accessHash.remove(this.access.path);
            }
        }
    }

    @Override
    public void insertCertificate(Certificate cert) throws DatabaseException {
        if (!(cert instanceof X509Certificate)) {
            throw new DatabaseException("Error: cert should be an instance of X509Certificate.");
        }
        this.access.insertCertificate((X509Certificate)cert, this.certJ);
    }

    @Override
    public void insertCRL(CRL crl) throws DatabaseException {
        if (!(crl instanceof X509CRL)) {
            throw new DatabaseException("Error: crl should be an instance of X509CRL.");
        }
        this.access.insertCRL((X509CRL)crl, this.certJ);
    }

    @Override
    public void insertPrivateKeyByCertificate(Certificate cert, JSAFE_PrivateKey privateKey) throws DatabaseException {
        if (cert == null) {
            throw new DatabaseException("Error: cert should not be null.");
        }
        try {
            this.insertPrivateKeyByPublicKey(cert.getSubjectPublicKey(this.certJ.getDevice()), privateKey);
        }
        catch (CertificateException e) {
            throw new DatabaseException("Error: insertPrivateKeyByCertificate.", e);
        }
    }

    @Override
    public void insertPrivateKeyByPublicKey(JSAFE_PublicKey publicKey, JSAFE_PrivateKey privateKey) throws DatabaseException {
        if (publicKey == null || privateKey == null) {
            throw new DatabaseException("Error: insertPrivateKeyByPublicKey: neither publicKey nor privateKey should be null.");
        }
        this.access.insertKey(publicKey, privateKey, this.certJ);
    }

    @Override
    public int selectCertificateByIssuerAndSerialNumber(X500Name issuerName, byte[] serialNumber, Vector<Certificate> certList) throws DatabaseException {
        if (certList == null) {
            throw new DatabaseException("Error: certList should not be null.");
        }
        if (issuerName == null || serialNumber == null) {
            throw new DatabaseException("Error: neither issuerName nor serialNumber should be null.");
        }
        return this.access.selectCertificate(issuerName, serialNumber, certList, this.certJ);
    }

    @Override
    public int selectCertificateBySubject(X500Name subjectName, Vector<Certificate> certList) throws DatabaseException {
        if (certList == null) {
            throw new DatabaseException("Error: certList should not be null.");
        }
        if (subjectName == null) {
            throw new DatabaseException("Error: subjectName should not be null.");
        }
        return this.access.selectCertificate(subjectName, certList);
    }

    @Override
    public int selectCertificateByExtensions(X500Name baseName, X509V3Extensions extensions, Vector<Certificate> certList) throws DatabaseException {
        if (certList == null) {
            throw new DatabaseException("Error: certList should not be null.");
        }
        if (baseName == null && extensions == null) {
            throw new DatabaseException("Error: Either baseName or extensions should have a non-null value.");
        }
        return this.access.selectCertificate(baseName, extensions, certList);
    }

    @Override
    public boolean isCertificateIteratorSetup() {
        return this.certIterator != null;
    }

    @Override
    public void setupCertificateIterator() {
        this.certIteratorLock.lock();
        this.certIterator = this.access.allCerts();
        this.certPointer = 0;
        this.certIteratorLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Certificate firstCertificate() throws DatabaseException {
        this.certIteratorLock.lock();
        try {
            this.setupCertificateIterator();
            Certificate certificate = this.nextCertificate();
            return certificate;
        }
        finally {
            this.certIteratorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Certificate nextCertificate() throws DatabaseException {
        this.certIteratorLock.lock();
        try {
            if (!this.isCertificateIteratorSetup()) {
                this.setupCertificateIterator();
            }
            if (this.hasMoreCertificates()) {
                X509Certificate x509Certificate = EnhancedFlatFileDBAccess.loadCertFromFile(this.certIterator.get(this.certPointer++));
                return x509Certificate;
            }
            this.certIterator = null;
            Certificate certificate = null;
            return certificate;
        }
        finally {
            this.certIteratorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMoreCertificates() {
        this.certIteratorLock.lock();
        try {
            if (!this.isCertificateIteratorSetup()) {
                this.setupCertificateIterator();
            }
            boolean bl = this.certPointer < this.certIterator.size();
            return bl;
        }
        finally {
            this.certIteratorLock.unlock();
        }
    }

    @Override
    public int selectCRLByIssuerAndTime(X500Name issuerName, Date time, Vector<CRL> crlList) throws DatabaseException {
        if (crlList == null) {
            throw new DatabaseException("Error: crlList should not be null.");
        }
        if (issuerName == null || time == null) {
            throw new DatabaseException("Error: neither issuerName nor time should be null.");
        }
        return this.access.selectCRL(issuerName, time, crlList, this.certJ);
    }

    @Override
    public boolean isCRLIteratorSetup() {
        return this.crlIterator != null;
    }

    @Override
    public void setupCRLIterator() {
        this.crlIteratorLock.lock();
        this.crlIterator = this.access.allCRLs();
        this.crlPointer = 0;
        this.crlIteratorLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CRL firstCRL() throws DatabaseException {
        this.crlIteratorLock.lock();
        try {
            this.setupCRLIterator();
            CRL cRL = this.nextCRL();
            return cRL;
        }
        finally {
            this.crlIteratorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CRL nextCRL() throws DatabaseException {
        this.crlIteratorLock.lock();
        try {
            if (!this.isCRLIteratorSetup()) {
                this.setupCRLIterator();
            }
            if (this.hasMoreCRLs()) {
                X509CRL x509CRL = EnhancedFlatFileDBAccess.loadCRLFromFile(this.crlIterator.get(this.crlPointer++));
                return x509CRL;
            }
            this.crlIterator = null;
            CRL cRL = null;
            return cRL;
        }
        finally {
            this.crlIteratorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMoreCRLs() {
        this.crlIteratorLock.lock();
        try {
            if (!this.isCRLIteratorSetup()) {
                this.setupCRLIterator();
            }
            boolean bl = this.crlPointer < this.crlIterator.size();
            return bl;
        }
        finally {
            this.crlIteratorLock.unlock();
        }
    }

    @Override
    public JSAFE_PrivateKey selectPrivateKeyByCertificate(Certificate cert) throws DatabaseException {
        if (cert == null) {
            throw new DatabaseException("Error: cert should not be null.");
        }
        try {
            return this.selectPrivateKeyByPublicKey(cert.getSubjectPublicKey(this.certJ.getDevice()));
        }
        catch (CertificateException e) {
            throw new DatabaseException("Error: selectPrivateKeyByCertificate.", e);
        }
    }

    @Override
    public JSAFE_PrivateKey selectPrivateKeyByPublicKey(JSAFE_PublicKey publicKey) throws DatabaseException {
        if (publicKey == null) {
            throw new DatabaseException("Error: publicKey should not be null.");
        }
        return this.access.selectPrivateKey(publicKey, this.certJ);
    }

    @Override
    public boolean isPrivateKeyIteratorSetup() {
        return this.keyIterator != null;
    }

    @Override
    public void setupPrivateKeyIterator() {
        this.keyIteratorLock.lock();
        this.keyIterator = this.access.allKeys();
        this.keyPointer = 0;
        this.keyIteratorLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSAFE_PrivateKey firstPrivateKey() throws DatabaseException {
        this.keyIteratorLock.lock();
        try {
            this.setupPrivateKeyIterator();
            JSAFE_PrivateKey jSAFE_PrivateKey = this.nextPrivateKey();
            return jSAFE_PrivateKey;
        }
        finally {
            this.keyIteratorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSAFE_PrivateKey nextPrivateKey() throws DatabaseException {
        this.keyIteratorLock.lock();
        try {
            if (!this.isPrivateKeyIteratorSetup()) {
                this.setupPrivateKeyIterator();
            }
            if (this.hasMorePrivateKeys()) {
                JSAFE_PrivateKey jSAFE_PrivateKey = this.access.loadPrivateKeyFromFile(this.keyIterator.get(this.keyPointer++), this.certJ);
                return jSAFE_PrivateKey;
            }
            this.keyIterator = null;
            JSAFE_PrivateKey jSAFE_PrivateKey = null;
            return jSAFE_PrivateKey;
        }
        finally {
            this.keyIteratorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMorePrivateKeys() {
        this.keyIteratorLock.lock();
        try {
            if (!this.isPrivateKeyIteratorSetup()) {
                this.setupPrivateKeyIterator();
            }
            boolean bl = this.keyPointer < this.keyIterator.size();
            return bl;
        }
        finally {
            this.keyIteratorLock.unlock();
        }
    }

    @Override
    public void deleteCertificate(X500Name issuerName, byte[] serialNumber) throws DatabaseException {
        if (issuerName == null || serialNumber == null) {
            throw new DatabaseException("Error: neither issuerName nor serialNumber is null.");
        }
        this.access.deleteCertificate(issuerName, serialNumber, this.certJ);
    }

    @Override
    public void deleteCRL(X500Name issuerName, Date lastUpdate) throws DatabaseException {
        if (issuerName == null || lastUpdate == null) {
            throw new DatabaseException("Error: neither issuerName nor lastUpdate should be null.");
        }
        this.access.deleteCRL(issuerName, lastUpdate, this.certJ);
    }

    @Override
    public void deletePrivateKeyByCertificate(Certificate cert) throws DatabaseException {
        if (cert == null) {
            throw new DatabaseException("Error: cert should not be null.");
        }
        try {
            this.deletePrivateKeyByPublicKey(cert.getSubjectPublicKey(this.certJ.getDevice()));
        }
        catch (CertificateException e) {
            throw new DatabaseException("Error: deletePrivateKeyByCertificate", e);
        }
    }

    @Override
    public void deletePrivateKeyByPublicKey(JSAFE_PublicKey publicKey) throws DatabaseException {
        if (publicKey == null) {
            throw new DatabaseException("Error: publicKey should not be null.");
        }
        this.access.deleteKey(publicKey, this.certJ);
    }

    @Override
    public String toString() {
        return "Enhanced Flat File database provider named: " + super.getName();
    }
}

