/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.db;

import com.rsa.certj.CertJ;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.provider.db.EnhancedFlatFileDBImpl;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Hashtable;

public final class FlatFileDB
extends Provider {
    public static final int DEFAULT_BASE_NAME_LEN = 6;
    public static final int DEFAULT_PREFIX_LEN = 2;
    static Hashtable<File, Object> accessHash = new Hashtable();
    int baseNameLen;
    int prefixLen;
    File path;
    char[] passphrase;

    public static boolean create(String pathString) throws InvalidParameterException {
        if (pathString == null) {
            throw new InvalidParameterException("Error: pathString should not be null.");
        }
        return FlatFileDB.create(new File(pathString));
    }

    public static boolean create(File path) throws InvalidParameterException {
        if (path == null) {
            throw new InvalidParameterException("Error: path should not be null.");
        }
        if (path.exists()) {
            return false;
        }
        path.mkdirs();
        FlatFileDB.setupComponentDirectory(path, "certs");
        FlatFileDB.setupComponentDirectory(path, "crls");
        FlatFileDB.setupComponentDirectory(path, "privs");
        FlatFileDB.setupComponentDirectory(path, "pubs");
        return true;
    }

    public static boolean delete(String pathString) throws InvalidParameterException {
        if (pathString == null) {
            throw new InvalidParameterException("Error: pathString should not be null.");
        }
        return FlatFileDB.delete(new File(pathString));
    }

    public static boolean delete(File path) throws InvalidParameterException {
        if (path == null) {
            throw new InvalidParameterException("Error: path should not be null.");
        }
        if (!path.exists()) {
            return false;
        }
        if (accessHash.get(path) != null) {
            throw new InvalidParameterException("Error: cannot delete database currently in use.");
        }
        FlatFileDB.cleanupDirectory(new File(path, "certs"), "cer");
        FlatFileDB.cleanupDirectory(new File(path, "crls"), "crl");
        FlatFileDB.cleanupDirectory(new File(path, "privs"), "prv");
        FlatFileDB.cleanupDirectory(new File(path, "pubs"), "pub");
        boolean success = path.delete();
        if (success) {
            accessHash.remove(path);
        }
        return success;
    }

    public FlatFileDB(String name, String pathString, char[] passphrase) throws InvalidParameterException {
        super(1, name);
        if (pathString == null) {
            throw new InvalidParameterException("Error: pathString should not be null.");
        }
        if (passphrase == null) {
            throw new InvalidParameterException("Error: passphrase should not be null.");
        }
        this.path = new File(pathString);
        this.passphrase = passphrase;
        this.baseNameLen = 6;
        this.prefixLen = 2;
        this.setupStores();
    }

    public FlatFileDB(String name, File path, char[] passphrase) throws InvalidParameterException {
        super(1, name);
        if (path == null) {
            throw new InvalidParameterException("Error: path should not be null.");
        }
        if (passphrase == null) {
            throw new InvalidParameterException("Error: passphrase should not be null.");
        }
        this.path = path;
        this.passphrase = passphrase;
        this.baseNameLen = 6;
        this.prefixLen = 2;
        this.setupStores();
    }

    public FlatFileDB(String name, String pathString, char[] passphrase, int baseNameLen, int prefixLen) throws InvalidParameterException {
        super(1, name);
        if (pathString == null) {
            throw new InvalidParameterException("Error: pathString should not be null.");
        }
        if (passphrase == null) {
            throw new InvalidParameterException("Error: passphrase should not be null.");
        }
        this.path = new File(pathString);
        this.passphrase = passphrase;
        this.baseNameLen = baseNameLen > 0 ? baseNameLen : 6;
        this.prefixLen = prefixLen > 0 ? prefixLen : 2;
        this.setupStores();
    }

    public FlatFileDB(String name, File path, char[] passphrase, int baseNameLen, int prefixLen) throws InvalidParameterException {
        super(1, name);
        if (path == null) {
            throw new InvalidParameterException("Error: path should not be null.");
        }
        if (passphrase == null) {
            throw new InvalidParameterException("Error: passphrase should not be null.");
        }
        this.path = path;
        this.passphrase = passphrase;
        this.baseNameLen = baseNameLen > 0 ? baseNameLen : 6;
        this.prefixLen = prefixLen > 0 ? prefixLen : 2;
        this.setupStores();
    }

    public ProviderImplementation instantiate(CertJ certJ) throws ProviderManagementException {
        try {
            return new EnhancedFlatFileDBImpl(this, certJ, this.getName());
        }
        catch (InvalidParameterException e) {
            throw new ProviderManagementException("FlatFileDB.instantiate: ", e);
        }
    }

    private void setupStores() {
        if (!this.path.exists()) {
            this.path.mkdirs();
        }
        FlatFileDB.setupComponentDirectory(this.path, "certs");
        FlatFileDB.setupComponentDirectory(this.path, "crls");
        FlatFileDB.setupComponentDirectory(this.path, "privs");
        FlatFileDB.setupComponentDirectory(this.path, "pubs");
    }

    private static File setupComponentDirectory(File directory, String subdirectory) {
        File file = new File(directory, subdirectory);
        if (file.exists()) {
            if (!file.isDirectory()) {
                file.delete();
                file.mkdir();
            }
        } else {
            file.mkdir();
        }
        return file;
    }

    private static void cleanupDirectory(File directory, String extension) {
        if (!directory.exists()) {
            return;
        }
        DbFilenameFilter filter = new DbFilenameFilter(extension);
        File[] files = directory.listFiles(filter);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
        }
        directory.delete();
    }

    private static class DbFilenameFilter
    implements FilenameFilter {
        private String basefilename;

        public DbFilenameFilter(String extension) {
            this.basefilename = "." + extension;
        }

        public boolean accept(File directory, String filename) {
            return filename.endsWith(this.basefilename);
        }
    }
}

