/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.db;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPSearchConstraints;
import com.novell.ldap.LDAPSearchResults;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.AttributeValueAssertion;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.provider.db.LDAPConfiguration;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.db.DatabaseInterface;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LDAPDatabase
extends Provider {
    private static final int CERT_TYPE = 0;
    private static final int CRL_TYPE = 1;
    private LDAPConfiguration configuration;
    private String userDN;
    private String password;
    private String[] certAttrs;
    private String[] crlAttrs;
    private String certAttrFilter;
    private String crlAttrFilter;

    public LDAPDatabase(String name, LDAPConfiguration configuration, String userDN, String password) throws InvalidParameterException {
        super(1, name);
        if (configuration == null) {
            throw new InvalidParameterException("LDAPDatabase.LDAPDatabase: configuration should not be null.");
        }
        if (configuration.getAuthType() == 1 && (userDN == null || password == null)) {
            throw new InvalidParameterException("LDAPDatabase.LDAPDatabase: neither userDN nor password can be null if configuration.authType is LDAP_AUTH_SIMPLE.");
        }
        this.configuration = configuration;
        this.userDN = userDN;
        this.password = password;
        this.certAttrs = this.buildCertCRLAttrList(configuration.getCertificateAttrs());
        this.crlAttrs = this.buildCertCRLAttrList(configuration.getCertificateRevocationAttrs());
        this.certAttrFilter = this.buildAttrFilter(this.certAttrs);
        this.crlAttrFilter = this.buildAttrFilter(this.crlAttrs);
    }

    @Override
    public ProviderImplementation instantiate(CertJ certJ) throws ProviderManagementException {
        try {
            return new Implementation(certJ, this.getName());
        }
        catch (InvalidParameterException e) {
            throw new ProviderManagementException("LDAPDatabase.instantiate.", e);
        }
    }

    private String[] buildCertCRLAttrList(String attrList) {
        if (attrList == null || attrList.equals("")) {
            return null;
        }
        String[] strings = attrList.split(",");
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = strings[i].trim();
        }
        return strings;
    }

    private Vector<Object> retrieve(LDAPConnection connection, X500Name subjectName, boolean exactNameProvided, String attrFilter, String[] searchAttrs, int type) throws DatabaseException {
        Vector<Object> foundList;
        DatabaseException lastException = null;
        LDAPSearchResults results = null;
        if (exactNameProvided) {
            try {
                Vector<Object> foundList2 = this.attributeSearch(connection, subjectName.toString(true), 0, attrFilter, searchAttrs, type);
                if (foundList2 != null && !foundList2.isEmpty()) {
                    return foundList2;
                }
            }
            catch (DatabaseException e) {
                lastException = e;
            }
        }
        if (this.configuration.getSearchScope() == 1) {
            return null;
        }
        String baseDN = this.buildBaseDN(this.configuration.getBaseDNAttrs(), subjectName);
        String filter = this.buildFilter(this.configuration.getSearchFilterAttrs(), subjectName);
        if (!baseDN.equals("") && !filter.equals("")) {
            try {
                results = connection.search(baseDN, 2, filter, searchAttrs, false);
            }
            catch (LDAPException e) {
                lastException = new DatabaseException("LDAPDatabase.retrieve: baseDN filter search failed.", (Exception)((Object)e));
            }
            if (results != null) {
                try {
                    foundList = this.processResults(results, searchAttrs, type);
                    lastException = null;
                    if (foundList != null && !foundList.isEmpty()) {
                        return foundList;
                    }
                }
                catch (DatabaseException e) {
                    lastException = e;
                }
            }
        }
        if (this.configuration.getSearchScope() == 2) {
            return null;
        }
        if (this.configuration.getSearchRoot() != null && !filter.equals("")) {
            try {
                results = connection.search(this.configuration.getSearchRoot(), 2, filter, searchAttrs, false);
            }
            catch (LDAPException e) {
                lastException = new DatabaseException("LDAPDatabase.retrieve: subtree filter search failed.", (Exception)((Object)e));
            }
            if (results != null) {
                try {
                    foundList = this.processResults(results, searchAttrs, type);
                    lastException = null;
                    if (foundList != null && !foundList.isEmpty()) {
                        return foundList;
                    }
                }
                catch (DatabaseException e) {
                    lastException = e;
                }
            }
        }
        if (this.configuration.getSearchScope() == 3) {
            return null;
        }
        if (this.configuration.getSearchRoot() != null) {
            return this.exhaustiveSearch(connection, attrFilter, searchAttrs, type);
        }
        if (lastException != null) {
            throw lastException;
        }
        return null;
    }

    private Vector<Object> exhaustiveSearch(LDAPConnection connection, String attrFilter, String[] attrs, int type) throws DatabaseException {
        return this.attributeSearch(connection, this.configuration.getSearchRoot(), 2, attrFilter, attrs, type);
    }

    private Vector<Object> attributeSearch(LDAPConnection connection, String base, int scope, String attrFilter, String[] attrs, int type) throws DatabaseException {
        LDAPSearchResults results;
        try {
            results = connection.search(base, scope, attrFilter, attrs, false);
        }
        catch (LDAPException e) {
            throw new DatabaseException("LDAPDatabase.attributeSearch.", (Exception)((Object)e));
        }
        return this.processResults(results, attrs, type);
    }

    private String buildAttrFilter(String[] attrs) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(|");
        for (int i = 0; i < attrs.length; ++i) {
            buffer.append('(');
            buffer.append(attrs[i]);
            buffer.append("=*)");
        }
        buffer.append(')');
        return new String(buffer);
    }

    private String buildBaseDN(String attrsToMatch, X500Name subjectName) throws DatabaseException {
        StringBuffer baseDN = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(attrsToMatch, ",");
        int tokens = tok.countTokens();
        for (int i = 0; i < tokens; ++i) {
            String attr = tok.nextToken();
            String attrAndValue = this.getNameValueForAttribute(attr.trim(), subjectName);
            if (attrAndValue == null) continue;
            if (baseDN.length() != 0) {
                baseDN.append(",");
            }
            baseDN.append(attrAndValue);
        }
        return baseDN.toString();
    }

    private String buildFilter(String attrsToMatch, X500Name subjectName) throws DatabaseException {
        Vector<String> attrs = new Vector<String>();
        StringTokenizer tok = new StringTokenizer(attrsToMatch, ",");
        int tokens = tok.countTokens();
        for (int i = 0; i < tokens; ++i) {
            String attr = tok.nextToken();
            String attrAndValue = this.getNameValueForAttribute(attr.trim(), subjectName);
            if (attrAndValue == null) continue;
            attrs.addElement(attrAndValue);
        }
        if (attrs.isEmpty()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        if (attrs.size() == 1) {
            buffer.append('(');
            buffer.append((String)attrs.elementAt(0));
            buffer.append(')');
        } else {
            buffer.append("(&");
            for (int i = 0; i < attrs.size(); ++i) {
                buffer.append('(');
                buffer.append((String)attrs.elementAt(i));
                buffer.append(')');
            }
            buffer.append(')');
        }
        return buffer.toString();
    }

    private String getNameValueForAttribute(String attr, X500Name source) throws DatabaseException {
        int attrType = AttributeValueAssertion.findAttributeType(attr);
        if (attrType == -1) {
            throw new DatabaseException("Attribute type string " + attr + " not recognized.");
        }
        AttributeValueAssertion ava = source.getAttribute(attrType);
        if (ava == null) {
            return null;
        }
        try {
            return attr + "=" + ava.getStringAttribute();
        }
        catch (NameException e) {
            throw new DatabaseException("Could not get value for attribute " + attr);
        }
    }

    private Vector<Object> processResults(LDAPSearchResults results, String[] attrs, int type) throws DatabaseException {
        if (results == null) {
            return null;
        }
        Vector<Object> list = new Vector<Object>();
        while (results.hasMore()) {
            try {
                LDAPEntry element = results.next();
                if (!(element instanceof LDAPEntry)) continue;
                LDAPEntry entry = element;
                for (int i = 0; i < attrs.length; ++i) {
                    Enumeration values;
                    LDAPAttribute attr = entry.getAttribute(attrs[i]);
                    if (attr == null || (values = attr.getByteValues()) == null) continue;
                    while (values.hasMoreElements()) {
                        byte[] value = (byte[])values.nextElement();
                        if (value == null) continue;
                        if (type == 0) {
                            try {
                                X509Certificate cert = new X509Certificate(value, 0, 0);
                                list.addElement(cert);
                            }
                            catch (Exception e) {}
                            continue;
                        }
                        if (type != 1) continue;
                        try {
                            X509CRL crl = new X509CRL(value, 0, 0);
                            list.addElement(crl);
                        }
                        catch (Exception e) {}
                    }
                }
            }
            catch (LDAPException e1) {
                switch (e1.getResultCode()) {
                    case 3: {
                        throw new DatabaseException("LDAPDatabase.processResults: time limit exceeded.", (Exception)((Object)e1));
                    }
                    case 4: {
                        throw new DatabaseException("LDAPDatabase.processResults: size limit exceeded.", (Exception)((Object)e1));
                    }
                    case 11: {
                        throw new DatabaseException("LDAPDatabase.processResults: admin limit exceeded.", (Exception)((Object)e1));
                    }
                }
            }
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Implementation
    extends ProviderImplementation
    implements DatabaseInterface {
        private LDAPConnection connection;
        private Iterator certIterator;
        private Iterator crlIterator;
        private final Object certIteratorLock;
        private final Object crlIteratorLock;

        private Implementation(CertJ certJ, String name) throws InvalidParameterException {
            super(certJ, name);
            this.certIteratorLock = new Object();
            this.crlIteratorLock = new Object();
            this.certIterator = null;
            this.crlIterator = null;
            this.connection = new LDAPConnection();
        }

        @Override
        public void unregister() {
            try {
                this.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void insertCertificate(Certificate cert) throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.insertCertificate: LDAP database is read-only.");
        }

        @Override
        public void insertCRL(CRL crl) throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.insertCRL: LDAP database is read-only.");
        }

        @Override
        public void insertPrivateKeyByCertificate(Certificate cert, JSAFE_PrivateKey privateKey) throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.insertPrivateKeyByCertificate: LDAP database does not store privateKeys.");
        }

        @Override
        public void insertPrivateKeyByPublicKey(JSAFE_PublicKey publicKey, JSAFE_PrivateKey privateKey) throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.insertPrivateKeyByPublicKey: LDAP database does not store privateKeys.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int selectCertificateByIssuerAndSerialNumber(X500Name issuerName, byte[] serialNumber, Vector<Certificate> certList) throws DatabaseException {
            if (issuerName == null || serialNumber == null) {
                throw new DatabaseException("LDAPDatabase$Implementation.selectCertificateByIssuerAndSerialNumber: neither issuerName nor serialNumber should be null.");
            }
            this.connect();
            try {
                if (LDAPDatabase.this.configuration.getSearchRoot() == null) {
                    throw new DatabaseException("LDAPDatabase$Implementation.selectCertificateByIssuerAndSerialNumber: searchRoot can not be null to perform this search.");
                }
                Vector foundCerts = LDAPDatabase.this.exhaustiveSearch(this.connection, LDAPDatabase.this.certAttrFilter, LDAPDatabase.this.certAttrs, 0);
                int count = 0;
                for (Object certObject : foundCerts) {
                    X509Certificate cert = (X509Certificate)certObject;
                    if (!issuerName.equals(cert.getIssuerName()) || !CertJUtils.byteArraysEqual(serialNumber, cert.getSerialNumber())) continue;
                    ++count;
                    if (certList.contains(cert)) continue;
                    certList.addElement(cert);
                }
                int n = count;
                return n;
            }
            finally {
                if (LDAPDatabase.this.configuration.getDisconnectBeforeConnect()) {
                    this.disconnect();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int selectCertificateBySubject(X500Name subjectName, Vector<Certificate> certList) throws DatabaseException {
            if (subjectName == null) {
                throw new DatabaseException("LDAPDatabase$Implementation.selectCertificateBySubject: subjectName should not be null.");
            }
            this.connect();
            try {
                Vector foundCerts = LDAPDatabase.this.retrieve(this.connection, subjectName, true, LDAPDatabase.this.certAttrFilter, LDAPDatabase.this.certAttrs, 0);
                if (foundCerts == null) {
                    int n = 0;
                    return n;
                }
                int count = 0;
                for (int i = 0; i < foundCerts.size(); ++i) {
                    X509Certificate cert = (X509Certificate)foundCerts.elementAt(i);
                    if (!subjectName.equals(cert.getSubjectName())) continue;
                    if (!certList.contains(cert)) {
                        certList.addElement(cert);
                    }
                    ++count;
                }
                int n = count;
                return n;
            }
            finally {
                if (LDAPDatabase.this.configuration.getDisconnectBeforeConnect()) {
                    this.disconnect();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int selectCertificateByExtensions(X500Name baseName, X509V3Extensions extensions, Vector<Certificate> certList) throws DatabaseException {
            if (baseName == null) {
                throw new DatabaseException("LDAPDatabase.selectCertificateByExtensions: baseName should not be null.");
            }
            this.connect();
            try {
                Vector foundCerts = LDAPDatabase.this.retrieve(this.connection, baseName, false, LDAPDatabase.this.certAttrFilter, LDAPDatabase.this.certAttrs, 0);
                if (foundCerts == null) {
                    int n = 0;
                    return n;
                }
                int count = 0;
                for (int i = 0; i < foundCerts.size(); ++i) {
                    X509V3Extensions theseExtensions;
                    X509Certificate cert = (X509Certificate)foundCerts.elementAt(i);
                    if (!cert.getSubjectName().contains(baseName) || !CertJUtils.compareExtensions(extensions, theseExtensions = cert.getExtensions())) continue;
                    if (!certList.contains(cert)) {
                        certList.addElement(cert);
                    }
                    ++count;
                }
                int n = count;
                return n;
            }
            finally {
                if (LDAPDatabase.this.configuration.getDisconnectBeforeConnect()) {
                    this.disconnect();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCertificateIteratorSetup() {
            Object object = this.certIteratorLock;
            synchronized (object) {
                return this.certIterator != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setupCertificateIterator() throws DatabaseException {
            this.connect();
            try {
                Object object = this.certIteratorLock;
                synchronized (object) {
                    this.certIterator = new Iterator(LDAPDatabase.this.configuration.getSearchRoot(), LDAPDatabase.this.certAttrFilter, LDAPDatabase.this.certAttrs, 0);
                }
            }
            finally {
                if (LDAPDatabase.this.configuration.getDisconnectBeforeConnect()) {
                    this.disconnect();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Certificate firstCertificate() throws DatabaseException {
            Object object = this.certIteratorLock;
            synchronized (object) {
                this.setupCertificateIterator();
                return this.nextCertificate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Certificate nextCertificate() throws DatabaseException {
            Object object = this.certIteratorLock;
            synchronized (object) {
                if (!this.isCertificateIteratorSetup()) {
                    this.setupCertificateIterator();
                }
                if (this.hasMoreCertificates()) {
                    return (Certificate)this.certIterator.nextElement();
                }
                this.certIterator = null;
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasMoreCertificates() throws DatabaseException {
            Object object = this.certIteratorLock;
            synchronized (object) {
                if (!this.isCertificateIteratorSetup()) {
                    this.setupCertificateIterator();
                }
                return this.certIterator.hasMoreElements();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int selectCRLByIssuerAndTime(X500Name issuerName, Date time, Vector<CRL> crlList) throws DatabaseException {
            if (issuerName == null || time == null) {
                throw new DatabaseException("LDAPDatabase$Implementation.selectCRLByIssuerAndTime: neither issuerName nor time should be null.");
            }
            this.connect();
            try {
                Vector foundCrls = LDAPDatabase.this.retrieve(this.connection, issuerName, true, LDAPDatabase.this.crlAttrFilter, LDAPDatabase.this.crlAttrs, 1);
                if (foundCrls == null) {
                    int n = 0;
                    return n;
                }
                Date bestTime = new Date(0L);
                X509CRL bestCrl = null;
                int count = 0;
                for (int i = 0; i < foundCrls.size(); ++i) {
                    Date lastUpdate;
                    X509CRL crl = (X509CRL)foundCrls.elementAt(i);
                    X500Name testName = crl.getIssuerName();
                    if (!issuerName.equals(testName) || (lastUpdate = crl.getThisUpdate()).after(time) || !lastUpdate.after(bestTime)) continue;
                    bestTime = lastUpdate;
                    bestCrl = crl;
                }
                if (bestCrl != null) {
                    if (!crlList.contains(bestCrl)) {
                        crlList.addElement(bestCrl);
                    }
                    count = 1;
                }
                int n = count;
                return n;
            }
            finally {
                if (LDAPDatabase.this.configuration.getDisconnectBeforeConnect()) {
                    this.disconnect();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCRLIteratorSetup() {
            Object object = this.crlIteratorLock;
            synchronized (object) {
                return this.crlIterator != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setupCRLIterator() throws DatabaseException {
            this.connect();
            try {
                Object object = this.crlIteratorLock;
                synchronized (object) {
                    this.crlIterator = new Iterator(LDAPDatabase.this.configuration.getSearchRoot(), LDAPDatabase.this.crlAttrFilter, LDAPDatabase.this.crlAttrs, 1);
                }
            }
            finally {
                if (LDAPDatabase.this.configuration.getDisconnectBeforeConnect()) {
                    this.disconnect();
                }
            }
        }

        @Override
        public CRL firstCRL() throws DatabaseException {
            this.setupCRLIterator();
            return this.nextCRL();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CRL nextCRL() throws DatabaseException {
            Object object = this.crlIteratorLock;
            synchronized (object) {
                if (!this.isCRLIteratorSetup()) {
                    this.setupCRLIterator();
                }
                if (this.hasMoreCRLs()) {
                    return (CRL)this.crlIterator.nextElement();
                }
                this.crlIterator = null;
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasMoreCRLs() throws DatabaseException {
            Object object = this.crlIteratorLock;
            synchronized (object) {
                if (!this.isCRLIteratorSetup()) {
                    this.setupCRLIterator();
                }
                return this.crlIterator.hasMoreElements();
            }
        }

        @Override
        public JSAFE_PrivateKey selectPrivateKeyByCertificate(Certificate cert) throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.selectPrivateKeyByCertificate:  LDAP database does not store keys.");
        }

        @Override
        public JSAFE_PrivateKey selectPrivateKeyByPublicKey(JSAFE_PublicKey publicKey) throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.selectPrivateKeyByPublicKey:  LDAP database does not store keys.");
        }

        @Override
        public boolean isPrivateKeyIteratorSetup() throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.isPrivateKeyIteratorSetup: LDAP database does not store keys.");
        }

        @Override
        public void setupPrivateKeyIterator() throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.setupPrivateKeyIterator: LDAP database does not store keys.");
        }

        @Override
        public JSAFE_PrivateKey firstPrivateKey() throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.firstPrivateKey: LDAP database does not store keys.");
        }

        @Override
        public JSAFE_PrivateKey nextPrivateKey() throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.nextPrivateKey: LDAP database does not store keys.");
        }

        @Override
        public boolean hasMorePrivateKeys() throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.hasMorePrivateKeys: LDAP database does not store keys.");
        }

        @Override
        public void deleteCertificate(X500Name issuerName, byte[] serialNumber) throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.deleteCertificate: LDAP database is read-only.");
        }

        @Override
        public void deleteCRL(X500Name issuerName, Date lastUpdate) throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.deleteCRL: LDAP database is read-only.");
        }

        @Override
        public void deletePrivateKeyByCertificate(Certificate cert) throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.deletePrivateKeyByCertificate: LDAP database does not store keys.");
        }

        @Override
        public void deletePrivateKeyByPublicKey(JSAFE_PublicKey publicKey) throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.deletePrivateKeyByPublicKey: LDAP database does not store keys.");
        }

        private void connect() throws DatabaseException {
            if (this.connection.isConnected()) {
                return;
            }
            try {
                this.connection.connect(LDAPDatabase.this.configuration.getNetworkAddress().getHostName(), LDAPDatabase.this.configuration.getPortNumber());
            }
            catch (LDAPException e) {
                throw new DatabaseException("LDAPDatabase$Implementation.connect: LDAP connect call failed.", (Exception)((Object)e));
            }
            LDAPSearchConstraints ldapConstraints = new LDAPSearchConstraints();
            ldapConstraints.setTimeLimit(LDAPDatabase.this.configuration.getTimeLimit());
            ldapConstraints.setMaxResults(LDAPDatabase.this.configuration.getSizeLimit());
            this.connection.setConstraints((LDAPConstraints)ldapConstraints);
            try {
                if (LDAPDatabase.this.configuration.getAuthType() == 1) {
                    this.connection.bind(3, LDAPDatabase.this.userDN, LDAPDatabase.this.password.getBytes());
                }
            }
            catch (LDAPException e) {
                throw new DatabaseException("LDAPDatabase$Implementation.connect: LDAP authenticate call failed.", (Exception)((Object)e));
            }
        }

        private void disconnect() throws DatabaseException {
            if (!this.connection.isConnected()) {
                return;
            }
            try {
                this.connection.disconnect();
            }
            catch (LDAPException e) {
                throw new DatabaseException("LDAPDatabase$Implementation.disconnect: LDAP disconnect call failed.", (Exception)((Object)e));
            }
        }

        @Override
        public String toString() {
            return "LDAP database provider named: " + super.getName();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class Iterator
        implements Enumeration<Object> {
            private int index;
            private Vector<Object> entries;

            private Iterator(String searchRoot, String attrFilter, String[] searchAttrs, int type) throws DatabaseException {
                if (searchRoot == null) {
                    throw new DatabaseException("LDAPDatabase$Iterator.Iterator: searchRoot can not be null to perform iteration operations.");
                }
                this.entries = LDAPDatabase.this.exhaustiveSearch(Implementation.this.connection, attrFilter, searchAttrs, type);
                this.index = 0;
            }

            @Override
            public boolean hasMoreElements() {
                return this.index < this.entries.size();
            }

            @Override
            public Object nextElement() {
                if (this.hasMoreElements()) {
                    return this.entries.elementAt(this.index++);
                }
                return null;
            }
        }
    }
}

