/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.db;

import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.db.DatabaseInterface;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.util.Date;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MemoryDB
extends Provider {
    private Vector<Certificate> certStoreProvided;
    private Vector<CRL> crlStoreProvided;
    private Vector<JSAFE_PrivateKey> privateKeyStoreProvided;
    private Vector<JSAFE_PublicKey> publicKeyStoreProvided;

    public MemoryDB(String name) throws InvalidParameterException {
        super(1, name);
    }

    public MemoryDB(String name, Vector<Certificate> certificates, Vector<CRL> crls, Vector<JSAFE_PrivateKey> privateKeys, Vector<JSAFE_PublicKey> publicKeys) throws InvalidParameterException {
        super(1, name);
        if (privateKeys == null || publicKeys == null || privateKeys.size() != publicKeys.size()) {
            throw new InvalidParameterException("MemoryDB.MemoryDB: privateKeys and publicKeys should have the same number of elements.");
        }
        if (certificates != null) {
            this.certStoreProvided = certificates;
        }
        if (crls != null) {
            this.crlStoreProvided = crls;
        }
        this.privateKeyStoreProvided = privateKeys;
        this.publicKeyStoreProvided = publicKeys;
    }

    @Override
    public ProviderImplementation instantiate(CertJ certJ) throws ProviderManagementException {
        try {
            return new Implementation(certJ, this.getName());
        }
        catch (InvalidParameterException e) {
            throw new ProviderManagementException("MemoryDB.instantiate.", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Implementation
    extends ProviderImplementation
    implements DatabaseInterface {
        private Vector<Certificate> certStore;
        private Vector<CRL> crlStore;
        private Vector<JSAFE_PrivateKey> privateKeyStore;
        private Vector<JSAFE_PublicKey> publicKeyStore;
        private int certPointer;
        private int crlPointer;
        private int keyPointer;
        private final Object certIteratorLock;
        private final Object crlIteratorLock;
        private final Object keyIteratorLock;

        private Implementation(CertJ certJ, String name) throws InvalidParameterException {
            super(certJ, name);
            this.certIteratorLock = new Object();
            this.crlIteratorLock = new Object();
            this.keyIteratorLock = new Object();
            this.certStore = MemoryDB.this.certStoreProvided == null ? new Vector() : MemoryDB.this.certStoreProvided;
            this.crlStore = MemoryDB.this.crlStoreProvided == null ? new Vector() : MemoryDB.this.crlStoreProvided;
            if (MemoryDB.this.privateKeyStoreProvided == null) {
                this.privateKeyStore = new Vector();
                this.publicKeyStore = new Vector();
            } else {
                this.privateKeyStore = MemoryDB.this.privateKeyStoreProvided;
                this.publicKeyStore = MemoryDB.this.publicKeyStoreProvided;
            }
            this.certPointer = -1;
            this.crlPointer = -1;
            this.keyPointer = -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertCertificate(Certificate cert) throws DatabaseException {
            if (cert == null) {
                throw new DatabaseException("MemoryDBProvider.insertCertificate: cert should not be null.");
            }
            Vector<Certificate> vector = this.certStore;
            synchronized (vector) {
                if (!this.certStore.contains(cert)) {
                    try {
                        this.certStore.addElement((Certificate)((X509Certificate)cert).clone());
                    }
                    catch (CloneNotSupportedException e) {
                        throw new DatabaseException("MemoryDBProvider.insertCertificate: Unable to clone the certificate.", e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertCRL(CRL crl) throws DatabaseException {
            if (crl == null) {
                throw new DatabaseException("MemoryDBProvider.insertCRL: crl should not be null.");
            }
            Vector<CRL> vector = this.crlStore;
            synchronized (vector) {
                if (!this.crlStore.contains(crl)) {
                    try {
                        this.crlStore.addElement((CRL)((X509CRL)crl).clone());
                    }
                    catch (CloneNotSupportedException e) {
                        throw new DatabaseException("MemoryDBProvider.insertCRL: Unable to clone the CRL.", e);
                    }
                }
            }
        }

        @Override
        public void insertPrivateKeyByCertificate(Certificate cert, JSAFE_PrivateKey privateKey) throws DatabaseException {
            if (cert == null) {
                throw new DatabaseException("MemoryDB$Implementation.insertPrivateKeyByCertificate: cert should not be null");
            }
            try {
                this.insertPrivateKeyByPublicKey(cert.getSubjectPublicKey(this.certJ.getDevice()), privateKey);
            }
            catch (CertificateException e) {
                throw new DatabaseException("MemoryDB$Implementation.insertPrivateKeyByCertificate.", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertPrivateKeyByPublicKey(JSAFE_PublicKey publicKey, JSAFE_PrivateKey privateKey) throws DatabaseException {
            if (publicKey == null || privateKey == null) {
                throw new DatabaseException("MemoryDBProvider.insertPrivateKeyByPublicKey: Neither publicKey nor privateKey should be null.");
            }
            Vector<JSAFE_PrivateKey> vector = this.privateKeyStore;
            synchronized (vector) {
                if (!this.publicKeyStore.contains(publicKey)) {
                    try {
                        this.privateKeyStore.addElement((JSAFE_PrivateKey)privateKey.clone());
                        this.publicKeyStore.addElement((JSAFE_PublicKey)publicKey.clone());
                    }
                    catch (CloneNotSupportedException e) {
                        throw new DatabaseException("MemoryDBProvider.insertPrivateKeyByPublicKey: Unable to clone a key.", e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int selectCertificateByIssuerAndSerialNumber(X500Name issuerName, byte[] serialNumber, Vector<Certificate> certList) throws DatabaseException {
            if (issuerName == null || serialNumber == null) {
                throw new DatabaseException("MemoryDBProvider.selectCertificateByIssuerAndSerialNumber: Neither issuerName nor serialNumber should be null.");
            }
            Vector<Certificate> vector = this.certStore;
            synchronized (vector) {
                for (int i = 0; i < this.certStore.size(); ++i) {
                    try {
                        X509Certificate testCert = (X509Certificate)this.certStore.elementAt(i);
                        if (!issuerName.equals(testCert.getIssuerName()) || !CertJUtils.byteArraysEqual(serialNumber, testCert.getSerialNumber())) continue;
                        if (!certList.contains(testCert)) {
                            certList.addElement((Certificate)testCert.clone());
                        }
                        return 1;
                    }
                    catch (CloneNotSupportedException e) {
                        throw new DatabaseException("MemoryDBProvider.selectCertificateByIssuerAndSerialNumber: Unable to clone a certificate.", e);
                    }
                    catch (ClassCastException e) {
                        // empty catch block
                    }
                }
                return 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int selectCertificateBySubject(X500Name subjectName, Vector<Certificate> certList) throws DatabaseException {
            if (subjectName == null) {
                throw new DatabaseException("MemoryDBProvider.selectCertificateBySubject: subjectName should not be null.");
            }
            int count = 0;
            Vector<Certificate> vector = this.certStore;
            synchronized (vector) {
                for (int i = 0; i < this.certStore.size(); ++i) {
                    try {
                        X509Certificate testCert = (X509Certificate)this.certStore.elementAt(i);
                        X500Name testName = testCert.getSubjectName();
                        if (!testName.equals(subjectName)) continue;
                        if (!certList.contains(testCert)) {
                            certList.addElement((Certificate)testCert.clone());
                        }
                        ++count;
                        continue;
                    }
                    catch (CloneNotSupportedException e) {
                        throw new DatabaseException("MemoryDBProvider.selectCertificateByIssuerAndSerialNumber: Unable to clone a certificate.", e);
                    }
                    catch (ClassCastException e) {
                        // empty catch block
                    }
                }
                return count;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int selectCertificateByExtensions(X500Name baseName, X509V3Extensions extensions, Vector<Certificate> certList) throws DatabaseException {
            if (baseName == null && extensions == null) {
                throw new DatabaseException("MemoryDB.selectCertificateByExtensions: Either baseName or extensions should have a non-null value.");
            }
            int count = 0;
            Vector<Certificate> vector = this.certStore;
            synchronized (vector) {
                try {
                    for (int i = 0; i < this.certStore.size(); ++i) {
                        X509V3Extensions theseExtensions;
                        X509Certificate cert = (X509Certificate)this.certStore.elementAt(i);
                        if (baseName != null && !cert.getSubjectName().contains(baseName) || !CertJUtils.compareExtensions(extensions, theseExtensions = cert.getExtensions())) continue;
                        if (!certList.contains(cert)) {
                            certList.addElement((Certificate)cert.clone());
                        }
                        ++count;
                    }
                }
                catch (CloneNotSupportedException e) {
                    throw new DatabaseException("MemoryDBProvider.selectCertificateByExtensions: Unable to clone a certificate.", e);
                }
                return count;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCertificateIteratorSetup() {
            Object object = this.certIteratorLock;
            synchronized (object) {
                return this.certPointer >= 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setupCertificateIterator() {
            Object object = this.certIteratorLock;
            synchronized (object) {
                this.certPointer = 0;
            }
        }

        @Override
        public Certificate firstCertificate() throws DatabaseException {
            Object object = this.certIteratorLock;
            synchronized (object) {
                this.setupCertificateIterator();
                Vector<Certificate> vector = this.certStore;
                synchronized (vector) {
                    if (this.certStore.isEmpty()) {
                        this.certPointer = -1;
                        return null;
                    }
                    try {
                        X509Certificate cert = (X509Certificate)this.certStore.elementAt(this.certPointer++);
                        return (Certificate)cert.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        throw new DatabaseException("MemoryDBProvider.firstCertificate: Unable to clone a certificate.", e);
                    }
                }
            }
        }

        @Override
        public Certificate nextCertificate() throws DatabaseException {
            Object object = this.certIteratorLock;
            synchronized (object) {
                if (!this.isCertificateIteratorSetup()) {
                    this.setupCertificateIterator();
                }
                Vector<Certificate> vector = this.certStore;
                synchronized (vector) {
                    if (this.certPointer >= this.certStore.size()) {
                        this.certPointer = -1;
                        return null;
                    }
                    try {
                        X509Certificate cert = (X509Certificate)this.certStore.elementAt(this.certPointer++);
                        return (Certificate)cert.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        throw new DatabaseException("MemoryDBProvider.nextCertificate: Unable to clone a certificate.", e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasMoreCertificates() {
            Object object = this.certIteratorLock;
            synchronized (object) {
                if (!this.isCertificateIteratorSetup()) {
                    this.setupCertificateIterator();
                }
                Vector<Certificate> vector = this.certStore;
                synchronized (vector) {
                    return this.certPointer < this.certStore.size();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int selectCRLByIssuerAndTime(X500Name issuerName, Date time, Vector<CRL> crlList) throws DatabaseException {
            if (issuerName == null || time == null) {
                throw new DatabaseException("MemoryDBProvider.selectCRLByIssuerAndTime: Neither issuerName nor time should be null.");
            }
            Date bestTime = new Date(0L);
            X509CRL bestCrl = null;
            Vector<CRL> vector = this.crlStore;
            synchronized (vector) {
                for (int i = 0; i < this.crlStore.size(); ++i) {
                    try {
                        Date lastUpdate;
                        X509CRL crl = (X509CRL)this.crlStore.elementAt(i);
                        X500Name testName = crl.getIssuerName();
                        if (!issuerName.equals(testName) || (lastUpdate = crl.getThisUpdate()).after(time) || !lastUpdate.after(bestTime)) continue;
                        bestTime = lastUpdate;
                        bestCrl = crl;
                        continue;
                    }
                    catch (ClassCastException e) {
                        // empty catch block
                    }
                }
                if (bestCrl == null) {
                    return 0;
                }
                if (!crlList.contains(bestCrl)) {
                    try {
                        crlList.addElement((CRL)bestCrl.clone());
                    }
                    catch (CloneNotSupportedException e) {
                        throw new DatabaseException("MemoryDBProvider.selectCRLByIssuerAndTime: Unable to clone a CRL.", e);
                    }
                }
                return 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCRLIteratorSetup() {
            Object object = this.crlIteratorLock;
            synchronized (object) {
                return this.crlPointer >= 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setupCRLIterator() {
            Object object = this.crlIteratorLock;
            synchronized (object) {
                this.crlPointer = 0;
            }
        }

        @Override
        public CRL firstCRL() throws DatabaseException {
            Object object = this.crlIteratorLock;
            synchronized (object) {
                this.setupCRLIterator();
                Vector<CRL> vector = this.crlStore;
                synchronized (vector) {
                    if (this.crlStore.isEmpty()) {
                        this.crlPointer = -1;
                        return null;
                    }
                    try {
                        X509CRL crl = (X509CRL)this.crlStore.elementAt(this.crlPointer++);
                        return (CRL)crl.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        throw new DatabaseException("MemoryDBProvider.firstCRL: Unable to clone a CRL.", e);
                    }
                }
            }
        }

        @Override
        public CRL nextCRL() throws DatabaseException {
            Object object = this.crlIteratorLock;
            synchronized (object) {
                if (!this.isCRLIteratorSetup()) {
                    this.setupCRLIterator();
                }
                Vector<CRL> vector = this.crlStore;
                synchronized (vector) {
                    if (this.crlPointer >= this.crlStore.size()) {
                        this.crlPointer = -1;
                        return null;
                    }
                    try {
                        X509CRL crl = (X509CRL)this.crlStore.elementAt(this.crlPointer++);
                        return (CRL)crl.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        throw new DatabaseException("MemoryDBProvider.nextCRL: Unable to clone a CRL.", e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasMoreCRLs() {
            Object object = this.crlIteratorLock;
            synchronized (object) {
                if (!this.isCRLIteratorSetup()) {
                    this.setupCRLIterator();
                }
                Vector<CRL> vector = this.crlStore;
                synchronized (vector) {
                    return this.crlPointer < this.crlStore.size();
                }
            }
        }

        @Override
        public JSAFE_PrivateKey selectPrivateKeyByCertificate(Certificate cert) throws DatabaseException {
            if (cert == null) {
                throw new DatabaseException("MemoryDB$Implementation.selectPrivateKeyByCertificate: cert should not be null.");
            }
            try {
                return this.selectPrivateKeyByPublicKey(cert.getSubjectPublicKey(this.certJ.getDevice()));
            }
            catch (CertificateException e) {
                throw new DatabaseException("MemoryDB$Implementation.selectPrivateKeyByCertificate.", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JSAFE_PrivateKey selectPrivateKeyByPublicKey(JSAFE_PublicKey publicKey) throws DatabaseException {
            if (publicKey == null) {
                throw new DatabaseException("MemoryDB$Implementation.selectPrivateKeyByPublicKey: publicKey should not be null.");
            }
            Vector<JSAFE_PrivateKey> vector = this.privateKeyStore;
            synchronized (vector) {
                for (int i = 0; i < this.publicKeyStore.size(); ++i) {
                    if (!publicKey.equals((Object)this.publicKeyStore.elementAt(i))) continue;
                    try {
                        JSAFE_PrivateKey privKey = this.privateKeyStore.elementAt(i);
                        return (JSAFE_PrivateKey)privKey.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        throw new DatabaseException("MemoryDB$Implementation.selectPrivateKeyByPublicKeyUnable to clone a private key().");
                    }
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isPrivateKeyIteratorSetup() {
            Object object = this.keyIteratorLock;
            synchronized (object) {
                return this.keyPointer >= 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setupPrivateKeyIterator() {
            Object object = this.keyIteratorLock;
            synchronized (object) {
                this.keyPointer = 0;
            }
        }

        @Override
        public JSAFE_PrivateKey firstPrivateKey() throws DatabaseException {
            Object object = this.keyIteratorLock;
            synchronized (object) {
                this.setupPrivateKeyIterator();
                Vector<JSAFE_PrivateKey> vector = this.privateKeyStore;
                synchronized (vector) {
                    if (this.privateKeyStore.isEmpty()) {
                        this.keyPointer = -1;
                        return null;
                    }
                    try {
                        JSAFE_PrivateKey privKey = this.privateKeyStore.elementAt(this.keyPointer++);
                        return (JSAFE_PrivateKey)privKey.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        throw new DatabaseException("MemoryDB$Implementation.firstPrivateKey: Unable to clone a private key.", e);
                    }
                }
            }
        }

        @Override
        public JSAFE_PrivateKey nextPrivateKey() throws DatabaseException {
            Object object = this.keyIteratorLock;
            synchronized (object) {
                if (!this.isPrivateKeyIteratorSetup()) {
                    this.setupPrivateKeyIterator();
                }
                Vector<JSAFE_PrivateKey> vector = this.privateKeyStore;
                synchronized (vector) {
                    if (this.keyPointer >= this.privateKeyStore.size()) {
                        this.keyPointer = -1;
                        return null;
                    }
                    try {
                        JSAFE_PrivateKey privKey = this.privateKeyStore.elementAt(this.keyPointer++);
                        return (JSAFE_PrivateKey)privKey.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        throw new DatabaseException("MemoryDB$Implementation.nextPrivateKey: Unable to clone a private key.", e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasMorePrivateKeys() {
            Object object = this.keyIteratorLock;
            synchronized (object) {
                if (!this.isPrivateKeyIteratorSetup()) {
                    this.setupPrivateKeyIterator();
                }
                Vector<JSAFE_PrivateKey> vector = this.privateKeyStore;
                synchronized (vector) {
                    return this.keyPointer < this.privateKeyStore.size();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deleteCertificate(X500Name issuerName, byte[] serialNumber) throws DatabaseException {
            if (issuerName == null || serialNumber == null) {
                throw new DatabaseException("MemoryDB$Implementation.deleteCertificate: Neither issuerName nor serialNumber should be null.");
            }
            Vector<Certificate> vector = this.certStore;
            synchronized (vector) {
                for (int i = 0; i < this.certStore.size(); ++i) {
                    try {
                        X509Certificate testCert = (X509Certificate)this.certStore.elementAt(i);
                        if (!issuerName.equals(testCert.getIssuerName()) || !CertJUtils.byteArraysEqual(serialNumber, testCert.getSerialNumber())) continue;
                        this.certStore.removeElementAt(i);
                        continue;
                    }
                    catch (ClassCastException e) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deleteCRL(X500Name issuerName, Date lastUpdate) throws DatabaseException {
            if (issuerName == null || lastUpdate == null) {
                throw new DatabaseException("MemoryDB$Implementation.deleteCRL: Neither issuerName nor lastUpdate should be null.");
            }
            Vector<CRL> vector = this.crlStore;
            synchronized (vector) {
                for (int i = 0; i < this.crlStore.size(); ++i) {
                    try {
                        X509CRL crl = (X509CRL)this.crlStore.elementAt(i);
                        if (!issuerName.equals(crl.getIssuerName()) || !crl.getThisUpdate().equals(lastUpdate)) continue;
                        this.crlStore.removeElementAt(i);
                        continue;
                    }
                    catch (ClassCastException e) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public void deletePrivateKeyByCertificate(Certificate cert) throws DatabaseException {
            if (cert == null) {
                throw new DatabaseException("MemoryDB$Implementation.deletePrivateKeyByCertificate: cert should not be null.");
            }
            try {
                this.deletePrivateKeyByPublicKey(cert.getSubjectPublicKey(this.certJ.getDevice()));
            }
            catch (CertificateException e) {
                throw new DatabaseException("MemoryDB$Implementation.deletePrivateKeyByCertificate.", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deletePrivateKeyByPublicKey(JSAFE_PublicKey publicKey) throws DatabaseException {
            if (publicKey == null) {
                throw new DatabaseException("MemoryDB$Implementation.deletePrivateKeyByPublicKey: publickKey should not be null.");
            }
            Vector<JSAFE_PrivateKey> vector = this.privateKeyStore;
            synchronized (vector) {
                for (int i = 0; i < this.privateKeyStore.size(); ++i) {
                    if (!publicKey.equals((Object)this.publicKeyStore.elementAt(i))) continue;
                    this.privateKeyStore.removeElementAt(i);
                    this.publicKeyStore.removeElementAt(i);
                    return;
                }
            }
        }

        @Override
        public String toString() {
            return "In-memory database provider named: " + super.getName();
        }
    }
}

