/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.path;

import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.extensions.GeneralNames;
import com.rsa.certj.cert.extensions.GeneralSubtrees;
import com.rsa.certj.internal.Debug;
import com.rsa.certj.provider.revocation.CRLEvidence;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.path.CertPathException;
import com.rsa.certj.spi.path.CertPathInterface;
import com.rsa.certj.spi.path.CertPathResult;
import com.rsa.certj.spi.path.PolicyInformation;
import com.rsa.certj.spi.revocation.CertRevocationInfo;
import com.rsa.certj.spi.revocation.CertStatusException;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CertPathCommon
extends ProviderImplementation
implements CertPathInterface {
    protected static final boolean DEBUG_ON = Debug.isCertPathSet();

    protected CertPathCommon(CertJ certJ, String name) throws InvalidParameterException {
        super(certJ, name);
    }

    private boolean buildCertPath(CertPathCtx pathCtx, Object startObject, Vector<Certificate> certPath, Vector<CRL> crlList, Vector<Certificate> crlCerts, Vector<PolicyInformation> policyInfoList, GeneralSubtrees initialPermittedSubtrees, GeneralNames initialExcludedSubtrees, CertPathResult pathResult) throws NotSupportedException, CertPathException {
        if (this.trustedCertsEmpty(pathCtx)) {
            throw new CertPathException("TrustedCerts component of pathCtx should not be empty.");
        }
        Debug.println(DEBUG_ON, "________________Start Cert Path________________");
        if (crlList == null && crlCerts != null) {
            crlCerts = null;
        }
        Vector<Certificate> pathFound = new Vector<Certificate>();
        if (startObject instanceof X509Certificate) {
            X509Certificate cert = (X509Certificate)startObject;
            if (!this.verifyCertValidityPeriod(pathCtx, cert)) {
                if (!this.isTrusted(pathCtx, cert)) {
                    if (DEBUG_ON) {
                        String subjName = cert.getSubjectName() == null ? "null" : cert.getSubjectName().toString();
                        Debug.println("Certificate " + subjName + " cannot be trusted.");
                        Debug.println("________________ End Cert Path ________________");
                    }
                    return false;
                }
                if (certPath != null && !certPath.contains(cert)) {
                    certPath.addElement(cert);
                }
                if (pathResult != null) {
                    pathResult.setValidationResult(true);
                }
                if (DEBUG_ON) {
                    Debug.println("Certificate " + cert.getSubjectName().toString() + " is not in validity period but is trusted, so validation is successful.");
                    Debug.println("________________ End Cert Path ________________");
                }
                return true;
            }
            if (!this.certBuildPath(pathCtx, cert, pathFound, crlList, crlCerts, policyInfoList, initialPermittedSubtrees, initialExcludedSubtrees, pathResult)) {
                return false;
            }
        } else if (startObject instanceof X509CRL) {
            if (!this.crlBuildPath(pathCtx, (X509CRL)startObject, pathFound, crlList, crlCerts, policyInfoList, initialPermittedSubtrees, initialExcludedSubtrees)) {
                Debug.println("________________ End Cert Path ________________");
                return false;
            }
        } else {
            throw new NotSupportedException("Does not support startObjects other than X509Certificate or X509CRL.");
        }
        CertJUtils.mergeLists(certPath, pathFound);
        CertJUtils.subtractLists(crlCerts, certPath);
        Debug.println(DEBUG_ON, "________________ End Cert Path ________________");
        return true;
    }

    @Override
    public boolean buildCertPath(CertPathCtx pathCtx, Object startObject, Vector<Certificate> certPath, Vector<CRL> crlList, Vector<Certificate> crlCerts, Vector<PolicyInformation> certPolicyList) throws NotSupportedException, CertPathException {
        return this.buildCertPath(pathCtx, startObject, certPath, crlList, crlCerts, certPolicyList, null, null, null);
    }

    @Override
    public CertPathResult buildCertPath(CertPathCtx pathCtx, Object startObject, Vector<Certificate> certPath, Vector<CRL> crlList, Vector<Certificate> crlCerts) throws NotSupportedException, CertPathException {
        return this.buildCertPath(pathCtx, startObject, certPath, crlList, crlCerts, null, null);
    }

    @Override
    public CertPathResult buildCertPath(CertPathCtx pathCtx, Object startObject, Vector<Certificate> certPath, Vector<CRL> crlList, Vector<Certificate> crlCerts, GeneralSubtrees initialPermittedSubtrees, GeneralNames initialExcludedSubtrees) throws NotSupportedException, CertPathException {
        CertPathResult result = this.createCertPathResult();
        this.buildCertPath(pathCtx, startObject, certPath, crlList, crlCerts, null, initialPermittedSubtrees, initialExcludedSubtrees, result);
        return result;
    }

    protected CertPathResult createCertPathResult() throws NotSupportedException {
        throw new NotSupportedException("The path provider does not support this functionality!");
    }

    @Override
    public void getNextCertInPath(CertPathCtx pathCtx, Object baseObject, Vector<Certificate> certList) throws NotSupportedException, CertPathException {
        if (!(baseObject instanceof X509Certificate) && !(baseObject instanceof X509CRL)) {
            throw new NotSupportedException("startObjects other than X509Certificate or X509CRL not supported.");
        }
        this.getNextCertInPathInternal(pathCtx, baseObject, certList);
    }

    protected void getNextCertInPathInternal(CertPathCtx pathCtx, Object baseObject, Vector<Certificate> certList) throws CertPathException {
        Vector<Certificate> candidates = new Vector<Certificate>();
        this.getNextCertCandidates(pathCtx, baseObject, candidates);
        this.removeInvalidNextCerts(pathCtx, baseObject, candidates);
        CertJUtils.mergeLists(certList, candidates);
    }

    @Override
    public boolean validateCertificate(CertPathCtx pathCtx, Certificate cert, JSAFE_PublicKey validationKey) throws NotSupportedException, CertPathException {
        if (!(cert instanceof X509Certificate)) {
            throw new NotSupportedException("No certificate types other than X509Certificate supported.");
        }
        if (!this.verifyCertValidityPeriod(pathCtx, (X509Certificate)cert)) {
            return false;
        }
        if ((pathCtx.getPathOptions() & 1) != 0) {
            return true;
        }
        try {
            return cert.verifyCertificateSignature(this.certJ.getDevice(), validationKey, (SecureRandom)this.certJ.getRandomObject());
        }
        catch (NoServiceException e) {
            throw new CertPathException("No random service is registered.", e);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean certBuildPath(CertPathCtx pathCtx, X509Certificate cert, Vector<Certificate> certPath, Vector<CRL> crlList, Vector<Certificate> crlCerts, Vector<PolicyInformation> policyInfoList, GeneralSubtrees initialPermittedSubtrees, GeneralNames initialExcludedSubtrees, CertPathResult pathResult) throws CertPathException {
        if (DEBUG_ON) {
            Debug.println("Checking certificate " + cert.getSubjectName().toString() + " for cert path.");
        }
        if (certPath.contains(cert)) {
            Debug.println(DEBUG_ON, "Certificate already in cert path, so ignore.");
            return false;
        }
        Debug.println(DEBUG_ON, "Adding certificate to cert path.");
        certPath.addElement(cert);
        if (this.isTrusted(pathCtx, cert)) {
            Debug.println(DEBUG_ON, "Certificate is a trusted one, verifying path now.");
            if (this.verifyPath(pathCtx, certPath, crlList, crlCerts, policyInfoList, initialPermittedSubtrees, initialExcludedSubtrees, pathResult)) {
                if (DEBUG_ON) {
                    Debug.println("Certificate path validation passed for certificate " + cert.getSubjectName().toString());
                }
                return true;
            }
            if (DEBUG_ON) {
                Debug.println("Certificate path validation failed for certificate " + cert.getSubjectName().toString() + ", removing trusted cert from path.");
            }
            certPath.removeElement(cert);
            return false;
        }
        Debug.println(DEBUG_ON, "Certificate is not a trusted one, trying to find certificate candidates now.");
        Vector<Certificate> nextCerts = new Vector<Certificate>();
        this.getNextCertInPathInternal(pathCtx, cert, nextCerts);
        Debug.println(DEBUG_ON, "Found next " + nextCerts.size() + " certificate candidates in context.");
        for (Certificate nextCert : nextCerts) {
            if (!this.certBuildPath(pathCtx, (X509Certificate)nextCert, certPath, crlList, crlCerts, policyInfoList, initialPermittedSubtrees, initialExcludedSubtrees, pathResult)) continue;
            if (DEBUG_ON) {
                Debug.println("Certificate path validation passed for certificate " + cert.getSubjectName().toString());
            }
            return true;
        }
        if (DEBUG_ON) {
            Debug.println("Did not find any certificate candidates in path for certificate " + cert.getSubjectName().toString() + ", removing cert from path.");
        }
        certPath.removeElement(cert);
        return false;
    }

    private boolean crlBuildPath(CertPathCtx pathCtx, X509CRL crl, Vector<Certificate> certPath, Vector<CRL> crlList, Vector<Certificate> crlCerts, Vector<PolicyInformation> policyInfoList, GeneralSubtrees initialPermittedSubtrees, GeneralNames initialExcludedSubtrees) throws CertPathException {
        if (DEBUG_ON) {
            Debug.println("Checking CRL from issuer " + crl.getIssuerName().toString() + " for cert path.");
        }
        Debug.println(DEBUG_ON, "Trying to find issuing candidates for CRL now.");
        Vector<Certificate> crlIssuers = new Vector<Certificate>();
        this.getNextCertInPathInternal(pathCtx, crl, crlIssuers);
        Debug.println(DEBUG_ON, "Found next " + crlIssuers.size() + " issuing candidates for CRL in context.");
        for (Certificate crlIssuer : crlIssuers) {
            if (!this.certBuildPath(pathCtx, (X509Certificate)crlIssuer, certPath, crlList, crlCerts, policyInfoList, initialPermittedSubtrees, initialExcludedSubtrees, null)) continue;
            return true;
        }
        if (DEBUG_ON) {
            Debug.println("Did not find any issuing candidates in path for CRL issued by " + crl.getIssuerName().toString());
        }
        return false;
    }

    protected void getNextCertCandidates(CertPathCtx pathCtx, Object baseObject, Vector<Certificate> candidates) throws CertPathException {
        throw new CertPathException("Subclass should override this method.");
    }

    protected boolean verifyPath(CertPathCtx pathCtx, Vector<Certificate> path, Vector<CRL> crlList, Vector<Certificate> crlCerts, Vector<PolicyInformation> policyInfoList, GeneralSubtrees initialPermittedSubtrees, GeneralNames initialExcludedSubtrees, CertPathResult pathResult) throws CertPathException {
        throw new CertPathException("Subclass should override this method.");
    }

    public boolean verifyRevocation(CertPathCtx pathCtx, X509Certificate cert, Vector<CRL> crlList, Vector<Certificate> crlCerts) throws CertPathException {
        CertRevocationInfo revocation;
        if ((pathCtx.getPathOptions() & 4) != 0) {
            return true;
        }
        if (DEBUG_ON) {
            Debug.println("Running certificate revocation check for certificate " + cert.getSubjectName().toString());
        }
        try {
            revocation = this.certJ.checkCertRevocation(pathCtx, cert);
        }
        catch (NoServiceException e) {
            throw new CertPathException("No Certificate Status Service is registered.", e);
        }
        catch (InvalidParameterException e) {
            throw new CertPathException("Check certificate revocation parameters.", e);
        }
        catch (CertStatusException e) {
            throw new CertPathException(e);
        }
        if (revocation.getStatus() != 0) {
            return false;
        }
        switch (revocation.getType()) {
            case 1: {
                if (DEBUG_ON) {
                    Debug.println("Certificate revocation check passed on CRL evidence for certificate " + cert.getSubjectName().toString());
                }
                CRLEvidence evidence = (CRLEvidence)revocation.getEvidence();
                if (crlList != null) {
                    CRL crl = evidence.getCRL();
                    if (crl != null && !crlList.contains(crl)) {
                        crlList.addElement(crl);
                    }
                    if (DEBUG_ON && crl instanceof X509CRL) {
                        Debug.println("    Revocation evidence CRL issuer:  " + ((X509CRL)crl).getIssuerName().toString());
                    }
                }
                CertJUtils.mergeLists(crlList, evidence.getCRLList());
                CertJUtils.mergeLists(crlCerts, evidence.getCertList());
                break;
            }
            case 2: {
                Debug.println(DEBUG_ON, "Certificate revocation check passed on OCSP evidence.");
                break;
            }
        }
        return true;
    }

    private void removeInvalidNextCerts(CertPathCtx pathCtx, Object startObject, Vector<Certificate> nextCerts) throws CertPathException {
        int count = nextCerts.size();
        while (count > 0) {
            X509Certificate nextCert;
            boolean isValidCert;
            if (isValidCert = this.verifyCertValidityPeriod(pathCtx, nextCert = (X509Certificate)nextCerts.elementAt(--count))) {
                isValidCert = startObject instanceof X509Certificate ? this.verifyCertSignature(pathCtx, (X509Certificate)startObject, nextCert) : this.verifyCrlSignature(pathCtx, (X509CRL)startObject, nextCert);
            }
            if (isValidCert) continue;
            nextCerts.removeElementAt(count);
        }
    }

    private boolean verifyCertSignature(CertPathCtx pathCtx, X509Certificate cert, X509Certificate issuer) throws CertPathException {
        if ((pathCtx.getPathOptions() & 1) != 0) {
            return true;
        }
        try {
            JSAFE_PublicKey publicKey = issuer.getSubjectPublicKey(this.certJ.getDevice());
            return cert.verifyCertificateSignature(this.certJ.getDevice(), publicKey, (SecureRandom)this.certJ.getRandomObject());
        }
        catch (NoServiceException e) {
            throw new CertPathException(e);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean verifyCrlSignature(CertPathCtx pathCtx, X509CRL crl, X509Certificate issuer) throws CertPathException {
        if ((pathCtx.getPathOptions() & 1) != 0) {
            return true;
        }
        String device = this.certJ.getDevice();
        try {
            JSAFE_PublicKey publicKey = issuer.getSubjectPublicKey(device);
            return crl.verifyCRLSignature(device, publicKey, (SecureRandom)this.certJ.getRandomObject());
        }
        catch (NoServiceException e) {
            throw new CertPathException(e);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean verifyCertValidityPeriod(CertPathCtx pathCtx, X509Certificate cert) {
        if ((pathCtx.getPathOptions() & 2) != 0) {
            return true;
        }
        Date validationTime = pathCtx.getValidationTime();
        if (validationTime == null) {
            validationTime = new Date();
        }
        boolean result = cert.checkValidityDate(validationTime);
        if (DEBUG_ON) {
            String subjName = cert.getSubjectName() == null ? "null" : cert.getSubjectName().toString();
            Debug.println("Validity check of cert " + subjName + (result ? " succeeded" : " failed"));
        }
        return result;
    }

    protected boolean isTrusted(CertPathCtx pathCtx, Certificate cert) {
        Certificate[] trustedCerts = pathCtx.getTrustedCerts();
        if (trustedCerts == null) {
            return false;
        }
        for (int i = 0; i < trustedCerts.length; ++i) {
            if (!cert.equals(trustedCerts[i])) continue;
            return true;
        }
        return false;
    }

    private boolean trustedCertsEmpty(CertPathCtx pathCtx) {
        Certificate[] trustedCerts = pathCtx.getTrustedCerts();
        return trustedCerts == null || trustedCerts.length == 0;
    }

    protected void findCertBySubject(CertPathCtx pathCtx, X500Name subjectName, Vector<Certificate> result) throws CertPathException {
        Certificate[] trustedCerts = pathCtx.getTrustedCerts();
        if (trustedCerts != null) {
            for (int i = 0; i < trustedCerts.length; ++i) {
                Certificate cert = trustedCerts[i];
                if (!(cert instanceof X509Certificate)) continue;
                X509Certificate x509Cert = (X509Certificate)cert;
                if (subjectName == null || !subjectName.equals(x509Cert.getSubjectName()) || result.contains(x509Cert)) continue;
                result.addElement(x509Cert);
            }
        }
        try {
            DatabaseService db = pathCtx.getDatabase();
            if (db != null) {
                db.selectCertificateBySubject(subjectName, result);
            }
        }
        catch (NoServiceException e) {
            throw new CertPathException(e);
        }
        catch (DatabaseException e) {
            throw new CertPathException(e);
        }
    }
}

