/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.path;

import com.rsa.certj.CertJ;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.internal.SuiteBDelegator;
import com.rsa.certj.provider.path.PKIXCertPathCommon;
import com.rsa.certj.provider.revocation.CRLSuiteBCertStatus;
import com.rsa.certj.spi.path.CertPathException;
import com.rsa.jsafe.JSAFE_PublicKey;

public final class PKIXSuiteBCertPath
extends Provider {
    public PKIXSuiteBCertPath(String name) throws InvalidParameterException {
        super(3, name);
    }

    public ProviderImplementation instantiate(CertJ certJ) throws ProviderManagementException {
        try {
            return new Implementation(certJ, this.getName());
        }
        catch (InvalidParameterException e) {
            throw new ProviderManagementException("PKIXSuiteBCertPath.instantiate: ", e);
        }
    }

    private final class Implementation
    extends PKIXCertPathCommon {
        private Implementation(CertJ certJ, String name) throws InvalidParameterException {
            super(certJ, name);
        }

        public String toString() {
            return "PKIX SuiteB Certification Path provider named: " + super.getName();
        }

        protected boolean checkCompliance(X509Certificate certInPath, JSAFE_PublicKey issuerPubKey) throws CertPathException {
            try {
                if (!this.certJ.isProviderRegistered(new CRLSuiteBCertStatus(""), 2)) {
                    throw new CertPathException("Provider CRLSuiteBCertStatus MUST be used with a PKIXSuiteBCertPath Provider.");
                }
            }
            catch (InvalidParameterException e) {
                throw new CertPathException(e);
            }
            return SuiteBDelegator.checkSuiteBCompliance(certInPath, issuerPubKey, this.context);
        }

        protected String getCRLComplianceFailedMessage() {
            return " as no valid SuiteB CRL was found.";
        }
    }
}

