/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.path;

import com.rsa.certj.cert.extensions.PolicyQualifiers;
import com.rsa.certj.cert.extensions.X509V3Extension;
import com.rsa.certj.provider.path.ValidPolicyTreeNode;
import com.rsa.certj.spi.path.CertPathException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ValidPolicyTree {
    private ValidPolicyTreeNode root;

    ValidPolicyTree() {
        Vector<byte[]> expectedPolicies = new Vector<byte[]>();
        expectedPolicies.add(X509V3Extension.ANY_POLICY_OID);
        PolicyQualifiers qualifiers = new PolicyQualifiers();
        try {
            this.root = ValidPolicyTreeNode.createNode(X509V3Extension.ANY_POLICY_OID, qualifiers, expectedPolicies);
        }
        catch (CertPathException e) {
            throw new IllegalStateException("Internal error!");
        }
    }

    static void removeBranch(ValidPolicyTreeNode node) {
        if (node == null) {
            return;
        }
        ValidPolicyTreeNode parent = node.getParent();
        if (parent == null) {
            return;
        }
        parent.removeChild(node);
        Vector<ValidPolicyTreeNode> siblings = parent.getChildren();
        if (siblings == null) {
            ValidPolicyTree.removeBranch(parent);
        }
    }

    void removeNodesWithoutChildren(int depth) {
        if (depth < 1 || !this.root.hasChildren()) {
            return;
        }
        Vector<ValidPolicyTreeNode> rootChildren = new Vector<ValidPolicyTreeNode>(this.root.getChildren());
        this.removeNodesWithoutChildrenHelper(rootChildren, 1, depth);
    }

    Vector<ValidPolicyTreeNode> getNodesAtDepth(int depth) {
        Vector<ValidPolicyTreeNode> result = new Vector<ValidPolicyTreeNode>();
        if (depth < 0) {
            return result;
        }
        Vector<ValidPolicyTreeNode> rootNode = new Vector<ValidPolicyTreeNode>();
        rootNode.add(this.root);
        this.getNodesAtDepthHelper(rootNode, 0, result, depth);
        return result;
    }

    ValidPolicyTreeNode getRoot() {
        return this.root;
    }

    private void removeNodesWithoutChildrenHelper(Vector<ValidPolicyTreeNode> nodes, int currentDepth, int targetDepth) {
        if (nodes == null || currentDepth > targetDepth) {
            return;
        }
        Vector<ValidPolicyTreeNode> nodesCopy = new Vector<ValidPolicyTreeNode>(nodes);
        for (ValidPolicyTreeNode node : nodesCopy) {
            Vector<ValidPolicyTreeNode> children = node.getChildren();
            this.removeNodesWithoutChildrenHelper(children, currentDepth + 1, targetDepth);
            if (node.getChildren() != null) continue;
            ValidPolicyTreeNode parent = node.getParent();
            parent.removeChild(node);
        }
    }

    private void getNodesAtDepthHelper(Vector<ValidPolicyTreeNode> nodesAtCurrentLevel, int currentLevel, Vector<ValidPolicyTreeNode> nodesAtTargetLevel, int targetLevel) {
        if (nodesAtCurrentLevel == null) {
            return;
        }
        if (currentLevel == targetLevel) {
            nodesAtTargetLevel.addAll(nodesAtCurrentLevel);
            return;
        }
        for (ValidPolicyTreeNode node : nodesAtCurrentLevel) {
            this.getNodesAtDepthHelper(node.getChildren(), currentLevel + 1, nodesAtTargetLevel, targetLevel);
        }
    }
}

