/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.path;

import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.extensions.GeneralNames;
import com.rsa.certj.cert.extensions.GeneralSubtrees;
import com.rsa.certj.internal.Debug;
import com.rsa.certj.provider.path.CertPathCommon;
import com.rsa.certj.provider.path.X509V1CertPathResult;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.path.CertPathException;
import com.rsa.certj.spi.path.CertPathResult;
import com.rsa.certj.spi.path.PolicyInformation;
import java.util.Vector;

public final class X509V1CertPath
extends Provider {
    public X509V1CertPath(String name) throws InvalidParameterException {
        super(3, name);
    }

    public ProviderImplementation instantiate(CertJ certJ) throws ProviderManagementException {
        try {
            return new Implementation(certJ, this.getName());
        }
        catch (InvalidParameterException e) {
            throw new ProviderManagementException("X509V1CertPath.instantiate: ", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Implementation
    extends CertPathCommon {
        private Implementation(CertJ certJ, String name) throws InvalidParameterException {
            super(certJ, name);
        }

        @Override
        protected void getNextCertCandidates(CertPathCtx pathCtx, Object baseObject, Vector<Certificate> candidates) throws CertPathException {
            X500Name issuerName;
            if (baseObject instanceof X509Certificate) {
                X509Certificate cert = (X509Certificate)baseObject;
                issuerName = cert.getIssuerName();
            } else if (baseObject instanceof X509CRL) {
                X509CRL crl = (X509CRL)baseObject;
                issuerName = crl.getIssuerName();
            } else {
                throw new CertPathException("X509V1CertPath$Implementation.getNextCertCandidates: does not support startObjects other than X509Certificate or X509CRL.");
            }
            this.findCertBySubject(pathCtx, issuerName, candidates);
        }

        @Override
        protected boolean verifyPath(CertPathCtx pathCtx, Vector<Certificate> path, Vector<CRL> crlList, Vector<Certificate> crlCerts, Vector<PolicyInformation> policyInfoList, GeneralSubtrees initialPermittedSubtrees, GeneralNames initialExcludedSubtrees, CertPathResult pathResult) throws CertPathException {
            X509V1CertPathResult result = pathResult != null && pathResult instanceof X509V1CertPathResult ? (X509V1CertPathResult)pathResult : new X509V1CertPathResult();
            Vector<CRL> crlListLocal = crlList == null ? null : new Vector<CRL>();
            Vector<Certificate> crlCertsLocal = crlCerts == null ? null : new Vector<Certificate>();
            X509Certificate subject = null;
            int index = path.size() - 1;
            Debug.println(DEBUG_ON, "Start X509v1 verifying path, using trusted root first.");
            while (index > 0) {
                subject = (X509Certificate)path.elementAt(--index);
                if (DEBUG_ON) {
                    Debug.println("Verifying path with certificate " + subject.getSubjectName().toString());
                }
                if (this.verifyRevocation(pathCtx, subject, crlListLocal, crlCertsLocal)) continue;
                Debug.println(DEBUG_ON, "Certificate revocation check failed.");
                result.setValidationResult(false);
                result.setMessage("Certificate with subject " + subject.getSubjectName().toString() + " is either revoked or the revocation could not be determined");
                return false;
            }
            CertJUtils.mergeLists(crlList, crlListLocal);
            CertJUtils.mergeLists(crlCerts, crlCertsLocal);
            result.setValidationResult(true);
            if (subject != null) {
                result.setSubjectCert(subject);
            }
            return true;
        }

        @Override
        public String toString() {
            return "X509V1 Certification Path provider named: " + super.getName();
        }

        @Override
        protected CertPathResult createCertPathResult() {
            return new X509V1CertPathResult();
        }
    }
}

