/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJException;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.PKCS10CertRequest;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.attributes.V3ExtensionAttribute;
import com.rsa.certj.cert.attributes.VeriSignCRSFailureInfo;
import com.rsa.certj.cert.attributes.VeriSignCRSMessageType;
import com.rsa.certj.cert.attributes.VeriSignCRSPKIStatus;
import com.rsa.certj.cert.attributes.VeriSignCRSRecipientNonce;
import com.rsa.certj.cert.attributes.VeriSignCRSSenderNonce;
import com.rsa.certj.cert.attributes.VeriSignCRSTransactionID;
import com.rsa.certj.cert.attributes.VeriSignCRSVersion;
import com.rsa.certj.cert.attributes.X501Attribute;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.certj.pkcs7.ContentInfo;
import com.rsa.certj.pkcs7.Data;
import com.rsa.certj.pkcs7.EnvelopedData;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.certj.pkcs7.RecipientInfo;
import com.rsa.certj.pkcs7.SignedData;
import com.rsa.certj.pkcs7.SignerInfo;
import com.rsa.certj.provider.TransportImplementation;
import com.rsa.certj.provider.pki.PKICommonImplementation;
import com.rsa.certj.provider.pki.PKIDebug;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.pki.PKIException;
import com.rsa.certj.spi.pki.PKIInterface;
import com.rsa.certj.spi.pki.PKIMessage;
import com.rsa.certj.spi.pki.PKIRequestMessage;
import com.rsa.certj.spi.pki.PKIResponseMessage;
import com.rsa.certj.spi.pki.PKIResult;
import com.rsa.certj.spi.pki.PKIStatusInfo;
import com.rsa.certj.spi.pki.PKITransportException;
import com.rsa.certj.spi.pki.POPGenerationInfo;
import com.rsa.certj.spi.pki.POPValidationInfo;
import com.rsa.certj.spi.pki.ProtectInfo;
import com.rsa.certj.spi.pki.ProtectInfoPublicKey;
import com.rsa.certj.spi.random.RandomException;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_MessageDigest;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_Recode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class CRS
extends Provider
implements PKIDebug {
    public static final int POP_TYPE_CSR = 1;
    private static final int PKCS7_SIGNED_DATA_VERSION = 1;
    private static final int PKCS7_ENVELOPED_DATA_VERSION = 0;
    private static final String CSR_HEADER = "-----BEGIN NEW CERTIFICATE REQUEST-----";
    private static final String CSR_FOOTER = "-----END NEW CERTIFICATE REQUEST-----";
    private static final String MIME_TYPE_CRS_REQ = "application/octet-stream";
    private static final String MIME_TYPE_CRS_RES = "application/x-crs-message";
    private static final int CRS_VERSION_SUPPORTED = 0;
    private static final int CRS_MSGTYPE_CERTREQ = 19;
    private static final int CRS_MSGTYPE_GETCERTINITIAL = 20;
    private static final int CRS_MSGTYPE_CERTRES = 3;
    private static final String PKI_CRS_PROFILE_NAME_VERISIGN = "VeriSign";
    private static final int FAILINFO_COUNT = 76;
    private static final int[] FAILINFO_VALUE = new int[]{256, 261, 262, 263, 264, 266, 268, 269, 272, 276, 277, 288, 293, 294, 296, 298, 306, 307, 316, 317, 325, 326, 327, 328, 330, 4101, 12353, 12359, 12380, 12384, 12385, 12393, 12420, 14593, 14594, 14595, 14596, 14597, 14598, 14599, 14600, 14601, 14602, 14603, 14604, 14605, 14606, 14607, 14608, 14609, 14610, 14611, 14612, 14613, 14614, 14615, 14617, 14619, 14620, 14623, 14624, 14625, 14626, 14627, 14628, 14629, 14630, 14631, 14632, 14633, 14634, 14639, 14640, 14641, 14642, 14643};
    private static final int[] FAILINFO_FLAG = new int[]{0x200000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x40000000, 0x4000000, 0x4000000, Integer.MIN_VALUE, Integer.MIN_VALUE, 0x100000, Integer.MIN_VALUE, Integer.MIN_VALUE, 0x20000000, 0x40000000, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x8000000, 0x100000, 0x100000, 0x100000, 0x8000000, 0x8000000, 0x1000000, 0x1000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x40000000, 0x40000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x100000, 0x100000, 0x100000, 0x100000, 0x100000, 0x100000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x8000000, 0x4000000, 0x8000000, 0x8000000, 0x4000000, 0x100000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x8000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x8000000};
    private static final int NONCE_LEN = 16;
    private Hashtable<String, Vector<String>> configProperties;

    public CRS(String name, InputStream configStream) throws InvalidParameterException {
        super(4, name);
        if (configStream == null) {
            throw new InvalidParameterException("CRS.CRS: configStream should not be null.");
        }
        this.configProperties = PKICommonImplementation.loadProperties(configStream);
    }

    public CRS(String name, File configFile) throws InvalidParameterException {
        super(4, name);
        if (configFile == null) {
            throw new InvalidParameterException("CRS.CRS: configFile should not be null.");
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(configFile);
            this.configProperties = PKICommonImplementation.loadProperties(stream);
        }
        catch (FileNotFoundException e) {
            throw new InvalidParameterException("CRS.CRS: " + configFile.toString() + " does not exist.");
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException e) {}
            }
        }
    }

    public CRS(String name, String configFileName) throws InvalidParameterException {
        super(4, name);
        if (configFileName == null) {
            throw new InvalidParameterException("CRS.CRS: configFileName should not be null.");
        }
        InputStream stream = null;
        try {
            stream = new FileInputStream(new File(configFileName));
            this.configProperties = PKICommonImplementation.loadProperties(stream);
        }
        catch (FileNotFoundException e) {
            throw new InvalidParameterException("CRS.CRS: " + configFileName + " does not exist.");
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public ProviderImplementation instantiate(CertJ certJ) throws ProviderManagementException {
        try {
            return new Implementation(certJ, this.getName());
        }
        catch (Exception e) {
            throw new ProviderManagementException("CRS.instantiate: ", e);
        }
    }

    public void saveMessage(byte[] bytes, PKIMessage message, ProtectInfo protectInfo) throws PKIException {
    }

    public void saveCertificate(PKIResponseMessage response) throws PKIException {
    }

    public void saveData(byte[] data, String fileName) throws PKIException {
    }

    class ResponseData {
        byte[] recipientNonce;
        byte[] senderNonce;

        ResponseData(byte[] senderNonce, byte[] recipientNonce) {
            this.senderNonce = senderNonce;
            this.recipientNonce = recipientNonce;
        }
    }

    class RequestData {
        byte[] senderNonce;
        byte[] pop;
        X509Certificate selfSignedCert;
        JSAFE_PrivateKey privateKey;
        boolean startPolling;

        RequestData() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Implementation
    extends PKICommonImplementation
    implements PKIInterface {
        private Implementation(CertJ certJ, String name) throws InvalidParameterException, PKIException {
            super(certJ, name);
            this.loadConfig(CRS.this.configProperties);
            if (this.profile == null) {
                this.profile = CRS.PKI_CRS_PROFILE_NAME_VERISIGN;
            }
        }

        @Override
        public PKIResponseMessage readCertificationResponseMessage(byte[] encodedResponse, ProtectInfo protectInfo) throws NotSupportedException, PKIException {
            boolean success;
            if (!(protectInfo instanceof ProtectInfoPublicKey)) {
                throw new PKIException("CRS$Implementation.readCertificationResponseMessage:protectInfo should be an instance of ProtectInfoPublicKey.");
            }
            ProtectInfoPublicKey protectInfoPublicKey = (ProtectInfoPublicKey)protectInfo;
            SignedData signedData = new SignedData(this.certJ, protectInfoPublicKey.getCertPathCtx());
            try {
                success = signedData.readInit(encodedResponse, 0, encodedResponse.length);
                if (success) {
                    success = signedData.readFinal();
                }
            }
            catch (Exception e) {
                if (encodedResponse[0] == 48) {
                    throw new PKIException("CRS$Implementation.readCertificationResponseMessage:decoding response or signature verification failed.", e);
                }
                String[] statusStrings = new String[]{new String(encodedResponse)};
                throw new PKITransportException("CRS$Implementation.readCertificationResponseMessage:error returned in HTML. See the value returned by thisException.getStatusInfo().getStatusStrings[0] for the contents of the HTML response." + new String(encodedResponse) + ").", new PKIStatusInfo(2, 0x200000, statusStrings, -1));
            }
            if (!success) {
                throw new PKIException("CRS$Implementation.readCertificationResponseMessage: Decoding of SignedData failed.");
            }
            return this.readSignedResponse(signedData, protectInfoPublicKey);
        }

        @Override
        public byte[] writeCertificationRequestMessage(PKIRequestMessage request, ProtectInfo protectInfo) throws NotSupportedException, PKIException {
            ContentInfo contentInfo;
            if (!(protectInfo instanceof ProtectInfoPublicKey)) {
                throw new PKIException("CRS$Implementation.writeCertificationRequestMessage: ProtectInfo should be an instance of ProtectInfoPublicKey.");
            }
            if (request.getRegInfo() == null) {
                throw new PKIException("CRS$Implementation.writeCertificationRequestMessage: RegInfo of the request message should not be null.");
            }
            if (request.getSender() == null) {
                throw new PKIException("CRS$Implementation.writeCertificationRequestMessage: Sender information of the request message should not be null.");
            }
            RequestData requestData = (RequestData)request.getProviderData();
            if (requestData == null || requestData.pop == null || requestData.pop.length == 0) {
                throw new PKIException("CRS$Implementation.writeCertificationRequestMessage: POP of the request message should not be null.Use generateProofOfPossession to set it.");
            }
            boolean startPolling = requestData.startPolling;
            int wrapType = request.getWrapType();
            if (wrapType != 1 && wrapType != 4) {
                throw new PKIException("CRS$Implementation.writeCertificationRequestMessage: Only WRAP_SIGN or WRAP_ENVELOPE_THEN_SIGN is supported.");
            }
            if (request.getVersion() == -1) {
                request.setVersion(0);
            } else if (request.getVersion() != 0) {
                throw new PKIException("CRS$Implementation.writeCertificationRequestMessage: CRS version (" + request.getVersion() + ") is not the same as supported version(" + 0 + ").");
            }
            ProtectInfoPublicKey protectInfoPublicKey = (ProtectInfoPublicKey)protectInfo;
            try {
                byte[] pop = startPolling ? this.createCertInitialBodyDER(request, protectInfoPublicKey.getCertPathCtx()) : requestData.pop;
                byte[] bodyDER = this.createCertReqBodyDER(pop, request.getRegInfo());
                Data data = new Data();
                data.setContent(bodyDER, 0, bodyDER.length);
                if (wrapType == 4) {
                    if (request.getRecipient() == null) {
                        throw new PKIException("Implementation.writeCertificationRequestMessage: Recipent info of the request message should not be null.");
                    }
                    contentInfo = this.envelopeMessage(protectInfoPublicKey.getCertPathCtx(), request, data);
                } else {
                    contentInfo = data;
                }
                X501Attributes attrs = request.getSender().getAuthenticatedAttrs();
                if (attrs == null) {
                    attrs = new X501Attributes();
                }
                if (attrs.getAttributeByType(12) == null) {
                    attrs.addAttribute(new VeriSignCRSVersion(request.getVersion()));
                }
                if (attrs.getAttributeByType(6) == null) {
                    if (requestData.startPolling) {
                        attrs.addAttribute(new VeriSignCRSMessageType(20));
                    } else {
                        attrs.addAttribute(new VeriSignCRSMessageType(19));
                    }
                }
                if (attrs.getAttributeByType(11) == null) {
                    if (request.getTransactionID() == null) {
                        request.setTransactionID(this.createTransactionID(data));
                    }
                    attrs.addAttribute(new VeriSignCRSTransactionID(request.getTransactionID(), 0, request.getTransactionID().length));
                }
                if (attrs.getAttributeByType(9) == null) {
                    if (requestData.senderNonce == null) {
                        requestData.senderNonce = this.createNonce();
                    }
                    attrs.addAttribute(new VeriSignCRSSenderNonce(requestData.senderNonce, 0, requestData.senderNonce.length));
                }
                request.getSender().setAuthenticatedAttrs(attrs);
            }
            catch (PKCS7Exception e) {
                throw new PKIException("CRS$Implementation.writeCertificationRequestMessage: ", e);
            }
            byte[] encodedRequest = this.signMessage(protectInfoPublicKey.getCertPathCtx(), request, contentInfo);
            request.setMessageTime(new Date());
            return encodedRequest;
        }

        @Override
        public PKIResponseMessage sendRequest(PKIRequestMessage request, ProtectInfo protectInfo, DatabaseService database) throws NotSupportedException, PKIException {
            Certificate cert;
            byte[] encodedRequest = this.writeCertificationRequestMessage(request, protectInfo);
            CRS.this.saveMessage(encodedRequest, request, protectInfo);
            PKIResult result = this.sendMessage(encodedRequest);
            PKIStatusInfo statusInfo = result.getStatusInfo();
            if (statusInfo.getStatus() != 0) {
                return new PKIResponseMessage(statusInfo);
            }
            byte[] encodedResponse = result.getEncodedResponse();
            CRS.this.saveData(encodedResponse, "RespTemp.ber");
            PKIResponseMessage response = this.readCertificationResponseMessage(encodedResponse, protectInfo);
            CRS.this.saveMessage(encodedResponse, response, protectInfo);
            statusInfo = response.getStatusInfo();
            int status = statusInfo.getStatus();
            if (status != 0 && status != 3 && (statusInfo.getFailInfo() & 0x200000) != 0) {
                return response;
            }
            if (status == 0 || status == 3) {
                if (!CertJUtils.byteArraysEqual(request.getTransactionID(), response.getTransactionID())) {
                    throw new PKIException("CRS$Implementation.sendRequest: Transaction IDs do not match.");
                }
                if (!this.noncesMatch(request, response)) {
                    throw new PKIException("CRS$Implementation.sendRequest: Nonces do not match.");
                }
            }
            if (status == 3) {
                RequestData requestData = (RequestData)request.getProviderData();
                requestData.startPolling = true;
            }
            if ((cert = this.findCertificateReturned(request, response)) != null) {
                response.setCertificate(cert);
            }
            if (database != null) {
                this.disperseCertsAndCRLs(response, database);
            }
            CRS.this.saveCertificate(response);
            return response;
        }

        @Override
        public PKIResponseMessage requestCertification(PKIRequestMessage request, ProtectInfo protectInfo, DatabaseService database) throws NotSupportedException, PKIException {
            return this.sendRequest(request, protectInfo, database);
        }

        @Override
        public PKIResult sendMessage(byte[] request) throws NotSupportedException, PKIException {
            for (int i = 0; i < this.destList.length; ++i) {
                boolean isFailServerError;
                URL url;
                String dest = this.destList[i];
                try {
                    url = new URL(dest);
                }
                catch (Exception e) {
                    continue;
                }
                String protocol = url.getProtocol();
                if (!protocol.equals("http")) continue;
                String[] headers = new String[]{TransportImplementation.MIME_USER_AGENT_STRING, "Content-type: application/octet-stream"};
                String[] responseTypes = new String[]{"Content-type: application/x-crs-message"};
                PKIResult result = this.sendAndReceiveHttp(url, headers, this.proxyList, request, responseTypes);
                boolean bl = isFailServerError = (result.getStatusInfo().getFailInfo() & 0x200000) != 0;
                if (result.getStatusInfo().getStatus() == 2 && isFailServerError) continue;
                return result;
            }
            throw new PKIException("CRS$Implementation.sendMessage: Unable to connect to an auto-responder.");
        }

        @Override
        public void generateProofOfPossession(PKIRequestMessage request, JSAFE_PrivateKey privateKey, POPGenerationInfo popGenerationInfo) throws NotSupportedException, PKIException {
            if (privateKey == null) {
                throw new PKIException("CRS$Implementation.generateProofOfPossession: privateKey cannot be null.");
            }
            int popType = request.getPopType();
            if (popType == -1) {
                request.setPopType(1);
            } else if (popType != 1) {
                throw new PKIException("CRS$Implementation.generateProofOfPossession: POP type should be signature.");
            }
            PKCS10CertRequest pkcs10 = new PKCS10CertRequest();
            X509Certificate template = (X509Certificate)request.getCertificateTemplate();
            RequestData requestData = new RequestData();
            request.setProviderData(requestData);
            try {
                if (template.getVersion() == -1) {
                    pkcs10.setVersion(0);
                }
                if (template.getSubjectName() == null) {
                    throw new PKIException("CRS$Implementation.generateProofOfPossession: Subject name is not specified.");
                }
                pkcs10.setSubjectName(template.getSubjectName());
                if (template.getSubjectPublicKey(this.certJ.getDevice()) == null) {
                    throw new PKIException("CRS$Implementation.generateProofOfPossession: No public key in template.");
                }
                pkcs10.setSubjectPublicKey(template.getSubjectPublicKey(this.certJ.getDevice()));
                X509V3Extensions extensions = template.getExtensions();
                if (extensions != null) {
                    X501Attributes attrs = new X501Attributes();
                    attrs.addAttribute(new V3ExtensionAttribute(extensions));
                    pkcs10.setAttributes(attrs);
                }
                try {
                    pkcs10.signCertRequest("MD5/RSA/PKCS1Block01Pad", this.certJ.getDevice(), privateKey, (SecureRandom)this.certJ.getRandomObject());
                }
                catch (NoServiceException e) {
                    throw new PKIException("CRS$Implementation.generateProofOfPossession: No Random service provider available.", e);
                }
                catch (RandomException e) {
                    throw new PKIException("CRS$Implementation.generateProofOfPossession.", e);
                }
                byte[] pop = new byte[pkcs10.getDERLen(0)];
                requestData.pop = pop;
                pkcs10.getDEREncoding(pop, 0, 0);
            }
            catch (CertificateException e) {
                throw new PKIException("CRS$Implementation.generateProofOfPossession.", e);
            }
            SignerInfo signer = request.getSender();
            if (signer == null) {
                throw new PKIException("CRS$Implementation.generateProofOfPossession: Sender is not specified.");
            }
            try {
                if (signer.getIssuerName().equals(template.getSubjectName()) && CertJUtils.byteArraysEqual(signer.getSerialNumber(), template.getSerialNumber())) {
                    this.storeSelfSignedInfo(request, privateKey);
                }
            }
            catch (PKCS7Exception e) {
                throw new PKIException("CRS$Implementation.generateProofOfPossession.", e);
            }
        }

        @Override
        public boolean validateProofOfPossession(PKIMessage message, POPValidationInfo popValidationInfo) throws NotSupportedException, PKIException {
            throw new NotSupportedException("CRS$Implementation.validateProofOfPossession: not supported.");
        }

        @Override
        public void provideProofOfPossession(PKIRequestMessage request, int popType, byte[] pop) throws PKIException {
            if (popType != 1) {
                throw new PKIException("CRS$Implementation.provideProofOfPossession: Unsupported POP type(" + popType + ").");
            }
            if (pop == null || pop.length == 0) {
                throw new PKIException("CRS$Implementation.provideProofOfPossession: POP data is empty.");
            }
            int start = this.findBodyStart(pop, CRS.CSR_HEADER);
            int end = this.findBodyEnd(pop, CRS.CSR_FOOTER);
            if (end < start) {
                throw new PKIException("CRS$Implementation.provideProofOfPossession: Ill-formated POP data.");
            }
            byte[] body = this.base64Decode(pop, start, end);
            try {
                new PKCS10CertRequest(body, 0, 0);
            }
            catch (CertificateException e) {
                throw new PKIException("CRS$Implementation.provideProofOfPossession: POP is not in PKCS10 format.", e);
            }
            RequestData requestData = new RequestData();
            requestData.pop = body;
            request.setProviderData(requestData);
        }

        private byte[] createCertInitialBodyDER(PKIRequestMessage request, CertPathCtx pathCtx) throws PKIException {
            try {
                X500Name issuerName;
                SignerInfo signerInfo = request.getSender();
                Vector<Certificate> certList = new Vector<Certificate>();
                DatabaseService db = pathCtx.getDatabase();
                int count = db.selectCertificateByIssuerAndSerialNumber(signerInfo.getIssuerName(), signerInfo.getSerialNumber(), certList);
                X500Name subjectName = count == 0 ? new X500Name() : ((X509Certificate)certList.elementAt(0)).getSubjectName();
                RecipientInfo recipientInfo = request.getRecipient();
                if (recipientInfo == null) {
                    issuerName = new X500Name();
                } else {
                    certList = new Vector();
                    count = db.selectCertificateByIssuerAndSerialNumber(recipientInfo.getIssuerName(), recipientInfo.getSerialNumber(), certList);
                    issuerName = count == 0 ? new X500Name() : ((X509Certificate)certList.elementAt(0)).getSubjectName();
                }
                byte[] issuerDER = new byte[issuerName.getDERLen(0)];
                issuerName.getDEREncoding(issuerDER, 0, 0);
                byte[] subjectDER = new byte[subjectName.getDERLen(0)];
                subjectName.getDEREncoding(subjectDER, 0, 0);
                SequenceContainer sequence = new SequenceContainer(0, true, 0);
                EndContainer end = new EndContainer();
                EncodedContainer issuer = new EncodedContainer(0, true, 0, issuerDER, 0, issuerDER.length);
                EncodedContainer subject = new EncodedContainer(0, true, 0, subjectDER, 0, subjectDER.length);
                ASN1Container[] def = new ASN1Container[]{sequence, issuer, subject, end};
                return ASN1.derEncode((ASN1Container[])def);
            }
            catch (ASN_Exception e) {
                throw new PKIException("CRS$Implementation.createCertInitialBodyDER: ", (Exception)((Object)e));
            }
            catch (CertJException e) {
                throw new PKIException("CRS$Implementation.createCertInitialBodyDER: ", e);
            }
            catch (NameException e) {
                throw new PKIException("CRS$Implementation.createCertInitialBodyDER: ", e);
            }
        }

        private byte[] createCertReqBodyDER(byte[] pop, Properties regInfo) throws PKIException {
            try {
                String string = this.urlEncodeRegInfo(regInfo);
                byte[] attrs = string.getBytes();
                OctetStringContainer octetString = new OctetStringContainer(0, true, 0, attrs, 0, attrs.length);
                SequenceContainer sequence = new SequenceContainer(0, true, 0);
                EndContainer end = new EndContainer();
                EncodedContainer encoded = new EncodedContainer(0, true, 0, pop, 0, pop.length);
                ASN1Container[] asn1Def = new ASN1Container[]{sequence, encoded, octetString, end};
                return ASN1.derEncode((ASN1Container[])asn1Def);
            }
            catch (ASN_Exception e) {
                throw new PKIException("CRS$Implementation.createCertReqBodyDER: ", (Exception)((Object)e));
            }
        }

        private boolean noncesMatch(PKIRequestMessage request, PKIResponseMessage response) {
            RequestData requestData = (RequestData)request.getProviderData();
            ResponseData responseData = (ResponseData)response.getProviderData();
            return CertJUtils.byteArraysEqual(requestData.senderNonce, responseData.recipientNonce);
        }

        private byte[] signMessage(CertPathCtx pathCtx, PKIRequestMessage request, ContentInfo contentInfo) throws PKIException {
            RequestData requestData = (RequestData)request.getProviderData();
            DatabaseService database = pathCtx.getDatabase();
            X509Certificate selfSignedCert = requestData.selfSignedCert;
            if (selfSignedCert != null) {
                try {
                    database.insertCertificate(selfSignedCert);
                    database.insertPrivateKeyByCertificate(selfSignedCert, requestData.privateKey);
                }
                catch (Exception e) {
                    throw new PKIException("CRS$Implementation.signMessage: Storing EE signing key failed(", e);
                }
            }
            try {
                CRL[] extraCRLs;
                SignedData signedData = new SignedData(this.certJ, pathCtx);
                signedData.setVersionNumber(1);
                SignerInfo sender = request.getSender();
                signedData.addSignerInfo(sender);
                signedData.setContentInfo(contentInfo);
                Certificate[] extraCerts = request.getExtraCerts();
                if (extraCerts != null) {
                    for (int i = 0; i < extraCerts.length; ++i) {
                        signedData.addCertificate((X509Certificate)extraCerts[i]);
                    }
                }
                if ((extraCRLs = request.getExtraCRLs()) != null) {
                    for (int i = 0; i < extraCRLs.length; ++i) {
                        signedData.addCRL((X509CRL)extraCRLs[i]);
                    }
                }
                DatabaseService db = pathCtx.getDatabase();
                Vector<Certificate> certList = new Vector<Certificate>();
                int count = db.selectCertificateByIssuerAndSerialNumber(sender.getIssuerName(), sender.getSerialNumber(), certList);
                if (count > 0) {
                    Certificate cert = certList.elementAt(0);
                    this.certJ.buildCertPath(pathCtx, cert, certList, null, null, null);
                    for (int i = 0; i < certList.size(); ++i) {
                        signedData.addCertificate((X509Certificate)certList.elementAt(i));
                    }
                }
                count = signedData.getContentInfoDERLen();
                byte[] der = new byte[count];
                signedData.writeMessage(der, 0);
                return der;
            }
            catch (CertJException e) {
                throw new PKIException("CRS$Implementation.signMessage: ", e);
            }
        }

        private EnvelopedData envelopeMessage(CertPathCtx pathCtx, PKIRequestMessage request, Data bodyDER) throws PKIException {
            try {
                EnvelopedData envelopedData = new EnvelopedData(this.certJ, pathCtx);
                envelopedData.setVersionNumber(0);
                int[] params = request.getEncryptionParams();
                envelopedData.setEncryptionAlgorithm(request.getEncryptionName(), params == null ? -1 : params[0]);
                envelopedData.setContentInfo(bodyDER);
                envelopedData.addRecipientInfo(request.getRecipient());
                return envelopedData;
            }
            catch (PKCS7Exception e) {
                throw new PKIException("CRS$Implementation.envelopeMessage: ", e);
            }
        }

        private byte[] createTransactionID(Data data) throws PKIException {
            try {
                byte[] ber = new byte[data.getContentInfoDERLen()];
                data.writeMessage(ber, 0);
                JSAFE_MessageDigest md5 = JSAFEFactory.getDigest("MD5", this.certJ.getDevice(), this.context.jsafe);
                byte[] digestedData = new byte[md5.getDigestSize()];
                md5.digestInit();
                md5.digestUpdate(ber, 0, ber.length);
                md5.digestFinal(digestedData, 0);
                if ((digestedData[0] & 0x80) == 0) {
                    return digestedData;
                }
                byte[] newBer = new byte[digestedData.length + 1];
                System.arraycopy(digestedData, 0, newBer, 1, digestedData.length);
                newBer[0] = 0;
                return newBer;
            }
            catch (PKCS7Exception e) {
                throw new PKIException("CRS$Implementation.createTransactionID: ", e);
            }
            catch (JSAFE_Exception e) {
                throw new PKIException("CRS$Implementation.createTransactionID: ", (Exception)((Object)e));
            }
        }

        private byte[] createNonce() throws PKIException {
            try {
                return this.certJ.getRandomObject().generateRandomBytes(16);
            }
            catch (NoServiceException e) {
                throw new PKIException("CRS$Implementation.createNonce: No random provider available(", e);
            }
            catch (RandomException e) {
                throw new PKIException("CRS$Implementation.createNonce: ", e);
            }
        }

        private PKIResponseMessage readSignedResponse(SignedData signedData, ProtectInfoPublicKey protectInfo) throws PKIException {
            X501Attributes attrs;
            byte[] body;
            int wrapType;
            ContentInfo content = signedData.getContent();
            RecipientInfo recipient = null;
            switch (content.getContentType()) {
                case 1: {
                    wrapType = 1;
                    body = ((Data)content).getData();
                    break;
                }
                case 3: {
                    wrapType = 4;
                    Vector<RecipientInfo> recipients = ((EnvelopedData)content).getRecipientInfos();
                    if (recipients == null || recipients.size() != 1) {
                        throw new PKIException("CRS$Implementation.readSignedResponse: Only one recipient is expected.");
                    }
                    recipient = recipients.elementAt(0);
                    ContentInfo data = content.getContent();
                    if (data.getContentType() != 1) {
                        throw new PKIException("CRS$Implementation.readSignedResponse: Content of EnvelopedData should be Data.");
                    }
                    body = ((Data)data).getData();
                    break;
                }
                default: {
                    throw new PKIException("CRS$Implementation.readSignedResponse: Invalid response message foramt(" + content.getContentType() + "). Valid formats are DATA and ENVELOPED_DATA.");
                }
            }
            Vector<Certificate> certs = new Vector<Certificate>();
            Vector<CRL> crls = new Vector<CRL>();
            this.processResponseBody(body, protectInfo, certs, crls);
            SignerInfo sender = this.getSender(signedData);
            try {
                attrs = sender.getAuthenticatedAttrs();
            }
            catch (PKCS7Exception e) {
                throw new PKIException("CRS$Implementation.readSignedResponse: ", e);
            }
            if (attrs == null) {
                throw new PKIException("CRS$Implementation.readSignedResponse: No authenticated attributes included.");
            }
            X501Attribute attr = attrs.getAttributeByType(12);
            if (attr == null) {
                throw new PKIException("CRS$Implementation.readSignedResponse: Version attribute not found.");
            }
            int version = ((VeriSignCRSVersion)attr).getVersion();
            attr = attrs.getAttributeByType(6);
            if (attr == null) {
                throw new PKIException("CRS$Implementation.readSignedResponse: Message Type attribute not found.");
            }
            int messageType = ((VeriSignCRSMessageType)attr).getMessageType();
            if (messageType != 3) {
                throw new PKIException("CRS$Implementation.readSignedResponse: Message Type CertResponse (3) is expected.");
            }
            attr = attrs.getAttributeByType(9);
            if (attr == null) {
                throw new PKIException("CRS$Implementation.readSignedResponse: Sender nonce attribute not found.");
            }
            byte[] snonce = ((VeriSignCRSSenderNonce)attr).getSenderNonce();
            attr = attrs.getAttributeByType(10);
            if (attr == null) {
                throw new PKIException("CRS$Implementation.readSignedResponse: Recipient nonce attribute not found.");
            }
            byte[] rnonce = ((VeriSignCRSRecipientNonce)attr).getRecipientNonce();
            Object[] certArray = new Certificate[certs.size()];
            certs.copyInto(certArray);
            Object[] crlArray = new CRL[crls.size()];
            crls.copyInto(crlArray);
            PKIResponseMessage response = new PKIResponseMessage(this.extractStatusInfo(attrs));
            ResponseData responseData = new ResponseData(snonce, rnonce);
            response.setProviderData(responseData);
            response.setVersion(version);
            response.setWrapInfo(wrapType, sender, recipient, null, null);
            response.setTransactionID(this.extractTransactionID(attrs));
            response.setExtraCerts((Certificate[])certArray);
            response.setExtraCRLs((CRL[])crlArray);
            return response;
        }

        private void storeSelfSignedInfo(PKIRequestMessage request, JSAFE_PrivateKey privateKey) throws PKIException {
            String alg = "MD5/RSA/PKCS1Block01Pad";
            X509Certificate template = (X509Certificate)request.getCertificateTemplate();
            try {
                Date endDate;
                if (template.getIssuerName() == null) {
                    template.setIssuerName(template.getSubjectName());
                }
                long milliSeconds = System.currentTimeMillis();
                Date startDate = template.getStartDate();
                long millisInHour = 3600000L;
                if (startDate == null) {
                    startDate = new Date(milliSeconds - 720L * millisInHour);
                }
                if ((endDate = template.getEndDate()) == null) {
                    endDate = new Date(milliSeconds + 8760L * millisInHour);
                }
                template.setValidity(startDate, endDate);
                X509Certificate selfSignedCert = template;
                selfSignedCert.signCertificate(alg, this.certJ.getDevice(), privateKey, (SecureRandom)this.certJ.getRandomObject());
                RequestData requestData = (RequestData)request.getProviderData();
                requestData.privateKey = privateKey;
                requestData.selfSignedCert = selfSignedCert;
                Certificate[] extraCerts = request.getExtraCerts();
                int certCount = extraCerts == null ? 0 : extraCerts.length;
                Certificate[] newExtraCerts = new Certificate[certCount + 1];
                if (extraCerts != null) {
                    System.arraycopy(extraCerts, 0, newExtraCerts, 0, certCount);
                }
                newExtraCerts[certCount] = selfSignedCert;
                request.setExtraCerts(newExtraCerts);
            }
            catch (CertificateException e) {
                throw new PKIException("CRS$Implementation.storeSelfSignedInfo: ", e);
            }
            catch (CertJException e) {
                throw new PKIException("CRS$Implementation.storeSelfSignedInfo: ", e);
            }
        }

        private SignerInfo getSender(SignedData signedData) throws PKIException {
            Vector<SignerInfo> signers = signedData.getSignerInfos();
            if (signers == null || signers.size() > 2 || signers.isEmpty()) {
                throw new PKIException("CRS$Implementation.getSender: Expected exactly one signer.");
            }
            return signers.elementAt(0);
        }

        private byte[] extractTransactionID(X501Attributes attrs) throws PKIException {
            VeriSignCRSTransactionID attr = (VeriSignCRSTransactionID)attrs.getAttributeByType(11);
            if (attr == null) {
                throw new PKIException("CRS$Implementation.extractTransactionID: Transaction ID attribute not found.");
            }
            return attr.getTransactionID();
        }

        private PKIStatusInfo extractStatusInfo(X501Attributes attrs) throws PKIException {
            X501Attribute attr = attrs.getAttributeByType(7);
            if (attr == null) {
                throw new PKIException("CRS$Implementation.extractStatusInfo: No status attribute found.");
            }
            int status = ((VeriSignCRSPKIStatus)attr).getPKIStatus();
            status = this.mapStatusInfo(status);
            int failInfoAux = -1;
            int failInfo = -1;
            if (status == 2) {
                attr = attrs.getAttributeByType(8);
                if (attr == null) {
                    throw new PKIException("CRS$Implementation.extractStatusInfo: No Failure Info attribute found.");
                }
                failInfoAux = ((VeriSignCRSFailureInfo)attr).getFailureInfo();
                failInfo = this.mapFailInfo(failInfoAux);
            }
            return new PKIStatusInfo(status, failInfo, null, failInfoAux);
        }

        private int mapStatusInfo(int status) throws PKIException {
            switch (status) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 3;
                }
                case 2: {
                    return 2;
                }
            }
            throw new PKIException("CRS$Implementation.mapStatusInfo: Status value(" + status + ") is not valid. Valid values are 0, 1, and 2.");
        }

        private int mapFailInfo(int failInfoAux) {
            if (this.profile.equals(CRS.PKI_CRS_PROFILE_NAME_VERISIGN)) {
                for (int i = 0; i < 76; ++i) {
                    if (FAILINFO_VALUE[i] != failInfoAux) continue;
                    return FAILINFO_FLAG[i];
                }
            }
            return 0x20000000;
        }

        private Properties processResponseBody(byte[] body, ProtectInfoPublicKey protectInfo, Vector<Certificate> certs, Vector<CRL> crls) throws PKIException {
            if (body == null || body.length == 0) {
                return null;
            }
            try {
                SequenceContainer aSeq = new SequenceContainer(0);
                EndContainer anEnd = new EndContainer();
                EncodedContainer degenPKCS7 = new EncodedContainer(77824);
                OctetStringContainer rspInfo = new OctetStringContainer(0);
                ASN1Container[] innerDER = new ASN1Container[]{aSeq, degenPKCS7, rspInfo, anEnd};
                ASN1.berDecode((byte[])body, (int)0, (ASN1Container[])innerDER);
                if (degenPKCS7.dataLen != 0) {
                    SignedData signedData = new SignedData(this.certJ, protectInfo.getCertPathCtx());
                    boolean success = signedData.readInit(degenPKCS7.data, degenPKCS7.dataOffset, degenPKCS7.dataLen);
                    if (success) {
                        success = signedData.readFinal();
                    }
                    if (!success) {
                        throw new PKIException("CRS$Implementation.processResponseBody: Unable to decode degenerate PKCS7.");
                    }
                    Vector<X509Certificate> vector = signedData.getCertificates();
                    if (vector != null) {
                        for (int i = 0; i < vector.size(); ++i) {
                            certs.addElement(vector.elementAt(i));
                        }
                    }
                    Vector<X509CRL> crlVector = signedData.getCRLs();
                    if (vector != null) {
                        for (int i = 0; i < crlVector.size(); ++i) {
                            crls.addElement(crlVector.elementAt(i));
                        }
                    }
                }
                return this.urlDecodeRegInfo(new String(rspInfo.data, rspInfo.dataOffset, rspInfo.dataLen));
            }
            catch (ASN_Exception e) {
                throw new PKIException("CRS$Implementation.processResponseBody: Unable to decode innerDER.", (Exception)((Object)e));
            }
            catch (PKCS7Exception e) {
                throw new PKIException("CRS$Implementation.processResponseBody: Unable to decode degenerated PKCS7.", e);
            }
        }

        private int findBodyStart(byte[] data, String header) {
            int start;
            int fence = data.length - header.length();
            for (start = 0; start < fence; ++start) {
                if (!this.memeq(data, start, header)) continue;
                start += header.length();
                break;
            }
            if (start == fence) {
                return 0;
            }
            if (!(data[start] != 13 && data[start] != 10 || data[++start] != 13 && data[start] != 10)) {
                ++start;
            }
            return start;
        }

        private int findBodyEnd(byte[] data, String footer) {
            int end;
            int fence = data.length - footer.length();
            for (end = 0; end < fence && !this.memeq(data, end, footer); ++end) {
            }
            if (end == fence) {
                return data.length;
            }
            return end;
        }

        private boolean memeq(byte[] data, int offset, String string) {
            if (data.length - offset < string.length()) {
                return false;
            }
            for (int i = 0; i < string.length(); ++i) {
                if (data[offset + i] == (byte)string.charAt(i)) continue;
                return false;
            }
            return true;
        }

        private byte[] base64Decode(byte[] data, int offset, int length) throws PKIException {
            try {
                JSAFE_Recode decoder = JSAFEFactory.getRecode("Base64-76", this.certJ.getDevice(), this.context.jsafe);
                decoder.decodeInit();
                int outputSize = decoder.getOutputBufferSize(length);
                byte[] buffer = new byte[outputSize];
                int outputLenUpdate = decoder.decodeUpdate(data, offset, length, buffer, 0);
                int outputLenFinal = decoder.decodeFinal(buffer, outputLenUpdate);
                int outputLenTotal = outputLenUpdate + outputLenFinal;
                if (outputLenTotal != outputSize) {
                    byte[] result = new byte[outputLenTotal];
                    System.arraycopy(buffer, 0, result, 0, outputLenTotal);
                    return result;
                }
                return buffer;
            }
            catch (JSAFE_Exception e) {
                throw new PKIException("CRS$Implementation.base64Decode: ", (Exception)((Object)e));
            }
        }

        @Override
        public String toString() {
            return "CRS provider named: " + super.getName();
        }
    }
}

