/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki;

import com.rsa.certj.CertJ;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.provider.TransportImplementation;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.pki.PKIException;
import com.rsa.certj.spi.pki.PKIRequestMessage;
import com.rsa.certj.spi.pki.PKIResponseMessage;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PKICommonImplementation
extends TransportImplementation {
    private static final char CR = '\r';
    private static final char LF = '\n';

    protected PKICommonImplementation(CertJ certJ, String name) throws InvalidParameterException {
        super(certJ, name);
    }

    public String urlEncodeRegInfo(Properties regInfo) {
        if (regInfo == null) {
            return null;
        }
        int count = regInfo.size();
        Enumeration<?> names = regInfo.propertyNames();
        String[] sortedNames = new String[count];
        for (int i = 0; i < count; ++i) {
            String name = (String)names.nextElement();
            int lo = 0;
            int hi = i - 1;
            while (hi >= lo) {
                int mid = (lo + hi) / 2;
                int cmp = name.compareTo(sortedNames[mid]);
                if (cmp < 0) {
                    hi = mid - 1;
                    continue;
                }
                lo = mid + 1;
            }
            for (int j = i - 1; j >= lo; --j) {
                sortedNames[j + 1] = sortedNames[j];
            }
            sortedNames[lo] = name;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            String name = sortedNames[i];
            buffer.append(this.urlEncode(name));
            buffer.append('=');
            buffer.append(this.urlEncode(regInfo.getProperty(name)));
            buffer.append('&');
        }
        buffer.setLength(buffer.length() - 1);
        return buffer.toString();
    }

    public Properties urlDecodeRegInfo(String string) throws PKIException {
        Properties regInfo = new Properties();
        StringTokenizer properties = new StringTokenizer(string, "&");
        while (properties.hasMoreTokens()) {
            String property = properties.nextToken();
            StringTokenizer pair = new StringTokenizer(property, "=");
            if (!pair.hasMoreTokens()) {
                throw new PKIException("PKICommonImplementation.urlDecodeRegInfo: no property found.");
            }
            String encodedName = pair.nextToken();
            if (!pair.hasMoreTokens()) continue;
            String encodedValue = pair.nextToken();
            if (pair.hasMoreTokens()) {
                throw new PKIException("PKICommonImplementation.urlDecodeRegInfo: property does not conform to the valid format (name=value).");
            }
            try {
                regInfo.put(this.urlDecode(encodedName), this.urlDecode(encodedValue));
            }
            catch (Exception e) {
                throw new PKIException("PKICommonImplementation.urlDecodeRegInfo: error in URL-decoding.", e);
            }
        }
        return regInfo;
    }

    protected Certificate findCertificateReturned(PKIRequestMessage request, PKIResponseMessage response) throws PKIException {
        try {
            Certificate template = request.getCertificateTemplate();
            if (template == null) {
                return null;
            }
            JSAFE_PublicKey publicKey = template.getSubjectPublicKey(this.certJ.getDevice());
            Certificate[] extraCerts = response.getExtraCerts();
            if (extraCerts != null) {
                for (int i = 0; i < extraCerts.length; ++i) {
                    X509Certificate cert = (X509Certificate)extraCerts[i];
                    if (!publicKey.equals((Object)cert.getSubjectPublicKey(this.certJ.getDevice()))) continue;
                    return cert;
                }
            }
            return null;
        }
        catch (CertificateException e) {
            throw new PKIException("PKICommonImplementation.findCertificateReturned: ", e);
        }
    }

    protected void disperseCertsAndCRLs(PKIResponseMessage response, DatabaseService database) throws PKIException {
        try {
            CRL[] crls;
            Certificate[] extraCerts = response.getExtraCerts();
            if (extraCerts != null) {
                database.insertCertificates(extraCerts);
            }
            if ((crls = response.getExtraCRLs()) != null) {
                database.insertCRLs(response.getExtraCRLs());
            }
        }
        catch (NoServiceException e) {
            throw new PKIException("PKICommonImplementation.disperseCertsAndCRLs: ", e);
        }
        catch (DatabaseException e) {
            throw new PKIException("PKICommonImplementation.disperseCertsAndCRLs: ", e);
        }
    }

    protected void loadConfig(Hashtable<String, Vector<String>> properties) throws PKIException {
        Vector<String> vector = properties.get("dest");
        if (vector == null) {
            this.destList = new String[0];
        } else {
            this.destList = new String[vector.size()];
            vector.copyInto(this.destList);
        }
        vector = properties.get("http.proxy");
        if (vector == null) {
            this.proxyList = new String[0];
        } else {
            this.proxyList = new String[vector.size()];
            vector.copyInto(this.proxyList);
        }
        vector = properties.get("profile");
        this.profile = vector == null || vector.isEmpty() ? null : vector.elementAt(0);
        vector = properties.get("timeoutSecs");
        if (vector == null || vector.isEmpty()) {
            this.timeoutSecs = -1;
        } else {
            String number = vector.elementAt(0);
            this.timeoutSecs = 0;
            for (int i = 0; i < number.length(); ++i) {
                int digit = Character.digit(number.charAt(i), 10);
                if (digit == -1) {
                    throw new PKIException("PKICommonImplementation.PKICommonImplementation: non-numeric character used in timeoutSecs.");
                }
                this.timeoutSecs = this.timeoutSecs * 10 + digit;
            }
        }
    }

    public static Hashtable<String, Vector<String>> loadProperties(InputStream stream) throws InvalidParameterException {
        String line;
        Hashtable<String, Vector<String>> properties = new Hashtable<String, Vector<String>>();
        while ((line = PKICommonImplementation.readLine(stream)) != null) {
            int lineLen = line.length();
            int delimiter = line.indexOf(61, 0);
            if (delimiter < 0 || delimiter == lineLen) continue;
            String property = PKICommonImplementation.removeExtraSpaces(line.substring(0, delimiter));
            Vector<String> hashedValue = properties.get(property);
            if (hashedValue == null) {
                hashedValue = new Vector();
                properties.put(property, hashedValue);
            }
            String values = line.substring(delimiter + 1, lineLen);
            StringTokenizer valueList = new StringTokenizer(values, ",");
            while (valueList.hasMoreTokens()) {
                hashedValue.addElement(PKICommonImplementation.removeExtraSpaces(valueList.nextToken()));
            }
        }
        return properties;
    }

    private static String readLine(InputStream stream) throws InvalidParameterException {
        StringBuffer buffer;
        try {
            int character = stream.read();
            if (character == -1) {
                return null;
            }
            buffer = new StringBuffer();
            while (character != -1 && character != 10) {
                if (character != 13) {
                    buffer.append((char)character);
                }
                character = stream.read();
            }
        }
        catch (IOException e) {
            throw new InvalidParameterException("PKICommonImplementation.readLine: reading from " + stream.toString() + " failed(", e);
        }
        return buffer.toString();
    }

    private static String removeExtraSpaces(String string) {
        int start = 0;
        int end = string.length();
        while (string.charAt(start) == ' ') {
            ++start;
        }
        while (string.charAt(end - 1) == ' ') {
            --end;
        }
        return string.substring(start, end);
    }

    private String urlDecode(String string) throws UnsupportedEncodingException {
        return URLDecoder.decode(string, "Cp1252");
    }

    private String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, "Cp1252");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

