/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki.cmp;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.RegInfo;
import com.rsa.certj.provider.pki.PKICommonImplementation;
import com.rsa.certj.provider.pki.PKIDebug;
import com.rsa.certj.provider.pki.cmp.CMPCertRequestCommon;
import com.rsa.certj.provider.pki.cmp.CMPException;
import com.rsa.certj.provider.pki.cmp.CMPPOPGenerationInfo;
import com.rsa.certj.provider.pki.cmp.CMPPOPGenerationInfoEncryption;
import com.rsa.certj.provider.pki.cmp.CMPPOPGenerationInfoSignature;
import com.rsa.certj.provider.pki.cmp.CMPProtectInfo;
import com.rsa.certj.provider.pki.cmp.CMPRequestCommon;
import com.rsa.certj.provider.pki.cmp.CMPResponseCommon;
import com.rsa.certj.spi.pki.PKIException;
import com.rsa.certj.spi.pki.PKIInterface;
import com.rsa.certj.spi.pki.PKIMessage;
import com.rsa.certj.spi.pki.PKIRequestMessage;
import com.rsa.certj.spi.pki.PKIResponseMessage;
import com.rsa.certj.spi.pki.PKIResult;
import com.rsa.certj.spi.pki.PKIStatusInfo;
import com.rsa.certj.spi.pki.PKITransportException;
import com.rsa.certj.spi.pki.POPGenerationInfo;
import com.rsa.certj.spi.pki.POPValidationInfo;
import com.rsa.certj.spi.pki.ProtectInfo;
import com.rsa.jsafe.JSAFE_PrivateKey;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class CMP
extends Provider
implements PKIDebug {
    public static final int CMP1999 = 1;
    public static final int CMP2000 = 2;
    protected static final int MESSAGE_IR = 0;
    protected static final int MESSAGE_IP = 1;
    protected static final int MESSAGE_CR = 2;
    protected static final int MESSAGE_CP = 3;
    protected static final int MESSAGE_P10CR = 4;
    protected static final int MESSAGE_POPDECC = 5;
    protected static final int MESSAGE_POPDECR = 6;
    protected static final int MESSAGE_KUR = 7;
    protected static final int MESSAGE_KUP = 8;
    protected static final int MESSAGE_KRR = 9;
    protected static final int MESSAGE_KRP = 10;
    protected static final int MESSAGE_RR = 11;
    protected static final int MESSAGE_RP = 12;
    protected static final int MESSAGE_CCR = 13;
    protected static final int MESSAGE_CCP = 14;
    protected static final int MESSAGE_CKUANN = 15;
    protected static final int MESSAGE_CANN = 16;
    protected static final int MESSAGE_RANN = 17;
    protected static final int MESSAGE_CRLANN = 18;
    protected static final int MESSAGE_PKICONF = 19;
    protected static final int MESSAGE_NESTED = 20;
    protected static final int MESSAGE_GENM = 21;
    protected static final int MESSAGE_GENP = 22;
    protected static final int MESSAGE_ERROR = 23;
    protected static final int MESSAGE_CERTCONF = 24;
    public static final int DEFAULT_CMPTCP_PORT = 829;
    public static final int CMPTCP_ERROR_NONE = 0;
    public static final int CMPTCP_ERROR_VERSION = 257;
    public static final int CMPTCP_ERROR_CLIENT = 512;
    public static final int CMPTCP_ERROR_MSGTYPE = 513;
    public static final int CMPTCP_ERROR_POLLID = 514;
    public static final int CMPTCP_ERROR_SERVER = 768;
    public static final int CMPTCP_FLAGS_CLOSE_CONN = 1;
    public static final int CMPTCP_FLAGS_NO_AUTOPOLL = 2;
    protected static final int CONTEXT_SPECIAL = 0xA10000;
    protected static final byte[] PASSWORD_BASED_MAC_OID = new byte[]{42, -122, 72, -122, -10, 125, 7, 66, 13};
    private static final int CMPTCP_SPEC_VERSION = 10;
    private static final int HEADER_REMAINDER_SIZE_V10 = 3;
    private static final int HEADER_LEN_SIZE = 4;
    private static final int HEADER_SIZE_V10 = 7;
    private static final int POLLID_SIZE = 4;
    private static final int SLEEP_TIME_SIZE = 4;
    private static final int HEADER_VERSION_INDEX = 4;
    private static final int HEADER_FLAGS_INDEX = 5;
    private static final int HEADER_MSGTYPE_INDEX = 6;
    private static final int MSGTYPE_PKIREQ = 0;
    private static final int MSGTYPE_POLLREP = 1;
    private static final int MSGTYPE_POLLREQ = 2;
    private static final int MSGTYPE_FINREP = 3;
    private static final int MSGTYPE_PKIREP = 5;
    private static final int MSGTYPE_ERRORMSGREP = 6;
    private static final int CMPTCP_MAX_DATAMSG_LEN = 50000;
    private static final int MSG_POLLREP_LEN = 8;
    private static final int MSG_FINREP_LEN = 0;
    private static final int MSG_ERROR_MSGREP_TYPE_LEN = 2;
    private static final int MSG_ERROR_MSGREP_LEN_LEN = 2;
    private Hashtable<String, Vector<String>> configProperties;
    private int cmptcpFlags;
    private int pollDuration;

    public CMP(String name, InputStream configStream) throws InvalidParameterException {
        super(4, name);
        if (configStream == null) {
            throw new InvalidParameterException("CMP.CMP: configStream should not be null.");
        }
        this.configProperties = PKICommonImplementation.loadProperties(configStream);
    }

    public CMP(String name, File configFile) throws InvalidParameterException {
        super(4, name);
        if (configFile == null) {
            throw new InvalidParameterException("CMP.CMP: configFile should not be null.");
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(configFile);
            this.configProperties = PKICommonImplementation.loadProperties(stream);
        }
        catch (FileNotFoundException e) {
            throw new InvalidParameterException("CMP.CMP: " + configFile.toString() + " does not exist.");
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException e) {}
            }
        }
    }

    public CMP(String name, String configFileName) throws InvalidParameterException {
        super(4, name);
        if (configFileName == null) {
            throw new InvalidParameterException("CMP.CMP: configFileName should not be null.");
        }
        InputStream stream = null;
        try {
            stream = new FileInputStream(new File(configFileName));
            this.configProperties = PKICommonImplementation.loadProperties(stream);
        }
        catch (FileNotFoundException e) {
            throw new InvalidParameterException("CMP.CMP: " + configFileName + " does not exist.");
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public synchronized void setCMPTCPOptions(int cmptcpFlags, int pollDuration) {
        this.cmptcpFlags = cmptcpFlags;
        this.pollDuration = pollDuration;
    }

    public ProviderImplementation instantiate(CertJ certJ) throws ProviderManagementException {
        try {
            return new Implementation(certJ, this.getName());
        }
        catch (Exception e) {
            throw new ProviderManagementException("CMP.instantiate: ", e);
        }
    }

    public void saveMessage(byte[] bytes, PKIMessage message, ProtectInfo protectInfo) throws CMPException {
    }

    public void saveCertificate(PKIResponseMessage response) throws CMPException {
    }

    public void saveData(byte[] data, String fileName) throws CMPException {
    }

    protected static byte[] derEncodeProtectedPart(byte[] headerDER, int headerOffset, int headerLen, byte[] bodyDER, int bodyOffset, int bodyLen) throws CMPException {
        try {
            SequenceContainer protectedPartContainer = new SequenceContainer(0, true, 0);
            EncodedContainer headerContainer = new EncodedContainer(0, true, 0, headerDER, headerOffset, headerLen);
            EncodedContainer bodyContainer = new EncodedContainer(0, true, 0, bodyDER, bodyOffset, bodyLen);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] def = new ASN1Container[]{protectedPartContainer, headerContainer, bodyContainer, endContainer};
            ASN1Template template = new ASN1Template(def);
            byte[] protectedPartDER = new byte[template.derEncodeInit()];
            template.derEncode(protectedPartDER, 0);
            return protectedPartDER;
        }
        catch (ASN_Exception e) {
            throw new CMPException("CMP.derEncodeProtectedPart: Encoding ProtectedPart failed.", (Exception)((Object)e));
        }
    }

    protected static RegInfo convertRegInfo(Properties properties) throws CMPException {
        if (properties == null) {
            return null;
        }
        RegInfo regInfo = new RegInfo();
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = properties.getProperty(name, null);
            try {
                regInfo.addNameValuePair(name, value, true);
            }
            catch (CRMFException e) {
                throw new CMPException("CMP$Implementation.convertRegInfo: ", e);
            }
        }
        return regInfo;
    }

    private synchronized int getCmpTcpFlags() {
        return this.cmptcpFlags;
    }

    private synchronized int getPollDuration() {
        return this.pollDuration;
    }

    private final class Implementation
    extends PKICommonImplementation
    implements PKIInterface {
        private Implementation(CertJ certJ, String name) throws InvalidParameterException, PKIException {
            super(certJ, name);
            this.loadConfig(CMP.this.configProperties);
            if (this.destList.length > 1 || this.destList.length == 0) {
                throw new CMPException("CMP$Implementation.Implementation: config file should contain exactly one dest information.");
            }
            this.closeConnection = (CMP.this.getCmpTcpFlags() & 1) != 0;
            String urlString = this.destList[0];
            StringTokenizer tokens = new StringTokenizer(urlString, ":");
            if (!tokens.hasMoreTokens()) {
                throw new CMPException("CMP$Implementation.Implementation:dest string does not contain protocol part.");
            }
            String protocol = tokens.nextToken();
            if (!protocol.equals("cmptcp")) {
                throw new CMPException("CMP$Implementation.Implementation: protocol(" + protocol + ") is not supported.");
            }
            String rest = urlString.substring(protocol.length() + 3);
            tokens = new StringTokenizer(rest, "/");
            if (!tokens.hasMoreTokens()) {
                throw new CMPException("CMP$Implementation.Implementation:urlString does not contain host part.");
            }
            String hostAndPort = tokens.nextToken();
            StringTokenizer hostTokens = new StringTokenizer(hostAndPort, ":");
            this.host = null;
            this.port = 829;
            if (hostTokens.hasMoreTokens()) {
                this.host = hostTokens.nextToken();
                if (hostTokens.hasMoreTokens()) {
                    this.port = Integer.parseInt(hostTokens.nextToken());
                }
            }
        }

        public PKIResponseMessage readCertificationResponseMessage(byte[] encodedResponse, ProtectInfo protectInfo) throws NotSupportedException {
            throw new NotSupportedException("CMP$Implementation.readCertificationResponseMessage: use sendRequest method.");
        }

        private CMPResponseCommon readResponse(byte[] encodedResponse, CMPProtectInfo protectInfo, CMPRequestCommon request) throws CMPException {
            return CMPResponseCommon.berDecode(encodedResponse, protectInfo, request, this.certJ);
        }

        public byte[] writeCertificationRequestMessage(PKIRequestMessage message, ProtectInfo protectInfo) throws NotSupportedException {
            throw new NotSupportedException("CMP$Implementation.writeCertificationRequestMessage: use sendRequest method.");
        }

        private byte[] writeRequest(CMPRequestCommon request, CMPProtectInfo protectInfo) throws CMPException {
            return request.derEncode(protectInfo, this.certJ);
        }

        public PKIResponseMessage sendRequest(PKIRequestMessage message, ProtectInfo protectInfo, DatabaseService database) throws PKIException {
            if (!(message instanceof CMPRequestCommon)) {
                throw new CMPException("CMP$Implementation.sendRequest: message should be an instance of either CMPInitRequestMessage or CMPCertRequestMessage.");
            }
            if (protectInfo != null && !(protectInfo instanceof CMPProtectInfo)) {
                throw new CMPException("CMP$Implementation.sendRequest:protectInfo should be either null, or an instance of CMPProtectInfo.");
            }
            CMPProtectInfo cmpProtectInfo = null;
            if (protectInfo != null) {
                cmpProtectInfo = (CMPProtectInfo)protectInfo;
            }
            CMPRequestCommon request = (CMPRequestCommon)message;
            this.checkProtectInfoType(request, cmpProtectInfo);
            byte[] encodedRequest = this.writeRequest(request, cmpProtectInfo);
            CMP.this.saveMessage(encodedRequest, request, cmpProtectInfo);
            PKIResult result = this.cmptcpSendPKIReq(encodedRequest);
            PKIStatusInfo statusInfo = result.getStatusInfo();
            if (statusInfo.getStatus() != 0) {
                throw new PKITransportException("CMP$Implementation.sendRequest: transport error occurred while sending a message of type(" + request.getMessageType() + ").", statusInfo);
            }
            byte[] encodedResponse = result.getEncodedResponse();
            CMP.this.saveData(encodedResponse, "RespTemp.ber");
            CMPResponseCommon response = this.readResponse(encodedResponse, cmpProtectInfo, request);
            CMP.this.saveMessage(encodedResponse, response, cmpProtectInfo);
            int msgType = response.getMessageType();
            if (msgType == 23) {
                return response;
            }
            statusInfo = response.getStatusInfo();
            this.checkTransactionID(response, request);
            if (database != null) {
                this.disperseCertsAndCRLs(response, database);
            }
            CMP.this.saveCertificate(response);
            return response;
        }

        public PKIResponseMessage requestCertification(PKIRequestMessage message, ProtectInfo protectInfo, DatabaseService database) throws PKIException {
            return this.sendRequest(message, protectInfo, database);
        }

        public PKIResult sendMessage(byte[] request) throws PKIException {
            return this.cmptcpSendPKIReq(request);
        }

        public void generateProofOfPossession(PKIRequestMessage message, JSAFE_PrivateKey privateKey, POPGenerationInfo popGenerationInfo) throws CMPException {
            if (!(message instanceof CMPCertRequestCommon)) {
                throw new CMPException("CMP$Implementation.generateProofOfPossession: message should be an instance of CMPCertRequestCommon.");
            }
            CMPCertRequestCommon request = (CMPCertRequestCommon)message;
            if (!(popGenerationInfo instanceof CMPPOPGenerationInfo)) {
                throw new CMPException("CMP$Implementation.generateProofOfPossession: popGenerationInfo should be an instance of CMPPOPGenerationInfo.");
            }
            int popType = ((CMPPOPGenerationInfo)popGenerationInfo).getPopType();
            switch (popType) {
                case 0: {
                    request.setPop(popType);
                    break;
                }
                case 1: {
                    if (privateKey == null) {
                        throw new CMPException("CMP$Implementation.generateProofOfPossession: privateKey cannot be null.");
                    }
                    request.setPop((CMPPOPGenerationInfoSignature)popGenerationInfo, privateKey, this.certJ);
                    break;
                }
                case 2: {
                    request.setPop(popType, (CMPPOPGenerationInfoEncryption)popGenerationInfo);
                    break;
                }
                default: {
                    throw new CMPException("CMP$Implementation.generateProofOfPossession: pop type(" + popType + ") not supported.");
                }
            }
        }

        public boolean validateProofOfPossession(PKIMessage message, POPValidationInfo popValidationInfo) throws NotSupportedException {
            throw new NotSupportedException("CMP$Implementation.validateProofOfPossession: not supported.");
        }

        public void provideProofOfPossession(PKIRequestMessage message, int popType, byte[] pop) throws NotSupportedException {
            throw new NotSupportedException("CMP$Implementation.provideProofOfPossession: not supported.");
        }

        private void checkTransactionID(CMPResponseCommon response, CMPRequestCommon request) throws CMPException {
            if (!CertJUtils.byteArraysEqual(request.getTransactionID(), response.getTransactionID())) {
                throw new CMPException("Implementation.checkTransactionID: transaction IDs do not match.");
            }
        }

        private void checkProtectInfoType(CMPRequestCommon request, CMPProtectInfo protectInfo) throws CMPException {
            int messageType = request.getMessageType();
            boolean pbmProtected = false;
            if (protectInfo != null) {
                pbmProtected = protectInfo.pbmProtected();
            }
            if (messageType == 0 && protectInfo != null && !pbmProtected) {
                throw new CMPException("CMP$Implementation.checkProtectInfoType: signature protection cannot be used for CMPInitRequestMessage.");
            }
        }

        private void closeSocket() throws PKITransportException {
            try {
                this.socket.close();
                this.socket = null;
            }
            catch (IOException e) {
                throw new PKITransportException("CMP$Implementation.closeSocket: unable to close a socket.", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized PKIResult cmptcpSendPKIReq(byte[] data) throws PKIException {
            boolean askedToClose = false;
            try {
                this.openSocketIfNecessary();
                byte[][] dataRead = this.cmptcpTransport(this.cmptcpCreateHeader(data.length, 0), data, true);
                askedToClose = this.askedToCloseConnection(dataRead[0]);
                PKIResult pKIResult = this.cmptcpProcessResponse(dataRead);
                return pKIResult;
            }
            finally {
                if (this.socket != null && (this.closeConnection || askedToClose)) {
                    this.closeSocket();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized PKIResult cmptcpSendPollReq(byte[] pollID, int sleepTime, Date notAfter) throws PKIException {
            boolean askedToClose = false;
            try {
                Thread.sleep(sleepTime * 1000);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (notAfter != null && notAfter.after(new Date())) {
                return new PKIResult(new PKIStatusInfo(3, 0, null, sleepTime));
            }
            try {
                this.openSocketIfNecessary();
                byte[][] dataRead = this.cmptcpTransport(this.cmptcpCreateHeader(4, 2), pollID, 0, 4, true);
                askedToClose = this.askedToCloseConnection(dataRead[0]);
                PKIResult pKIResult = this.cmptcpProcessResponse(dataRead);
                return pKIResult;
            }
            finally {
                if (this.socket != null && (this.closeConnection || askedToClose)) {
                    this.closeSocket();
                }
            }
        }

        private byte[][] cmptcpTransport(byte[] header, byte[] body, boolean retry) throws PKITransportException {
            return this.cmptcpTransport(header, body, 0, body.length, retry);
        }

        private byte[][] cmptcpTransport(byte[] header, byte[] body, int bodyStart, int bodyLen, boolean retry) throws PKITransportException {
            byte[] entireData = new byte[header.length + bodyLen];
            System.arraycopy(header, 0, entireData, 0, header.length);
            System.arraycopy(body, bodyStart, entireData, header.length, bodyLen);
            return this.cmptcpTransport(entireData, retry);
        }

        private byte[][] cmptcpTransport(byte[] data, boolean retry) throws PKITransportException {
            try {
                this.writeToSocket(data);
            }
            catch (IOException e) {
                return this.retryTransportOrThrow(data, retry, "unable to write data to server.");
            }
            byte[] responseHeader = new byte[7];
            try {
                int count = this.readFromSocket(responseHeader, 0, 7);
                if (count != 7) {
                    return this.retryTransportOrThrow(data, retry, "unable to read CMPTCP header from server.");
                }
            }
            catch (InterruptedIOException e) {
                this.closeSocket();
                throw new PKITransportException("CMP$Implementation.cmptcpTrasport: socket read operation interrupted, possibly timed out. Check timeoutSecs value used in your configuration file. " + e.bytesTransferred + " bytes have been transferred(", e);
            }
            catch (IOException e) {
                return this.retryTransportOrThrow(data, retry, "unable to read CMPTCP header from server.");
            }
            int responseBodyLen = this.cmptcpFindMessageBodyLen(responseHeader);
            byte[] responseBody = new byte[responseBodyLen];
            try {
                int count = this.readFromSocket(responseBody, 0, responseBodyLen);
                if (count != responseBodyLen) {
                    this.closeSocket();
                    throw new PKITransportException("CMP$Implementation.cmptcpTransport: unable to read CMPTCP body from server. Possibly the server is down.");
                }
            }
            catch (InterruptedIOException e) {
                this.closeSocket();
                throw new PKITransportException("CMP$Implementation.cmptcpTrasport: socket read operation interrupted, possibly timed out. Check timeoutSecs value used in your configuration file. " + e.bytesTransferred + " bytes have been transferred(", e);
            }
            catch (IOException e) {
                this.closeSocket();
                throw new PKITransportException("CMP$Implementation.cmptcpTrasport: socket read operation failed. Possibly the server is down.", e);
            }
            byte[][] returnValues = new byte[][]{responseHeader, responseBody};
            return returnValues;
        }

        private int readFromSocket(byte[] buffer, int offset, int length) throws IOException {
            int readCount;
            InputStream input = this.socket.getInputStream();
            int bytesReadSoFar = 0;
            do {
                if ((readCount = input.read(buffer, offset + bytesReadSoFar, length - bytesReadSoFar)) <= 0) continue;
                bytesReadSoFar += readCount;
            } while (readCount >= 0 && bytesReadSoFar < length);
            return bytesReadSoFar;
        }

        private byte[][] retryTransportOrThrow(byte[] data, boolean retry, String errorMessage) throws PKITransportException {
            if (retry) {
                this.closeSocket();
                this.openSocket();
                return this.cmptcpTransport(data, false);
            }
            throw new PKITransportException("CMP$Implementation.retryTransportOrThrow: " + errorMessage + " Possibly the server is down.");
        }

        private byte[] cmptcpCreateHeader(int dataSize, int type) {
            byte[] header = new byte[7];
            this.intToByteArray(3 + dataSize, header, 0, 4);
            header[4] = 10;
            byte cmptcpFlags = 0;
            if (this.closeConnection) {
                cmptcpFlags = 1;
            }
            header[5] = cmptcpFlags;
            header[6] = (byte)type;
            return header;
        }

        private int cmptcpFindMessageBodyLen(byte[] header) throws PKITransportException {
            int bodyLen = this.byteArrayToInt(header, 0, 4) - 3;
            if (bodyLen > 50000) {
                throw new PKITransportException("CMP$Implementation.cmptcpFindMessageBodyLen: received data is too long(>50000).");
            }
            return bodyLen;
        }

        private PKIResult cmptcpProcessResponse(byte[][] dataRead) throws PKIException {
            byte[] header = dataRead[0];
            byte[] body = dataRead[1];
            byte responseType = header[6];
            switch (responseType) {
                case 5: {
                    return new PKIResult(new PKIStatusInfo(0, 0, null, 0), body);
                }
                case 1: {
                    if (body.length != 8) {
                        throw new CMPException("CMP$Implementation.cmptcpProcessResponse: POLLREP should have a body of exactly 8 bytes.");
                    }
                    int sleepTime = this.byteArrayToInt(body, 4, 4);
                    if ((CMP.this.getCmpTcpFlags() & 2) != 0) {
                        return new PKIResult(new PKIStatusInfo(3, 0, null, sleepTime));
                    }
                    Date notAfter = null;
                    int duration = CMP.this.getPollDuration();
                    if (duration > 0) {
                        notAfter = new Date(System.currentTimeMillis() + (long)(duration * 1000));
                    }
                    return this.cmptcpSendPollReq(body, sleepTime, notAfter);
                }
                case 3: {
                    if (body.length != 0) {
                        throw new CMPException("CMP$Implementation.cmptcpProcessResponse: FINREP should have a body of exactly 0 bytes.");
                    }
                    return new PKIResult(new PKIStatusInfo(0, 0, null, 0));
                }
                case 6: {
                    return new PKIResult(this.cmptcpErrorMsgToStatusInfo(body));
                }
            }
            throw new CMPException("CMP$Implementation.cmptcpProcessResponse: unexpected message of type(" + responseType + ")received.");
        }

        private boolean askedToCloseConnection(byte[] header) {
            return header[5] != 0;
        }

        private PKIStatusInfo cmptcpErrorMsgToStatusInfo(byte[] body) throws CMPException {
            int failInfo;
            int errorHeaderLen = 4;
            if (body.length < errorHeaderLen) {
                throw new CMPException("CMP$Implementation.cmptcpErrorMsgToStatusInfo: POLLREQ should have a body of more than " + errorHeaderLen + " bytes.");
            }
            int errorType = this.byteArrayToInt(body, 0, 2);
            int errorDataLen = this.byteArrayToInt(body, 2, 2);
            if (body.length < errorHeaderLen + errorDataLen) {
                throw new CMPException("CMP$Implementation.cmptcpErrorMsgToStatusInfo: message body too short.");
            }
            int errorStrLen = body.length - (errorHeaderLen + errorDataLen);
            switch (errorType) {
                case 257: {
                    failInfo = 128;
                    break;
                }
                case 512: {
                    failInfo = 0x20000000;
                    break;
                }
                case 513: {
                    failInfo = 0x4000000;
                    break;
                }
                case 514: {
                    if ((CMP.this.getCmpTcpFlags() & 2) != 0) {
                        failInfo = 0x4000000;
                        break;
                    }
                    failInfo = 0x20000000;
                    break;
                }
                case 768: {
                    failInfo = 0x100000;
                    break;
                }
                default: {
                    throw new CMPException("CMP$Implementation.cmptcpErrorMsgToStatusInfo: unknown error type(" + errorType + ").");
                }
            }
            String dataString = null;
            String errorStrString = null;
            if (errorDataLen > 0) {
                dataString = new String(body, errorHeaderLen, errorDataLen);
            }
            if (errorStrLen > 0) {
                errorStrString = new String(body, errorHeaderLen + errorDataLen, errorStrLen);
            }
            String[] statusStrings = null;
            if (dataString != null && errorStrString != null) {
                statusStrings = new String[]{dataString, errorStrString};
            } else if (dataString != null) {
                statusStrings = new String[]{dataString};
            } else if (errorStrString != null) {
                statusStrings = new String[]{errorStrString};
            }
            return new PKIStatusInfo(2, failInfo, statusStrings, errorType);
        }

        private void intToByteArray(int integer, byte[] byteArray, int offset, int size) {
            for (int i = size - 1; i >= 0; --i) {
                byteArray[offset + i] = (byte)(integer & 0xFF);
                integer >>= 8;
            }
        }

        private int byteArrayToInt(byte[] byteArray, int offset, int size) {
            int integer = 0;
            for (int i = 0; i < size; ++i) {
                byte temp = byteArray[offset + i];
                integer = (integer << 8) + (temp & 0xFF);
            }
            return integer;
        }
    }
}

