/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki.cmp;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJInternalHelper;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.internal.CertJContext;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.certj.provider.pki.cmp.CMPCertResponseCommon;
import com.rsa.certj.provider.pki.cmp.CMPException;
import com.rsa.certj.provider.pki.cmp.CMPRequestCommon;
import com.rsa.certj.spi.pki.PKIException;
import com.rsa.certj.spi.pki.PKIStatusInfo;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_MessageDigest;
import java.util.StringTokenizer;

public final class CMPCertConfirmMessage
extends CMPRequestCommon {
    private PKIStatusInfo statusInfo;
    private Certificate certReturned;

    public CMPCertConfirmMessage(CMPCertResponseCommon response, PKIStatusInfo statusInfo) throws InvalidParameterException {
        super(24, null);
        if (response == null) {
            throw new InvalidParameterException("CMPCertConfirmMessage.CMPCertConfirmMessage: response should not be null.");
        }
        this.setRecipNonce(response.getSenderNonce());
        this.statusInfo = statusInfo;
        this.certReturned = response.getCertificate();
        if (this.certReturned == null) {
            throw new InvalidParameterException("CMPCertConfirmMessage.CMPCertConfirmMessage: response should contain certificate.");
        }
        this.setTransactionID(response.getTransactionID());
    }

    Certificate getCertificateReturned() {
        return this.certReturned;
    }

    protected byte[] derEncodeBody(CertJ certJ) throws CMPException {
        CertConfirmContent certConfirmContent = new CertConfirmContent(CertJInternalHelper.context(certJ), this.statusInfo, this.certReturned, certJ.getDevice());
        return certConfirmContent.derEncode(0xA00000 | this.getMessageType());
    }

    private final class CertStatus {
        private PKIStatusInfo statusInfo;
        private byte[] certHash;
        private final CertJContext context;

        private CertStatus(CertJContext context, PKIStatusInfo statusInfo, Certificate certificate, String device) throws CMPException {
            this.context = context;
            this.statusInfo = statusInfo;
            this.certHash = this.createCertHash(certificate, device);
        }

        private byte[] derEncode() throws CMPException {
            try {
                EncodedContainer statusInfoContainer;
                SequenceContainer certStatusContainer = new SequenceContainer(0, true, 0);
                EndContainer endContainer = new EndContainer();
                OctetStringContainer certHashContainer = new OctetStringContainer(0, true, 0, this.certHash, 0, this.certHash.length);
                if (this.statusInfo == null) {
                    statusInfoContainer = new EncodedContainer(65536, false, 0, null, 0, 0);
                } else {
                    try {
                        int derLen = this.statusInfo.getDERLen(65536);
                        byte[] statusInfoDer = new byte[derLen];
                        this.statusInfo.getDEREncoding(statusInfoDer, 0, 65536);
                        statusInfoContainer = new EncodedContainer(65536, true, 0, statusInfoDer, 0, statusInfoDer.length);
                    }
                    catch (PKIException e) {
                        throw new CMPException("CMPCertConfirmMessage$CertStatus.derEncode: unable to encode StatusInfo");
                    }
                }
                ASN1Container[] def = new ASN1Container[]{certStatusContainer, certHashContainer, new IntegerContainer(0, true, 0, 0), statusInfoContainer, endContainer};
                ASN1Template template = new ASN1Template(def);
                byte[] der = new byte[template.derEncodeInit()];
                template.derEncode(der, 0);
                return der;
            }
            catch (ASN_Exception e) {
                throw new CMPException("CMPCertConfirmMessage$CertStatus.derEncode: encoding CertStatus failed.", (Exception)((Object)e));
            }
        }

        private byte[] createCertHash(Certificate cert, String device) throws CMPException {
            JSAFE_MessageDigest digest;
            String hashAlg;
            if (!(cert instanceof X509Certificate)) {
                throw new CMPException("CMPCertConfirmMessage$CertStatus.createCertHash: cert has to be an instance of X509Certificate.");
            }
            X509Certificate x509 = (X509Certificate)cert;
            try {
                StringTokenizer tokens = new StringTokenizer(x509.getSignatureAlgorithm(), "/");
                if (!tokens.hasMoreTokens()) {
                    throw new CMPException("CMPCertConfirmMessage$CertStatus.createCertHash: unable to get signature algorithm from cert.");
                }
                hashAlg = tokens.nextToken();
            }
            catch (CertificateException e) {
                throw new CMPException("CMPCertConfirmMessage$CertStatus.createCertHash: unable to get signature algorithm from cert.");
            }
            try {
                digest = JSAFEFactory.getDigest(hashAlg, device, this.context.jsafe);
            }
            catch (JSAFE_Exception e) {
                throw new CMPException("CMPCertConfirmMessage$CertStatus.createCertHash: unable to get digest algorithm for " + hashAlg + ".", (Exception)((Object)e));
            }
            digest.digestInit();
            byte[] der = new byte[x509.getDERLen(0)];
            try {
                x509.getDEREncoding(der, 0, 0);
            }
            catch (CertificateException e) {
                throw new CMPException("CMPCertConfirmMessage$CertStatus.createCertHash: unable to get DER encoding of cert(", e);
            }
            try {
                digest.digestUpdate(der, 0, der.length);
                return digest.digestFinal();
            }
            catch (JSAFE_Exception e) {
                throw new CMPException("CMPCertConfirmMessage$CertStatus.createCertHash: unable to compute digest.", (Exception)((Object)e));
            }
        }
    }

    private final class CertConfirmContent {
        private CertStatus certStatus;

        private CertConfirmContent(CertJContext context, PKIStatusInfo statusInfo, Certificate certificate, String device) throws CMPException {
            this.certStatus = new CertStatus(context, statusInfo, certificate, device);
        }

        private byte[] derEncode(int special) throws CMPException {
            try {
                OfContainer certConfirmContentContainer = new OfContainer(special, 12288, (ASN1Container)new EncodedContainer(12288));
                byte[] certStatusDER = this.certStatus.derEncode();
                certConfirmContentContainer.addContainer((ASN1Container)new EncodedContainer(0, true, 0, certStatusDER, 0, certStatusDER.length));
                ASN1Container[] def = new ASN1Container[]{certConfirmContentContainer};
                ASN1Template template = new ASN1Template(def);
                byte[] der = new byte[template.derEncodeInit()];
                template.derEncode(der, 0);
                return der;
            }
            catch (ASN_Exception e) {
                throw new CMPException("CMPCertConfirmMessage$CertConfirmContent.derEncode: encoding CertConfirmContent failed.", (Exception)((Object)e));
            }
        }
    }
}

