/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki.cmp;

import com.rsa.certj.CertJ;
import com.rsa.certj.CertJException;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.CertReqMessages;
import com.rsa.certj.crmf.CertRequest;
import com.rsa.certj.crmf.CertTemplate;
import com.rsa.certj.crmf.Control;
import com.rsa.certj.crmf.Controls;
import com.rsa.certj.crmf.POPOPrivKey;
import com.rsa.certj.crmf.POPOSigningKeyInput;
import com.rsa.certj.crmf.ProofOfPossession;
import com.rsa.certj.crmf.RegInfo;
import com.rsa.certj.provider.pki.cmp.CMP;
import com.rsa.certj.provider.pki.cmp.CMPException;
import com.rsa.certj.provider.pki.cmp.CMPPOPGenerationInfoNonSignature;
import com.rsa.certj.provider.pki.cmp.CMPPOPGenerationInfoSignature;
import com.rsa.certj.provider.pki.cmp.CMPRequestCommon;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import java.security.SecureRandom;
import java.util.Date;

public abstract class CMPCertRequestCommon
extends CMPRequestCommon {
    protected Controls controls;
    protected CertTemplate certTemplate;
    private CertRequest certRequest;
    private ProofOfPossession pop;

    protected CMPCertRequestCommon(int messageType, CertTemplate certTemplate, Controls controls) throws InvalidParameterException {
        super(messageType, null);
        if (certTemplate == null) {
            throw new InvalidParameterException("CMPCertRequestCommon.CMPCertRequestCommon: certTemplate should not be null.");
        }
        this.certTemplate = certTemplate;
        this.controls = controls;
    }

    protected CMPCertRequestCommon(int messageType, CertTemplate certTemplate, Control control) throws InvalidParameterException {
        super(messageType, null);
        if (certTemplate == null) {
            throw new InvalidParameterException("CMPCertRequestCommon.CMPCertRequestCommon: certTemplate should not be null.");
        }
        this.certTemplate = certTemplate;
        if (control != null) {
            try {
                Controls controls = new Controls();
                controls.addControl(control);
                this.controls = controls;
            }
            catch (CRMFException e) {
                throw new InvalidParameterException("CMPCertRequestCommon:CMPCertRequestCommon: creation of Controls object failed.", e);
            }
        }
    }

    public Certificate getCertificateTemplate() {
        try {
            X509V3Extensions extensions;
            byte[] uid;
            JSAFE_PublicKey publicKey;
            X500Name name;
            X509Certificate cert = new X509Certificate();
            byte[] serialNumber = this.certTemplate.getSerialNumber();
            if (serialNumber != null && serialNumber.length > 0) {
                cert.setSerialNumber(serialNumber, 0, serialNumber.length);
            }
            if ((name = this.certTemplate.getIssuerName()) != null) {
                cert.setIssuerName(name);
            }
            Date startDate = this.certTemplate.getStartDate();
            Date endDate = this.certTemplate.getEndDate();
            if (startDate != null && endDate != null) {
                cert.setValidity(startDate, endDate);
            }
            if ((name = this.certTemplate.getSubjectName()) != null) {
                cert.setSubjectName(name);
            }
            if ((publicKey = this.certTemplate.getSubjectPublicKey()) != null) {
                cert.setSubjectPublicKey(publicKey);
            }
            if ((uid = this.certTemplate.getIssuerUniqueID()) != null) {
                cert.setIssuerUniqueID(uid, 0, uid.length);
            }
            if ((uid = this.certTemplate.getSubjectUniqueID()) != null) {
                cert.setSubjectUniqueID(uid, 0, uid.length);
            }
            if ((extensions = this.certTemplate.getExtensions()) != null) {
                cert.setExtensions(extensions);
            }
            return cert;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected CertTemplate getCertTemplate() {
        return this.certTemplate;
    }

    protected byte[] derEncodeBody(CertJ certJ) throws CMPException {
        int msgType = this.getMessageType();
        try {
            if (this.certTemplate.getSubjectPublicKey() != null && this.pop == null) {
                throw new CMPException("CMPCertRequestCommon.derEncode: pop has not been set. Use generateProofOfPossession method to create pop.");
            }
            RegInfo regInfo = CMP.convertRegInfo(this.getRegInfo());
            if (this.certRequest == null) {
                this.certRequest = this.createCertRequest();
            }
            CertReqMessages certReqMessages = new CertReqMessages(this.certRequest, this.pop, regInfo);
            int derLen = certReqMessages.getDERLen(0xA00000 | msgType);
            byte[] der = new byte[derLen];
            certReqMessages.getDEREncoding(der, 0, 0xA00000 | msgType);
            return der;
        }
        catch (CRMFException e) {
            throw new CMPException("CMPCertRequestCommon.derEncode: unable to encode CertReqMessages(", e);
        }
    }

    protected void setPop(CMPPOPGenerationInfoSignature popGenerationInfo, JSAFE_PrivateKey privateKey, CertJ certJ) throws CMPException {
        JSAFE_SecureRandom random;
        try {
            random = certJ.getRandomObject();
        }
        catch (CertJException e) {
            throw new CMPException("CMPCertRequestCommon.setPop: unable to get a registered random service(", e);
        }
        try {
            this.pop = new ProofOfPossession(1, certJ);
            this.pop.setSignatureAlgorithm(popGenerationInfo.getSignatureAlgorithm());
            X500Name subjectName = this.certTemplate.getSubjectName();
            if (subjectName == null) {
                POPOSigningKeyInput input = new POPOSigningKeyInput();
                input.setSubjectPublicKey(this.certTemplate.getSubjectPublicKey());
                if (popGenerationInfo.authBySenderName()) {
                    GeneralName sender = popGenerationInfo.getSender();
                    input.setSenderName(sender);
                } else {
                    char[] sharedSecret = popGenerationInfo.getSharedSecret();
                    input.setSharedSecret(sharedSecret, 0, sharedSecret.length);
                    byte[] salt = popGenerationInfo.getSalt();
                    input.setSalt(salt, 0, salt.length);
                    input.setIterationCount(popGenerationInfo.getIterationCount());
                }
                this.pop.setPOPOSigningKeyInput(input);
            } else {
                this.pop.setCertRequest(this.createCertRequest());
            }
            this.pop.signPOP(certJ.getDevice(), privateKey, (SecureRandom)random);
        }
        catch (CRMFException e) {
            throw new CMPException("CMPCertRequestCommon.setPop: ", e);
        }
    }

    protected void setPop(int popType, CMPPOPGenerationInfoNonSignature popGenerationInfo) throws CMPException {
        try {
            this.pop = new ProofOfPossession(popType);
            POPOPrivKey popoPrivKey = new POPOPrivKey();
            int method = popGenerationInfo.getMethod();
            switch (method) {
                case 2: {
                    popoPrivKey.setType(1);
                    popoPrivKey.setSubsequentMessage(0);
                    break;
                }
                default: {
                    throw new CMPException("CMPCertRequestCommon.setPop: unsupported POP method(" + method + ").");
                }
            }
            this.pop.setPOPOPrivKey(popoPrivKey);
        }
        catch (CRMFException e) {
            throw new CMPException("CMPCertRequestCommon.setPop: ", e);
        }
    }

    protected void setPop(int popType) throws CMPException {
        try {
            this.pop = new ProofOfPossession(popType);
        }
        catch (CRMFException e) {
            throw new CMPException("CMPCertRequestCommon.setPop: ", e);
        }
    }

    protected Controls getControls() {
        return this.controls;
    }

    private CertRequest createCertRequest() throws CMPException {
        try {
            return new CertRequest(0, this.certTemplate, this.controls);
        }
        catch (CRMFException e) {
            throw new CMPException("CMPCertRequestCommon.createCertRequest: unable to instantiate CertRequest(", e);
        }
    }
}

