/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki.cmp;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJException;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.CertTemplate;
import com.rsa.certj.crmf.Control;
import com.rsa.certj.crmf.Controls;
import com.rsa.certj.crmf.EncryptedValue;
import com.rsa.certj.crmf.PKIPublicationInfo;
import com.rsa.certj.crmf.ProtocolEncryptionKey;
import com.rsa.certj.provider.pki.cmp.CMPCertRequestCommon;
import com.rsa.certj.provider.pki.cmp.CMPCertResponseMessage;
import com.rsa.certj.provider.pki.cmp.CMPException;
import com.rsa.certj.provider.pki.cmp.CMPInitResponseMessage;
import com.rsa.certj.provider.pki.cmp.CMPProtectInfo;
import com.rsa.certj.provider.pki.cmp.CMPRequestCommon;
import com.rsa.certj.provider.pki.cmp.CMPResponseCommon;
import com.rsa.certj.provider.pki.cmp.PKIHeader;
import com.rsa.certj.spi.pki.PKIException;
import com.rsa.certj.spi.pki.PKIStatusInfo;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Properties;
import java.util.StringTokenizer;

public class CMPCertResponseCommon
extends CMPResponseCommon {
    private PKIPublicationInfo publicationInfo;

    protected CMPCertResponseCommon(int messageType, PKIHeader header, PKIStatusInfo statusInfo) {
        super(messageType, header, statusInfo);
    }

    public PKIPublicationInfo getPublicationInfo() {
        return this.publicationInfo;
    }

    protected static CMPCertResponseCommon berDecodeBody(int messageType, PKIHeader header, byte[] body, int bodyOffset, CMPProtectInfo protectInfo, CMPRequestCommon request, CertJ certJ) throws CMPException {
        if (!(request instanceof CMPCertRequestCommon)) {
            throw new CMPException("CMPCertResponseCommon.berDecodeBody: request should be an instance of CMPCertRequestCommon.");
        }
        CMPInitResponseMessage dummy = new CMPInitResponseMessage(header, null);
        return super.decode(messageType, header, body, bodyOffset, protectInfo, (CMPCertRequestCommon)request, certJ);
    }

    private CMPCertResponseCommon decode(int messageType, PKIHeader header, byte[] body, int bodyOffset, CMPProtectInfo protectInfo, CMPCertRequestCommon request, CertJ certJ) throws CMPException {
        CMPCertResponseCommon response;
        CertRepMessage certRepMessage = new CertRepMessage(body, bodyOffset, 0xA10000 | messageType, certJ, request, protectInfo);
        CertResponse certResponse = certRepMessage.response[0];
        switch (messageType) {
            case 1: {
                response = new CMPInitResponseMessage(header, certResponse.status);
                break;
            }
            case 3: {
                response = new CMPCertResponseMessage(header, certResponse.status);
                break;
            }
            default: {
                throw new CMPException("CMPCertResponseCommon.berDecode: message type(" + messageType + ") not supported.");
            }
        }
        CertifiedKeyPair certifiedKeyPair = certResponse.certifiedKeyPair;
        if (certifiedKeyPair != null) {
            response.setCertifiedKeyPairInfo(certifiedKeyPair.getCertificate(), certifiedKeyPair.getPrivateKey(), certifiedKeyPair.publicationInfo);
        }
        response.setCACerts(certRepMessage.caPubs);
        response.setRegInfo(certResponse.rspInfo);
        return response;
    }

    private void setCertifiedKeyPairInfo(Certificate certificate, JSAFE_PrivateKey privateKey, PKIPublicationInfo publicationInfo) {
        this.setCertificate(certificate);
        this.setPrivateKey(privateKey);
        this.publicationInfo = publicationInfo;
    }

    private final class CertifiedKeyPair {
        private Certificate certificate;
        private EncryptedValue encryptedCert;
        private EncryptedValue encryptedPrivateKey;
        private PKIPublicationInfo publicationInfo;

        private CertifiedKeyPair(byte[] ber, int offset, int special, CertJ certJ, CMPCertRequestCommon request, CMPProtectInfo protectInfo) throws CMPException {
            JSAFE_PrivateKey encKey;
            SequenceContainer certifiedKeyPairContainer = new SequenceContainer(special);
            ChoiceContainer certOrEncCertContainer = new ChoiceContainer(0);
            EncodedContainer certificateContainer = new EncodedContainer(0xA03000);
            EncodedContainer encryptedCertContainer = new EncodedContainer(10498049);
            EndContainer certEndContainer = new EndContainer();
            EncodedContainer privateKeyContainer = new EncodedContainer(10563584);
            EncodedContainer publicationInfoContainer = new EncodedContainer(10563585);
            EndContainer keyPairEndContainer = new EndContainer();
            ASN1Container[] def = new ASN1Container[]{certifiedKeyPairContainer, certOrEncCertContainer, certificateContainer, encryptedCertContainer, certEndContainer, privateKeyContainer, publicationInfoContainer, keyPairEndContainer};
            try {
                ASN1.berDecode((byte[])ber, (int)offset, (ASN1Container[])def);
            }
            catch (ASN_Exception e) {
                throw new CMPException("CMPCertResponseCommon$CertifiedKeyPair.CertifiedKeyPair: decoding CertifiedKeyPair failed.", (Exception)((Object)e));
            }
            if (certificateContainer.dataPresent) {
                try {
                    this.certificate = new X509Certificate(certificateContainer.data, certificateContainer.dataOffset, 0xA03000);
                }
                catch (CertificateException e) {
                    throw new CMPException("CMPCertResponseCommon$CertifiedKeyPair.CertifiedKeyPair: decoding X509Certificate failed.", e);
                }
            }
            if (encryptedCertContainer.dataPresent) {
                encKey = this.findEncryptionPrivateKey(request, protectInfo);
                try {
                    this.encryptedCert = new EncryptedValue(certJ, null, encKey);
                    this.encryptedCert.decodeEncryptedValue(encryptedCertContainer.data, encryptedCertContainer.dataOffset, 10498049);
                }
                catch (CRMFException e) {
                    throw new CMPException("CMPCertResponseCommon$CertifiedKeyPair.CertifiedKeyPair: unable to decode EncryptedValue for encryptedCert.", e);
                }
            }
            if (privateKeyContainer.dataPresent) {
                encKey = this.findProtEncKey(request, protectInfo);
                try {
                    this.encryptedCert = new EncryptedValue(certJ, null, encKey);
                    this.encryptedCert.decodeEncryptedValue(encryptedCertContainer.data, encryptedCertContainer.dataOffset, 0xA03000);
                }
                catch (CRMFException e) {
                    throw new CMPException("CMPCertResponseCommon$CertifiedKeyPair.CertifiedKeyPair: unable to decode EncryptedValue for encrypted private key.", e);
                }
            }
            if (publicationInfoContainer.dataPresent) {
                try {
                    Control control = Control.getInstance(publicationInfoContainer.data, publicationInfoContainer.dataOffset, 10563585);
                    if (!(control instanceof PKIPublicationInfo)) {
                        throw new CMPException("CMPCertResponseCommon$CertifiedKeyPair.CertifiedKeyPair: decoded data is not a PKIPublicationInfo object.");
                    }
                    this.publicationInfo = (PKIPublicationInfo)control;
                }
                catch (CRMFException e) {
                    throw new CMPException("CMPCertResponseCommon$CertifiedKeyPair.CertifiedKeyPair: unable to decode PKIPublicationInfo.", e);
                }
            }
        }

        private JSAFE_PrivateKey findEncryptionPrivateKey(CMPCertRequestCommon request, CMPProtectInfo protectInfo) throws CMPException {
            JSAFE_PrivateKey encKey;
            try {
                CertTemplate template = request.getCertTemplate();
                JSAFE_PublicKey publicKey = template.getSubjectPublicKey();
                if (publicKey == null) {
                    throw new CMPException("CMPCertResponseCommon$CertifiedKeyPair.findEncryptionPrivateKey: unable to find public key in CertTemplate.");
                }
                DatabaseService db = protectInfo.getDatabase();
                if (db == null) {
                    throw new CMPException("CMPCertResponseCommon$CertifiedKeyPair.findEncryptionPrivateKey: database in protectinfo is null.");
                }
                encKey = db.selectPrivateKeyByPublicKey(publicKey);
                if (encKey == null) {
                    throw new CMPException("CMPCertResponseCommon$CertifiedKeyPair.findEncryptionPrivateKey: private key for the certificate returned should be provided in protectInfo.");
                }
            }
            catch (CertJException e) {
                throw new CMPException("CMPCertResponseCommon$CertifiedKeyPair.findEncryptionPrivateKey: ", e);
            }
            return encKey;
        }

        private JSAFE_PrivateKey findProtEncKey(CMPCertRequestCommon request, CMPProtectInfo protectInfo) throws CMPException {
            JSAFE_PublicKey encKey;
            Controls controls = request.getControls();
            ProtocolEncryptionKey control = (ProtocolEncryptionKey)controls.getControlByType(5);
            if (control == null) {
                throw new CMPException("CMPCertResponseCommon$CertifiedKeyPair.findProtEncKey: request does not contain ProtEncKey control.");
            }
            try {
                encKey = control.getSubjectPublicKey();
            }
            catch (CRMFException e) {
                throw new CMPException("CMPCertResponseCommon$CertifiedKeyPair.findProtEncKey: unable to extract public key from ProtEncKey control.", e);
            }
            DatabaseService db = protectInfo.getDatabase();
            if (db == null) {
                throw new CMPException("CMPCertResponseCommon$CertifiedKeyPair.findProtEncKey: database in protectinfo is null.");
            }
            try {
                return db.selectPrivateKeyByPublicKey(encKey);
            }
            catch (CertJException e) {
                throw new CMPException("CMPCertResponseCommon$CertifiedKeyPair.findProtEncKey: searching private key failed.", e);
            }
        }

        private Certificate getCertificate() throws CMPException {
            if (this.certificate != null) {
                return this.certificate;
            }
            if (this.encryptedCert == null) {
                return null;
            }
            try {
                return new X509Certificate(this.encryptedCert.getDecryptedValue(), 0, 0);
            }
            catch (CertificateException e) {
                throw new CMPException("CMPCertResponseCommon$CertifiedKeyPair.getCertificate: unable to decode a certificate.");
            }
        }

        private JSAFE_PrivateKey getPrivateKey() throws CMPException {
            if (this.encryptedPrivateKey == null) {
                return null;
            }
            try {
                return this.encryptedPrivateKey.getPrivateKey();
            }
            catch (CRMFException e) {
                throw new CMPException("CMPCertResponseCommon$CertifiedKeyPair.getPrivateKey: unable to get decrypted private key.", e);
            }
        }
    }

    private final class CertResponse {
        private PKIStatusInfo status;
        private CertifiedKeyPair certifiedKeyPair;
        private Properties rspInfo;

        private CertResponse(byte[] ber, int offset, int special, CertJ certJ, CMPCertRequestCommon request, CMPProtectInfo protectInfo) throws CMPException {
            SequenceContainer certResponseContainer = new SequenceContainer(special);
            IntegerContainer certReqIdContainer = new IntegerContainer(0);
            EncodedContainer statusContainer = new EncodedContainer(12288);
            EncodedContainer certifiedKeyPairContainer = new EncodedContainer(77824);
            OctetStringContainer rspInfoContainer = new OctetStringContainer(65536);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] def = new ASN1Container[]{certResponseContainer, certReqIdContainer, statusContainer, certifiedKeyPairContainer, rspInfoContainer, endContainer};
            try {
                ASN1.berDecode((byte[])ber, (int)offset, (ASN1Container[])def);
            }
            catch (ASN_Exception e) {
                throw new CMPException("CMPCertResponseCommon$CertResponse.CertResponse: decoding CertResponse failed.", (Exception)((Object)e));
            }
            try {
                certReqIdContainer.getValueAsInt();
            }
            catch (ASN_Exception e) {
                throw new CMPException("CMPCertResponseCommon$CertResponse.CertResponse: unable to get CertResponse.certReqId as int.", (Exception)((Object)e));
            }
            try {
                this.status = new PKIStatusInfo(statusContainer.data, statusContainer.dataOffset, 0);
            }
            catch (PKIException e) {
                throw new CMPException("CMPCertResponseCommon$CertResponse.CertResponse: unable to instantiate PKIStatusInfo.", e);
            }
            if (certifiedKeyPairContainer.dataPresent) {
                this.certifiedKeyPair = new CertifiedKeyPair(certifiedKeyPairContainer.data, certifiedKeyPairContainer.dataOffset, 65536, certJ, request, protectInfo);
            }
            if (rspInfoContainer.dataPresent && rspInfoContainer.dataLen != 0) {
                this.rspInfo = this.stringToProperties(new String(rspInfoContainer.data, rspInfoContainer.dataOffset, rspInfoContainer.dataLen));
            }
        }

        private Properties stringToProperties(String string) throws CMPException {
            Properties properties = new Properties();
            StringTokenizer tokens = new StringTokenizer(string, "%");
            while (tokens.hasMoreTokens()) {
                String nextPair = tokens.nextToken();
                StringTokenizer pair = new StringTokenizer(nextPair, "?");
                if (!pair.hasMoreTokens()) {
                    throw new CMPException("CMPCertResponseCommon$CertResponse.CertResponse: ill-formed rspInfo (? char not found).");
                }
                String type = pair.nextToken();
                if (!pair.hasMoreTokens()) {
                    throw new CMPException("CMPCertResponseCommon$CertResponse.CertResponse: ill-formed rspInfo (nothing follows ? char).");
                }
                String value = pair.nextToken();
                try {
                    properties.put(this.urlDecode(type), this.urlDecode(value));
                }
                catch (Exception e) {
                    throw new CMPException("CMPCertResponseCommon$CertResponse.CertResponse: Properties.put failed.", e);
                }
            }
            return properties;
        }

        private String urlDecode(String string) throws UnsupportedEncodingException {
            return URLDecoder.decode(string, "Cp1252");
        }
    }

    private final class CertRepMessage {
        private Certificate[] caPubs;
        private CertResponse[] response;

        private CertRepMessage(byte[] ber, int offset, int special, CertJ certJ, CMPCertRequestCommon request, CMPProtectInfo protectInfo) throws CMPException {
            ASN1Container container;
            OfContainer responseContainer;
            OfContainer caPubsContainer;
            try {
                SequenceContainer certReqMessageContainer = new SequenceContainer(special);
                caPubsContainer = new OfContainer(0xA10001, 12288, (ASN1Container)new EncodedContainer(12288));
                responseContainer = new OfContainer(0, 12288, (ASN1Container)new EncodedContainer(12288));
                EndContainer endContainer = new EndContainer();
                ASN1Container[] def = new ASN1Container[]{certReqMessageContainer, caPubsContainer, responseContainer, endContainer};
                ASN1.berDecode((byte[])ber, (int)offset, (ASN1Container[])def);
            }
            catch (ASN_Exception e) {
                throw new CMPException("CMPCertResponseCommon$CertRepMessage.CertRepMessage: decoding CertRepMessage failed.", (Exception)((Object)e));
            }
            if (caPubsContainer.dataPresent) {
                int count = caPubsContainer.getContainerCount();
                this.caPubs = new Certificate[count];
                for (int i = 0; i < count; ++i) {
                    try {
                        container = caPubsContainer.containerAt(i);
                        this.caPubs[i] = new X509Certificate(container.data, container.dataOffset, 0);
                        continue;
                    }
                    catch (ASN_Exception e) {
                        throw new CMPException("CMPCertResponseCommon$CertRepMessage.CertRepMessage: unable to obtain component of caPubs.", (Exception)((Object)e));
                    }
                    catch (CertificateException e) {
                        throw new CMPException("CMPCertResponseCommon$CertRepMessage.CertRepMessage: unable to decode a certificate.", e);
                    }
                }
            }
            int count = responseContainer.getContainerCount();
            this.response = new CertResponse[count];
            for (int i = 0; i < count; ++i) {
                try {
                    container = responseContainer.containerAt(i);
                    this.response[i] = new CertResponse(container.data, container.dataOffset, 0, certJ, request, protectInfo);
                    continue;
                }
                catch (ASN_Exception e) {
                    throw new CMPException("CMPCertResponseCommon$CertRepMessage.CertRepMessage: unable to obtain component of response.", (Exception)((Object)e));
                }
            }
        }
    }
}

