/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki.cmp;

import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.cert.AttributeValueAssertion;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.crmf.CertTemplate;
import com.rsa.certj.provider.pki.cmp.CMP;
import com.rsa.certj.provider.pki.cmp.CMPCertConfirmMessage;
import com.rsa.certj.provider.pki.cmp.CMPCertRequestCommon;
import com.rsa.certj.provider.pki.cmp.CMPException;
import com.rsa.certj.provider.pki.cmp.CMPProtectInfo;
import com.rsa.certj.provider.pki.cmp.CMPRequestCommon;
import com.rsa.certj.provider.pki.cmp.CMPResponseCommon;
import com.rsa.certj.spi.pki.PKIMessage;
import com.rsa.certj.spi.pki.PKIResponseMessage;
import com.rsa.certj.spi.pki.ProtectInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public final class CMPDebug
extends CMP {
    private File messageStore;
    private String requestCN;
    private static final String UNKNOWN = "unknown";

    public CMPDebug(String name, File configFile, File messageStore) throws InvalidParameterException {
        super(name, configFile);
        this.messageStore = messageStore;
    }

    public void saveMessage(byte[] messageBytes, PKIMessage message, ProtectInfo protectInfo) throws CMPException {
        String cn;
        int type;
        if (messageBytes == null) {
            return;
        }
        if (message instanceof CMPRequestCommon) {
            type = ((CMPRequestCommon)message).getMessageType();
            cn = protectInfo == null ? UNKNOWN : this.getCN((CMPRequestCommon)message, (CMPProtectInfo)protectInfo);
            this.requestCN = cn;
        } else if (message instanceof CMPResponseCommon) {
            type = ((CMPResponseCommon)message).getMessageType();
            cn = this.requestCN;
        } else {
            throw new CMPException("CMPDebug.saveMessage: message should be an instance of either CMPRequestCommon or CMPResponseCommon.");
        }
        this.writeDataToFile(messageBytes, this.getOutputFileName(cn, type));
    }

    public void saveCertificate(PKIResponseMessage response) throws CMPException {
        if (response == null) {
            return;
        }
        Certificate cert = response.getCertificate();
        if (cert == null) {
            return;
        }
        byte[] der = new byte[((X509Certificate)cert).getDERLen(0)];
        try {
            ((X509Certificate)cert).getDEREncoding(der, 0, 0);
        }
        catch (CertificateException e) {
            // empty catch block
        }
        int index = 0;
        String cn = this.getCN((X509Certificate)cert);
        File file = new File(this.messageStore, cn + "." + index + ".cer");
        while (file.exists()) {
            file = new File(this.messageStore, cn + "." + ++index + ".cer");
        }
        this.writeDataToFile(der, file);
    }

    public void saveData(byte[] data, String fileName) throws CMPException {
        if (data == null) {
            return;
        }
        if (fileName == null) {
            throw new CMPException("CMPDebug.saveData: fileName should not be null.");
        }
        this.writeDataToFile(data, new File(this.messageStore, fileName));
    }

    private String messageTypeString(int msgType) {
        switch (msgType) {
            case 0: {
                return "ir";
            }
            case 1: {
                return "ip";
            }
            case 2: {
                return "cr";
            }
            case 3: {
                return "cp";
            }
            case 11: {
                return "rr";
            }
            case 12: {
                return "rp";
            }
            case 24: {
                return "certconf";
            }
            case 19: {
                return "pkiconf";
            }
            case 23: {
                return "error";
            }
        }
        return UNKNOWN;
    }

    private int messageStartIndex(int msgType) {
        switch (msgType) {
            case 0: 
            case 1: {
                return -1;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: {
                return 1;
            }
        }
        return 0;
    }

    private File getOutputFileName(String filename, int type) {
        String typeString = this.messageTypeString(type);
        int index = this.messageStartIndex(type);
        if (index < 0) {
            return new File(this.messageStore, filename + "." + typeString + ".ber");
        }
        File file = new File(this.messageStore, filename + "." + typeString + index + ".ber");
        while (file.exists()) {
            file = new File(this.messageStore, filename + "." + typeString + ++index + ".ber");
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDataToFile(byte[] data, File file) {
        FileOutputStream fileOut = null;
        try {
            fileOut = new FileOutputStream(file);
            fileOut.write(data);
        }
        catch (IOException e) {
        }
        finally {
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private String getCN(CMPRequestCommon request, CMPProtectInfo protectInfo) {
        switch (request.getMessageType()) {
            case 0: {
                CertTemplate template = ((CMPCertRequestCommon)request).getCertTemplate();
                return this.getCN(template.getSubjectName());
            }
            case 2: 
            case 11: {
                return this.getCN(protectInfo.getSenderCert());
            }
            case 24: {
                X509Certificate cert = (X509Certificate)((CMPCertConfirmMessage)request).getCertificateReturned();
                if (cert != null) {
                    return this.getCN(cert);
                }
                if (!protectInfo.pbmProtected()) {
                    return this.getCN(protectInfo.getSenderCert());
                }
                return UNKNOWN;
            }
        }
        return UNKNOWN;
    }

    private String getCN(X509Certificate cert) {
        if (cert == null) {
            return UNKNOWN;
        }
        return this.getCN(cert.getSubjectName());
    }

    private String getCN(X500Name name) {
        if (name == null) {
            return UNKNOWN;
        }
        AttributeValueAssertion ava = name.getAttribute(0);
        if (ava == null) {
            return UNKNOWN;
        }
        try {
            return ava.getStringAttribute();
        }
        catch (NameException e) {
            return UNKNOWN;
        }
    }
}

