/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki.cmp;

import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.provider.pki.cmp.CMPException;
import com.rsa.certj.provider.pki.cmp.CMPPOPGenerationInfo;

public final class CMPPOPGenerationInfoSignature
extends CMPPOPGenerationInfo {
    private static final int AUTH_BY_SENDER_NAME = 0;
    private static final int AUTH_BY_PBM = 1;
    private static final int DEFAULT_PBM_ITERATION_COUNT = 1024;
    private int type;
    private String signatureAlgorithm;
    private GeneralName sender;
    private char[] sharedSecret;
    private byte[] salt;
    private int iterationCount;

    boolean authBySenderName() {
        return this.type == 0;
    }

    boolean authByPBM() {
        return this.type == 1;
    }

    private CMPPOPGenerationInfoSignature(String signatureAlgorithm) throws InvalidParameterException {
        super(1);
        if (signatureAlgorithm == null) {
            throw new InvalidParameterException("CMPPOPGenerationInfoSignature.CMPPOPGenerationInfoSignature:signatureAlgorithm should not be null.");
        }
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public CMPPOPGenerationInfoSignature(String signatureAlgorithm, GeneralName sender) throws InvalidParameterException {
        this(signatureAlgorithm);
        if (sender == null) {
            throw new InvalidParameterException("CMPPOPGenerationInfoSignature.CMPPOPGenerationInfoSignature: sender should not be null.");
        }
        this.type = 0;
        this.sender = sender;
    }

    public CMPPOPGenerationInfoSignature(String signatureAlgorithm, char[] sharedSecret, byte[] salt, int iterationCount) throws InvalidParameterException {
        this(signatureAlgorithm);
        if (sharedSecret == null || salt == null) {
            throw new InvalidParameterException("CMPPOPGenerationInfoSignature.CMPPOPGenerationInfoSignature: none of algorithm, sharedSecret and salt should be null.");
        }
        if (iterationCount <= 0) {
            iterationCount = 1024;
        }
        this.type = 1;
        this.sharedSecret = sharedSecret;
        this.salt = salt;
        this.iterationCount = iterationCount;
    }

    String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    GeneralName getSender() throws CMPException {
        if (this.type != 0) {
            throw new CMPException("CMPPOPGenerationInfoSignature.getSignatureAlgorithm: this object represents information for a pop using PBM.");
        }
        return this.sender;
    }

    char[] getSharedSecret() throws CMPException {
        if (this.type != 1) {
            throw new CMPException("CMPPOPGenerationInfoSignature.getSignatureAlgorithm: this object represents information for a pop using an already authenticated sender name.");
        }
        return this.sharedSecret;
    }

    byte[] getSalt() throws CMPException {
        if (this.type != 1) {
            throw new CMPException("CMPPOPGenerationInfoSignature.getSignatureAlgorithm: this object represents information for a pop using an already authenticated sender name.");
        }
        return this.salt;
    }

    int getIterationCount() throws CMPException {
        if (this.type != 1) {
            throw new CMPException("CMPPOPGenerationInfoSignature.getSignatureAlgorithm: this object represents information for a pop using an already authenticated sender name.");
        }
        return this.iterationCount;
    }
}

