/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki.cmp;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJException;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.certj.provider.pki.cmp.CMP;
import com.rsa.certj.provider.pki.cmp.CMPException;
import com.rsa.certj.provider.pki.cmp.CMPProtectInfo;
import com.rsa.certj.provider.pki.cmp.PKIHeader;
import com.rsa.certj.provider.pki.cmp.TypeAndValue;
import com.rsa.certj.spi.pki.PKIRequestMessage;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_MAC;
import com.rsa.jsafe.JSAFE_MessageDigest;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_Signature;
import java.security.SecureRandom;
import java.util.StringTokenizer;

abstract class CMPRequestCommon
extends PKIRequestMessage {
    private static final int SALT_LEN = 20;
    private static final int PBHMAC_ITERATIONS = 1024;
    private static final byte[] HMAC_SHA1_OID = new byte[]{43, 6, 1, 5, 5, 8, 1, 2};
    private byte[] recipNonce;
    private TypeAndValue[] generalInfo;
    private int messageType;

    protected CMPRequestCommon(int messageType, byte[] recipNonce) {
        this(messageType, recipNonce, null, null);
    }

    protected CMPRequestCommon(int messageType, byte[] recipNonce, String[] freeText, TypeAndValue[] generalInfo) {
        super(null, null, false);
        this.messageType = messageType;
        this.recipNonce = recipNonce;
        this.generalInfo = generalInfo;
        this.setFreeText(freeText);
    }

    protected int getMessageType() {
        return this.messageType;
    }

    protected byte[] getRecipNonce() {
        return this.recipNonce;
    }

    protected TypeAndValue[] getGeneralInfo() {
        return this.generalInfo;
    }

    protected void setRecipNonce(byte[] recipNonce) {
        this.recipNonce = recipNonce;
    }

    protected byte[] derEncodeBody(CertJ certJ) throws CMPException {
        throw new CMPException("CMPRequestCommon.derEncode: this method should be overwritten by sublclasses.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] derEncode(CMPProtectInfo protectInfo, CertJ certJ) throws CMPException {
        JSAFE_SecureRandom random;
        try {
            random = certJ.getRandomObject();
        }
        catch (CertJException e) {
            throw new CMPException("CMPRequestCommon.writeMessage: unable to get a registered random service.", e);
        }
        byte[] protectionAlgDER = null;
        byte[] protectionSalt = null;
        int protectionIterationCount = -1;
        byte[] bodyDER = this.derEncodeBody(certJ);
        if (protectInfo != null) {
            if (protectInfo.pbmProtected()) {
                String protectionAlg = protectInfo.getAlgorithm();
                if (!protectionAlg.startsWith("PBE/HMAC/SHA1")) throw new CMPException("CMPRequestCommon.writeMessage: PBM MAC algorithm specified by " + protectionAlg + " is not supported.");
                protectionSalt = random.generateRandomBytes(20);
                StringTokenizer tokens = new StringTokenizer(protectionAlg, "-");
                if (tokens.hasMoreTokens()) {
                    tokens.nextToken();
                    if (tokens.hasMoreTokens()) {
                        protectionIterationCount = Integer.parseInt(tokens.nextToken());
                    }
                }
                if (protectionIterationCount <= 0) {
                    protectionIterationCount = 1024;
                }
                protectionAlgDER = this.derEncodePBMAlg(protectionSalt, protectionIterationCount, certJ);
            } else {
                protectionAlgDER = this.derEncodeSignatureAlg(protectInfo.getAlgorithm(), certJ);
            }
        }
        byte[] headerDER = new PKIHeader(this, protectInfo, protectionAlgDER, random).derEncode();
        byte[] protectedPart = CMP.derEncodeProtectedPart(headerDER, 0, headerDER.length, bodyDER, 0, bodyDER.length);
        byte[] protectionBits = null;
        if (protectInfo == null) return this.derEncodePKIMessage(headerDER, bodyDER, protectionBits, this.getExtraCerts());
        protectionBits = protectInfo.pbmProtected() ? this.computeProtection(protectedPart, protectInfo, protectionSalt, certJ) : this.computeProtection(protectedPart, protectInfo, random, certJ);
        return this.derEncodePKIMessage(headerDER, bodyDER, protectionBits, this.getExtraCerts());
    }

    private byte[] computeProtection(byte[] protectedPart, CMPProtectInfo protectInfo, JSAFE_SecureRandom random, CertJ certJ) throws CMPException {
        JSAFE_PrivateKey privateKey;
        DatabaseService db = protectInfo.getDatabase();
        X509Certificate signerCert = protectInfo.getSenderCert();
        try {
            privateKey = db.selectPrivateKeyByCertificate(signerCert);
        }
        catch (CertJException e) {
            throw new CMPException("CMPRequestCommon.computeProtection: unable to find a signer private key in the database.", e);
        }
        if (privateKey == null) {
            throw new CMPException("CMPRequestCommon.computeProtection: unable to find a signer private key in the database.");
        }
        String algorithm = protectInfo.getAlgorithm();
        try {
            JSAFE_Signature signer = JSAFEFactory.getSignature(algorithm, certJ.getDevice(), certJ);
            signer.signInit(privateKey, null, (SecureRandom)random, certJ.getPKCS11Sessions());
            signer.signUpdate(protectedPart, 0, protectedPart.length);
            byte[] byArray = signer.signFinal();
            return byArray;
        }
        catch (JSAFE_Exception e) {
            throw new CMPException("CMPRequestCommon.createSignatureProtectionDER: unable to generate a signature for " + algorithm + ".", (Exception)((Object)e));
        }
        finally {
            privateKey.clearSensitiveData();
        }
    }

    private byte[] computeProtection(byte[] protectedPart, CMPProtectInfo protectInfo, byte[] salt, CertJ certJ) throws CMPException {
        JSAFE_MAC macObject = null;
        try {
            macObject = JSAFEFactory.getMAC(protectInfo.getAlgorithm(), certJ.getDevice(), certJ);
            macObject.setSalt(salt, 0, salt.length);
            JSAFE_SecretKey macKey = macObject.getBlankKey();
            char[] sharedSecret = protectInfo.getSharedSecret();
            macKey.setPassword(sharedSecret, 0, sharedSecret.length);
            macObject.macInit(macKey, null);
            macObject.macUpdate(protectedPart, 0, protectedPart.length);
            byte[] byArray = macObject.macFinal();
            return byArray;
        }
        catch (JSAFE_Exception e) {
            throw new CMPException("CMPRequestCommon.createPBMProtection: unable to compute PBM.", (Exception)((Object)e));
        }
        finally {
            if (macObject != null) {
                macObject.clearSensitiveData();
            }
        }
    }

    private byte[] derEncodePKIMessage(byte[] headerDER, byte[] bodyDER, byte[] protectionBits, Certificate[] extraCerts) throws CMPException {
        try {
            ASN1Container extraCertsContainer = this.createExtraCertsContainer(extraCerts);
            SequenceContainer pkiMessageContainer = new SequenceContainer(0, true, 0);
            EncodedContainer headerContainer = new EncodedContainer(0, true, 0, headerDER, 0, headerDER.length);
            EncodedContainer bodyContainer = new EncodedContainer(0, true, 0, bodyDER, 0, bodyDER.length);
            BitStringContainer protectionContainer = protectionBits == null ? new BitStringContainer(0xA10000, false, 0, 0, 0, false) : new BitStringContainer(0xA10000, true, 0, protectionBits, 0, protectionBits.length, protectionBits.length * 8, false);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] def = new ASN1Container[]{pkiMessageContainer, headerContainer, bodyContainer, protectionContainer, extraCertsContainer, endContainer};
            ASN1Template template = new ASN1Template(def);
            byte[] messageDER = new byte[template.derEncodeInit()];
            template.derEncode(messageDER, 0);
            return messageDER;
        }
        catch (ASN_Exception e) {
            throw new CMPException("CMPRequestCommon.derEncodePKIMessage: Encoding CMP message failed.", (Exception)((Object)e));
        }
    }

    private ASN1Container createExtraCertsContainer(Certificate[] extraCerts) throws CMPException, ASN_Exception {
        if (extraCerts == null) {
            return new EncodedContainer(0xA10001, false, 0, null, 0, 0);
        }
        OfContainer extraCertsContainer = new OfContainer(0xA10001, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
        for (int i = 0; i < extraCerts.length; ++i) {
            byte[] certDER;
            Certificate cert = extraCerts[i];
            if (!(cert instanceof X509Certificate)) {
                throw new CMPException("CMPRequestCommon.createExtraCertsContainer:certificate in extraCerts should be an instance of X509Certificate.");
            }
            try {
                certDER = new byte[((X509Certificate)cert).getDERLen(0)];
                ((X509Certificate)cert).getDEREncoding(certDER, 0, 0);
            }
            catch (CertificateException e) {
                throw new CMPException("CMPRequestCommon.createExtraCertsContainer: Encoding a certificate failed.", e);
            }
            try {
                extraCertsContainer.addContainer((ASN1Container)new EncodedContainer(0, true, 0, certDER, 0, certDER.length));
                continue;
            }
            catch (ASN_Exception e) {
                throw new CMPException("CMPRequestCommon.createExtraCertsContainer: unable to add an element of extraCerts.", (Exception)((Object)e));
            }
        }
        return extraCertsContainer;
    }

    private byte[] derEncodePBMAlg(byte[] saltData, int iterationCount, CertJ certJ) throws CMPException {
        byte[] paramDER = this.derEncodePBMParameter(saltData, iterationCount, certJ);
        try {
            SequenceContainer algorithmIdentifierContainer = new SequenceContainer(0xA10001, true, 0);
            OIDContainer algorithmIdContainer = new OIDContainer(0x1000000, true, 0, CMP.PASSWORD_BASED_MAC_OID, 0, CMP.PASSWORD_BASED_MAC_OID.length);
            EncodedContainer algorithmParamContainer = new EncodedContainer(77824, true, 0, paramDER, 0, paramDER.length);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] def = new ASN1Container[]{algorithmIdentifierContainer, algorithmIdContainer, algorithmParamContainer, endContainer};
            ASN1Template template = new ASN1Template(def);
            byte[] algorithmIdentifierDER = new byte[template.derEncodeInit()];
            template.derEncode(algorithmIdentifierDER, 0);
            return algorithmIdentifierDER;
        }
        catch (ASN_Exception e) {
            throw new CMPException("CMPRequestCommon.encodePBMAlgorithmIdentifier: unable to encodeEncoding PBMAlgorithmIdentifier.", (Exception)((Object)e));
        }
    }

    private byte[] derEncodeSignatureAlg(String algorithm, CertJ certJ) throws CMPException {
        byte[] algDer;
        try {
            algDer = JSAFEFactory.getSignature(algorithm, certJ.getDevice(), certJ).getDERAlgorithmID();
        }
        catch (JSAFE_Exception e) {
            throw new CMPException("CMPRequestCommon.derEncodeSignatureAlgorithm: unable to get algorithm identifier for " + algorithm + ".", (Exception)((Object)e));
        }
        try {
            SequenceContainer seq = new SequenceContainer(0x800001, true, 0);
            EncodedContainer alg = new EncodedContainer(0, true, 0, algDer, 0, algDer.length);
            EndContainer end = new EndContainer();
            ASN1Container[] def = new ASN1Container[]{seq, alg, end};
            ASN1Template template = new ASN1Template(def);
            byte[] der = new byte[template.derEncodeInit()];
            template.derEncode(der, 0);
            return der;
        }
        catch (ASN_Exception e) {
            throw new CMPException("CMPRequestCommon.derEncodeSignatureAlgorithm: unable to encode signature algorithm.", (Exception)((Object)e));
        }
    }

    private byte[] derEncodePBMParameter(byte[] saltData, int iterations, CertJ certJ) throws CMPException {
        JSAFE_MAC macObj;
        JSAFE_MessageDigest digestObj;
        String device = certJ.getDevice();
        try {
            digestObj = JSAFEFactory.getDigest("SHA1", device, certJ);
        }
        catch (JSAFE_Exception e) {
            throw new CMPException("CMPRequestCommon.derEncodePBMParameter.", (Exception)((Object)e));
        }
        byte[] digestAlgDER = digestObj.getDERAlgorithmID();
        try {
            macObj = JSAFEFactory.getMAC("HMAC/SHA1", device, certJ);
        }
        catch (JSAFE_Exception e) {
            throw new CMPException("CMPRequestCommon.derEncodePBMParameter.", (Exception)((Object)e));
        }
        byte[] macAlgDER = this.getMACAlgorithmID(macObj);
        try {
            SequenceContainer pbmParameterContainer = new SequenceContainer(0, true, 0);
            OctetStringContainer saltContainer = new OctetStringContainer(0, true, 0, saltData, 0, saltData.length);
            EncodedContainer owfContainer = new EncodedContainer(12288, true, 0, digestAlgDER, 0, digestAlgDER.length);
            IntegerContainer iterationCountContainer = new IntegerContainer(0, true, 0, iterations);
            EncodedContainer macContainer = new EncodedContainer(12288, true, 0, macAlgDER, 0, macAlgDER.length);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] def = new ASN1Container[]{pbmParameterContainer, saltContainer, owfContainer, iterationCountContainer, macContainer, endContainer};
            ASN1Template template = new ASN1Template(def);
            byte[] pbmParameterDER = new byte[template.derEncodeInit()];
            template.derEncode(pbmParameterDER, 0);
            return pbmParameterDER;
        }
        catch (ASN_Exception e) {
            throw new CMPException("CMPRequestCommon.derEncodePBMParameter: Encoding PBMParameter failed.", (Exception)((Object)e));
        }
    }

    private byte[] getMACAlgorithmID(JSAFE_MAC macObj) throws CMPException {
        String macAlg = macObj.getMACAlgorithm();
        String digestAlg = macObj.getDigestAlgorithm();
        if (!macObj.getMACAlgorithm().equals("HMAC") || !macObj.getDigestAlgorithm().equals("SHA1")) {
            throw new CMPException("CMPRequestCommon.getMACAlgorithmID: algorithm(" + macAlg + "/" + digestAlg + ") not supported.  Use HMAC/SHA1.");
        }
        try {
            SequenceContainer algorithmIdentifierContainer = new SequenceContainer(0, true, 0);
            OIDContainer algorithmIdContainer = new OIDContainer(0x1000000, true, 0, HMAC_SHA1_OID, 0, HMAC_SHA1_OID.length);
            EncodedContainer algorithmParamContainer = new EncodedContainer(77824, false, 5, null, 0, 0);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] def = new ASN1Container[]{algorithmIdentifierContainer, algorithmIdContainer, algorithmParamContainer, endContainer};
            ASN1Template template = new ASN1Template(def);
            byte[] algorithmIdentifierDER = new byte[template.derEncodeInit()];
            template.derEncode(algorithmIdentifierDER, 0);
            return algorithmIdentifierDER;
        }
        catch (ASN_Exception e) {
            throw new CMPException("CMPRequestCommon.getMACAlgorithmID: Encoding MAC Algorithm Identifier failed.", (Exception)((Object)e));
        }
    }
}

