/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki.cmp;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.cert.CRLEntryExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.X509V3Extension;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.CertTemplate;
import com.rsa.certj.provider.pki.cmp.CMPException;
import com.rsa.certj.provider.pki.cmp.CMPRequestCommon;
import com.rsa.jsafe.JSAFE_PublicKey;

public final class CMPRevokeRequestMessage
extends CMPRequestCommon {
    private final X509Certificate[] certsToBeRevoked;
    private X509V3Extensions[] crlEntryExtensionsList;

    public CMPRevokeRequestMessage(X509Certificate[] certsToBeRevoked, X509V3Extensions[] crlEntryExtensionsList) throws InvalidParameterException {
        super(11, null);
        int i;
        if (certsToBeRevoked == null || certsToBeRevoked.length == 0) {
            throw new InvalidParameterException("CMPRevokeRequestMessage.CMPRevokeRequestMessage: certsToBeRevoked should not be empty.");
        }
        int count = certsToBeRevoked.length;
        if (crlEntryExtensionsList != null && count != crlEntryExtensionsList.length) {
            throw new InvalidParameterException("CMPRevokeRequestMessage.CMPRevokeRequestMessage: certsToBeRevoked and crlEntryExtensionsList should have the same number of elements.");
        }
        for (i = 0; i < count; ++i) {
            if (certsToBeRevoked[i] != null) continue;
            throw new InvalidParameterException("CMPRevokeRequestMessage.CMPRevokeRequestMessage: An element of certsToBeRevoked should not be null.");
        }
        if (crlEntryExtensionsList != null) {
            for (i = 0; i < count; ++i) {
                X509V3Extensions extensions = crlEntryExtensionsList[i];
                if (extensions == null) continue;
                this.checkCRLEntryExtensions(extensions);
            }
        }
        this.certsToBeRevoked = certsToBeRevoked;
        this.crlEntryExtensionsList = crlEntryExtensionsList;
    }

    public CMPRevokeRequestMessage(X509Certificate certToBeRevoked, X509V3Extensions crlEntryExtensions) throws InvalidParameterException {
        super(11, null, null, null);
        if (certToBeRevoked == null) {
            throw new InvalidParameterException("CMPRevokeRequestMessage.CMPRevokeRequestMessage: certToBeRevoked should not be null.");
        }
        this.certsToBeRevoked = new X509Certificate[1];
        this.certsToBeRevoked[0] = certToBeRevoked;
        if (crlEntryExtensions != null) {
            this.checkCRLEntryExtensions(crlEntryExtensions);
            this.crlEntryExtensionsList = new X509V3Extensions[1];
            this.crlEntryExtensionsList[0] = crlEntryExtensions;
        }
    }

    private void checkCRLEntryExtensions(X509V3Extensions extensions) throws InvalidParameterException {
        if (extensions.getExtensionsType() != 3) {
            throw new InvalidParameterException("CMPRevokeRequestMessage.checkCRLEntryExtensions: extensions should be of type X509V3Extensions.X509_EXT_TYPE_CRL_ENTRY.");
        }
        for (int i = 0; i < extensions.getExtensionCount(); ++i) {
            try {
                X509V3Extension extension = extensions.getExtensionByIndex(i);
                if (extension instanceof CRLEntryExtension) continue;
                throw new InvalidParameterException("CMPRevokeRequestMessage.checkCRLEntryExtensions: extensions should consists of CRLEntryExtension.");
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
    }

    protected byte[] derEncodeBody(CertJ certJ) throws CMPException {
        try {
            int special = 0xA00000 | this.getMessageType();
            OfContainer revReqContentContainer = new OfContainer(special, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
            for (int i = 0; i < this.certsToBeRevoked.length; ++i) {
                EncodedContainer extensionsContainer;
                byte[] templateDER;
                X509Certificate certToBeRevoked = this.certsToBeRevoked[i];
                X509V3Extensions extensions = null;
                if (this.crlEntryExtensionsList != null) {
                    extensions = this.crlEntryExtensionsList[i];
                }
                CertTemplate certTemplate = this.certToTemplate(certToBeRevoked, certJ);
                try {
                    templateDER = new byte[certTemplate.getDERLen(0)];
                    certTemplate.getDEREncoding(templateDER, 0, 0);
                }
                catch (CRMFException e) {
                    throw new CMPException("CMPRevokeRequestMessage.derEncode: unable to encode certDetails.", e);
                }
                EncodedContainer templateContainer = new EncodedContainer(0, true, 0, templateDER, 0, templateDER.length);
                if (extensions == null) {
                    extensionsContainer = new EncodedContainer(65536, false, 0, null, 0, 0);
                } else {
                    byte[] extensionsDER = new byte[extensions.getDERLen(0)];
                    extensions.getDEREncoding(extensionsDER, 0, 0);
                    extensionsContainer = new EncodedContainer(65536, true, 0, extensionsDER, 0, extensionsDER.length);
                }
                ASN1Container[] def = new ASN1Container[]{new SequenceContainer(0, true, 0), templateContainer, extensionsContainer, new EndContainer()};
                ASN1Template template = new ASN1Template(def);
                try {
                    byte[] der = new byte[template.derEncodeInit()];
                    template.derEncode(der, 0);
                    revReqContentContainer.addContainer((ASN1Container)new EncodedContainer(0, true, 0, der, 0, der.length));
                    continue;
                }
                catch (ASN_Exception e) {
                    throw new CMPException("CMPRevokeRequestMessage.derEncode: encoding RevDetails failed.", (Exception)((Object)e));
                }
            }
            ASN1Container[] def = new ASN1Container[]{revReqContentContainer};
            ASN1Template template = new ASN1Template(def);
            byte[] der = new byte[template.derEncodeInit()];
            template.derEncode(der, 0);
            return der;
        }
        catch (ASN_Exception e) {
            throw new CMPException("CMPRevokeRequestMessage.derEncode: encoding RevDetails failed.", (Exception)((Object)e));
        }
    }

    private CertTemplate certToTemplate(X509Certificate cert, CertJ certJ) throws CMPException {
        try {
            JSAFE_PublicKey publicKey;
            CertTemplate template = new CertTemplate();
            byte[] serialNumber = cert.getSerialNumber();
            template.setSerialNumber(serialNumber, 0, serialNumber.length);
            X500Name name = cert.getIssuerName();
            if (name != null) {
                template.setIssuerName(name);
            }
            if ((name = cert.getSubjectName()) != null) {
                template.setSubjectName(name);
            }
            if ((publicKey = cert.getSubjectPublicKey(certJ.getDevice())) != null) {
                template.setSubjectPublicKey(publicKey);
            }
            return template;
        }
        catch (CRMFException e) {
            throw new CMPException("CMPRevokeRequestMessage.certToTemplate: unable to convert X509Certificate to CertTemplate.", e);
        }
        catch (CertificateException e) {
            throw new CMPException("CMPRevokeRequestMessage.certToTemplate: unable to set public key of X509Certificate.", e);
        }
    }
}

