/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki.cmp;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.OldCertID;
import com.rsa.certj.provider.pki.cmp.CMPException;
import com.rsa.certj.provider.pki.cmp.CMPResponseCommon;
import com.rsa.certj.provider.pki.cmp.PKIHeader;
import com.rsa.certj.spi.pki.PKIException;
import com.rsa.certj.spi.pki.PKIStatusInfo;
import java.util.Vector;

public final class CMPRevokeResponseMessage
extends CMPResponseCommon {
    private Vector<PKIStatusInfo> statusArray = new Vector();
    private Vector<OldCertID> certIdArray = new Vector();
    private X509CRL[] crls;

    private CMPRevokeResponseMessage(PKIHeader header) {
        super(12, header, null);
    }

    static CMPRevokeResponseMessage berDecodeBody(PKIHeader header, byte[] body, int bodyOffset) throws CMPException {
        CMPRevokeResponseMessage rp = new CMPRevokeResponseMessage(header);
        rp.berDecode(body, bodyOffset, 10551308);
        return rp;
    }

    public X509CRL[] getCRLs() {
        return this.crls;
    }

    public int getStatusCount() {
        return this.statusArray.size();
    }

    public PKIStatusInfo getStatusAt(int index) throws CMPException {
        if (index >= this.statusArray.size()) {
            throw new CMPException("CMPrevokeResponseMessage.getStatusAt: index out of range.");
        }
        return this.statusArray.elementAt(index);
    }

    public OldCertID getCertIdAt(int index) throws CMPException {
        if (index >= this.statusArray.size()) {
            throw new CMPException("CMPrevokeResponseMessage.getCertIdAt: index out of range.");
        }
        return this.certIdArray.elementAt(index);
    }

    private void berDecode(byte[] ber, int offset, int special) throws CMPException {
        OfContainer crlsContainer;
        OfContainer revCertsContainer;
        OfContainer statusContainer;
        try {
            statusContainer = new OfContainer(0, 12288, (ASN1Container)new EncodedContainer(12288));
            revCertsContainer = new OfContainer(0xA10000, 12288, (ASN1Container)new EncodedContainer(12288));
            crlsContainer = new OfContainer(0xA10001, 12288, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] def = new ASN1Container[]{new SequenceContainer(special), statusContainer, revCertsContainer, crlsContainer, new EndContainer()};
            ASN1.berDecode((byte[])ber, (int)offset, (ASN1Container[])def);
        }
        catch (ASN_Exception e) {
            throw new CMPException("CMPRevokeResponseMessage.berDecode: decoding RevRepContent failed.", (Exception)((Object)e));
        }
        int statusCount = statusContainer.getContainerCount();
        int revCertsCount = 0;
        if (revCertsContainer.dataPresent) {
            revCertsCount = revCertsContainer.getContainerCount();
        }
        if (revCertsCount != 0 && statusCount < revCertsCount) {
            throw new CMPException("CMPRevokeResponseMessage.berDecode: more revCerts items than stauts items in RevRepContent.");
        }
        for (int i = 0; i < statusCount; ++i) {
            PKIStatusInfo statusInfo;
            ASN1Container statusInfoContainer;
            ASN1Container certIdContainer = null;
            try {
                statusInfoContainer = statusContainer.containerAt(i);
                if (revCertsContainer.dataPresent && i < revCertsCount) {
                    certIdContainer = revCertsContainer.containerAt(i);
                }
            }
            catch (ASN_Exception e) {
                throw new CMPException("CMPRevokeResponseMessage.berDecode: unable to extract OfContainer component.", (Exception)((Object)e));
            }
            try {
                statusInfo = new PKIStatusInfo(statusInfoContainer.data, statusInfoContainer.dataOffset, 0);
            }
            catch (PKIException e) {
                throw new CMPException("CMPRevokeResponseMessage.berDecode: unable to instantiate PKIStatusInfo.", e);
            }
            OldCertID certId = null;
            if (certIdContainer != null) {
                try {
                    certId = new OldCertID();
                    certId.decodeValue(certIdContainer.data, certIdContainer.dataOffset);
                }
                catch (CRMFException e) {
                    throw new CMPException("CMPRevokeResponseMessage.berDecode: unable to decode CertId.", e);
                }
            }
            this.addOneStatus(statusInfo, certId);
        }
        if (crlsContainer.dataPresent) {
            int count = crlsContainer.getContainerCount();
            this.crls = new X509CRL[count];
            for (int i = 0; i < count; ++i) {
                ASN1Container crlContainer;
                try {
                    crlContainer = crlsContainer.containerAt(i);
                }
                catch (ASN_Exception e) {
                    throw new CMPException("CMPRevokeResponseMessage.berDecode: unable to get OfContainer component.", (Exception)((Object)e));
                }
                try {
                    this.crls[i] = new X509CRL(crlContainer.data, crlContainer.dataOffset, 0);
                    continue;
                }
                catch (CertificateException e) {
                    throw new CMPException("CMPRevokeResponseMessage.berDecode: unable to decode CRL.", e);
                }
            }
        }
    }

    private void addOneStatus(PKIStatusInfo status, OldCertID certId) throws CMPException {
        if (status == null) {
            throw new CMPException("CMPrevokeResponseMessage.addOneStatus: status should not be null.");
        }
        this.statusArray.addElement(status);
        this.certIdArray.addElement(certId);
    }
}

