/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki.cmp;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.GenTimeContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.UTF8StringContainer;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.cert.extensions.SubjectAltName;
import com.rsa.certj.cert.extensions.SubjectKeyID;
import com.rsa.certj.provider.pki.cmp.CMPException;
import com.rsa.certj.provider.pki.cmp.CMPProtectInfo;
import com.rsa.certj.provider.pki.cmp.CMPRequestCommon;
import com.rsa.certj.provider.pki.cmp.TypeAndValue;
import com.rsa.jsafe.JSAFE_SecureRandom;
import java.util.Date;

class PKIHeader {
    private static final int SENDER_NONCE_LENGTH = 16;
    private static final int TRANSACTION_ID_LENGTH = 16;
    protected int pvno = -1;
    protected GeneralName sender;
    protected GeneralName recipient;
    protected Date messageTime;
    protected ByteArray protectionAlg;
    protected ByteArray senderKID;
    protected ByteArray recipKID;
    protected ByteArray transactionID;
    protected ByteArray senderNonce;
    protected ByteArray recipNonce;
    protected String[] freeText;
    protected TypeAndValue[] generalInfo;

    protected PKIHeader(byte[] ber, int offset) throws CMPException {
        ASN1Container container;
        OfContainer generalInfoContainer;
        OfContainer freeTextContainer;
        OctetStringContainer recipNonceContainer;
        OctetStringContainer senderNonceContainer;
        OctetStringContainer transactionIDContainer;
        OctetStringContainer recipKIDContainer;
        OctetStringContainer senderKIDContainer;
        EncodedContainer protectionAlgContainer;
        GenTimeContainer messageTimeContainer;
        EncodedContainer recipientContainer;
        EncodedContainer senderContainer;
        IntegerContainer pvnoContainer;
        try {
            EndContainer endContainer = new EndContainer();
            SequenceContainer pkiHeaderContainer = new SequenceContainer(0);
            pvnoContainer = new IntegerContainer(0);
            senderContainer = new EncodedContainer(65280);
            recipientContainer = new EncodedContainer(65280);
            messageTimeContainer = new GenTimeContainer(0xA10000);
            protectionAlgContainer = new EncodedContainer(10563585);
            senderKIDContainer = new OctetStringContainer(10551298);
            recipKIDContainer = new OctetStringContainer(10551299);
            transactionIDContainer = new OctetStringContainer(10551300);
            senderNonceContainer = new OctetStringContainer(10551301);
            recipNonceContainer = new OctetStringContainer(10551302);
            freeTextContainer = new OfContainer(10551303, 12288, (ASN1Container)new EncodedContainer(3072));
            generalInfoContainer = new OfContainer(10551304, 12288, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] def = new ASN1Container[]{pkiHeaderContainer, pvnoContainer, senderContainer, recipientContainer, messageTimeContainer, protectionAlgContainer, senderKIDContainer, recipKIDContainer, transactionIDContainer, senderNonceContainer, recipNonceContainer, freeTextContainer, generalInfoContainer, endContainer};
            ASN1.berDecode((byte[])ber, (int)offset, (ASN1Container[])def);
        }
        catch (ASN_Exception e) {
            throw new CMPException("PKIHeader.PKIHeader: decoding PKIHeader failed.", (Exception)((Object)e));
        }
        try {
            this.pvno = pvnoContainer.getValueAsInt();
        }
        catch (ASN_Exception e) {
            throw new CMPException("PKIHeader.PKIHeader: unable to get PKIHeader.pvo as int.", (Exception)((Object)e));
        }
        this.sender = this.decodeGeneralName((ASN1Container)senderContainer, "sender");
        this.recipient = this.decodeGeneralName((ASN1Container)recipientContainer, "recipient");
        if (messageTimeContainer.dataPresent) {
            this.messageTime = messageTimeContainer.theTime;
        }
        this.protectionAlg = this.containerToByteArray((ASN1Container)protectionAlgContainer);
        this.senderKID = this.containerToByteArray((ASN1Container)senderKIDContainer);
        this.recipKID = this.containerToByteArray((ASN1Container)recipKIDContainer);
        this.transactionID = this.containerToByteArray((ASN1Container)transactionIDContainer);
        this.senderNonce = this.containerToByteArray((ASN1Container)senderNonceContainer);
        this.recipNonce = this.containerToByteArray((ASN1Container)recipNonceContainer);
        if (freeTextContainer.dataPresent) {
            int count = freeTextContainer.getContainerCount();
            this.freeText = new String[count];
            for (int i = 0; i < count; ++i) {
                try {
                    container = freeTextContainer.containerAt(i);
                    UTF8StringContainer utf8Container = new UTF8StringContainer(0);
                    ASN1Container[] utf8Def = new ASN1Container[]{utf8Container};
                    ASN1.berDecode((byte[])container.data, (int)container.dataOffset, (ASN1Container[])utf8Def);
                    if (utf8Container.dataPresent && utf8Container.dataLen != 0) {
                        this.freeText[i] = new String(utf8Container.data, utf8Container.dataOffset, utf8Container.dataLen);
                        continue;
                    }
                    this.freeText[i] = null;
                    continue;
                }
                catch (ASN_Exception e) {
                    throw new CMPException("PKIHeader.PKIHeader: unable to extract and decode a freeText string.", (Exception)((Object)e));
                }
            }
        }
        if (generalInfoContainer.dataPresent) {
            int count = generalInfoContainer.getContainerCount();
            this.generalInfo = new TypeAndValue[count];
            for (int i = 0; i < count; ++i) {
                try {
                    container = generalInfoContainer.containerAt(i);
                    this.generalInfo[i] = new TypeAndValue(container.data, container.dataOffset, 0);
                    continue;
                }
                catch (ASN_Exception e) {
                    throw new CMPException("PKIHeader.PKIHeader: unable to get an element of generalInfo.", (Exception)((Object)e));
                }
            }
        }
    }

    protected PKIHeader(CMPRequestCommon request, CMPProtectInfo protectInfo, byte[] protectionAlgDER, JSAFE_SecureRandom random) throws CMPException {
        int version = request.getVersion();
        if (version > 0 && version != 2) {
            throw new CMPException("PKIHeader.PKIHeader: CMP version provided (" + request.getVersion() + ") does not match the supported version (" + 2 + ").");
        }
        this.pvno = 2;
        this.setSenderAndRecipientInfo(protectInfo);
        this.messageTime = request.getMessageTime();
        if (protectionAlgDER != null) {
            this.protectionAlg = new ByteArray(protectionAlgDER);
        }
        this.recipKID = null;
        this.fixTransactionID(request, random);
        this.transactionID = new ByteArray(request.getTransactionID());
        this.senderNonce = new ByteArray(this.generatePositiveBytes(random, 16));
        if (request.getRecipNonce() != null) {
            this.recipNonce = new ByteArray(request.getRecipNonce());
        }
        this.freeText = request.getFreeText();
        this.generalInfo = request.getGeneralInfo();
    }

    private void setSenderAndRecipientInfo(CMPProtectInfo protectInfo) throws CMPException {
        if (protectInfo == null) {
            return;
        }
        if (protectInfo.pbmProtected()) {
            this.senderKID = new ByteArray(protectInfo.getKeyID());
        } else {
            X509Certificate signerCert = protectInfo.getSenderCert();
            this.sender = this.getSubjectName(signerCert);
            this.senderKID = this.getSubjectKID(signerCert);
        }
        X509Certificate caCert = protectInfo.getRecipCert();
        if (caCert != null) {
            this.recipient = this.getSubjectName(caCert);
            this.recipKID = this.getSubjectKID(caCert);
        }
    }

    /*
     * Unable to fully structure code
     */
    private GeneralName getSubjectName(X509Certificate cert) throws CMPException {
        name = null;
        sn = cert.getSubjectName();
        if (sn == null || sn.getRDNCount() == 0) {
            ext = cert.getExtensions();
            if (ext != null) {
                try {
                    alt = (SubjectAltName)ext.getExtensionByType(17);
                }
                catch (CertificateException e) {
                    throw new CMPException("PKIHeader.getSubjectName: unable to extract SubjectAltName extension.", e);
                }
                if (alt != null) {
                    try {
                        gnames = alt.getGeneralNames();
                        if (gnames == null || (count = gnames.getNameCount()) <= 0) ** GOTO lbl27
                        name = gnames.getGeneralName(0);
                    }
                    catch (NameException e) {
                        throw new CMPException("PKIHeader.getSubjectName: unable to extract GeneralName from SubjectAltName.", e);
                    }
                }
            }
        } else {
            try {
                name = new GeneralName();
                name.setGeneralName(sn, 5);
            }
            catch (NameException e) {
                throw new CMPException("PKIHeader.getSubjectName: unable to create a GeneralName.", e);
            }
        }
lbl27:
        // 4 sources

        if (name == null) {
            name = this.createEmptyName();
        }
        return name;
    }

    private ByteArray getSubjectKID(X509Certificate cert) throws CMPException {
        X509V3Extensions extensions = cert.getExtensions();
        if (extensions != null) {
            try {
                SubjectKeyID extension = (SubjectKeyID)extensions.getExtensionByType(14);
                if (extension != null) {
                    return new ByteArray(extension.getKeyID());
                }
            }
            catch (CertificateException e) {
                throw new CMPException("PKIHeader.getSubjectKID: unable to extract Subject Key ID extension.", e);
            }
        }
        return null;
    }

    protected byte[] derEncode() throws CMPException {
        byte[] recipientDER;
        byte[] senderDER;
        if (this.sender == null) {
            this.sender = this.createEmptyName();
        }
        if (this.recipient == null) {
            this.recipient = this.createEmptyName();
        }
        try {
            senderDER = new byte[this.sender.getDERLen(0)];
            this.sender.getDEREncoding(senderDER, 0, 0);
        }
        catch (NameException e) {
            throw new CMPException("PKIHeader.derEncode: unable to encode sender.", e);
        }
        try {
            recipientDER = new byte[this.recipient.getDERLen(0)];
            this.recipient.getDEREncoding(recipientDER, 0, 0);
        }
        catch (NameException e) {
            throw new CMPException("PKIHeader.derEncode:  unable to encode recipient.", e);
        }
        try {
            OfContainer generalInfoContainer;
            OfContainer freeTextContainer;
            EndContainer endContainer = new EndContainer();
            SequenceContainer pkiHeaderContainer = new SequenceContainer(0, true, 0);
            IntegerContainer pvnoContainer = new IntegerContainer(0, true, 0, this.pvno);
            EncodedContainer senderContainer = new EncodedContainer(0, true, 0, senderDER, 0, senderDER.length);
            EncodedContainer recipientContainer = new EncodedContainer(0, true, 0, recipientDER, 0, recipientDER.length);
            GenTimeContainer messageTimeContainer = this.messageTime == null ? new GenTimeContainer(65536, false, 0, null) : new GenTimeContainer(0xA10000, true, 0, this.messageTime);
            EncodedContainer protectionAlgContainer = this.protectionAlg == null ? new EncodedContainer(65536, false, 0, null, 0, 0) : new EncodedContainer(0, true, 0, this.protectionAlg.data, this.protectionAlg.offset, this.protectionAlg.len);
            ASN1Container senderKIDContainer = this.byteArrayToContainer(this.senderKID, 2);
            ASN1Container recipKIDContainer = this.byteArrayToContainer(this.recipKID, 3);
            ASN1Container transactionIDContainer = this.byteArrayToContainer(this.transactionID, 4);
            ASN1Container senderNonceContainer = this.byteArrayToContainer(this.senderNonce, 5);
            ASN1Container recipNonceContainer = this.byteArrayToContainer(this.recipNonce, 6);
            if (this.freeText != null) {
                freeTextContainer = new OfContainer(10551303, true, 0, 12288, (ASN1Container)new EncodedContainer(3072));
                for (int i = 0; i < this.freeText.length; ++i) {
                    byte[] bytes = this.freeText[i].getBytes();
                    try {
                        freeTextContainer.addContainer((ASN1Container)new UTF8StringContainer(0, true, 0, bytes, 0, bytes.length));
                        continue;
                    }
                    catch (ASN_Exception e) {
                        throw new CMPException("PKIHeader.derEncode: unable to add an element to freeText.", (Exception)((Object)e));
                    }
                }
            } else {
                freeTextContainer = new OfContainer(65536, false, 0, 0, null);
            }
            if (this.generalInfo != null) {
                generalInfoContainer = new OfContainer(10551304, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
                for (int i = 0; i < this.generalInfo.length; ++i) {
                    TypeAndValue typeAndValue = this.generalInfo[i];
                    byte[] der = new byte[typeAndValue.getDERLen(0)];
                    typeAndValue.getDEREncoding(der, 0, 0);
                    EncodedContainer typeAndValueContainer = new EncodedContainer(0, true, 0, der, 0, der.length);
                    try {
                        generalInfoContainer.addContainer((ASN1Container)typeAndValueContainer);
                        continue;
                    }
                    catch (ASN_Exception e) {
                        throw new CMPException("PKIHeader.derEncode: unable to add an element to generalInfo.", (Exception)((Object)e));
                    }
                }
            } else {
                generalInfoContainer = new OfContainer(65536, false, 0, 0, null);
            }
            ASN1Container[] def = new ASN1Container[]{pkiHeaderContainer, pvnoContainer, senderContainer, recipientContainer, messageTimeContainer, protectionAlgContainer, senderKIDContainer, recipKIDContainer, transactionIDContainer, senderNonceContainer, recipNonceContainer, freeTextContainer, generalInfoContainer, endContainer};
            ASN1Template template = new ASN1Template(def);
            byte[] pkiHeaderDER = new byte[template.derEncodeInit()];
            template.derEncode(pkiHeaderDER, 0);
            return pkiHeaderDER;
        }
        catch (ASN_Exception e) {
            throw new CMPException("PKIHeader.derEncode: encoding CMP PKIHeader failed.", (Exception)((Object)e));
        }
    }

    protected byte[] getSenderKID() {
        return this.getBytes(this.senderKID);
    }

    protected byte[] getRecipKID() {
        return this.getBytes(this.recipKID);
    }

    protected byte[] getSenderNonce() {
        return this.getBytes(this.senderNonce);
    }

    protected byte[] getRecipNonce() {
        return this.getBytes(this.recipNonce);
    }

    protected byte[] getTransactionID() {
        return this.getBytes(this.transactionID);
    }

    protected byte[] getProtectionAlg() {
        return this.getBytes(this.protectionAlg);
    }

    private byte[] getBytes(ByteArray byteArray) {
        if (byteArray == null) {
            return null;
        }
        return byteArray.getData();
    }

    private void fixTransactionID(CMPRequestCommon request, JSAFE_SecureRandom random) {
        byte[] transID = request.getTransactionID();
        if (transID != null) {
            return;
        }
        transID = this.generatePositiveBytes(random, 16);
        request.setTransactionID(transID);
    }

    private byte[] generatePositiveBytes(JSAFE_SecureRandom random, int bytes) {
        byte[] id = new byte[bytes];
        do {
            random.generateRandomBytes(id, 0, id.length);
        } while ((id[0] & 0x80) != 0);
        return id;
    }

    private GeneralName createEmptyName() throws CMPException {
        GeneralName name = new GeneralName();
        try {
            name.setGeneralName(new X500Name(), 5);
            return name;
        }
        catch (NameException e) {
            throw new CMPException("PKIHeader.createEmptyName.", e);
        }
    }

    private GeneralName decodeGeneralName(ASN1Container container, String fieldName) throws CMPException {
        if (!container.dataPresent || container.dataLen == 0) {
            throw new CMPException("PKIHeader.decodeGeneralName: missing required field(" + fieldName + ").");
        }
        try {
            return new GeneralName(container.data, container.dataOffset, 0);
        }
        catch (NameException e) {
            throw new CMPException("PKIHeader.decodeGeneralName: unable to decode a GeneralName in the " + fieldName + " field.", e);
        }
    }

    private ASN1Container byteArrayToContainer(ByteArray data, int context) throws ASN_Exception {
        if (data == null || data.len == 0) {
            return new EncodedContainer(65536, false, 0, null, 0, 0);
        }
        return new OctetStringContainer(0xA10000 | context, true, 0, data.data, data.offset, data.len);
    }

    private ByteArray containerToByteArray(ASN1Container container) {
        if (!container.dataPresent) {
            return null;
        }
        return new ByteArray(container.data, container.dataOffset, container.dataLen);
    }

    private final class ByteArray {
        private byte[] data;
        private int offset;
        private int len;

        private ByteArray(byte[] data) {
            this.data = data;
            this.offset = 0;
            this.len = data.length;
        }

        private ByteArray(byte[] data, int offset, int len) {
            this.data = data;
            this.offset = offset;
            this.len = len;
        }

        private byte[] getData() {
            if (this.offset == 0 || this.data.length == this.len) {
                return this.data;
            }
            byte[] copy = new byte[this.len];
            System.arraycopy(this.data, this.offset, copy, 0, this.len);
            return copy;
        }
    }
}

