/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki.cmp;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.provider.pki.cmp.CMPException;
import java.util.Arrays;

public class TypeAndValue {
    private byte[] type;
    private byte[] value;
    private int special;
    private ASN1Template asn1Template;

    protected TypeAndValue(byte[] ber, int offset, int special) throws CMPException {
        if (ber == null) {
            throw new CMPException("TypeAndValue.TypeAndValue: ber should not be null.");
        }
        SequenceContainer typeAndValueContainer = new SequenceContainer(0);
        OIDContainer typeContainer = new OIDContainer(0x1000000);
        EncodedContainer valueContainer = new EncodedContainer(130816);
        EndContainer endContainer = new EndContainer();
        ASN1Container[] def = new ASN1Container[]{typeAndValueContainer, typeContainer, valueContainer, endContainer};
        try {
            ASN1.berDecode((byte[])ber, (int)offset, (ASN1Container[])def);
        }
        catch (ASN_Exception e) {
            throw new CMPException("TypeAndValue.TypeAndValue: BER-decoding failed.", (Exception)((Object)e));
        }
        this.type = new byte[typeContainer.dataLen];
        System.arraycopy(typeContainer.data, typeContainer.dataOffset, this.type, 0, typeContainer.dataLen);
        if (valueContainer.dataPresent) {
            this.value = new byte[valueContainer.dataLen];
            System.arraycopy(valueContainer.data, valueContainer.dataOffset, this.value, 0, valueContainer.dataLen);
        }
    }

    public TypeAndValue(byte[] type, int typeOffset, int typeLen, byte[] value, int valueOffset, int valueLen) throws CMPException {
        if (type == null) {
            throw new CMPException("TypeAndValue.TypeAndValue: type should not be null.");
        }
        this.type = new byte[typeLen];
        System.arraycopy(type, typeOffset, this.type, 0, typeLen);
        if (value == null) {
            this.value = null;
        } else {
            this.value = new byte[valueLen];
            System.arraycopy(value, valueOffset, this.value, 0, valueLen);
        }
    }

    protected int getDERLen(int special) throws CMPException {
        this.special = special;
        try {
            SequenceContainer typeAndValueContainer = new SequenceContainer(0, true, 0);
            OIDContainer typeContainer = new OIDContainer(0x1000000, true, 0, this.type, 0, this.type.length);
            EncodedContainer valueContainer = this.value == null ? new EncodedContainer(130816, false, 0, null, 0, 0) : new EncodedContainer(130816, true, 0, this.value, 0, this.value.length);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] def = new ASN1Container[]{typeAndValueContainer, typeContainer, valueContainer, endContainer};
            this.asn1Template = new ASN1Template(def);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception e) {
            throw new CMPException("TypeAndValue.getDERLen: DER-encoding failed.", (Exception)((Object)e));
        }
    }

    protected int getDEREncoding(byte[] encoding, int offset, int special) throws CMPException {
        if (encoding == null) {
            throw new CMPException("TypeAndValue.getDEREncoding: encoding should not be null.");
        }
        try {
            int len;
            if ((this.asn1Template == null || special != this.special) && (len = this.getDERLen(special)) == 0) {
                throw new CMPException("TypeAndValue.getDEREncoding: DER-encoding has 0 length.");
            }
            len = this.asn1Template.derEncode(encoding, offset);
            return len;
        }
        catch (ASN_Exception e) {
            throw new CMPException("TypeAndValue.getDEREncoding: DER-encoding failed.", (Exception)((Object)e));
        }
        finally {
            this.asn1Template = null;
        }
    }

    public byte[] getType() {
        if (this.type == null) {
            return null;
        }
        byte[] copy = new byte[this.type.length];
        System.arraycopy(this.type, 0, copy, 0, this.type.length);
        return copy;
    }

    public byte[] getValue() {
        if (this.value == null) {
            return null;
        }
        byte[] copy = new byte[this.value.length];
        System.arraycopy(this.value, 0, copy, 0, this.value.length);
        return copy;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TypeAndValue)) {
            return false;
        }
        TypeAndValue other = (TypeAndValue)obj;
        return CertJUtils.byteArraysEqual(this.type, other.type) && CertJUtils.byteArraysEqual(this.value, other.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(this.type);
        result = prime * result + Arrays.hashCode(this.value);
        return result;
    }
}

