/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.revocation.ocsp;

import com.rsa.asn1.ASN_Exception;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.internal.ConvertUtil;
import com.rsa.certj.provider.pki.PKICommonImplementation;
import com.rsa.certj.provider.revocation.ocsp.OCSPEvidence;
import com.rsa.certj.provider.revocation.ocsp.OCSPRequest;
import com.rsa.certj.provider.revocation.ocsp.OCSPResponder;
import com.rsa.certj.provider.revocation.ocsp.OCSPResponderInternal;
import com.rsa.certj.provider.revocation.ocsp.OCSPResponse;
import com.rsa.certj.provider.revocation.ocsp.OCSPutil;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.pki.PKIException;
import com.rsa.certj.spi.pki.PKIResult;
import com.rsa.certj.spi.pki.PKIStatusInfo;
import com.rsa.certj.spi.revocation.CertRevocationInfo;
import com.rsa.certj.spi.revocation.CertStatusException;
import com.rsa.certj.spi.revocation.CertStatusInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public final class OCSP
extends Provider {
    private OCSPResponder[] configedResponders;
    private OCSPResponderInternal[] responders;
    static final int SUPPORTED_VERSION = 0;
    static final int NONCE_LEN = 16;
    private static final String MIME_TYPE_OCSP_REQ = "application/ocsp-request";
    private static final String MIME_CONTENT_TYPE = "Content-type";
    private static final String MIME_CONTENT_LENGTH = "Content-length";
    private static final String MIME_USER_AGENT = "User-Agent";
    private static final String MIME_USER_AGENT_VALUE = "Cert-J/3.1";
    private boolean dbgWriteDERs;
    private Hashtable<String, Vector<String>> configProperties;

    public void setDebugWriteDERs(boolean debugOn) {
        this.dbgWriteDERs = debugOn;
    }

    public OCSP(String name, OCSPResponder responder) throws InvalidParameterException, CertificateException, NameException {
        super(2, name);
        if (responder == null) {
            throw new InvalidParameterException("responder == null");
        }
        this.configedResponders = new OCSPResponder[1];
        this.configedResponders[0] = new OCSPResponder(responder);
    }

    public OCSP(String name, OCSPResponder[] responders) throws InvalidParameterException, CertificateException, NameException {
        super(2, name);
        if (responders == null) {
            throw new InvalidParameterException("responder == null");
        }
        int n = responders.length;
        this.configedResponders = new OCSPResponder[n];
        for (int i = 0; i < n; ++i) {
            if (responders[i] == null) {
                throw new InvalidParameterException("responders[" + i + "] == null");
            }
            this.configedResponders[i] = new OCSPResponder(responders[i]);
        }
    }

    public OCSP(String name, OCSPResponder responder, InputStream configStream) throws InvalidParameterException, CertificateException, NameException {
        this(name, responder);
        if (configStream == null) {
            throw new InvalidParameterException("OCSP: configStream should not be null.");
        }
        this.configProperties = PKICommonImplementation.loadProperties(configStream);
    }

    public OCSP(String name, OCSPResponder responder, File configFile) throws InvalidParameterException, CertificateException, NameException {
        this(name, responder);
        if (configFile == null) {
            throw new InvalidParameterException("OCSP: configFile should not be null.");
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(configFile);
            this.configProperties = PKICommonImplementation.loadProperties(stream);
        }
        catch (FileNotFoundException e) {
            throw new InvalidParameterException("OCSP: " + configFile.toString() + " does not exist.");
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException e) {}
            }
        }
    }

    public OCSP(String name, OCSPResponder[] responders, InputStream configStream) throws InvalidParameterException, CertificateException, NameException {
        this(name, responders);
        if (configStream == null) {
            throw new InvalidParameterException("OCSP: configStream should not be null.");
        }
        this.configProperties = PKICommonImplementation.loadProperties(configStream);
    }

    public OCSP(String name, OCSPResponder[] responders, File configFile) throws InvalidParameterException, CertificateException, NameException {
        this(name, responders);
        if (configFile == null) {
            throw new InvalidParameterException("OCSP: configFile should not be null.");
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(configFile);
            this.configProperties = PKICommonImplementation.loadProperties(stream);
        }
        catch (FileNotFoundException e) {
            throw new InvalidParameterException("OCSP: " + configFile.toString() + " does not exist.");
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException e) {}
            }
        }
    }

    public ProviderImplementation instantiate(CertJ certJ) throws ProviderManagementException {
        int n = this.configedResponders.length;
        try {
            this.responders = new OCSPResponderInternal[n];
            for (int i = 0; i < n; ++i) {
                this.responders[i] = new OCSPResponderInternal(certJ, this.configedResponders[i]);
                this.configedResponders[i] = null;
            }
            return new Implementation(certJ, this.getName());
        }
        catch (InvalidParameterException ex) {
            throw new ProviderManagementException("OCSP.instantiate.", ex);
        }
        catch (CertificateException ex) {
            throw new ProviderManagementException("OCSP.instantiate.", ex);
        }
        catch (NameException ex) {
            throw new ProviderManagementException("OCSP.instantiate.", ex);
        }
        catch (PKIException ex) {
            throw new ProviderManagementException("OCSP.instantiate.", ex);
        }
    }

    private final class Implementation
    extends PKICommonImplementation
    implements CertStatusInterface {
        private Implementation(CertJ certJ, String name) throws InvalidParameterException, PKIException {
            super(certJ, name);
            if (OCSP.this.configProperties != null) {
                this.loadConfig(OCSP.this.configProperties);
            }
        }

        public CertRevocationInfo checkCertRevocation(CertPathCtx pathCtx, Certificate cert) throws NotSupportedException, CertStatusException {
            if (pathCtx == null) {
                throw new NotSupportedException("pathCtx==null");
            }
            Certificate[] certs = new Certificate[]{cert};
            CertRevocationInfo[] revInfo = this.checkCertRevocations(pathCtx, certs);
            return revInfo[0];
        }

        private void writeDER(String fname, byte[] der) throws NotSupportedException {
            FileOutputStream f = null;
            try {
                f = new FileOutputStream(fname);
                f.write(der);
                f.close();
            }
            catch (Exception ex) {
                throw new NotSupportedException("Could not write to file " + fname + ": " + ex.getMessage());
            }
            finally {
                if (f != null) {
                    try {
                        f.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }

        private CertRevocationInfo[] checkCertRevocations(CertPathCtx pathCtx, Certificate[] certs) throws NotSupportedException, CertStatusException {
            int i;
            if (certs == null) {
                return null;
            }
            int n = certs.length;
            CertRevocationInfo[] revInfo = new CertRevocationInfo[n];
            OCSPMatchedResponder[] matchedResponders = new OCSPMatchedResponder[n];
            for (i = 0; i < n; ++i) {
                if (certs[i] == null) {
                    matchedResponders[i] = null;
                    revInfo[i] = null;
                    continue;
                }
                matchedResponders[i] = this.matchResponder(pathCtx.getPathOptions(), (X509Certificate)certs[i]);
            }
            try {
                for (i = 0; i < n; ++i) {
                    byte[] respDER;
                    String debugDERId = null;
                    if (certs[i] == null) continue;
                    X509V3Extensions exts = ((X509Certificate)certs[i]).getExtensions();
                    if (exts != null && exts.getExtensionByType(117) != null) {
                        revInfo[i] = new CertRevocationInfo(0, 0, null);
                        continue;
                    }
                    revInfo[i] = new CertRevocationInfo(2, 0, null);
                    if (matchedResponders[i] == null) continue;
                    OCSPRequest request = new OCSPRequest(this.certJ, matchedResponders[i].responder, certs);
                    byte[] reqDER = request.encode(pathCtx);
                    if (OCSP.this.dbgWriteDERs) {
                        byte[] id = certs[i].getUniqueID();
                        debugDERId = id == null ? "" : new String(ConvertUtil.byteArrayToHexString(id));
                        this.writeDER("ocspreq." + debugDERId + ".der", reqDER);
                    }
                    try {
                        PKIResult result = this.sendMessage(matchedResponders[i].destList, matchedResponders[i].proxyList, reqDER);
                        respDER = result.getEncodedResponse();
                        PKIStatusInfo statusInfo = result.getStatusInfo();
                        if (statusInfo.getStatus() != 0) {
                            throw new CertStatusException("OCSP Transport status != 0 (" + statusInfo.getStatus() + ")");
                        }
                        if (statusInfo.getFailInfoAux() != 200) {
                            String statusInfoString = CertJUtils.objectArrayToString(statusInfo.getStatusStrings(), ", ");
                            throw new CertStatusException("OCSP Transport HTTP status != 200\n" + statusInfoString);
                        }
                        if (OCSP.this.dbgWriteDERs) {
                            this.writeDER("ocspresp." + debugDERId + ".der", respDER);
                        }
                    }
                    catch (PKIException ex) {
                        throw new CertStatusException(ex);
                    }
                    OCSPResponse response = new OCSPResponse(this.certJ, OCSP.this.responders[i], (X509Certificate)certs[i]);
                    response.decode(pathCtx, respDER, request);
                    CertRevocationInfo rev = response.getRevocationInfo(request.getCertID(i));
                    byte[] reqNonce = request.getNonce();
                    if (reqNonce != null) {
                        byte[] respNonce = response.getNonce();
                        if (respNonce == null) {
                            OCSPEvidence ev = null;
                            if (rev != null && rev.getType() == 2) {
                                ev = (OCSPEvidence)rev.getEvidence();
                            }
                            if (ev != null) {
                                ev.setFlags(ev.getFlags() | 1);
                            }
                        } else if (!CertJUtils.byteArraysEqual(reqNonce, respNonce)) {
                            throw new NotSupportedException("OCSP nonce mismatch");
                        }
                    }
                    if (rev == null) continue;
                    revInfo[i] = rev;
                }
            }
            catch (ASN_Exception ex) {
                throw new CertStatusException((Exception)((Object)ex));
            }
            catch (CertificateException ex) {
                throw new NotSupportedException(ex);
            }
            return revInfo;
        }

        private PKIResult sendMessage(String[] derivedDestList, String[] proxyList, byte[] request) throws PKIException {
            boolean found = false;
            for (int i = 0; i < derivedDestList.length; ++i) {
                boolean isFailServerError;
                PKIResult result;
                URL destURL;
                String dest = derivedDestList[i];
                try {
                    destURL = new URL(dest);
                }
                catch (Exception e) {
                    continue;
                }
                String protocol = destURL.getProtocol();
                if (!protocol.equals("http") && !protocol.equals("https")) continue;
                found = true;
                int proxyCount = 0;
                if (proxyList != null) {
                    proxyCount = proxyList.length;
                }
                if (request == null) {
                    request = new byte[]{};
                }
                if (proxyList == null || proxyCount == 0) {
                    result = this.sendOCSPRequest(destURL, request);
                } else {
                    result = null;
                    for (int j = 0; j < proxyCount; ++j) {
                        String urlstr = null;
                        try {
                            urlstr = proxyList[j];
                            URL proxyURL = new URL(urlstr);
                            String pxyHost = proxyURL.getHost();
                            String pxyPort = "" + proxyURL.getPort();
                            Properties systemProperties = System.getProperties();
                            systemProperties.setProperty("http.proxyHost", pxyHost);
                            systemProperties.setProperty("http.proxyPort", pxyPort);
                            systemProperties.setProperty("https.proxyHost", pxyHost);
                            systemProperties.setProperty("https.proxyPort", pxyPort);
                        }
                        catch (MalformedURLException e) {
                            throw new PKIException("OCSP.sendMessage: unable to parse proxy specification" + urlstr + ".", e);
                        }
                        try {
                            result = this.sendOCSPRequest(destURL, request);
                            break;
                        }
                        catch (Exception e) {
                            continue;
                        }
                    }
                }
                if (result == null) continue;
                PKIStatusInfo info = result.getStatusInfo();
                boolean bl = isFailServerError = (info.getFailInfo() & 0x200000) != 0;
                if (info.getStatus() == 2 && isFailServerError) continue;
                return result;
            }
            throw new PKIException(found ? "Unable to connect to an OCSP responder." : "Unable to choose an OCSP responder.");
        }

        private PKIResult sendOCSPRequest(URL url, byte[] request) throws PKIException {
            byte[] responseDER = null;
            OutputStream out = null;
            InputStream in = null;
            try {
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                con.setDoOutput(true);
                con.setRequestMethod("POST");
                con.setRequestProperty(OCSP.MIME_USER_AGENT, OCSP.MIME_USER_AGENT_VALUE);
                con.setRequestProperty(OCSP.MIME_CONTENT_TYPE, OCSP.MIME_TYPE_OCSP_REQ);
                con.setRequestProperty(OCSP.MIME_CONTENT_LENGTH, String.valueOf(request.length));
                out = con.getOutputStream();
                out.write(request);
                out.flush();
                int failInfoAux = con.getResponseCode();
                int status = this.mapHTTPStatus(failInfoAux);
                int failInfo = this.mapHTTPFailInfo(failInfoAux);
                if (status == 0) {
                    in = con.getInputStream();
                    int contentLen = con.getContentLength();
                    if (contentLen == -1) {
                        contentLen = Integer.MAX_VALUE;
                    }
                    int bytesRead = 0;
                    responseDER = new byte[contentLen];
                    for (int totalBytes = 0; bytesRead != -1 && totalBytes < contentLen; totalBytes += bytesRead) {
                        bytesRead = in.read(responseDER, totalBytes, responseDER.length - totalBytes);
                    }
                }
                String[] statusStrings = new String[]{con.getHeaderFields().toString()};
                PKIResult pKIResult = new PKIResult(new PKIStatusInfo(status, failInfo, statusStrings, failInfoAux), responseDER);
                return pKIResult;
            }
            catch (IOException e) {
                throw new PKIException("OCSP.SendOCSPRequest: " + e.getMessage());
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ignored) {}
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }

        private OCSPMatchedResponder matchResponder(int pfFlags, X509Certificate cert) {
            OCSPResponder bestResponder = null;
            String loc = null;
            if ((pfFlags & 0x800) == 0) {
                loc = OCSPutil.getAIALocation(cert);
            }
            if (loc == null) {
                for (int i = 0; i < OCSP.this.responders.length; ++i) {
                    String[] finalDestList;
                    OCSPResponderInternal r = OCSP.this.responders[i];
                    if (r.getResponderCACert(cert) == null || (finalDestList = r.getDestList()) == null) continue;
                    return new OCSPMatchedResponder(r, finalDestList, r.getProxyList());
                }
                return null;
            }
            String[] finalDestList = new String[]{loc};
            for (int i = 0; i < OCSP.this.responders.length; ++i) {
                OCSPResponderInternal r = OCSP.this.responders[i];
                if (r.getResponderCACert(cert, loc) == null) {
                    if (r.getResponderCACert(cert) == null || bestResponder != null) continue;
                    bestResponder = r;
                    continue;
                }
                return new OCSPMatchedResponder(r, finalDestList, r.getProxyList());
            }
            return bestResponder == null ? null : new OCSPMatchedResponder((OCSPResponderInternal)bestResponder, finalDestList, bestResponder.getProxyList());
        }

        public String toString() {
            return "OCSP Certificate Status provider named: " + this.getName();
        }
    }

    private class OCSPMatchedResponder {
        OCSPResponderInternal responder;
        String[] destList;
        String[] proxyList;

        protected OCSPMatchedResponder(OCSPResponderInternal responder, String[] destList, String[] proxyList) {
            this.responder = responder;
            this.destList = destList;
            this.proxyList = proxyList;
        }
    }
}

