/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.revocation.ocsp;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJInternalHelper;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.internal.CertJContext;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.certj.provider.revocation.ocsp.OCSPutil;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_MessageDigest;

public final class OCSPCertID {
    private String hashAlg;
    private byte[] issuerKeyHash;
    private byte[] issuerNameHash;
    private byte[] serial;
    private byte[] encoding;
    private static final int NO_SPECIAL = 0;
    private static final int BOGUS_OPTTAG = 0;
    private static final int BOGUS_OFFSET = 0;
    private static final boolean BOGUS_DATA_PRESENT = true;
    private final CertJContext context;

    OCSPCertID(CertJ certJ, X509Certificate caCert, X509Certificate eeCert, String hashAlg) throws NameException, NotSupportedException {
        this.context = CertJInternalHelper.context(certJ);
        this.hashAlg = hashAlg;
        try {
            byte[] keyval = OCSPutil.extractKeyDER(caCert.getSubjectPublicKeyBER(), 0);
            this.issuerKeyHash = OCSPutil.makeDataDigest(certJ, hashAlg, keyval, 0, keyval.length);
        }
        catch (Exception ex) {
            throw new NotSupportedException(ex);
        }
        byte[] hashData = new byte[caCert.getSubjectName().getDERLen(0)];
        caCert.getSubjectName().getDEREncoding(hashData, 0, 0);
        try {
            this.issuerNameHash = OCSPutil.makeDataDigest(certJ, hashAlg, hashData, 0, hashData.length);
        }
        catch (Exception ex) {
            throw new NotSupportedException(ex);
        }
        byte[] localSerialNumber = eeCert.getSerialNumber();
        this.serial = new byte[localSerialNumber.length];
        System.arraycopy(localSerialNumber, 0, this.serial, 0, localSerialNumber.length);
    }

    OCSPCertID(CertJ certJ, byte[] ber, int offset, int len) throws NotSupportedException {
        EncodedContainer snBER;
        OctetStringContainer osKeyHash;
        OctetStringContainer osNameHash;
        this.context = CertJInternalHelper.context(certJ);
        try {
            EndContainer anEnd = new EndContainer();
            SequenceContainer seq = new SequenceContainer(0);
            EncodedContainer hashAlgBER = new EncodedContainer(65280);
            osNameHash = new OctetStringContainer(0);
            osKeyHash = new OctetStringContainer(0);
            snBER = new EncodedContainer(65280);
            ASN1Container[] def = new ASN1Container[]{seq, hashAlgBER, osNameHash, osKeyHash, snBER, anEnd};
            SequenceContainer haSeq = new SequenceContainer(0);
            OIDContainer haOID = new OIDContainer(0x1000000);
            EncodedContainer haParams = new EncodedContainer(65536);
            ASN1Container[] defHashAlg = new ASN1Container[]{haSeq, haOID, haParams, anEnd};
            ASN1.berDecode((byte[])ber, (int)offset, (ASN1Container[])def);
            ASN1.berDecode((byte[])hashAlgBER.data, (int)hashAlgBER.dataOffset, (ASN1Container[])defHashAlg);
            JSAFE_MessageDigest ha = JSAFEFactory.getDigest(hashAlgBER.data, hashAlgBER.dataOffset, "Java", this.context.jsafe);
            this.hashAlg = ha.getAlgorithm();
        }
        catch (ASN_Exception ex) {
            throw new NotSupportedException((Exception)((Object)ex));
        }
        catch (JSAFE_Exception ex) {
            throw new NotSupportedException((Exception)((Object)ex));
        }
        this.issuerKeyHash = new byte[osKeyHash.dataLen];
        System.arraycopy(osKeyHash.data, osKeyHash.dataOffset, this.issuerKeyHash, 0, osKeyHash.dataLen);
        this.issuerNameHash = new byte[osNameHash.dataLen];
        System.arraycopy(osNameHash.data, osNameHash.dataOffset, this.issuerNameHash, 0, osNameHash.dataLen);
        this.serial = new byte[snBER.dataLen];
        System.arraycopy(snBER.data, snBER.dataOffset, this.serial, 0, snBER.dataLen);
        this.encoding = new byte[len];
        System.arraycopy(ber, offset, this.encoding, 0, len);
    }

    private byte[] getAlgorithmIDDER(String algName) throws NotSupportedException {
        try {
            JSAFE_MessageDigest digestObject = JSAFEFactory.getDigest(algName, "Java", this.context.jsafe);
            return digestObject.getDERAlgorithmID();
        }
        catch (JSAFE_Exception ex) {
            throw new NotSupportedException((Exception)((Object)ex));
        }
    }

    byte[] encode() throws NotSupportedException {
        if (this.encoding != null) {
            return this.encoding;
        }
        byte[] algoID = this.getAlgorithmIDDER(this.hashAlg);
        try {
            SequenceContainer seq = new SequenceContainer(0, true, 0);
            EncodedContainer hashAlgorithmDER = new EncodedContainer(0, true, 0, algoID, 0, algoID.length);
            OctetStringContainer issuerNameHashDER = new OctetStringContainer(0, true, 0, this.issuerNameHash, 0, this.issuerNameHash.length);
            OctetStringContainer issuerKeyHashDER = new OctetStringContainer(0, true, 0, this.issuerKeyHash, 0, this.issuerKeyHash.length);
            IntegerContainer serialDER = new IntegerContainer(0, true, 0, this.serial, 0, this.serial.length, true);
            EndContainer anEnd = new EndContainer();
            ASN1Container[] asn1Def = new ASN1Container[]{seq, hashAlgorithmDER, issuerNameHashDER, issuerKeyHashDER, serialDER, anEnd};
            ASN1Template asn1TemplateValue = new ASN1Template(asn1Def);
            int encodingLen = asn1TemplateValue.derEncodeInit();
            this.encoding = new byte[encodingLen];
            int actualEncodingLen = asn1TemplateValue.derEncode(this.encoding, 0);
            return encodingLen == actualEncodingLen ? this.encoding : null;
        }
        catch (ASN_Exception ex) {
            throw new NotSupportedException((Exception)((Object)ex));
        }
    }
}

