/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.revocation.ocsp;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.AuthorityInfoAccess;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.cert.extensions.OCSPAcceptableResponses;
import com.rsa.certj.cert.extensions.OCSPNonce;
import com.rsa.certj.cert.extensions.OCSPServiceLocator;
import com.rsa.certj.cert.extensions.X509V3Extension;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.certj.provider.revocation.ocsp.OCSPCertID;
import com.rsa.certj.provider.revocation.ocsp.OCSPResponderInternal;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.random.RandomException;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_Signature;
import java.security.SecureRandom;
import java.util.Vector;

public final class OCSPRequest {
    private CertJ certJ;
    private byte[] nonce;
    private OCSPCertID[] certIDs;
    private X509V3Extension[] serviceLocatorExtension;
    private X509V3Extensions[] singleRequestExtensions;
    private X509V3Extensions requestExtensions;
    private OCSPResponderInternal responder;

    OCSPRequest(CertJ certJ, OCSPResponderInternal responder, Certificate[] certs) throws CertificateException, NotSupportedException {
        int n = certs.length;
        try {
            this.certJ = certJ;
            this.setRequestExtensions(responder);
            int responderFlags = responder.getFlags();
            if ((responderFlags & 1) == 0) {
                JSAFE_SecureRandom rand = certJ.getRandomObject();
                byte[] nonceValue = new byte[16];
                rand.generateRandomBytes(nonceValue, 0, 16);
                this.setNonce(nonceValue, 0, 16);
            }
            this.singleRequestExtensions = new X509V3Extensions[n];
            this.certIDs = new OCSPCertID[n];
            this.serviceLocatorExtension = new X509V3Extension[n];
            for (int i = 0; i < n; ++i) {
                AuthorityInfoAccess aia;
                X509Certificate thisCert = (X509Certificate)certs[i];
                X509Certificate thisCACert = responder.getResponderCACert(thisCert);
                this.certIDs[i] = new OCSPCertID(certJ, thisCACert, thisCert, responder.getRequestControl().getDigestAlgorithm());
                X500Name issuerName = thisCert.getIssuerName();
                X509V3Extensions extns = thisCert.getExtensions();
                if (extns == null || (aia = (AuthorityInfoAccess)extns.getExtensionByType(100)) == null) continue;
                this.serviceLocatorExtension[i] = new OCSPServiceLocator(issuerName, aia);
            }
            this.responder = responder;
        }
        catch (CertificateException ex) {
            throw new NotSupportedException(ex);
        }
        catch (NoServiceException ex) {
            throw new NotSupportedException(ex);
        }
        catch (RandomException ex) {
            throw new NotSupportedException(ex);
        }
        catch (NameException ex) {
            throw new NotSupportedException(ex);
        }
    }

    private void setRequestExtensions(OCSPResponderInternal responder) throws NotSupportedException {
        X509V3Extensions reqExt = responder.getRequestControl().getRequestExtensions();
        try {
            this.requestExtensions = reqExt != null ? (X509V3Extensions)reqExt.clone() : new X509V3Extensions(5);
            OCSPAcceptableResponses atRespExt = new OCSPAcceptableResponses();
            byte[] atResp = OCSPAcceptableResponses.ID_PKIX_OCSP_BASIC;
            int len = OCSPAcceptableResponses.ID_PKIX_OCSP_BASIC.length;
            atRespExt.addAcceptableResponse(atResp, 0, len);
            this.requestExtensions.addV3Extension(atRespExt);
        }
        catch (CloneNotSupportedException ex) {
            throw new NotSupportedException(ex);
        }
        catch (CertificateException ex) {
            throw new NotSupportedException(ex);
        }
    }

    void setSingleRequestExtensions(int i, X509V3Extensions exts) throws NotSupportedException {
        try {
            this.singleRequestExtensions[i] = (X509V3Extensions)exts.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new NotSupportedException(ex);
        }
    }

    byte[] getNonce() {
        return this.nonce;
    }

    int setNonce(byte[] nonceValue, int offset, int len) throws CertificateException {
        if (nonceValue == null || len == 0) {
            return 0;
        }
        this.nonce = new byte[len];
        System.arraycopy(nonceValue, offset, this.nonce, 0, len);
        OCSPNonce nonceExt = new OCSPNonce(this.nonce, 0, len);
        if (this.requestExtensions == null) {
            this.requestExtensions = new X509V3Extensions(5);
        }
        this.requestExtensions.addV3Extension(nonceExt);
        return len;
    }

    OCSPCertID getCertID(int i) {
        return this.certIDs[i];
    }

    byte[] encode(CertPathCtx pathCtx) throws NotSupportedException {
        byte[] returnDER;
        byte[] sigDER = null;
        X500Name signerName = null;
        try {
            X509Certificate signingCert = this.responder.getRequestControl().getSignerCert();
            if (signingCert != null) {
                signerName = signingCert.getSubjectName();
            }
            byte[] tbsDER = this.encodeTBSRequestDER(0, signerName, this.requestExtensions);
            if (signingCert != null) {
                sigDER = this.encodeRequestSignatureDER(this.certJ, pathCtx, this.responder, signingCert, tbsDER);
            }
            returnDER = this.encodeOCSPRequestDER(tbsDER, sigDER);
        }
        catch (Exception ex) {
            throw new NotSupportedException(ex);
        }
        return returnDER;
    }

    private byte[] encodeRequestSignatureDER(CertJ certJ, CertPathCtx pathCtx, OCSPResponderInternal responder, Certificate signerCert, byte[] tbsDER) throws NotSupportedException, ASN_Exception {
        byte[] returnDER;
        EndContainer anEnd = new EndContainer();
        try {
            JSAFE_PrivateKey privateKey = pathCtx.getDatabase().selectPrivateKeyByCertificate(signerCert);
            String sigAlg = responder.getSignatureAlgorithm();
            JSAFE_Signature signer = JSAFEFactory.getSignature(sigAlg, certJ.getDevice(), certJ);
            signer.signInit(privateKey, null, (SecureRandom)certJ.getRandomObject(), certJ.getPKCS11Sessions());
            signer.signUpdate(tbsDER, 0, tbsDER.length);
            byte[] signature = signer.signFinal();
            JSAFE_Signature sigObject = JSAFEFactory.getSignature(sigAlg, this.certJ.getDevice(), certJ);
            byte[] algOID = sigObject.getDERAlgorithmID();
            SequenceContainer seq = new SequenceContainer(0xA10000, true, 0);
            EncodedContainer algDER = new EncodedContainer(0, true, 0, algOID, 0, algOID.length);
            BitStringContainer sigDER = new BitStringContainer(0, true, 0, signature, 0, signature.length, signature.length * 8, false);
            ASN1Container certsDER = this.createCertsContainer(responder.getFlags(), responder.getRequestControl().getExtraCerts(), pathCtx, signerCert);
            ASN1Container[] asn1Def = new ASN1Container[]{seq, algDER, sigDER, certsDER, anEnd};
            ASN1Template sigTemplate = new ASN1Template(asn1Def);
            returnDER = this.asnEncode(sigTemplate);
        }
        catch (JSAFE_Exception ex) {
            throw new NotSupportedException((Exception)((Object)ex));
        }
        catch (CertJException ex) {
            throw new NotSupportedException(ex);
        }
        return returnDER;
    }

    private byte[] encodeRequestListDER() throws NotSupportedException {
        try {
            OfContainer requestList = null;
            for (int i = 0; i < this.certIDs.length; ++i) {
                X509V3Extensions extns;
                if (this.singleRequestExtensions[i] == null) {
                    if (this.serviceLocatorExtension[i] == null) {
                        extns = null;
                    } else {
                        extns = new X509V3Extensions(4);
                        extns.addV3Extension(this.serviceLocatorExtension[i]);
                    }
                } else if (this.serviceLocatorExtension[i] == null) {
                    extns = this.singleRequestExtensions[i];
                } else {
                    extns = (X509V3Extensions)this.singleRequestExtensions[i].clone();
                    extns.addV3Extension(this.serviceLocatorExtension[i]);
                }
                byte[] requestDER = this.encodeRequestDER(this.certIDs[i].encode(), extns);
                requestList = new OfContainer(0, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
                requestList.addContainer((ASN1Container)new EncodedContainer(0, true, 0, requestDER, 0, requestDER.length));
            }
            ASN1Container[] asn1Def = new ASN1Container[]{requestList};
            ASN1Template asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asnEncode(asn1TemplateValue);
        }
        catch (ASN_Exception ex) {
            throw new NotSupportedException((Exception)((Object)ex));
        }
        catch (CertificateException ex) {
            throw new NotSupportedException(ex);
        }
        catch (CloneNotSupportedException ex) {
            throw new NotSupportedException(ex);
        }
    }

    private byte[] encodeTBSRequestDER(int version, X500Name requestorName, X509V3Extensions requestExtensions) throws NotSupportedException, ASN_Exception {
        SequenceContainer seq = new SequenceContainer(0, true, 0);
        EndContainer anEnd = new EndContainer();
        try {
            EncodedContainer requestExtContainer;
            EncodedContainer requestorContainer;
            IntegerContainer versionContainer = version != 0 ? new IntegerContainer(0xA30000, true, 0, version) : new IntegerContainer(0xA30000, false, 0, 0);
            if (requestorName != null) {
                GeneralName genName = new GeneralName();
                genName.setGeneralName(requestorName, 5);
                int requestorNameDERLen = genName.getDERLen(0xA10001);
                byte[] requestorNameDER = new byte[requestorNameDERLen];
                genName.getDEREncoding(requestorNameDER, 0, 0xA10001);
                requestorContainer = new EncodedContainer(12288, true, 12288, requestorNameDER, 0, requestorNameDERLen);
            } else {
                requestorContainer = new EncodedContainer(0xA10001, false, 0, null, 0, 0);
            }
            byte[] requestListDER = this.encodeRequestListDER();
            EncodedContainer requestListContainer = new EncodedContainer(0, true, 0, requestListDER, 0, requestListDER.length);
            if (requestExtensions != null) {
                int requestExtDERLen = requestExtensions.getDERLen(10551298);
                byte[] requestExtDER = new byte[requestExtDERLen];
                requestExtensions.getDEREncoding(requestExtDER, 0, 10551298);
                requestExtContainer = new EncodedContainer(10551298, true, 0, requestExtDER, 0, requestExtDERLen);
            } else {
                requestExtContainer = new EncodedContainer(10551298, false, 0, null, 0, 0);
            }
            ASN1Container[] asn1Def = new ASN1Container[]{seq, versionContainer, requestorContainer, requestListContainer, requestExtContainer, anEnd};
            ASN1Template asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asnEncode(asn1TemplateValue);
        }
        catch (NameException ex) {
            throw new NotSupportedException(ex);
        }
    }

    private ASN1Container createCertsContainer(int flags, X509Certificate[] certs, CertPathCtx pathCtx, Certificate signerCert) throws NotSupportedException, ASN_Exception {
        int i;
        Vector<Certificate> certsToSend = new Vector<Certificate>();
        if ((flags & 2) == 0) {
            certsToSend.addElement(signerCert);
        }
        if ((flags & 4) != 0) {
            Vector<Certificate> certPath = new Vector<Certificate>();
            try {
                this.certJ.buildCertPath(pathCtx, signerCert, certPath, null, null, null);
                for (i = 0; i < certPath.size(); ++i) {
                    certsToSend.addElement(certPath.elementAt(i));
                }
            }
            catch (CertJException ex) {
                throw new ASN_Exception(ex.getMessage());
            }
        }
        if (certs != null) {
            for (int i2 = 0; i2 < certs.length; ++i2) {
                certsToSend.addElement(certs[i2]);
            }
        }
        if (certsToSend.isEmpty()) {
            return new EncodedContainer(0xA10000, false, 0, null, 0, 0);
        }
        OfContainer certsContainer = new OfContainer(0xA10000, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
        for (i = 0; i < certsToSend.size(); ++i) {
            Certificate cert = (Certificate)certsToSend.elementAt(i);
            byte[] certDER = new byte[((X509Certificate)cert).getDERLen(0)];
            try {
                ((X509Certificate)cert).getDEREncoding(certDER, 0, 0);
                certsContainer.addContainer((ASN1Container)new EncodedContainer(0, true, 0, certDER, 0, certDER.length));
                continue;
            }
            catch (CertificateException ex) {
                throw new NotSupportedException(ex);
            }
            catch (ASN_Exception ex) {
                throw new NotSupportedException((Exception)((Object)ex));
            }
        }
        return certsContainer;
    }

    private byte[] encodeRequestDER(byte[] certId, X509V3Extensions extensions) throws NotSupportedException, ASN_Exception {
        byte[] extDER = null;
        int extDERLen = 0;
        if (extensions != null) {
            extDERLen = extensions.getDERLen(0xA10000);
            extDER = new byte[extDERLen];
            extensions.getDEREncoding(extDER, 0, 0xA10000);
        }
        SequenceContainer seq = new SequenceContainer(0, true, 0);
        EncodedContainer certIdDER = new EncodedContainer(0, true, 0, certId, 0, certId.length);
        EncodedContainer requestExtDER = new EncodedContainer(0, true, 0, extDER, 0, extDERLen);
        EndContainer anEnd = new EndContainer();
        ASN1Container[] asn1Def = new ASN1Container[]{seq, certIdDER, requestExtDER, anEnd};
        ASN1Template asn1TemplateValue = new ASN1Template(asn1Def);
        return this.asnEncode(asn1TemplateValue);
    }

    private byte[] encodeOCSPRequestDER(byte[] tbsDER, byte[] sigDER) throws NotSupportedException, ASN_Exception {
        SequenceContainer seq = new SequenceContainer(0, true, 0);
        EncodedContainer tbsRequest = new EncodedContainer(0, true, 0, tbsDER, 0, tbsDER.length);
        EncodedContainer optionalSignature = sigDER == null ? new EncodedContainer(0xA10000, false, 0, null, 0, 0) : new EncodedContainer(0xA10000, true, 0, sigDER, 0, sigDER.length);
        EndContainer anEnd = new EndContainer();
        ASN1Container[] asn1Def = new ASN1Container[]{seq, tbsRequest, optionalSignature, anEnd};
        ASN1Template asn1TemplateValue = new ASN1Template(asn1Def);
        return this.asnEncode(asn1TemplateValue);
    }

    private byte[] asnEncode(ASN1Template asn1TemplateValue) throws NotSupportedException {
        try {
            int encodingLen = asn1TemplateValue.derEncodeInit();
            byte[] returnDER = new byte[encodingLen];
            int actualEncodingLen = asn1TemplateValue.derEncode(returnDER, 0);
            return (byte[])(encodingLen == actualEncodingLen ? returnDER : null);
        }
        catch (ASN_Exception ex) {
            throw new NotSupportedException((Exception)((Object)ex));
        }
    }
}

