/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.revocation.ocsp;

import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.provider.revocation.ocsp.OCSPRequestControl;

public class OCSPResponder
implements Cloneable {
    public static final int PROFILE_GENERIC = 0;
    public static final int PROFILE_VALICERT = 1;
    public static final int PROFILE_RSAKCA = 2;
    public static final int PROFILE_VERISIGN = 3;
    private static final int PROFILE_MAX = 3;
    public static final int FLAG_DISABLE_NONCES = 1;
    public static final int FLAG_DISABLE_CERT_SEND = 2;
    public static final int FLAG_ENABLE_CHAIN_SEND = 4;
    public static final int FLAG_RESPONDER_NOCHECK = 8;
    private int profile;
    private int flags;
    private String[] destList;
    private String[] proxyList;
    private OCSPRequestControl requestControl;
    private X509Certificate responderCert;
    private X509Certificate[] responderCACerts;
    private DatabaseService database;
    private int timeTolerance;

    public OCSPResponder(int profile, int flags, String[] destList, String[] proxyList, OCSPRequestControl requestControl, X509Certificate responderCert, X509Certificate[] responderCACerts, DatabaseService database, int tolerance) throws InvalidParameterException {
        int i;
        if (profile < 0 || profile > 3) {
            throw new InvalidParameterException("OCSPResponder.profile");
        }
        this.profile = profile;
        if ((flags & 4) != 0 && (flags & 2) != 0) {
            throw new InvalidParameterException("FLAG_ENABLE_CHAIN_SEND && FLAG_DISABLE_CERT_SEND incompatible");
        }
        this.flags = flags;
        if (destList == null) {
            this.destList = null;
        } else {
            this.destList = new String[destList.length];
            for (i = 0; i < destList.length; ++i) {
                if (destList[i] == null) continue;
                this.destList[i] = destList[i];
            }
        }
        if (proxyList == null) {
            this.proxyList = null;
        } else {
            this.proxyList = new String[proxyList.length];
            for (i = 0; i < proxyList.length; ++i) {
                if (proxyList[i] == null) continue;
                this.proxyList[i] = proxyList[i];
            }
        }
        try {
            this.requestControl = requestControl == null ? null : (OCSPRequestControl)requestControl.clone();
            X509Certificate x509Certificate = this.responderCert = responderCert == null ? null : (X509Certificate)responderCert.clone();
            if (responderCACerts == null) {
                throw new InvalidParameterException("responderCACerts == null");
            }
            this.responderCACerts = new X509Certificate[responderCACerts.length];
            for (i = 0; i < responderCACerts.length; ++i) {
                if (responderCACerts[i] == null) {
                    throw new InvalidParameterException("responderCACerts[" + i + "] == null");
                }
                this.responderCACerts[i] = (X509Certificate)responderCACerts[i].clone();
            }
        }
        catch (CloneNotSupportedException ex) {
            throw new InvalidParameterException(ex);
        }
        this.database = database;
        this.timeTolerance = tolerance;
    }

    public OCSPResponder(OCSPRequestControl requestControl, X509Certificate[] responderCACerts) throws InvalidParameterException {
        try {
            this.profile = 0;
            this.flags = 0;
            OCSPRequestControl oCSPRequestControl = this.requestControl = requestControl == null ? null : (OCSPRequestControl)requestControl.clone();
            if (responderCACerts == null) {
                throw new InvalidParameterException("responderCACerts == null");
            }
            this.responderCACerts = new X509Certificate[responderCACerts.length];
            for (int i = 0; i < responderCACerts.length; ++i) {
                if (responderCACerts[i] == null) {
                    throw new InvalidParameterException("responderCACerts[" + i + "] == null");
                }
                this.responderCACerts[i] = (X509Certificate)responderCACerts[i].clone();
            }
        }
        catch (CloneNotSupportedException ex) {
            throw new InvalidParameterException(ex);
        }
        this.database = null;
        this.timeTolerance = 0;
    }

    public OCSPResponder(OCSPResponder responder) throws InvalidParameterException {
        int i;
        if (responder == null) {
            throw new InvalidParameterException("responder == null");
        }
        this.profile = responder.getProfile();
        this.flags = responder.getFlags();
        String[] localDestList = responder.getDestList();
        if (localDestList == null) {
            this.destList = null;
        } else {
            int destListLen = localDestList.length;
            this.destList = new String[destListLen];
            for (int i2 = 0; i2 < destListLen; ++i2) {
                if (localDestList[i2] == null) continue;
                this.destList[i2] = localDestList[i2];
            }
        }
        String[] tmpProxyList = responder.getProxyList();
        if (tmpProxyList == null) {
            this.proxyList = null;
        } else {
            int tmpProxyListLen = tmpProxyList.length;
            this.proxyList = new String[tmpProxyListLen];
            for (i = 0; i < tmpProxyListLen; ++i) {
                if (tmpProxyList[i] == null) continue;
                this.proxyList[i] = tmpProxyList[i];
            }
        }
        try {
            this.requestControl = responder.getRequestControl() == null ? null : (OCSPRequestControl)responder.getRequestControl().clone();
            this.responderCert = responder.getResponderCert() == null ? null : (X509Certificate)responder.getResponderCert().clone();
            X509Certificate[] responderCACerts = responder.getResponderCACerts();
            if (responderCACerts == null) {
                throw new InvalidParameterException("OCSPResponder.responderCACerts");
            }
            this.responderCACerts = new X509Certificate[responderCACerts.length];
            for (i = 0; i < responderCACerts.length; ++i) {
                if (responderCACerts[i] == null) {
                    throw new InvalidParameterException("responderCACerts[" + i + "] == null");
                }
                this.responderCACerts[i] = (X509Certificate)responderCACerts[i].clone();
            }
        }
        catch (CloneNotSupportedException ex) {
            throw new InvalidParameterException(ex);
        }
        this.database = responder.getDatabase();
        this.timeTolerance = responder.getTimeTolerance();
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return new OCSPResponder(this);
        }
        catch (InvalidParameterException ex) {
            throw new CloneNotSupportedException(ex.getMessage());
        }
    }

    public int getProfile() {
        return this.profile;
    }

    public int getFlags() {
        return this.flags;
    }

    public String[] getDestList() {
        return this.destList;
    }

    public String[] getProxyList() {
        return this.proxyList;
    }

    public OCSPRequestControl getRequestControl() {
        return this.requestControl;
    }

    public X509Certificate getResponderCert() {
        return this.responderCert;
    }

    public X509Certificate[] getResponderCACerts() {
        return this.responderCACerts;
    }

    protected X509Certificate getResponderCACert(X509Certificate cert) {
        if (cert == null) {
            return null;
        }
        for (int i = 0; i < this.responderCACerts.length; ++i) {
            if (!cert.getIssuerName().equals(this.responderCACerts[i].getSubjectName())) continue;
            return this.responderCACerts[i];
        }
        return null;
    }

    protected X509Certificate getResponderCACert(X509Certificate cert, String loc) {
        if (cert == null || loc == null || this.destList == null) {
            return null;
        }
        for (int j = 0; j < this.destList.length; ++j) {
            X509Certificate caCert;
            if (!loc.equals(this.destList[j]) || (caCert = this.getResponderCACert(cert)) == null) continue;
            return caCert;
        }
        return null;
    }

    public void setProfile(int profile) throws InvalidParameterException {
        if (profile < 0 || profile > 3) {
            throw new InvalidParameterException("OCSPResponder.profile");
        }
        this.profile = profile;
    }

    public void setFlags(int flags) throws InvalidParameterException {
        this.flags = flags;
    }

    public void setProxyList(String[] proxyList) throws InvalidParameterException {
        if (proxyList == null) {
            this.proxyList = null;
        } else {
            this.proxyList = new String[proxyList.length];
            for (int i = 0; i < proxyList.length; ++i) {
                if (proxyList[i] == null) {
                    throw new InvalidParameterException("proxyList[" + i + "] == null");
                }
                this.proxyList[i] = proxyList[i];
            }
        }
    }

    public void setRequestControl(OCSPRequestControl requestControl) throws InvalidParameterException {
        try {
            this.requestControl = requestControl == null ? null : (OCSPRequestControl)requestControl.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InvalidParameterException(ex);
        }
    }

    public void setResponderCACerts(X509Certificate[] responderCACerts) throws InvalidParameterException {
        if (responderCACerts == null) {
            throw new InvalidParameterException("responderCACerts");
        }
        try {
            for (int i = 0; i < responderCACerts.length; ++i) {
                if (responderCACerts[i] == null) {
                    throw new InvalidParameterException("responderCACerts[" + i + "] == null");
                }
                this.responderCACerts[i] = (X509Certificate)responderCACerts[i].clone();
            }
        }
        catch (CloneNotSupportedException ex) {
            throw new InvalidParameterException(ex);
        }
    }

    public void setDatabase(DatabaseService database) throws InvalidParameterException {
        this.database = database;
    }

    public DatabaseService getDatabase() {
        return this.database;
    }

    public void setTimeTolerance(int timeTolerance) {
        this.timeTolerance = timeTolerance;
    }

    public int getTimeTolerance() {
        return this.timeTolerance;
    }
}

