/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.revocation.ocsp;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.EnumeratedContainer;
import com.rsa.asn1.GenTimeContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJException;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.ExtendedKeyUsage;
import com.rsa.certj.cert.extensions.OCSPAcceptableResponses;
import com.rsa.certj.cert.extensions.OCSPNonce;
import com.rsa.certj.cert.extensions.X509V3Extension;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.certj.provider.revocation.ocsp.OCSPCertID;
import com.rsa.certj.provider.revocation.ocsp.OCSPEvidence;
import com.rsa.certj.provider.revocation.ocsp.OCSPRequest;
import com.rsa.certj.provider.revocation.ocsp.OCSPResponderInternal;
import com.rsa.certj.provider.revocation.ocsp.OCSPRevocationInfo;
import com.rsa.certj.provider.revocation.ocsp.OCSPutil;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.revocation.CertRevocationInfo;
import com.rsa.certj.spi.revocation.CertStatusException;
import com.rsa.jsafe.JSAFE_Signature;
import java.util.Date;
import java.util.Vector;

public final class OCSPResponse {
    private CertJ certJ;
    private DatabaseService database;
    private byte[] nonce;
    private String sigAlg;
    private OCSPCertID[] certIDs;
    private X509Certificate checkCert;
    private X509Certificate caCert;
    private X509Certificate designatedResponder;
    private X509Certificate actualResponder;
    private Vector<Certificate> potentialResponderCerts;
    private long validationTime;
    private int tolerance;
    private CertRevocationInfo[] revInfos;
    private boolean responderNoCheck;
    private static final int OCSP_STATUS_SUCCESSFUL = 0;
    private static final int OCSP_STATUS_MALFORMED_REQUEST = 1;
    private static final int OCSP_STATUS_INTERNAL_ERROR = 2;
    private static final int OCSP_STATUS_TRY_LATER = 3;
    private static final int OCSP_STATUS_SIG_REQUIRED = 5;
    private static final int OCSP_STATUS_UNAUTHORIZED = 6;
    private static final int NO_SPECIAL = 0;
    private static final int ZERO_OFFSET = 0;

    OCSPResponse(CertJ certj, OCSPResponderInternal responder, X509Certificate checkCert) {
        this.certJ = certj;
        this.checkCert = checkCert;
        this.designatedResponder = responder.getResponderCert();
        this.tolerance = responder.getTimeTolerance();
        this.database = responder.getDatabase();
        this.caCert = responder.getResponderCACert(checkCert);
        this.responderNoCheck = (responder.getFlags() & 8) != 0;
    }

    CertRevocationInfo getRevocationInfo(OCSPCertID certID) throws NotSupportedException {
        if (this.certIDs == null) {
            return null;
        }
        byte[] ref = certID.encode();
        for (int i = 0; i < this.certIDs.length; ++i) {
            if (!CertJUtils.byteArraysEqual(this.certIDs[i].encode(), ref)) continue;
            return this.revInfos[i];
        }
        return null;
    }

    byte[] getNonce() {
        return this.nonce;
    }

    private void checkStatus(int status) throws CertStatusException {
        switch (status) {
            case 0: {
                break;
            }
            case 1: {
                throw new CertStatusException("OCSP_STATUS_MALFORMED_REQUEST");
            }
            case 2: {
                throw new CertStatusException("OCSP_STATUS_INTERNAL_ERROR");
            }
            case 3: {
                throw new CertStatusException("OCSP_STATUS_TRY_LATER");
            }
            case 5: {
                throw new CertStatusException("OCSP_STATUS_SIG_REQUIRED");
            }
            case 6: {
                throw new CertStatusException("OCSP_STATUS_UNAUTHORIZED");
            }
            default: {
                throw new CertStatusException("OCSP_STATUS UNKNOWN!!!");
            }
        }
    }

    private boolean verifySignature(Certificate cert, String sigAlg, byte[] data, int dataOffset, int dataLen, byte[] sigData, int sigOffset, int sigLen) {
        boolean verified;
        try {
            String device = this.certJ.getDevice();
            JSAFE_Signature verifier = JSAFEFactory.getSignature(sigAlg, device, this.certJ);
            verifier.verifyInit(cert.getSubjectPublicKey(device), null, null, this.certJ.getPKCS11Sessions());
            verifier.verifyUpdate(data, dataOffset, dataLen);
            byte[] localSig = new byte[sigLen];
            System.arraycopy(sigData, sigOffset, localSig, 0, sigLen);
            verified = verifier.verifyFinal(localSig, 0, sigLen);
            verifier.clearSensitiveData();
        }
        catch (Exception ex) {
            verified = false;
        }
        return verified;
    }

    void decode(CertPathCtx pathCtx, byte[] responseBER, OCSPRequest ocspReq) throws ASN_Exception, CertStatusException {
        EndContainer anEnd = new EndContainer();
        SequenceContainer orSeq = new SequenceContainer(0);
        EnumeratedContainer respStatus = new EnumeratedContainer(0);
        EncodedContainer responseBytesBER = new EncodedContainer(10563584);
        SequenceContainer rbSeq = new SequenceContainer(0xA10000);
        OIDContainer respTypeOID = new OIDContainer(0x1000000);
        OctetStringContainer responseString = new OctetStringContainer(0);
        ASN1Container[] defOCSPResponse = new ASN1Container[]{orSeq, respStatus, responseBytesBER, anEnd};
        ASN1Container[] defResponseBytes = new ASN1Container[]{rbSeq, respTypeOID, responseString, anEnd};
        Date t = pathCtx.getValidationTime();
        this.validationTime = t == null ? System.currentTimeMillis() : t.getTime();
        ASN1.berDecode((byte[])responseBER, (int)0, (ASN1Container[])defOCSPResponse);
        int responseStatus = respStatus.getValueAsInt();
        this.checkStatus(responseStatus);
        if (!responseBytesBER.dataPresent) {
            throw new CertStatusException("OCSPResponse: missing status=OK responseBytes!");
        }
        ASN1.berDecode((byte[])responseBytesBER.data, (int)responseBytesBER.dataOffset, (ASN1Container[])defResponseBytes);
        if (!CertJUtils.byteArraysEqual(respTypeOID.data, respTypeOID.dataOffset, respTypeOID.dataLen, OCSPAcceptableResponses.ID_PKIX_OCSP_BASIC)) {
            throw new CertStatusException("!ID_PKIX_OCSP_BASIC");
        }
        this.decodeBasicResponse(pathCtx, responseString.data, responseString.dataOffset);
    }

    private void decodeBasicResponse(CertPathCtx pathCtx, byte[] ber, int offset) throws ASN_Exception, CertStatusException {
        EndContainer anEnd = new EndContainer();
        SequenceContainer outerSeq = new SequenceContainer(0);
        EncodedContainer tbsBER = new EncodedContainer(12288);
        EncodedContainer sigAlgBER = new EncodedContainer(65280);
        BitStringContainer sigBits = new BitStringContainer(0);
        OfContainer certs = new OfContainer(0xA10000, 12288, (ASN1Container)new EncodedContainer(12288));
        ASN1Container[] def = new ASN1Container[]{outerSeq, tbsBER, sigAlgBER, sigBits, certs, anEnd};
        SequenceContainer sigSeq = new SequenceContainer(0);
        OIDContainer sigOID = new OIDContainer(0x1000000);
        EncodedContainer sigParams = new EncodedContainer(65536);
        ASN1Container[] defSigAlg = new ASN1Container[]{sigSeq, sigOID, sigParams, anEnd};
        ASN1.berDecode((byte[])ber, (int)offset, (ASN1Container[])def);
        ASN1.berDecode((byte[])sigAlgBER.data, (int)sigAlgBER.dataOffset, (ASN1Container[])defSigAlg);
        try {
            JSAFE_Signature sg = JSAFEFactory.getSignature(sigAlgBER.data, sigAlgBER.dataOffset, "Java", this.certJ);
            this.sigAlg = sg.getDigestAlgorithm() + "/" + sg.getSignatureAlgorithm() + "/" + sg.getPaddingScheme();
            if (this.database != null) {
                for (int i = 0; i < certs.getContainerCount(); ++i) {
                    ASN1Container c = certs.containerAt(i);
                    X509Certificate crt = new X509Certificate(c.data, c.dataOffset, c.dataLen);
                    this.database.insertCertificate(crt);
                }
            }
            this.decodeResponseData(pathCtx, tbsBER.data, tbsBER.dataOffset);
        }
        catch (CertStatusException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CertStatusException(ex);
        }
        if (!this.verifyResponse(pathCtx, (ASN1Container)tbsBER, (ASN1Container)sigBits)) {
            throw new CertStatusException("Unable to verify identity of responder");
        }
    }

    private void decodeResponseData(CertPathCtx pathCtx, byte[] ber, int offset) throws ASN_Exception, NoServiceException, CertStatusException, NotSupportedException {
        EndContainer anEnd = new EndContainer();
        SequenceContainer seq = new SequenceContainer(0);
        IntegerContainer version = new IntegerContainer(0xA20000);
        EncodedContainer respIDBER = new EncodedContainer(65280);
        GenTimeContainer producedAt = new GenTimeContainer(0);
        OfContainer responses = new OfContainer(0, 12288, (ASN1Container)new EncodedContainer(12288));
        EncodedContainer extsBER = new EncodedContainer(130816);
        ASN1Container[] def = new ASN1Container[]{seq, version, respIDBER, producedAt, responses, extsBER, anEnd};
        ASN1.berDecode((byte[])ber, (int)offset, (ASN1Container[])def);
        if (version.dataPresent && version.getValueAsInt() != 0) {
            throw new CertStatusException("0 != " + version.getValueAsInt());
        }
        this.decodeResponderID(pathCtx.getDatabase(), respIDBER.data, respIDBER.dataOffset);
        Date producedAt1 = new Date(producedAt.theTime.getTime());
        this.decodeSingleResponses(responses, producedAt1);
        try {
            if (extsBER.dataPresent) {
                X509V3Extensions responseExtensions = new X509V3Extensions(extsBER.data, extsBER.dataOffset, 0xA00001, 5);
                int n = responseExtensions.getExtensionCount();
                for (int i = 0; i < n; ++i) {
                    X509V3Extension ext = responseExtensions.getExtensionByIndex(i);
                    int extType = ext.getExtensionType();
                    if (ext.getCriticality()) {
                        if (extType == 120) continue;
                        throw new CertStatusException("unknown critical OCSP response extension");
                    }
                    if (extType != 120) continue;
                    OCSPNonce non = (OCSPNonce)ext;
                    this.nonce = non.getNonceValue();
                }
            }
        }
        catch (CertificateException ex) {
            throw new CertStatusException(ex);
        }
    }

    private void decodeResponderID(DatabaseService db, byte[] ber, int offset) throws ASN_Exception, NoServiceException, CertStatusException {
        block7: {
            EndContainer anEnd = new EndContainer();
            ChoiceContainer choice = new ChoiceContainer(0);
            EncodedContainer byName = new EncodedContainer(10498049);
            EncodedContainer byKeyHash = new EncodedContainer(10551042);
            ASN1Container[] defChoice = new ASN1Container[]{choice, byName, byKeyHash, anEnd};
            ASN1.berDecode((byte[])ber, (int)offset, (ASN1Container[])defChoice);
            this.potentialResponderCerts = new Vector();
            try {
                if (byName.dataPresent) {
                    X500Name name = new X500Name(byName.data, byName.dataOffset, 0xA00001);
                    db.selectCertificateBySubject(name, this.potentialResponderCerts);
                    break block7;
                }
                if (byKeyHash.dataPresent) {
                    OctetStringContainer os = new OctetStringContainer(0xA00002);
                    ASN1Container[] def2 = new ASN1Container[]{os};
                    ASN1.berDecode((byte[])ber, (int)offset, (ASN1Container[])def2);
                    OCSPutil.selectCertificateByKeyHash(this.certJ, db, os.data, os.dataOffset, os.dataLen, this.potentialResponderCerts);
                    break block7;
                }
                throw new CertStatusException("unknown ResponderID CHOICE");
            }
            catch (CertificateException ex) {
                throw new CertStatusException(ex);
            }
            catch (NameException ex) {
                throw new CertStatusException(ex);
            }
            catch (DatabaseException ex) {
                throw new CertStatusException(ex);
            }
            catch (InvalidParameterException ex) {
                throw new CertStatusException(ex);
            }
        }
    }

    private OCSPRevocationInfo decodeRevocationInfo(byte[] ber, int offset, CertRevocationInfo ri) throws ASN_Exception, NotSupportedException {
        ChoiceContainer certStatus = new ChoiceContainer(0);
        EncodedContainer statGood = new EncodedContainer(0x800500);
        EncodedContainer statRevoked = new EncodedContainer(8400897);
        EncodedContainer statUnknown = new EncodedContainer(8389890);
        EndContainer anEnd = new EndContainer();
        ASN1Container[] def = new ASN1Container[]{certStatus, statGood, statRevoked, statUnknown, anEnd};
        OCSPRevocationInfo ori = null;
        ASN1.berDecode((byte[])ber, (int)offset, (ASN1Container[])def);
        if (statGood.dataPresent) {
            ri.setStatus(0);
        } else if (statRevoked.dataPresent) {
            SequenceContainer riSeq = new SequenceContainer(0x800001);
            GenTimeContainer revTime = new GenTimeContainer(0);
            EncodedContainer reason = new EncodedContainer(10616576);
            ASN1Container[] defReason = new ASN1Container[]{riSeq, revTime, reason, anEnd};
            ASN1.berDecode((byte[])statRevoked.data, (int)statRevoked.dataOffset, (ASN1Container[])defReason);
            ori = new OCSPRevocationInfo(revTime.theTime.getTime());
            if (reason.dataPresent) {
                EnumeratedContainer code = new EnumeratedContainer(0xA0FF00);
                ASN1Container[] defCode = new ASN1Container[]{code};
                ASN1.berDecode((byte[])reason.data, (int)reason.dataOffset, (ASN1Container[])defCode);
                ori.setReasonCode(code.getValueAsInt());
            }
            ri.setStatus(1);
        } else if (statUnknown.dataPresent) {
            ri.setStatus(2);
        } else {
            throw new NotSupportedException("CertStatus");
        }
        return ori;
    }

    private boolean checkTime(long vt, int tolerance, OCSPEvidence ev) {
        long t = ev.getThisUpdate().getTime() - (long)tolerance * 1000L;
        if (vt < t) {
            return false;
        }
        Date d = ev.getNextUpdate();
        return d == null || vt <= d.getTime() + (long)tolerance * 1000L;
    }

    private void decodeSingleResponses(OfContainer srCont, Date producedAt) throws ASN_Exception, NotSupportedException {
        EndContainer anEnd = new EndContainer();
        SequenceContainer seq = new SequenceContainer(0);
        EncodedContainer certIDBER = new EncodedContainer(65280);
        EncodedContainer statusBER = new EncodedContainer(65280);
        GenTimeContainer thisUpdate = new GenTimeContainer(0);
        GenTimeContainer nextUpdate = new GenTimeContainer(0xA10000);
        EncodedContainer exts = new EncodedContainer(130816);
        ASN1Container[] def = new ASN1Container[]{seq, certIDBER, statusBER, thisUpdate, nextUpdate, exts, anEnd};
        int n = srCont.getContainerCount();
        this.certIDs = new OCSPCertID[n];
        this.revInfos = new CertRevocationInfo[n];
        for (int i = 0; i < n; ++i) {
            ASN1Container sr = srCont.containerAt(i);
            ASN1.berDecode((byte[])sr.data, (int)sr.dataOffset, (ASN1Container[])def);
            this.revInfos[i] = new CertRevocationInfo();
            OCSPRevocationInfo ori = this.decodeRevocationInfo(statusBER.data, statusBER.dataOffset, this.revInfos[i]);
            try {
                X509V3Extensions x509v3exts;
                Date nextUpdateDate;
                Date thisUpdateDate = new Date(thisUpdate.theTime.getTime());
                Date date = nextUpdateDate = nextUpdate.dataPresent ? new Date(nextUpdate.theTime.getTime()) : null;
                if (exts.dataPresent && exts.data != null) {
                    x509v3exts = new X509V3Extensions(exts.data, exts.dataOffset, 0xA00001, 4);
                    int extCount = x509v3exts.getExtensionCount();
                    for (int j = 0; j < extCount; ++j) {
                        X509V3Extension ext = x509v3exts.getExtensionByIndex(j);
                        if (!ext.isExtensionType(-1) || !ext.getCriticality()) continue;
                        throw new NotSupportedException("Unknown critical extension.");
                    }
                } else {
                    x509v3exts = null;
                }
                OCSPEvidence ev = new OCSPEvidence(0, producedAt, thisUpdateDate, nextUpdateDate, x509v3exts, ori);
                this.revInfos[i].setEvidence(ev);
                this.revInfos[i].setType(2);
                this.certIDs[i] = new OCSPCertID(this.certJ, certIDBER.data, certIDBER.dataOffset, certIDBER.dataLen);
                if (this.checkTime(this.validationTime, this.tolerance, ev)) continue;
                this.revInfos[i].setStatus(2);
                continue;
            }
            catch (CertificateException ex) {
                throw new NotSupportedException(ex);
            }
            catch (InvalidParameterException ex) {
                throw new NotSupportedException(ex);
            }
        }
    }

    private boolean verifyResponse(CertPathCtx pathCtx, ASN1Container tbs, ASN1Container sigBits) {
        boolean valid = false;
        CertPathCtx actualPathCtx = pathCtx;
        for (int i = 0; i < this.potentialResponderCerts.size(); ++i) {
            this.actualResponder = (X509Certificate)this.potentialResponderCerts.elementAt(0);
            if (!this.verifySignature(this.actualResponder, this.sigAlg, tbs.data, tbs.dataOffset, tbs.dataLen, sigBits.data, sigBits.dataOffset, sigBits.dataLen)) continue;
            try {
                if (this.checkCert.equals(this.actualResponder)) {
                    if (this.responderNoCheck) {
                        actualPathCtx = new CertPathCtx(pathCtx.getPathOptions() | 4, pathCtx.getTrustedCerts(), pathCtx.getPolicies(), pathCtx.getValidationTime(), pathCtx.getDatabase());
                    } else {
                        return false;
                    }
                }
                valid = this.certJ.buildCertPath(actualPathCtx, this.actualResponder, null, null, null, null);
            }
            catch (CertJException ex) {
                valid = false;
            }
            if (!valid) continue;
            if (this.actualResponder.equals(this.caCert)) {
                return true;
            }
            if (this.isOCSPDelegatedResponder(this.actualResponder, this.caCert)) {
                return true;
            }
            if (this.actualResponder.equals(this.designatedResponder)) {
                return true;
            }
            valid = false;
        }
        return valid;
    }

    private boolean isOCSPDelegatedResponder(X509Certificate cert, X509Certificate caCert) {
        X509V3Extensions exts = cert.getExtensions();
        if (exts == null || exts.getExtensionCount() == 0) {
            return false;
        }
        try {
            ExtendedKeyUsage eku = (ExtendedKeyUsage)exts.getExtensionByType(37);
            if (eku == null) {
                return false;
            }
            for (int i = 0; i < eku.getKeyUsageCount(); ++i) {
                if (!CertJUtils.byteArraysEqual(ExtendedKeyUsage.ID_KP_OCSP_SIGNING, eku.getExtendedKeyUsage(i))) continue;
                return true;
            }
        }
        catch (CertificateException ex) {
            return false;
        }
        return this.actualResponder.getIssuerName().equals(caCert.getSubjectName());
    }
}

