/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.spi.db;

import com.rsa.certj.NotSupportedException;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.util.Date;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface DatabaseInterface {
    public void insertCertificate(Certificate var1) throws NotSupportedException, DatabaseException;

    public void insertCRL(CRL var1) throws NotSupportedException, DatabaseException;

    public void insertPrivateKeyByCertificate(Certificate var1, JSAFE_PrivateKey var2) throws NotSupportedException, DatabaseException;

    public void insertPrivateKeyByPublicKey(JSAFE_PublicKey var1, JSAFE_PrivateKey var2) throws NotSupportedException, DatabaseException;

    public int selectCertificateByIssuerAndSerialNumber(X500Name var1, byte[] var2, Vector<Certificate> var3) throws NotSupportedException, DatabaseException;

    public int selectCertificateBySubject(X500Name var1, Vector<Certificate> var2) throws NotSupportedException, DatabaseException;

    public int selectCertificateByExtensions(X500Name var1, X509V3Extensions var2, Vector<Certificate> var3) throws NotSupportedException, DatabaseException;

    public boolean isCertificateIteratorSetup() throws NotSupportedException, DatabaseException;

    public void setupCertificateIterator() throws NotSupportedException, DatabaseException;

    public Certificate firstCertificate() throws NotSupportedException, DatabaseException;

    public Certificate nextCertificate() throws NotSupportedException, DatabaseException;

    public boolean hasMoreCertificates() throws NotSupportedException, DatabaseException;

    public int selectCRLByIssuerAndTime(X500Name var1, Date var2, Vector<CRL> var3) throws NotSupportedException, DatabaseException;

    public boolean isCRLIteratorSetup() throws NotSupportedException, DatabaseException;

    public void setupCRLIterator() throws NotSupportedException, DatabaseException;

    public CRL firstCRL() throws NotSupportedException, DatabaseException;

    public CRL nextCRL() throws NotSupportedException, DatabaseException;

    public boolean hasMoreCRLs() throws NotSupportedException, DatabaseException;

    public JSAFE_PrivateKey selectPrivateKeyByCertificate(Certificate var1) throws NotSupportedException, DatabaseException;

    public JSAFE_PrivateKey selectPrivateKeyByPublicKey(JSAFE_PublicKey var1) throws NotSupportedException, DatabaseException;

    public boolean isPrivateKeyIteratorSetup() throws NotSupportedException, DatabaseException;

    public void setupPrivateKeyIterator() throws NotSupportedException, DatabaseException;

    public JSAFE_PrivateKey firstPrivateKey() throws NotSupportedException, DatabaseException;

    public JSAFE_PrivateKey nextPrivateKey() throws NotSupportedException, DatabaseException;

    public boolean hasMorePrivateKeys() throws NotSupportedException, DatabaseException;

    public void deleteCertificate(X500Name var1, byte[] var2) throws NotSupportedException, DatabaseException;

    public void deleteCRL(X500Name var1, Date var2) throws NotSupportedException, DatabaseException;

    public void deletePrivateKeyByCertificate(Certificate var1) throws NotSupportedException, DatabaseException;

    public void deletePrivateKeyByPublicKey(JSAFE_PublicKey var1) throws NotSupportedException, DatabaseException;
}

