/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.spi.revocation;

public final class CertRevocationInfo {
    public static final int CERT_NOT_REVOKED = 0;
    public static final int CERT_REVOKED = 1;
    public static final int CERT_REVOCATION_UNKNOWN = 2;
    public static final int CRE_NONE = 0;
    public static final int CRE_CRL = 1;
    public static final int CRE_OCSP = 2;
    private int status;
    private int evidenceType;
    private Object evidence;

    public CertRevocationInfo() {
        this.status = 2;
        this.evidenceType = 0;
        this.evidence = null;
    }

    public CertRevocationInfo(int status, int evidenceType, Object evidence) {
        this.status = status;
        this.evidenceType = evidenceType;
        this.evidence = evidence;
    }

    public String toString() {
        String s3;
        String s2;
        String s1;
        switch (this.status) {
            case 0: {
                s1 = "CERT_NOT_REVOKED";
                break;
            }
            case 1: {
                s1 = "CERT_REVOKED";
                break;
            }
            case 2: {
                s1 = "CERT_REVOCATION_UNKNOWN";
                break;
            }
            default: {
                s1 = "???";
            }
        }
        switch (this.evidenceType) {
            case 0: {
                s2 = "CRE_NONE";
                s3 = "null";
                break;
            }
            case 1: {
                s2 = "CRE_CRL";
                s3 = this.evidence.toString();
                break;
            }
            case 2: {
                s2 = "CRE_OCSP";
                s3 = this.evidence.toString();
                break;
            }
            default: {
                s2 = "???";
                s3 = "???";
            }
        }
        return "{status=" + s1 + ",evidenceType=" + s2 + ",evidence=" + s3 + "}";
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setType(int type) {
        this.evidenceType = type;
    }

    public void setEvidence(Object evidence) {
        this.evidence = evidence;
    }

    public int getStatus() {
        return this.status;
    }

    public int getType() {
        return this.evidenceType;
    }

    public Object getEvidence() {
        return this.evidence;
    }
}

