/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.encryption;

import com.adobe.internal.pdftoolkit.core.encryption.DecryptedStatePBSH;
import com.adobe.internal.pdftoolkit.core.encryption.EncryptionKeyCalc;
import com.adobe.internal.pdftoolkit.core.encryption.EncryptionKeyImpl;
import com.adobe.internal.pdftoolkit.core.encryption.JCERC4EncryptionHandler;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityAuthorizationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.permissionprovider.PermissionProvider;
import com.adobe.internal.pdftoolkit.core.permissionprovider.PermissionProviderStandard;
import com.adobe.internal.pdftoolkit.core.securityframework.DecryptedState;
import com.adobe.internal.pdftoolkit.core.securityframework.EncryptionHandler;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityHandler;
import com.adobe.internal.pdftoolkit.core.securityframework.impl.SecurityProvidersImpl;
import com.adobe.internal.pdftoolkit.core.util.ByteOps;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class PBSHStandard
implements SecurityHandler {
    protected EncryptionHandler rc4encrypt;
    protected MessageDigest md5Digest;
    protected MessageDigest sha256Digest;
    protected MessageDigest sha384Digest;
    protected MessageDigest sha512Digest;
    protected EncryptionHandler mainEncryption;
    private DecryptedState decryptedState;
    protected boolean decryptedUsingState = false;
    protected SecurityProvidersImpl secProviders;
    protected Provider rc4Provider;
    private SecureRandom randomGenerator;
    private Cipher aesCipher = null;
    private boolean cipherFunctionsSetUp = false;
    protected byte[] encryptKey = null;
    private byte[] zeroFill = null;
    protected byte[] password;
    protected byte[] owner;
    protected byte[] user;
    protected byte[] userPW = null;
    protected byte[] encryptedUser;
    protected byte[] encryptedOwner;
    protected byte[] encryptedUserEncryption;
    protected byte[] encryptedOwnerEncryption;
    protected int revision;
    protected int length;
    protected Number grantedPerms = null;
    protected Number requestedPerms = null;
    protected Map requestedEncryption;
    protected boolean encryptMetadata;
    protected boolean ownerDefined = false;
    protected boolean secure = false;
    protected boolean isEFF = false;
    protected byte[] curDocID = null;
    protected static final Integer allPerms = -1028;
    private static final int internalBitsMask = -4;
    static final String USER = "U";
    static final String OWNER = "O";
    static final String USER_ENCRYPTION = "UE";
    static final String OWNER_ENCRYPTION = "OE";
    static final String REVISION = "R";
    static final String PERMISSIONS = "P";
    static final String PERMS = "Perms";
    static final String METADATA = "EncryptMetadata";
    protected static final byte[] emptyPassword = new byte[0];
    protected static final byte[] padding = new byte[]{40, -65, 78, 94, 78, 117, -118, 65, 100, 0, 78, 86, -1, -6, 1, 8, 46, 46, 0, -74, -48, 104, 62, -128, 47, 12, -87, -2, 100, 83, 105, 122};
    private static final int CryptPasswordMaxLengthR5 = 32;
    private static final int CryptKeySaltLengthR5 = 8;
    private static final int nPermStrChars = 16;

    public PBSHStandard(byte[] owner, byte[] user, Map encrypt, PermissionProvider encryptionPermissions, SecurityProvidersImpl providers) throws PDFSecurityConfigurationException {
        this.secProviders = providers;
        this.setup(owner, user, encrypt, encryptionPermissions);
    }

    public PBSHStandard(byte[] password, SecurityProvidersImpl providers) throws PDFSecurityConfigurationException {
        this.secProviders = providers;
        this.setup(password);
    }

    protected void setup(byte[] owner, byte[] user, Map encrypt, PermissionProvider encryptionPermissions) throws PDFSecurityConfigurationException {
        this.password = null;
        this.owner = owner;
        this.user = user;
        this.requestedEncryption = encrypt;
        this.revision = encrypt != null && encrypt.containsKey(REVISION) ? ((Number)encrypt.get(REVISION)).intValue() : 2;
        this.setUpCipherFunctions();
        try {
            PermissionProviderStandard permProvider = PermissionProviderStandard.newInstance((PermissionProvider)encryptionPermissions);
            Integer internalPermissions = permProvider != null ? Integer.valueOf(permProvider.getPermissionBits()) : allPerms;
            this.requestedPerms = internalPermissions & 0xFFFFFFFC;
            if (encrypt != null) {
                encrypt.put(PERMISSIONS, this.requestedPerms);
            }
            this.grantedPerms = this.requestedPerms;
            if (5 <= this.revision) {
                this.makeFileKey();
                if (encrypt != null) {
                    this.encryptPermsR5(this.requestedPerms, encrypt);
                }
            }
        }
        catch (PDFUnableToCompleteOperationException excp) {
            throw new PDFSecurityConfigurationException("Unable to get requested permissions", (Throwable)excp);
        }
    }

    protected void setup(byte[] password) throws PDFSecurityConfigurationException {
        this.password = password;
        this.owner = null;
        this.user = null;
        this.zeroFill = new byte[32];
        Arrays.fill(this.zeroFill, (byte)0);
        this.encryptKey = new byte[32];
        Arrays.fill(this.encryptKey, (byte)0);
    }

    private void setUpCipherFunctions() throws PDFSecurityConfigurationException {
        if (!this.cipherFunctionsSetUp) {
            try {
                if (this.revision == 5 || this.revision == 6) {
                    this.setUpRandomNumberGenerator();
                    this.setUpAESCipher();
                    this.setUpSHA256Digester();
                    if (this.revision == 6) {
                        this.setUpSHA384Digester();
                        this.setUpSHA512Digester();
                    }
                } else if (this.revision < 5) {
                    this.setUpRC4Provider();
                    this.setUpMD5Digester();
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new PDFSecurityConfigurationException((Throwable)e);
            }
            this.cipherFunctionsSetUp = true;
        }
    }

    private void setUpRC4Provider() throws PDFSecurityConfigurationException {
        this.rc4Provider = this.secProviders != null ? this.secProviders.requireRC4() : null;
    }

    private void setUpRandomNumberGenerator() throws PDFSecurityConfigurationException, NoSuchAlgorithmException {
        SecureRandom secureRandom = this.randomGenerator = this.secProviders != null ? this.secProviders.getRandomGenerator() : null;
        if (this.randomGenerator == null) {
            Provider sha1prngProvider = this.secProviders != null ? this.secProviders.requireSHA1PRNG() : null;
            this.randomGenerator = sha1prngProvider == null ? SecureRandom.getInstance("SHA1PRNG") : SecureRandom.getInstance("SHA1PRNG", sha1prngProvider);
        }
    }

    private void setUpSHA512Digester() throws PDFSecurityConfigurationException, NoSuchAlgorithmException {
        Provider sha512Provider = this.secProviders != null ? this.secProviders.requireSHA512() : null;
        this.sha512Digest = sha512Provider == null ? MessageDigest.getInstance("SHA-512") : MessageDigest.getInstance("SHA-512", sha512Provider);
    }

    private void setUpSHA384Digester() throws PDFSecurityConfigurationException, NoSuchAlgorithmException {
        Provider sha384Provider = this.secProviders != null ? this.secProviders.requireSHA384() : null;
        this.sha384Digest = sha384Provider == null ? MessageDigest.getInstance("SHA-384") : MessageDigest.getInstance("SHA-384", sha384Provider);
    }

    private void setUpSHA256Digester() throws PDFSecurityConfigurationException, NoSuchAlgorithmException {
        Provider sha256Provider = this.secProviders != null ? this.secProviders.requireSHA256() : null;
        this.sha256Digest = sha256Provider == null ? MessageDigest.getInstance("SHA-256") : MessageDigest.getInstance("SHA-256", sha256Provider);
    }

    private void setUpMD5Digester() throws PDFSecurityConfigurationException, NoSuchAlgorithmException {
        Provider md5Provider = this.secProviders != null ? this.secProviders.requireMD5() : null;
        this.md5Digest = md5Provider == null ? MessageDigest.getInstance("MD5") : MessageDigest.getInstance("MD5", md5Provider);
    }

    private void setUpAESCipher() throws PDFSecurityConfigurationException, NoSuchAlgorithmException {
        try {
            this.aesCipher = this.secProviders == null ? Cipher.getInstance("AES/CBC/NoPadding") : Cipher.getInstance("AES/CBC/NoPadding", this.secProviders.requireAES());
        }
        catch (NoSuchPaddingException e) {
            throw new PDFSecurityConfigurationException("Cannot instantiate cipher. No Such Padding", (Throwable)e);
        }
    }

    protected void checkPassword(String cryptName, Map encryptParams, byte[] docId) throws PDFSecurityConfigurationException, PDFSecurityAuthorizationException {
        this.setEncryptParams(encryptParams, cryptName);
        if (this.password == null) {
            this.computePasswords(this.owner, this.user, encryptParams, docId);
            this.setEncryptParams(encryptParams, cryptName);
        } else if (this.curDocID == null) {
            this.authenticatePassword(this.password, docId);
        } else if (ByteOps.equalArrays((byte[])docId, (int)0, (byte[])this.curDocID, (int)0, (int)Math.max(this.curDocID.length, docId.length)) >= 0) {
            this.computePasswords(this.ownerDefined ? this.password : null, this.userPW, encryptParams, docId);
        }
        this.curDocID = docId;
    }

    protected void authenticatePassword(byte[] password, byte[] docId) throws PDFSecurityConfigurationException, PDFSecurityAuthorizationException {
        this.ownerDefined = false;
        if (this.isEFF && password.length == 0) {
            this.user = password;
            this.userPW = password;
        } else if (password.length != 0 && (this.revision < 5 && !Arrays.equals(padding, password) || 5 <= this.revision) && this.authenticateOwnerPassword(password, docId)) {
            this.secure = true;
            if (ByteOps.equalArrays((byte[])password, (int)0, (byte[])this.user, (int)0, (int)Math.max(this.user.length, password.length)) != -1) {
                this.owner = password;
                this.ownerDefined = true;
            } else {
                this.user = password;
                this.userPW = password;
            }
        } else {
            if (!this.authenticateUserPassword(password, docId)) {
                throw new PDFSecurityAuthorizationException("Wrong password");
            }
            byte[] saveEncryptKey = this.encryptKey;
            byte[] emptyR5Password = new byte[]{};
            this.secure = this.revision < 5 ? this.authenticateOwnerPassword(padding, docId) : this.authenticateOwnerPassword(emptyR5Password, docId);
            this.user = password;
            this.userPW = password;
            this.encryptKey = saveEncryptKey;
        }
        this.curDocID = docId;
    }

    protected void setEncryptParams(Map encryptParms, String cryptName) throws PDFSecurityConfigurationException {
        this.encryptedUser = (byte[])encryptParms.get(USER);
        this.encryptedOwner = (byte[])encryptParms.get(OWNER);
        this.revision = encryptParms.containsKey(REVISION) ? ((Number)encryptParms.get(REVISION)).intValue() : 2;
        this.setUpCipherFunctions();
        if (5 <= this.revision) {
            this.encryptedUserEncryption = (byte[])encryptParms.get(USER_ENCRYPTION);
            this.encryptedOwnerEncryption = (byte[])encryptParms.get(OWNER_ENCRYPTION);
        }
        this.length = EncryptionKeyCalc.calculateEncryptionKey(encryptParms, cryptName, 40);
        if (this.length < 0) {
            throw new PDFSecurityConfigurationException("Encryption with key length greater than 56 is not supported");
        }
        if (this.revision < 5) {
            this.grantedPerms = encryptParms.containsKey(PERMISSIONS) ? (Number)((Number)encryptParms.get(PERMISSIONS)) : (Number)allPerms;
            this.encryptMetadata = EncryptionKeyImpl.toEncryptMetadata(encryptParms, cryptName);
        }
        this.isEFF = encryptParms.containsKey("EFF");
        if (this.revision < 2) {
            throw new PDFSecurityConfigurationException("PBSHStandard: Not supported revision");
        }
    }

    protected byte[] computeMD5Hash(byte[] padded, byte[] id) {
        this.md5Digest.update(padded);
        if (id != null) {
            this.md5Digest.update(id);
        }
        return this.md5Digest.digest();
    }

    protected byte[] computeMD5DeepHash(byte[] padded, int revision, int interations) {
        return this.deepenDigest(this.computeMD5Hash(padded, null), interations, revision);
    }

    protected byte[] makeOwnerKeyR4(byte[] password, int revision, int length) {
        byte[] padded = this.padPassword(password);
        if (revision < 3) {
            return this.makeKey(this.computeMD5Hash(padded, null), revision, length);
        }
        return this.makeKey(this.computeMD5DeepHash(padded, revision, 50), revision, length);
    }

    protected byte[] computeEncryptionKeyR2(int revision, byte[] password, byte[] owner, byte[] perms, byte[] id, boolean encryptMetaData, int length) {
        byte[] padded = this.padPassword(password);
        this.md5Digest.update(padded);
        this.md5Digest.update(owner);
        if (perms != null && perms.length != 0) {
            this.md5Digest.update(perms);
        }
        if (id != null && id.length != 0) {
            this.md5Digest.update(id);
        }
        if (revision > 3 && !encryptMetaData) {
            this.md5Digest.update(EncryptionKeyImpl.defaultMetadataMark);
        }
        byte[] digest = null;
        digest = revision < 3 ? this.md5Digest.digest() : this.deepenDigest(this.md5Digest.digest(), 50, revision);
        return this.makeKey(digest, revision, length);
    }

    protected byte[] deepenDigest(byte[] digest, int count, int revision) {
        if (revision > 2) {
            while (count-- > 0) {
                digest = this.computeMD5Hash(digest, null);
            }
        }
        return digest;
    }

    protected void computePasswords(byte[] owner, byte[] user, Map encryptParms, byte[] docID) throws PDFSecurityConfigurationException {
        if (this.revision < 5) {
            if (user == null || user.length == 0) {
                user = padding;
            }
            byte[] encryptedOwner = this.computeOwnerPasswordR4(owner, user, this.revision, this.length);
            byte[] perms = this.grantedPerms != null ? ByteOps.splitInt2Bytes((int)this.grantedPerms.intValue(), (int)4) : null;
            this.encryptKey = this.computeEncryptionKeyR2(this.revision, user, encryptedOwner, perms, docID, this.encryptMetadata, this.length);
            byte[] encryptedUser = this.revision == 2 ? this.computeUserPasswordR2() : this.computeUserPasswordR3(docID);
            encryptParms.put(OWNER, encryptedOwner);
            encryptParms.put(USER, encryptedUser);
        } else {
            this.computePasswordsR_5_6(owner, user, encryptParms);
        }
    }

    protected byte[] computeOwnerPasswordR4(byte[] owner, byte[] user, int revision, int length) throws PDFSecurityConfigurationException {
        byte[] password = owner == null ? user : owner;
        byte[] rc4Key = this.makeOwnerKeyR4(password, revision, length);
        byte[] padded = this.padPassword(user);
        byte[] encryptedPassword = this.rc4encrypt.encrypt(padded, rc4Key);
        if (revision > 2) {
            for (int counter = 1; counter <= 19; ++counter) {
                encryptedPassword = this.rc4encrypt.encrypt(encryptedPassword, ByteOps.xorArray((byte[])rc4Key, (byte)((byte)counter)));
            }
        }
        return encryptedPassword;
    }

    protected byte[] computeUserPasswordR2() throws PDFSecurityConfigurationException {
        return this.rc4encrypt.encrypt(padding, this.encryptKey);
    }

    private byte[] computeUserPasswordR3(byte[] id) throws PDFSecurityConfigurationException {
        byte[] hash = this.computeMD5Hash(padding, id);
        byte[] encryptedPassword = this.rc4encrypt.encrypt(hash, this.encryptKey);
        for (int counter = 1; counter <= 19; ++counter) {
            encryptedPassword = this.rc4encrypt.encrypt(encryptedPassword, ByteOps.xorArray((byte[])this.encryptKey, (byte)((byte)counter)));
        }
        return this.appendPadding(encryptedPassword, padding, 32);
    }

    private void makeKeyStringsR_5_6(byte[] authData, byte[] securityPassword, byte[] extraHash, byte[] cryptKey, byte[] fileKey) throws PDFSecurityConfigurationException {
        byte[] digest = null;
        byte[] random = new byte[16];
        if (this.randomGenerator == null) {
            throw new PDFSecurityConfigurationException("Do not have a SecureRandom for making R5 key strings");
        }
        this.randomGenerator.nextBytes(random);
        System.arraycopy(random, 0, securityPassword, 32, 16);
        digest = this.makeR_5_6Digest(authData, securityPassword, extraHash, 32);
        System.arraycopy(digest, 0, securityPassword, 0, 32);
        digest = this.makeR_5_6Digest(authData, securityPassword, extraHash, 40);
        byte[] zeroIV = new byte[16];
        Arrays.fill(zeroIV, (byte)0);
        IvParameterSpec iv = new IvParameterSpec(zeroIV, 0, 16);
        SecretKeySpec mEncryptKey = new SecretKeySpec(digest, EncryptionKeyImpl.AES);
        try {
            this.aesCipher.init(1, (Key)mEncryptKey, iv);
            try {
                byte[] p = this.aesCipher.doFinal(fileKey, 0, 32);
                System.arraycopy(p, 0, cryptKey, 0, 32);
            }
            catch (IllegalBlockSizeException e) {
                throw new PDFSecurityConfigurationException("Cannot encrypt R5 file key. Illegal Block Size", (Throwable)e);
            }
            catch (BadPaddingException e) {
                throw new PDFSecurityConfigurationException("Cannot encrypt R5 file key. Bad Padding", (Throwable)e);
            }
        }
        catch (InvalidKeyException e) {
            throw new PDFSecurityConfigurationException("Cannot init cipher for R5 file key. Invalid Key", (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new PDFSecurityConfigurationException("Cannot init cipher for R5 file key. Invalid Algorithm Parameter", (Throwable)e);
        }
        catch (SecurityException e) {
            throw new PDFSecurityConfigurationException("Cannot init cipher for R5 file key. Security Exception", (Throwable)e);
        }
    }

    private byte[] makeR_5_6Digest(byte[] authData, byte[] salt, byte[] extraHash, int saltOffset) throws PDFSecurityConfigurationException {
        byte[] digest = null;
        if (authData != null) {
            this.sha256Digest.update(authData);
        }
        this.sha256Digest.update(salt, saltOffset, 8);
        if (extraHash != null) {
            this.sha256Digest.update(extraHash, 0, 48);
        }
        digest = this.sha256Digest.digest();
        if (this.revision == 6) {
            digest = this.slowDownForR6(authData, extraHash, digest);
        }
        return digest;
    }

    private byte[] slowDownForR6(byte[] authData, byte[] u, byte[] k) throws PDFSecurityConfigurationException {
        byte[] e = new byte[this.getMaxELength(authData, u)];
        int actualELength = -1;
        for (int j = 0; j < 64 || (e[actualELength - 1] & 0xFF) > j - 32; ++j) {
            actualELength = this.getELength(authData, u, k);
            k = this.updateK(authData, u, e, k, actualELength);
        }
        byte[] updatedK = new byte[32];
        System.arraycopy(k, 0, updatedK, 0, 32);
        return updatedK;
    }

    private int getELength(byte[] authData, byte[] u, byte[] k) {
        int lengthWithoutSalt = k.length * 64;
        if (authData != null) {
            lengthWithoutSalt += authData.length * 64;
        }
        if (u == null) {
            return lengthWithoutSalt;
        }
        return lengthWithoutSalt + 3072;
    }

    private int getMaxELength(byte[] authData, byte[] u) {
        int lengthWithoutSalt = 4096;
        if (authData != null) {
            lengthWithoutSalt += authData.length * 64;
        }
        if (u == null) {
            return lengthWithoutSalt;
        }
        return lengthWithoutSalt + 3072;
    }

    private byte[] updateK(byte[] authData, byte[] u, byte[] e, byte[] k, int eLen) throws PDFSecurityConfigurationException {
        byte[] k1 = new byte[eLen];
        int currentPosition = 0;
        for (int i = 0; i < 64; ++i) {
            if (authData != null) {
                System.arraycopy(authData, 0, k1, currentPosition, authData.length);
                currentPosition += authData.length;
            }
            System.arraycopy(k, 0, k1, currentPosition, k.length);
            currentPosition += k.length;
            if (u == null) continue;
            System.arraycopy(u, 0, k1, currentPosition, 48);
            currentPosition += 48;
        }
        IvParameterSpec iv = new IvParameterSpec(k, 16, 16);
        SecretKeySpec mEncryptKey = new SecretKeySpec(k, 0, 16, EncryptionKeyImpl.AES);
        try {
            this.aesCipher.init(1, (Key)mEncryptKey, iv);
        }
        catch (InvalidKeyException e1) {
            throw new PDFSecurityConfigurationException("Cannot init cipher", (Throwable)e1);
        }
        catch (InvalidAlgorithmParameterException e1) {
            throw new PDFSecurityConfigurationException("Cannot init cipher", (Throwable)e1);
        }
        try {
            this.aesCipher.doFinal(k1, 0, k1.length, e);
        }
        catch (ShortBufferException e1) {
            throw new PDFSecurityConfigurationException("Cannot encrypt", (Throwable)e1);
        }
        catch (IllegalBlockSizeException e1) {
            throw new PDFSecurityConfigurationException("Cannot encrypt", (Throwable)e1);
        }
        catch (BadPaddingException e1) {
            throw new PDFSecurityConfigurationException("Cannot encrypt", (Throwable)e1);
        }
        int remainder = this.getModulo3(e, 0, 16);
        MessageDigest shaDigest = null;
        switch (remainder) {
            case 0: {
                shaDigest = this.sha256Digest;
                break;
            }
            case 1: {
                shaDigest = this.sha384Digest;
                break;
            }
            case 2: {
                shaDigest = this.sha512Digest;
            }
        }
        shaDigest.update(e, 0, eLen);
        return shaDigest.digest();
    }

    private int getModulo3(byte[] array, int offset, int length) {
        int remainder = 0;
        for (int i = offset; i < length; ++i) {
            remainder += (array[i] & 0xFF) % 3;
        }
        return remainder % 3;
    }

    private boolean testPasswordR_5_6(byte[] authData, byte[] securityHash, byte[] extraHash, byte[] cryptKey, byte[] fileKey, int keySize) throws PDFSecurityConfigurationException {
        byte[] digest = this.makeR_5_6Digest(authData, securityHash, extraHash, 32);
        if (ByteOps.equalArrays((byte[])digest, (int)0, (byte[])securityHash, (int)0, (int)32) != -1) {
            return false;
        }
        if (fileKey != null) {
            digest = this.makeR_5_6Digest(authData, securityHash, extraHash, 40);
            IvParameterSpec iv = new IvParameterSpec(this.zeroFill, 0, 16);
            SecretKeySpec mEncryptKey = new SecretKeySpec(digest, EncryptionKeyImpl.AES);
            try {
                this.aesCipher.init(2, (Key)mEncryptKey, iv);
                try {
                    digest = this.aesCipher.doFinal(cryptKey, 0, 32);
                }
                catch (IllegalBlockSizeException e) {
                    throw new PDFSecurityConfigurationException("Cannot encrypt R5 file key. Illegal Block Size", (Throwable)e);
                }
                catch (BadPaddingException e) {
                    throw new PDFSecurityConfigurationException("Cannot encrypt R5 file key. Bad Padding", (Throwable)e);
                }
            }
            catch (InvalidKeyException e) {
                throw new PDFSecurityConfigurationException("Cannot init cipher for R5 file key. Invalid Key", (Throwable)e);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new PDFSecurityConfigurationException("Cannot init cipher for R5 file key. Invalid Algorithm Parameter", (Throwable)e);
            }
            catch (SecurityException e) {
                throw new PDFSecurityConfigurationException("Cannot init cipher for R5 file key. Security Exception", (Throwable)e);
            }
            if (!Arrays.equals(fileKey, this.zeroFill)) {
                return Arrays.equals(fileKey, digest);
            }
            System.arraycopy(digest, 0, fileKey, 0, keySize);
        }
        return true;
    }

    private void encryptPermsR5(Number perms, Map encrypt) throws PDFSecurityConfigurationException {
        byte[] sPerms = new byte[16];
        int iPerms = perms.intValue();
        sPerms[0] = (byte)(iPerms & 0xFF);
        sPerms[1] = (byte)(iPerms >> 8 & 0xFF);
        sPerms[2] = (byte)(iPerms >> 16 & 0xFF);
        sPerms[3] = (byte)(iPerms >> 24 & 0xFF);
        sPerms[7] = -1;
        sPerms[6] = -1;
        sPerms[5] = -1;
        sPerms[4] = -1;
        Boolean toEncrypt = (Boolean)encrypt.get(METADATA);
        sPerms[8] = toEncrypt == null || toEncrypt != false ? 84 : 70;
        sPerms[9] = 97;
        sPerms[10] = 100;
        sPerms[11] = 98;
        byte[] random = new byte[4];
        if (this.randomGenerator == null) {
            throw new PDFSecurityConfigurationException("Do not have a SecureRandom for R5 permissions");
        }
        this.randomGenerator.nextBytes(random);
        System.arraycopy(random, 0, sPerms, 12, 4);
        byte[] zeroIV = new byte[16];
        Arrays.fill(zeroIV, (byte)0);
        IvParameterSpec iv = new IvParameterSpec(zeroIV, 0, 16);
        SecretKeySpec mEncryptKey = new SecretKeySpec(this.encryptKey, EncryptionKeyImpl.AES);
        try {
            this.aesCipher.init(1, (Key)mEncryptKey, iv);
            try {
                byte[] p = this.aesCipher.doFinal(sPerms, 0, 16);
                encrypt.put(PERMS, p);
            }
            catch (IllegalBlockSizeException e) {
                throw new PDFSecurityConfigurationException("Cannot encrypt R5 permissions. Illegal Block Size", (Throwable)e);
            }
            catch (BadPaddingException e) {
                throw new PDFSecurityConfigurationException("Cannot encrypt R5 permissions. Bad Padding", (Throwable)e);
            }
        }
        catch (InvalidKeyException e) {
            throw new PDFSecurityConfigurationException("Cannot init cipher for R5 permissions. Invalid Key", (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new PDFSecurityConfigurationException("Cannot init cipher for R5 permissions. Invalid Algorithm Parameter", (Throwable)e);
        }
        catch (SecurityException e) {
            throw new PDFSecurityConfigurationException("Cannot init cipher for R5 permissions. Security Exception", (Throwable)e);
        }
    }

    private Number decryptPermsR5(Map encryptParms) throws PDFSecurityConfigurationException {
        byte[] sPerms;
        byte[] zeroIV = new byte[16];
        Arrays.fill(zeroIV, (byte)0);
        IvParameterSpec iv = new IvParameterSpec(zeroIV, 0, 16);
        SecretKeySpec mEncryptKey = new SecretKeySpec(this.encryptKey, EncryptionKeyImpl.AES);
        try {
            this.aesCipher.init(2, (Key)mEncryptKey, iv);
            try {
                byte[] p = (byte[])encryptParms.get(PERMS);
                sPerms = this.aesCipher.doFinal(p, 0, 16);
            }
            catch (IllegalBlockSizeException e) {
                throw new PDFSecurityConfigurationException("Cannot encrypt R5 file key. Illegal Block Size", (Throwable)e);
            }
            catch (BadPaddingException e) {
                throw new PDFSecurityConfigurationException("Cannot encrypt R5 file key. Bad Padding", (Throwable)e);
            }
        }
        catch (InvalidKeyException e) {
            throw new PDFSecurityConfigurationException("Cannot init cipher for R5 file key. Invalid Key", (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new PDFSecurityConfigurationException("Cannot init cipher for R5 file key. Invalid Algorithm Parameter", (Throwable)e);
        }
        catch (SecurityException e) {
            throw new PDFSecurityConfigurationException("Cannot init cipher for R5 file key. Security Exception", (Throwable)e);
        }
        if (sPerms[9] != 97 || sPerms[10] != 100 || sPerms[11] != 98) {
            throw new PDFSecurityConfigurationException("Invalid or old version of Encryption Parameters (filler)");
        }
        if (sPerms[8] == 84) {
            this.encryptMetadata = true;
        } else if (sPerms[8] == 70) {
            this.encryptMetadata = false;
        } else {
            throw new PDFSecurityConfigurationException("Invalid or old version of Encryption Parameters (encryptMetadata)");
        }
        return sPerms[0] & 0xFF | sPerms[1] << 8 & 0xFF00 | sPerms[2] << 16 & 0xFF0000 | sPerms[3] << 24 & 0xFF000000;
    }

    private boolean authenticateOwnerPasswordR_5_6(byte[] ownerAuthData) throws PDFSecurityConfigurationException {
        return this.testPasswordR_5_6(ownerAuthData, this.encryptedOwner, this.encryptedUser, this.encryptedOwnerEncryption, this.encryptKey, 32);
    }

    private boolean authenticateUserPasswordR_5_6(byte[] userAuthData) throws PDFSecurityConfigurationException {
        return this.testPasswordR_5_6(userAuthData, this.encryptedUser, null, this.encryptedUserEncryption, this.encryptKey, 32);
    }

    private void makeFileKey() throws PDFSecurityConfigurationException {
        if (this.encryptKey == null) {
            byte[] random = new byte[32];
            if (this.randomGenerator == null) {
                throw new PDFSecurityConfigurationException("Do not have a SecureRandom for file key");
            }
            this.randomGenerator.nextBytes(random);
            this.encryptKey = random;
        }
    }

    private void computePasswordsR_5_6(byte[] ownerAuthData, byte[] userAuthData, Map encryptParms) throws PDFSecurityConfigurationException {
        if (this.encryptKey == null) {
            this.makeFileKey();
        }
        this.encryptedUser = new byte[48];
        this.encryptedUserEncryption = new byte[32];
        this.makeKeyStringsR_5_6(userAuthData, this.encryptedUser, null, this.encryptedUserEncryption, this.encryptKey);
        encryptParms.put(USER, this.encryptedUser);
        encryptParms.put(USER_ENCRYPTION, this.encryptedUserEncryption);
        this.encryptedOwner = new byte[48];
        this.encryptedOwnerEncryption = new byte[32];
        if (ownerAuthData == null || ownerAuthData.length == 0) {
            this.makeKeyStringsR_5_6(userAuthData, this.encryptedOwner, this.encryptedUser, this.encryptedOwnerEncryption, this.encryptKey);
        } else {
            this.makeKeyStringsR_5_6(ownerAuthData, this.encryptedOwner, this.encryptedUser, this.encryptedOwnerEncryption, this.encryptKey);
        }
        encryptParms.put(OWNER, this.encryptedOwner);
        encryptParms.put(OWNER_ENCRYPTION, this.encryptedOwnerEncryption);
    }

    private boolean authenticateOwnerPasswordR4(byte[] password, byte[] id) throws PDFSecurityConfigurationException {
        byte[] rc4Key = this.makeOwnerKeyR4(password, this.revision, this.length);
        byte[] decrypted = this.encryptedOwner;
        int limit = this.revision > 2 ? 19 : 0;
        for (int count = 0; count <= limit; ++count) {
            decrypted = this.rc4encrypt.decrypt(decrypted, ByteOps.xorArray((byte[])rc4Key, (byte)((byte)count)));
        }
        int pwLen = ByteOps.endsWithPartial((byte[])decrypted, (int)0, (byte[])padding, (int)0);
        if (pwLen == -1) {
            pwLen = decrypted.length;
        }
        this.userPW = new byte[pwLen];
        System.arraycopy(decrypted, 0, this.userPW, 0, pwLen);
        boolean gotIt = this.authenticateUserPassword(this.userPW, id);
        if (gotIt) {
            this.user = this.userPW;
        }
        return gotIt;
    }

    MessageDigest getMD5Digest() {
        return this.md5Digest;
    }

    public boolean authenticateUserPassword(byte[] password, byte[] id) throws PDFSecurityConfigurationException {
        if (this.revision < 5) {
            byte[] perms = this.grantedPerms != null ? ByteOps.splitInt2Bytes((int)this.grantedPerms.intValue(), (int)4) : null;
            this.encryptKey = this.computeEncryptionKeyR2(this.revision, password, this.encryptedOwner, perms, id, this.encryptMetadata, this.length);
            byte[] encrypted = this.revision == 2 ? this.rc4encrypt.encrypt(padding, this.encryptKey) : this.computeUserPasswordR3(id);
            return ByteOps.equalArrays((byte[])encrypted, (int)0, (byte[])this.encryptedUser, (int)0, (int)(this.revision < 3 ? Math.max(this.encryptedUser.length, encrypted.length) : 16)) == -1;
        }
        return this.authenticateUserPasswordR_5_6(password);
    }

    public boolean authenticateOwnerPassword(byte[] password, byte[] id) throws PDFSecurityConfigurationException {
        if (this.revision < 5) {
            return this.authenticateOwnerPasswordR4(password, id);
        }
        boolean match = this.authenticateOwnerPasswordR_5_6(password);
        if (match && this.user == null) {
            this.user = new byte[0];
        }
        return match;
    }

    public Map getEncryptParameters() {
        return this.requestedEncryption;
    }

    public byte[] getOwnerPassword() {
        if (this.secure && this.owner == null) {
            return emptyPassword;
        }
        return this.owner;
    }

    public byte[] getUserPassword() {
        if (this.revision < 5 && this.user != null && (this.user.length == 0 || ByteOps.equalArrays((byte[])this.user, (int)0, (byte[])padding, (int)0, (int)Math.max(this.user.length, padding.length)) == -1)) {
            return null;
        }
        return this.user;
    }

    private Integer getPermissions() {
        Integer externalPermissions = this.getOwnerPassword() != null || this.grantedPerms == null ? (Number)allPerms : (Number)this.grantedPerms;
        return externalPermissions & 0xFFFFFFFC;
    }

    public PermissionProvider getPermissionProvider() {
        int perms = this.getPermissions();
        if (this.user != null) {
            perms |= 1;
        }
        if (this.secure) {
            perms |= 3;
        }
        return new PermissionProviderStandard(perms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(Map params, byte[] docID) throws PDFSecurityConfigurationException, PDFSecurityAuthorizationException {
        try {
            this.decryptedState = new DecryptedStatePBSH();
            EncryptionKeyImpl.verifyEncryptionVersion(params, true);
            if (this.password == null) {
                if (!params.containsKey(OWNER)) {
                    String cryptName = (String)params.get("EFF");
                    if (cryptName == null) {
                        cryptName = (String)params.get("StmF");
                    }
                    this.checkPassword(cryptName, params, docID);
                }
                boolean cryptName = true;
                return cryptName;
            }
            String cryptName = null;
            Map cfDict = EncryptionKeyImpl.getCFDict(params);
            if (cfDict != null) {
                for (Map.Entry curCrypt : cfDict.entrySet()) {
                    String authEvent = (String)((Map)curCrypt.getValue()).get("AuthEvent");
                    if (!"DocOpen".equals(authEvent)) continue;
                    cryptName = (String)curCrypt.getKey();
                    break;
                }
            }
            this.setEncryptParams(params, cryptName);
            this.authenticatePassword(this.password, docID);
            if (5 <= this.revision) {
                this.grantedPerms = this.decryptPermsR5(params);
            }
        }
        finally {
            this.decryptedState.setEncryptKey(this.encryptKey);
            if (this.grantedPerms != null) {
                this.decryptedState.setPerms(Integer.valueOf(this.grantedPerms.intValue()));
            }
        }
        return true;
    }

    public boolean authenticate(Map params, byte[] docID, DecryptedState decryptedState) throws PDFSecurityConfigurationException, PDFSecurityAuthorizationException {
        if (decryptedState != null) {
            this.setUpCipherFunctions();
            this.decryptedUsingState = true;
            this.decryptedState = decryptedState;
            this.encryptKey = decryptedState.getEncryptKey();
            this.grantedPerms = decryptedState.getPerms();
            return true;
        }
        return this.authenticate(params, docID);
    }

    protected byte[] padPassword(byte[] password) {
        int passwordLen;
        byte[] padded = new byte[32];
        int n = passwordLen = password != null && password.length != 0 ? password.length : 0;
        if (passwordLen > 32) {
            passwordLen = 32;
        }
        if (passwordLen > 0) {
            System.arraycopy(password, 0, padded, 0, passwordLen);
        }
        if (passwordLen < 32) {
            System.arraycopy(padding, 0, padded, passwordLen, 32 - passwordLen);
        }
        return padded;
    }

    private byte[] appendPadding(byte[] src, byte[] pad, int len) {
        int add = len - src.length;
        byte[] result = new byte[len];
        System.arraycopy(src, 0, result, 0, src.length);
        if (add > 0) {
            System.arraycopy(pad, 0, result, src.length, add);
        }
        return result;
    }

    protected byte[] makeKey(byte[] digest, int revision, int length) {
        int len;
        int n = len = revision == 2 ? 5 : length / 8;
        if (digest.length < len) {
            len = digest.length;
        }
        byte[] result = new byte[len];
        System.arraycopy(digest, 0, result, 0, len);
        return result;
    }

    protected void setInternalRC4Encryption() throws PDFSecurityConfigurationException {
        this.rc4encrypt = new JCERC4EncryptionHandler(null, this.md5Digest, true, this.rc4Provider);
    }

    public DecryptedState getDecryptedState() {
        return this.decryptedState;
    }
}

