/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.waf.rules;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.regex.Pattern;
import org.owasp.esapi.waf.actions.Action;
import org.owasp.esapi.waf.actions.DoNothingAction;
import org.owasp.esapi.waf.internal.InterceptingHTTPServletResponse;
import org.owasp.esapi.waf.rules.Rule;

public class AddHeaderRule
extends Rule {
    private String header;
    private String value;
    private Pattern path;
    private List<Object> exceptions;

    public AddHeaderRule(String id, String header, String value, Pattern path, List<Object> exceptions) {
        this.setId(id);
        this.header = header;
        this.value = value;
        this.path = path;
        this.exceptions = exceptions;
    }

    @Override
    public Action check(HttpServletRequest request, InterceptingHTTPServletResponse response, HttpServletResponse httpResponse) {
        DoNothingAction action = new DoNothingAction();
        if (this.path.matcher(request.getRequestURI()).matches()) {
            for (int i = 0; i < this.exceptions.size(); ++i) {
                Object o = this.exceptions.get(i);
                if (o instanceof String) {
                    if (!request.getRequestURI().equals((String)o)) continue;
                    action.setFailed(false);
                    action.setActionNecessary(false);
                    return action;
                }
                if (!(o instanceof Pattern) || !((Pattern)o).matcher(request.getRequestURI()).matches()) continue;
                action.setFailed(false);
                action.setActionNecessary(false);
                return action;
            }
            action.setFailed(true);
            action.setActionNecessary(false);
            if (response != null) {
                response.setHeader(this.header, this.value);
            } else {
                httpResponse.setHeader(this.header, this.value);
            }
        }
        return action;
    }
}

