/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.validator;

import coldfusion.cloud.validator.FieldValidationFailedException;
import coldfusion.cloud.validator.Validator;
import coldfusion.runtime.Cast;
import coldfusion.util.RB;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum GCPProjectIdValidator implements Validator
{
    INSTANCE;

    private static final Pattern regex;
    private String projectId;

    public boolean validate(Object obj) {
        try {
            if (obj == null) {
                return true;
            }
            this.projectId = Cast._String(obj).trim().toLowerCase();
            if (this.projectId.length() == 0) {
                return true;
            }
            Matcher matcher = regex.matcher(this.projectId);
            boolean result = matcher.find();
            if (!result) {
                throw new FieldValidationFailedException(RB.getString(GCPProjectIdValidator.class, "PROJECT_ID_VALIDATION_ERROR", (Object)this.projectId));
            }
            return result;
        }
        catch (ClassCastException ex) {
            throw new FieldValidationFailedException(RB.getString(GCPProjectIdValidator.class, "PROJECT_ID_VALIDATION_ERROR", (Object)this.projectId), ex);
        }
    }

    static {
        regex = Pattern.compile("\\b(?!.*google|.*ssl)\\b^[a-z][-a-z0-9]{4,28}[a-z0-9]{1}$");
    }
}

