/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.util;

import coldfusion.cloud.CloudService;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.cloud.validator.FieldValidationFailedException;
import coldfusion.runtime.Cast;
import coldfusion.util.RB;
import java.time.Duration;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public enum FieldTypecastUtil {
    INSTANCE;


    public final String getStringProperty(Object val) {
        try {
            return Cast._String(val);
        }
        catch (RuntimeException ex) {
            throw new FieldValidationFailedException("Casting exception while casting " + val + " to String", ex);
        }
    }

    public final int getIntegerProperty(Object val) {
        return Cast._int(val);
    }

    public final Map getMapProperty(Object val) {
        return Cast._Map(val);
    }

    public final Map<String, Object> getStringObjectMapProperty(Object val) {
        try {
            return (Map)val;
        }
        catch (ClassCastException ex) {
            throw new FieldValidationFailedException("incorrect value", ex);
        }
    }

    public List<String> getStringListProperty(Object val) {
        return Cast._List(val);
    }

    public List getListProperty(Object val) {
        return Cast._List(val);
    }

    public Integer[] getIntegerArrayProperty(Object val) {
        try {
            List list = Cast._List(val);
            Integer[] temp = new Integer[list.size()];
            return list.toArray(temp);
        }
        catch (ClassCastException ex) {
            throw new FieldValidationFailedException("Incorrect syntax : Array Of Integer values expected", ex);
        }
    }

    public Set<String> getStringSetProperty(Object val) {
        try {
            return new HashSet<String>(Cast._List(val));
        }
        catch (ClassCastException ex) {
            throw new FieldValidationFailedException("Incorrect syntax : Set Of String values expected", ex);
        }
    }

    public Map<String, String> getStringStringMapProperty(Object val) {
        try {
            return (Map)val;
        }
        catch (ClassCastException ex) {
            throw new FieldValidationFailedException("Incorrect syntax : struct of attributes", ex);
        }
    }

    public final Boolean getBooleanProperty(Object val) {
        return Cast._boolean(val);
    }

    public final Date getDateProperty(Object val) {
        if (val != null) {
            String input = String.valueOf(val);
            if (input.trim().length() == 0) {
                throw new ValidationException(RB.getString(CloudService.class, "invalidDateException"));
            }
            return Cast._Date(input);
        }
        return null;
    }

    public final Instant getInstantProperty(Object val) {
        return this.getDateProperty(val).toInstant();
    }

    public final Long getLongProperty(Object value) {
        return Long.parseLong(String.valueOf(value));
    }

    public final Double getDoubleProperty(Object value) {
        return Cast._double(value);
    }

    public Duration getDurationProperty(Object val) {
        try {
            String stringDuration = Cast._String(val);
            int length = stringDuration.length();
            String unit = stringDuration.substring(length - 1);
            int response = 1;
            response = Integer.parseInt(stringDuration.substring(0, length - 1));
            switch (unit) {
                case "m": {
                    return Duration.ofMillis(response);
                }
                case "M": {
                    return Duration.ofMinutes(response);
                }
                case "d": {
                    return Duration.ofDays(response);
                }
                case "h": {
                    return Duration.ofHours(response);
                }
                case "s": {
                    return Duration.ofSeconds(response);
                }
                case "n": {
                    return Duration.ofNanos(response);
                }
            }
            return null;
        }
        catch (Exception ex) {
            throw new FieldValidationFailedException("Incorrect syntax : struct of attributes", ex);
        }
    }

    public Instant getMidNightInstant(Object value) {
        Date date = this.getDateProperty(value);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        return calendar.toInstant();
    }
}

