/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.validator;

import coldfusion.cloud.validator.FieldValidationFailedException;
import coldfusion.cloud.validator.Validator;
import java.util.Objects;

public class IntegerRangeValidator
implements Validator {
    String fieldName;
    Integer minRange;
    Integer maxRange;

    public boolean validate(Object obj) {
        if (Objects.isNull(obj)) {
            return true;
        }
        try {
            int val = (Integer)obj;
            if (this.minRange != null && val < this.minRange) {
                throw new FieldValidationFailedException("value " + obj + " out of range");
            }
            if (this.maxRange != null && val > this.maxRange) {
                throw new FieldValidationFailedException("value " + obj + " out of range");
            }
            return true;
        }
        catch (ClassCastException ex) {
            throw new FieldValidationFailedException("Incorrect type for field name " + this.fieldName, ex);
        }
    }

    public IntegerRangeValidator(String fieldName, Integer minRange, Integer maxRange) {
        this.fieldName = fieldName;
        this.minRange = minRange;
        this.maxRange = maxRange;
    }
}

