/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.cloud.exception.ValidationException;
import coldfusion.runtime.BinaryConversionException;
import coldfusion.runtime.BooleanStringConversionException;
import coldfusion.runtime.CFBoolean;
import coldfusion.runtime.CFDouble;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.NonArrayException;
import coldfusion.runtime.OleDate;
import coldfusion.xml.XmlNodeList;
import coldfusion.xml.XmlNodeMap;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class Cast {
    public static ThreadLocal<Boolean> parseDateInThread = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };

    public static double _double(Object x) {
        return Cast._double(x, true);
    }

    public static double _double(Object x, boolean parseDate) {
        if (x instanceof Number) {
            return ((Number)x).doubleValue();
        }
        if (x instanceof String) {
            return Cast._double((String)x, parseDate);
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? 1.0 : 0.0;
        }
        if (x instanceof CFBoolean) {
            return ((CFBoolean)x).value ? 1.0 : 0.0;
        }
        if (x instanceof Date) {
            return OleDate.days(((Date)x).getTime());
        }
        if (x instanceof Character) {
            return ((Character)x).charValue();
        }
        throw new NumberConversionException(x.getClass().getName());
    }

    public static double _double(String s, boolean parseDate) {
        return Cast._double(s, parseDate, true);
    }

    public static double _double(String s, boolean parseDate, boolean parseBoolean) {
        int len = (s = s.trim()).length();
        if (len == 0) {
            throw new NumberConversionException(s);
        }
        switch (s.charAt(0)) {
            case '+': 
            case '-': 
            case '.': {
                try {
                    double d = CFDouble.parseDouble(s);
                    if (Double.isInfinite(d)) {
                        throw new NumberConversionException(s);
                    }
                    return d;
                }
                catch (RuntimeException ex) {
                    throw new NumberConversionException(s);
                }
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                if (len == 1) {
                    return s.charAt(0) - 48;
                }
                try {
                    double d = CFDouble.parseDouble(s);
                    if (Double.isInfinite(d)) {
                        throw new NumberConversionException(s);
                    }
                    return d;
                }
                catch (RuntimeException ex) {
                    break;
                }
            }
            case 'Y': 
            case 'y': {
                if (!parseBoolean) break;
                if (s.equalsIgnoreCase("yes")) {
                    return 1.0;
                }
                throw new NumberConversionException(s);
            }
            case 'T': 
            case 't': {
                if (!parseBoolean) break;
                if (s.equalsIgnoreCase("true")) {
                    return 1.0;
                }
                throw new NumberConversionException(s);
            }
            case 'N': 
            case 'n': {
                if (!parseBoolean || !s.equalsIgnoreCase("no")) break;
                return 0.0;
            }
            case 'F': 
            case 'f': {
                if (!parseBoolean || !s.equalsIgnoreCase("false")) break;
                return 0.0;
            }
            case 'A': 
            case 'D': 
            case 'J': 
            case 'M': 
            case 'O': 
            case 'S': 
            case 'a': 
            case 'd': 
            case 'j': 
            case 'm': 
            case 'o': 
            case 's': 
            case '{': {
                break;
            }
            default: {
                throw new NumberConversionException(s);
            }
        }
        if (!parseDate || !parseDateInThread.get().booleanValue()) {
            throw new NumberConversionException(s);
        }
        throw new NumberConversionException(s);
    }

    public static String _String(Object value) {
        return String.valueOf(value);
    }

    public static boolean _boolean(Object property, boolean b) {
        return Cast._boolean(property);
    }

    public static boolean _boolean(Object property) {
        String s = String.valueOf(property);
        if (s.length() != 0) {
            switch (s.charAt(0)) {
                case 'Y': 
                case 'y': {
                    if (!s.equalsIgnoreCase("yes")) break;
                    return true;
                }
                case 'N': 
                case 'n': {
                    if (!s.equalsIgnoreCase("no")) break;
                    return false;
                }
                case 'T': 
                case 't': {
                    if (!s.equalsIgnoreCase("true")) break;
                    return true;
                }
                case 'F': 
                case 'f': {
                    if (!s.equalsIgnoreCase("false")) break;
                    return false;
                }
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    Double d = Double.parseDouble(s);
                    return 0.0 != d;
                }
            }
        }
        throw new BooleanStringConversionException(s);
    }

    public static byte[] _Binary(Object x) {
        return Cast._Binary(x, null);
    }

    public static byte[] _Binary(Object binObj, String charset) {
        byte[] attachBin = null;
        if (binObj instanceof byte[]) {
            attachBin = (byte[])binObj;
        } else if (binObj instanceof String) {
            if (charset == null) {
                return ((String)binObj).getBytes();
            }
            try {
                return ((String)binObj).getBytes(charset);
            }
            catch (Exception ex) {
                attachBin = ((String)binObj).getBytes();
            }
        } else if (binObj instanceof Number) {
            try {
                attachBin = ((Number)binObj).toString().getBytes(charset);
            }
            catch (Exception ex) {
                attachBin = ((Number)binObj).toString().getBytes();
            }
        } else if (binObj instanceof char[]) {
            char[] cArray = (char[])binObj;
            attachBin = new byte[cArray.length];
            for (int i = 0; i < attachBin.length; ++i) {
                attachBin[i] = (byte)cArray[i];
            }
        } else {
            throw new BinaryConversionException(binObj.getClass());
        }
        return attachBin;
    }

    public static int _int(Object value) {
        return Integer.valueOf(String.valueOf(value));
    }

    public static Map _Map(Object x) {
        if (x == null) {
            return null;
        }
        if (x instanceof XmlNodeList) {
            return new XmlNodeMap((XmlNodeList)x);
        }
        return (Map)x;
    }

    public static List _List(final Object x) {
        if (x instanceof List) {
            return (List)x;
        }
        if (x instanceof Object[]) {
            final Object[] array = (Object[])x;
            return new AbstractList(){

                @Override
                public Object get(int i) {
                    return array[i];
                }

                @Override
                public int size() {
                    return array.length;
                }
            };
        }
        if (x instanceof int[] || x instanceof boolean[] || x instanceof double[] || x instanceof char[] || x instanceof byte[] || x instanceof short[] || x instanceof long[] || x instanceof float[]) {
            return new AbstractList(){

                @Override
                public Object get(int i) {
                    return Array.get(x, i);
                }

                @Override
                public int size() {
                    return Array.getLength(x);
                }
            };
        }
        throw new NonArrayException(x.getClass());
    }

    public static Date _Date(String s) {
        try {
            return DateFormat.getInstance().parse(s);
        }
        catch (ParseException e) {
            throw new ValidationException(e.getMessage(), e);
        }
    }

    public static class NumberConversionException
    extends ExpressionException {
        public String source;

        public NumberConversionException(String source) {
            this.source = source;
        }
    }
}

