/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.util.FileLock;
import com.adobe.cfsetup.settings.service.RuntimeService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

class ClientIDHelper {
    private String mPath = null;
    private Properties mClientProp = new Properties();
    private int mNextIDBlock = 0;
    private int mID = 0;
    private boolean isFileLock = false;
    private static String CLIENT_PROPERTIES = "client.properties";
    private static String PROPERTY_NAME = "LastID";
    private static int BLOCK_SIZE = 100;
    private RuntimeService runtimeService;

    public ClientIDHelper(String rootDir, RuntimeService runtimeService) {
        this.mPath = rootDir + File.separatorChar + "lib";
        this.runtimeService = runtimeService;
    }

    private synchronized FileInputStream getInputStream() throws IOException {
        File file = new File(this.mPath, CLIENT_PROPERTIES);
        if (!file.exists()) {
            file.createNewFile();
            FileOutputStream fos = new FileOutputStream(file);
            this.mClientProp.setProperty(PROPERTY_NAME, "0");
            this.mClientProp.store(fos, "client id file");
            fos.close();
        }
        return new FileInputStream(file);
    }

    private synchronized void storeClientID(int id) throws IOException {
        File file = new File(this.mPath, CLIENT_PROPERTIES);
        FileOutputStream fos = new FileOutputStream(file);
        this.mClientProp.setProperty(PROPERTY_NAME, Long.toString(id));
        this.mClientProp.store(fos, "ClientID Sequence");
        fos.close();
    }

    private synchronized void GetIDBlockFromFile() throws IOException {
        FileInputStream fis = this.getInputStream();
        this.mClientProp.clear();
        this.mClientProp.load(fis);
        fis.close();
        String result = this.mClientProp.getProperty(PROPERTY_NAME);
        try {
            this.mID = Integer.parseInt(result);
        }
        catch (NumberFormatException e) {
            String msg = "ClientIDHelper.GetIDBlockFromFile() error: " + CLIENT_PROPERTIES + " file exists but has zero length.";
            this.mID = this.mNextIDBlock;
        }
        if (this.mID > Integer.MAX_VALUE - BLOCK_SIZE) {
            this.mID = 0;
        }
        this.mNextIDBlock = this.mID + BLOCK_SIZE;
        this.storeClientID(this.mNextIDBlock);
    }

    public synchronized int GetClientId() {
        try {
            if (this.mID >= this.mNextIDBlock) {
                this.GetIDBlockFromFile();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.mID++;
    }

    public void save() {
        try {
            if (!this.runtimeService.isFileLockEnabled()) {
                this.storeClientID(this.mID);
            } else {
                this.storeClientIDWithLock(this.mID);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void storeClientIDWithLock(int id) throws IOException {
        FileLock fileLock = new FileLock(this.mPath, CLIENT_PROPERTIES);
        try {
            fileLock.obtain();
            this.storeClientID(id);
        }
        finally {
            fileLock.release();
        }
    }
}

